package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.R$styleable;

public class ImageFilterView extends AppCompatImageView {

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean f942 = true;

    /* renamed from: ඓ  reason: contains not printable characters */
    public float f943 = 0.0f;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public LayerDrawable f944;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public RectF f945;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C0136 f946 = new C0136();

    /* renamed from: ⁱ  reason: contains not printable characters */
    public Path f947;

    /* renamed from: 㳳  reason: contains not printable characters */
    public Drawable[] f948;

    /* renamed from: 㴹  reason: contains not printable characters */
    public float f949 = Float.NaN;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f950 = 0.0f;

    /* renamed from: 㿎  reason: contains not printable characters */
    public ViewOutlineProvider f951;

    /* renamed from: androidx.constraintlayout.utils.widget.ImageFilterView$ʬ  reason: contains not printable characters */
    public static class C0136 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public ColorMatrix f952 = new ColorMatrix();

        /* renamed from: ඓ  reason: contains not printable characters */
        public float f953 = 1.0f;

        /* renamed from: ῲ  reason: contains not printable characters */
        public ColorMatrix f954 = new ColorMatrix();

        /* renamed from: ⁱ  reason: contains not printable characters */
        public float f955 = 1.0f;

        /* renamed from: K  reason: contains not printable characters */
        public float[] f956 = new float[20];

        /* renamed from: 㴹  reason: contains not printable characters */
        public float f957 = 1.0f;

        /* renamed from: 㸾  reason: contains not printable characters */
        public float f958 = 1.0f;

        /* renamed from: K  reason: contains not printable characters */
        public void m532(ImageView imageView) {
            float f;
            boolean z;
            float f2;
            float f3;
            this.f954.reset();
            float f4 = this.f953;
            boolean z2 = true;
            if (f4 != 1.0f) {
                float f5 = 1.0f - f4;
                float f6 = 0.2999f * f5;
                float f7 = 0.587f * f5;
                float f8 = f5 * 0.114f;
                float[] fArr = this.f956;
                fArr[0] = f6 + f4;
                fArr[1] = f7;
                fArr[2] = f8;
                fArr[3] = 0.0f;
                fArr[4] = 0.0f;
                fArr[5] = f6;
                fArr[6] = f7 + f4;
                fArr[7] = f8;
                fArr[8] = 0.0f;
                fArr[9] = 0.0f;
                fArr[10] = f6;
                fArr[11] = f7;
                fArr[12] = f8 + f4;
                fArr[13] = 0.0f;
                fArr[14] = 0.0f;
                fArr[15] = 0.0f;
                fArr[16] = 0.0f;
                fArr[17] = 0.0f;
                f = 1.0f;
                fArr[18] = 1.0f;
                fArr[19] = 0.0f;
                this.f954.set(fArr);
                z = true;
            } else {
                f = 1.0f;
                z = false;
            }
            float f9 = this.f957;
            if (f9 != f) {
                this.f952.setScale(f9, f9, f9, f);
                this.f954.postConcat(this.f952);
                z = true;
            }
            float f10 = this.f955;
            if (f10 != f) {
                if (f10 <= 0.0f) {
                    f10 = 0.01f;
                }
                float f11 = (5000.0f / f10) / 100.0f;
                if (f11 > 66.0f) {
                    double d = (double) (f11 - 60.0f);
                    f2 = ((float) Math.pow(d, -0.13320475816726685d)) * 329.69873f;
                    f3 = ((float) Math.pow(d, 0.07551484555006027d)) * 288.12216f;
                } else {
                    f3 = (((float) Math.log((double) f11)) * 99.4708f) - 161.11957f;
                    f2 = 255.0f;
                }
                float log = f11 < 66.0f ? f11 > 19.0f ? (((float) Math.log((double) (f11 - 10.0f))) * 138.51773f) - 305.0448f : 0.0f : 255.0f;
                float min = Math.min(255.0f, Math.max(f2, 0.0f));
                float min2 = Math.min(255.0f, Math.max(f3, 0.0f));
                float min3 = Math.min(255.0f, Math.max(log, 0.0f));
                float min4 = Math.min(255.0f, Math.max(255.0f, 0.0f));
                float min5 = Math.min(255.0f, Math.max((((float) Math.log((double) 50.0f)) * 99.4708f) - 161.11957f, 0.0f));
                float min6 = min3 / Math.min(255.0f, Math.max((((float) Math.log((double) 40.0f)) * 138.51773f) - 305.0448f, 0.0f));
                float[] fArr2 = this.f956;
                fArr2[0] = min / min4;
                fArr2[1] = 0.0f;
                fArr2[2] = 0.0f;
                fArr2[3] = 0.0f;
                fArr2[4] = 0.0f;
                fArr2[5] = 0.0f;
                fArr2[6] = min2 / min5;
                fArr2[7] = 0.0f;
                fArr2[8] = 0.0f;
                fArr2[9] = 0.0f;
                fArr2[10] = 0.0f;
                fArr2[11] = 0.0f;
                fArr2[12] = min6;
                fArr2[13] = 0.0f;
                fArr2[14] = 0.0f;
                fArr2[15] = 0.0f;
                fArr2[16] = 0.0f;
                fArr2[17] = 0.0f;
                fArr2[18] = 1.0f;
                fArr2[19] = 0.0f;
                this.f952.set(fArr2);
                this.f954.postConcat(this.f952);
                z = true;
            }
            float f12 = this.f958;
            if (f12 != 1.0f) {
                float[] fArr3 = this.f956;
                fArr3[0] = f12;
                fArr3[1] = 0.0f;
                fArr3[2] = 0.0f;
                fArr3[3] = 0.0f;
                fArr3[4] = 0.0f;
                fArr3[5] = 0.0f;
                fArr3[6] = f12;
                fArr3[7] = 0.0f;
                fArr3[8] = 0.0f;
                fArr3[9] = 0.0f;
                fArr3[10] = 0.0f;
                fArr3[11] = 0.0f;
                fArr3[12] = f12;
                fArr3[13] = 0.0f;
                fArr3[14] = 0.0f;
                fArr3[15] = 0.0f;
                fArr3[16] = 0.0f;
                fArr3[17] = 0.0f;
                fArr3[18] = 1.0f;
                fArr3[19] = 0.0f;
                this.f952.set(fArr3);
                this.f954.postConcat(this.f952);
            } else {
                z2 = z;
            }
            if (z2) {
                imageView.setColorFilter(new ColorMatrixColorFilter(this.f954));
            } else {
                imageView.clearColorFilter();
            }
        }
    }

    /* renamed from: androidx.constraintlayout.utils.widget.ImageFilterView$ῲ  reason: contains not printable characters */
    public class C0137 extends ViewOutlineProvider {
        public C0137() {
        }

        public void getOutline(View view, Outline outline) {
            outline.setRoundRect(0, 0, ImageFilterView.this.getWidth(), ImageFilterView.this.getHeight(), ImageFilterView.this.f949);
        }
    }

    /* renamed from: androidx.constraintlayout.utils.widget.ImageFilterView$K  reason: contains not printable characters */
    public class C0138 extends ViewOutlineProvider {
        public C0138() {
        }

        public void getOutline(View view, Outline outline) {
            int width = ImageFilterView.this.getWidth();
            int height = ImageFilterView.this.getHeight();
            outline.setRoundRect(0, 0, width, height, (((float) Math.min(width, height)) * ImageFilterView.this.f943) / 2.0f);
        }
    }

    public ImageFilterView(Context context) {
        super(context);
        m531(null);
    }

    private void setOverlay(boolean z) {
        this.f942 = z;
    }

    public void draw(Canvas canvas) {
        int i = Build.VERSION.SDK_INT;
        super.draw(canvas);
        if (0 != 0) {
            canvas.restore();
        }
    }

    public float getBrightness() {
        return this.f946.f958;
    }

    public float getContrast() {
        return this.f946.f957;
    }

    public float getCrossfade() {
        return this.f950;
    }

    public float getRound() {
        return this.f949;
    }

    public float getRoundPercent() {
        return this.f943;
    }

    public float getSaturation() {
        return this.f946.f953;
    }

    public float getWarmth() {
        return this.f946.f955;
    }

    public void setBrightness(float f) {
        C0136 r0 = this.f946;
        r0.f958 = f;
        r0.m532(this);
    }

    public void setContrast(float f) {
        C0136 r0 = this.f946;
        r0.f957 = f;
        r0.m532(this);
    }

    public void setCrossfade(float f) {
        this.f950 = f;
        if (this.f948 != null) {
            if (!this.f942) {
                this.f944.getDrawable(0).setAlpha((int) ((1.0f - this.f950) * 255.0f));
            }
            this.f944.getDrawable(1).setAlpha((int) (this.f950 * 255.0f));
            super.setImageDrawable(this.f944);
        }
    }

    public void setRound(float f) {
        if (Float.isNaN(f)) {
            this.f949 = f;
            float f2 = this.f943;
            this.f943 = -1.0f;
            setRoundPercent(f2);
            return;
        }
        boolean z = this.f949 != f;
        this.f949 = f;
        if (this.f949 != 0.0f) {
            if (this.f947 == null) {
                this.f947 = new Path();
            }
            if (this.f945 == null) {
                this.f945 = new RectF();
            }
            int i = Build.VERSION.SDK_INT;
            if (this.f951 == null) {
                this.f951 = new C0137();
                setOutlineProvider(this.f951);
            }
            setClipToOutline(true);
            this.f945.set(0.0f, 0.0f, (float) getWidth(), (float) getHeight());
            this.f947.reset();
            Path path = this.f947;
            RectF rectF = this.f945;
            float f3 = this.f949;
            path.addRoundRect(rectF, f3, f3, Path.Direction.CW);
        } else {
            int i2 = Build.VERSION.SDK_INT;
            setClipToOutline(false);
        }
        if (z) {
            int i3 = Build.VERSION.SDK_INT;
            invalidateOutline();
        }
    }

    public void setRoundPercent(float f) {
        boolean z = this.f943 != f;
        this.f943 = f;
        if (this.f943 != 0.0f) {
            if (this.f947 == null) {
                this.f947 = new Path();
            }
            if (this.f945 == null) {
                this.f945 = new RectF();
            }
            int i = Build.VERSION.SDK_INT;
            if (this.f951 == null) {
                this.f951 = new C0138();
                setOutlineProvider(this.f951);
            }
            setClipToOutline(true);
            int width = getWidth();
            int height = getHeight();
            float min = (((float) Math.min(width, height)) * this.f943) / 2.0f;
            this.f945.set(0.0f, 0.0f, (float) width, (float) height);
            this.f947.reset();
            this.f947.addRoundRect(this.f945, min, min, Path.Direction.CW);
        } else {
            int i2 = Build.VERSION.SDK_INT;
            setClipToOutline(false);
        }
        if (z) {
            int i3 = Build.VERSION.SDK_INT;
            invalidateOutline();
        }
    }

    public void setSaturation(float f) {
        C0136 r0 = this.f946;
        r0.f953 = f;
        r0.m532(this);
    }

    public void setWarmth(float f) {
        C0136 r0 = this.f946;
        r0.f955 = f;
        r0.m532(this);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m531(AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, R$styleable.ImageFilterView);
            int indexCount = obtainStyledAttributes.getIndexCount();
            Drawable drawable = obtainStyledAttributes.getDrawable(R$styleable.ImageFilterView_altSrc);
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.ImageFilterView_crossfade) {
                    this.f950 = obtainStyledAttributes.getFloat(index, 0.0f);
                } else if (index == R$styleable.ImageFilterView_warmth) {
                    setWarmth(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_saturation) {
                    setSaturation(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_contrast) {
                    setContrast(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_round) {
                    int i2 = Build.VERSION.SDK_INT;
                    setRound(obtainStyledAttributes.getDimension(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_roundPercent) {
                    int i3 = Build.VERSION.SDK_INT;
                    setRoundPercent(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_overlay) {
                    setOverlay(obtainStyledAttributes.getBoolean(index, this.f942));
                }
            }
            obtainStyledAttributes.recycle();
            if (drawable != null) {
                this.f948 = new Drawable[2];
                this.f948[0] = getDrawable();
                Drawable[] drawableArr = this.f948;
                drawableArr[1] = drawable;
                this.f944 = new LayerDrawable(drawableArr);
                this.f944.getDrawable(1).setAlpha((int) (this.f950 * 255.0f));
                super.setImageDrawable(this.f944);
            }
        }
    }

    public ImageFilterView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m531(attributeSet);
    }

    public ImageFilterView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m531(attributeSet);
    }
}
