package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R$styleable;

public class Layer extends ConstraintHelper {

    /* renamed from: Ԕ  reason: contains not printable characters */
    public float f669 = 1.0f;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public float f670 = Float.NaN;

    /* renamed from: ؿ  reason: contains not printable characters */
    public float f671 = Float.NaN;

    /* renamed from: ݜ  reason: contains not printable characters */
    public float f672 = Float.NaN;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public float f673 = 0.0f;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public View[] f674 = null;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public float f675 = Float.NaN;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public float f676 = Float.NaN;

    /* renamed from: ゎ  reason: contains not printable characters */
    public boolean f677;

    /* renamed from: ト  reason: contains not printable characters */
    public boolean f678;

    /* renamed from: 㑃  reason: contains not printable characters */
    public float f679 = Float.NaN;

    /* renamed from: 㗗  reason: contains not printable characters */
    public float f680 = 1.0f;

    /* renamed from: 㗽  reason: contains not printable characters */
    public float f681 = Float.NaN;

    /* renamed from: 㳳  reason: contains not printable characters */
    public float f682 = Float.NaN;

    /* renamed from: 㴪  reason: contains not printable characters */
    public float f683 = 0.0f;

    /* renamed from: 㶋  reason: contains not printable characters */
    public boolean f684 = true;

    /* renamed from: 䀟  reason: contains not printable characters */
    public float f685 = Float.NaN;

    /* renamed from: 䁗  reason: contains not printable characters */
    public ConstraintLayout f686;

    public Layer(Context context) {
        super(context);
    }

    @Override // androidx.constraintlayout.widget.ConstraintHelper
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f686 = (ConstraintLayout) getParent();
        if (this.f677 || this.f678) {
            int visibility = getVisibility();
            int i = Build.VERSION.SDK_INT;
            float elevation = getElevation();
            for (int i2 = 0; i2 < this.f990; i2++) {
                View viewById = this.f686.getViewById(this.f993[i2]);
                if (viewById != null) {
                    if (this.f677) {
                        viewById.setVisibility(visibility);
                    }
                    if (this.f678 && elevation > 0.0f) {
                        int i3 = Build.VERSION.SDK_INT;
                        viewById.setTranslationZ(viewById.getTranslationZ() + elevation);
                    }
                }
            }
        }
    }

    public void setElevation(float f) {
        super.setElevation(f);
        m555();
    }

    public void setPivotX(float f) {
        this.f682 = f;
        m391();
    }

    public void setPivotY(float f) {
        this.f676 = f;
        m391();
    }

    public void setRotation(float f) {
        this.f679 = f;
        m391();
    }

    public void setScaleX(float f) {
        this.f669 = f;
        m391();
    }

    public void setScaleY(float f) {
        this.f680 = f;
        m391();
    }

    public void setTranslationX(float f) {
        this.f683 = f;
        m391();
    }

    public void setTranslationY(float f) {
        this.f673 = f;
        m391();
    }

    public void setVisibility(int i) {
        super.setVisibility(i);
        m555();
    }

    @Override // androidx.constraintlayout.widget.ConstraintHelper
    /* renamed from: ʬ  reason: contains not printable characters */
    public void m388(ConstraintLayout constraintLayout) {
        m389();
        this.f671 = Float.NaN;
        this.f675 = Float.NaN;
        ConstraintWidget constraintWidget = ((ConstraintLayout.C0140) getLayoutParams()).f1025;
        constraintWidget.m502(0);
        constraintWidget.m479(0);
        m392();
        layout(((int) this.f685) - getPaddingLeft(), ((int) this.f670) - getPaddingTop(), getPaddingRight() + ((int) this.f681), getPaddingBottom() + ((int) this.f672));
        m391();
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final void m389() {
        int i;
        if (!(this.f686 == null || (i = this.f990) == 0)) {
            View[] viewArr = this.f674;
            if (viewArr == null || viewArr.length != i) {
                this.f674 = new View[this.f990];
            }
            for (int i2 = 0; i2 < this.f990; i2++) {
                this.f674[i2] = this.f686.getViewById(this.f993[i2]);
            }
        }
    }

    @Override // androidx.constraintlayout.widget.ConstraintHelper
    /* renamed from: K  reason: contains not printable characters */
    public void m390(AttributeSet attributeSet) {
        super.m557(attributeSet);
        this.f995 = false;
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, R$styleable.ConstraintLayout_Layout);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.ConstraintLayout_Layout_android_visibility) {
                    this.f677 = true;
                } else if (index == R$styleable.ConstraintLayout_Layout_android_elevation) {
                    this.f678 = true;
                }
            }
            obtainStyledAttributes.recycle();
        }
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public final void m391() {
        if (this.f686 != null) {
            if (this.f674 == null) {
                m389();
            }
            m392();
            double radians = Float.isNaN(this.f679) ? 0.0d : Math.toRadians((double) this.f679);
            float sin = (float) Math.sin(radians);
            float cos = (float) Math.cos(radians);
            float f = this.f669;
            float f2 = f * cos;
            float f3 = this.f680;
            float f4 = (-f3) * sin;
            float f5 = f * sin;
            float f6 = f3 * cos;
            for (int i = 0; i < this.f990; i++) {
                View view = this.f674[i];
                int left = view.getLeft();
                int top2 = view.getTop();
                float right = ((float) ((view.getRight() + left) / 2)) - this.f671;
                float bottom = ((float) ((view.getBottom() + top2) / 2)) - this.f675;
                view.setTranslationX((((f4 * bottom) + (f2 * right)) - right) + this.f683);
                view.setTranslationY((((f6 * bottom) + (right * f5)) - bottom) + this.f673);
                view.setScaleY(this.f680);
                view.setScaleX(this.f669);
                if (!Float.isNaN(this.f679)) {
                    view.setRotation(this.f679);
                }
            }
        }
    }

    @Override // androidx.constraintlayout.widget.ConstraintHelper
    /* renamed from: 㸾  reason: contains not printable characters */
    public void m393(ConstraintLayout constraintLayout) {
        this.f686 = constraintLayout;
        float rotation = getRotation();
        if (rotation != 0.0f) {
            this.f679 = rotation;
        } else if (!Float.isNaN(this.f679)) {
            this.f679 = rotation;
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m392() {
        if (this.f686 != null) {
            if (!(this.f684 || Float.isNaN(this.f671) || Float.isNaN(this.f675))) {
                return;
            }
            if (Float.isNaN(this.f682) || Float.isNaN(this.f676)) {
                View[] r0 = m553(this.f686);
                int left = r0[0].getLeft();
                int top2 = r0[0].getTop();
                int right = r0[0].getRight();
                int bottom = r0[0].getBottom();
                for (int i = 0; i < this.f990; i++) {
                    View view = r0[i];
                    left = Math.min(left, view.getLeft());
                    top2 = Math.min(top2, view.getTop());
                    right = Math.max(right, view.getRight());
                    bottom = Math.max(bottom, view.getBottom());
                }
                this.f681 = (float) right;
                this.f672 = (float) bottom;
                this.f685 = (float) left;
                this.f670 = (float) top2;
                if (Float.isNaN(this.f682)) {
                    this.f671 = (float) ((left + right) / 2);
                } else {
                    this.f671 = this.f682;
                }
                if (Float.isNaN(this.f676)) {
                    this.f675 = (float) ((top2 + bottom) / 2);
                } else {
                    this.f675 = this.f676;
                }
            } else {
                this.f675 = this.f676;
                this.f671 = this.f682;
            }
        }
    }

    public Layer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public Layer(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
    }
}
