package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$dimen;
import androidx.appcompat.R$id;
import androidx.appcompat.R$layout;
import androidx.appcompat.R$string;
import androidx.appcompat.R$styleable;
import androidx.customview.view.AbsSavedState;
import com.appsflyer.share.Constants;
import com.facebook.internal.NativeProtocol;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.ඓ.AbstractC1887;
import ῲ.ῲ.㴹.C2019;
import ῲ.ῲ.㴹.C2033;
import ῲ.ῲ.㴹.View$OnClickListenerC2038;
import ῲ.㳳.K.AbstractC2250;
import K.K.K.ʬ.C2369;

public class SearchView extends LinearLayoutCompat implements AbstractC1887 {

    /* renamed from: Ϸ  reason: contains not printable characters */
    public static final C0099 f572 = (Build.VERSION.SDK_INT < 29 ? new C0099() : null);

    /* renamed from: ʬ  reason: contains not printable characters */
    public final View f573;

    /* renamed from: В  reason: contains not printable characters */
    public CharSequence f574;

    /* renamed from: ѷ  reason: contains not printable characters */
    public final WeakHashMap<String, Drawable.ConstantState> f575;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int[] f576;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public final Intent f577;

    /* renamed from: ؿ  reason: contains not printable characters */
    public final ImageView f578;

    /* renamed from: ݜ  reason: contains not printable characters */
    public final int f579;

    /* renamed from: ࠋ  reason: contains not printable characters */
    public View.OnKeyListener f580;

    /* renamed from: ಯ  reason: contains not printable characters */
    public int f581;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final View f582;

    /* renamed from: ผ  reason: contains not printable characters */
    public final TextView.OnEditorActionListener f583;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public boolean f584;

    /* renamed from: ሽ  reason: contains not printable characters */
    public boolean f585;

    /* renamed from: ጒ  reason: contains not printable characters */
    public SearchableInfo f586;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public boolean f587;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public CharSequence f588;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public View.OnFocusChangeListener f589;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public final Drawable f590;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public C0107 f591;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public boolean f592;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final ImageView f593;

    /* renamed from: ᶲ  reason: contains not printable characters */
    public final View.OnClickListener f594;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final SearchAutoComplete f595;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final ImageView f596;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public int f597;

    /* renamed from: ゎ  reason: contains not printable characters */
    public boolean f598;

    /* renamed from: ト  reason: contains not printable characters */
    public AbstractC2250 f599;

    /* renamed from: ピ  reason: contains not printable characters */
    public final AdapterView.OnItemSelectedListener f600;

    /* renamed from: 㑃  reason: contains not printable characters */
    public Rect f601;

    /* renamed from: 㒁  reason: contains not printable characters */
    public final Runnable f602;

    /* renamed from: 㓚  reason: contains not printable characters */
    public TextWatcher f603;

    /* renamed from: 㗗  reason: contains not printable characters */
    public int[] f604;

    /* renamed from: 㗽  reason: contains not printable characters */
    public final int f605;

    /* renamed from: 㮔  reason: contains not printable characters */
    public boolean f606;

    /* renamed from: 㮝  reason: contains not printable characters */
    public boolean f607;

    /* renamed from: 㱶  reason: contains not printable characters */
    public final AdapterView.OnItemClickListener f608;

    /* renamed from: 㳳  reason: contains not printable characters */
    public final View f609;

    /* renamed from: 㴪  reason: contains not printable characters */
    public View.OnClickListener f610;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final ImageView f611;

    /* renamed from: 㶋  reason: contains not printable characters */
    public final CharSequence f612;

    /* renamed from: 㷛  reason: contains not printable characters */
    public Runnable f613;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final View f614;

    /* renamed from: 㹎  reason: contains not printable characters */
    public Bundle f615;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final ImageView f616;

    /* renamed from: 䀟  reason: contains not printable characters */
    public final Intent f617;

    /* renamed from: 䁗  reason: contains not printable characters */
    public Rect f618;

    /* renamed from: 䃖  reason: contains not printable characters */
    public CharSequence f619;

    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0096();

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f620;

        /* renamed from: androidx.appcompat.widget.SearchView$SavedState$K  reason: contains not printable characters */
        public class C0096 implements Parcelable.ClassLoaderCreator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder r0 = C1293.m3416("SearchView.SavedState{");
            r0.append(Integer.toHexString(System.identityHashCode(this)));
            r0.append(" isIconified=");
            r0.append(this.f620);
            r0.append("}");
            return r0.toString();
        }

        @Override // androidx.customview.view.AbsSavedState
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeValue(Boolean.valueOf(this.f620));
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f620 = ((Boolean) parcel.readValue(null)).booleanValue();
        }
    }

    public static class SearchAutoComplete extends AppCompatAutoCompleteTextView {

        /* renamed from: ʬ  reason: contains not printable characters */
        public SearchView f621;

        /* renamed from: ඓ  reason: contains not printable characters */
        public final Runnable f622;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f623;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f624;

        /* renamed from: androidx.appcompat.widget.SearchView$SearchAutoComplete$K  reason: contains not printable characters */
        public class RunnableC0097 implements Runnable {
            public RunnableC0097() {
            }

            public void run() {
                SearchAutoComplete.this.m364();
            }
        }

        public SearchAutoComplete(Context context) {
            this(context, null);
        }

        private int getSearchViewTextMinWidthDp() {
            Configuration configuration = getResources().getConfiguration();
            int i = configuration.screenWidthDp;
            int i2 = configuration.screenHeightDp;
            if (i >= 960 && i2 >= 720 && configuration.orientation == 2) {
                return 256;
            }
            if (i < 600) {
                return (i < 640 || i2 < 480) ? 160 : 192;
            }
            return 192;
        }

        public boolean enoughToFilter() {
            return this.f623 <= 0 || super.enoughToFilter();
        }

        @Override // androidx.appcompat.widget.AppCompatAutoCompleteTextView
        public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
            InputConnection onCreateInputConnection = super.onCreateInputConnection(editorInfo);
            if (this.f624) {
                removeCallbacks(this.f622);
                post(this.f622);
            }
            return onCreateInputConnection;
        }

        public void onFinishInflate() {
            super.onFinishInflate();
            setMinWidth((int) TypedValue.applyDimension(1, (float) getSearchViewTextMinWidthDp(), getResources().getDisplayMetrics()));
        }

        public void onFocusChanged(boolean z, int i, Rect rect) {
            super.onFocusChanged(z, i, rect);
            this.f621.m359();
        }

        public boolean onKeyPreIme(int i, KeyEvent keyEvent) {
            if (i == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState keyDispatcherState = getKeyDispatcherState();
                    if (keyDispatcherState != null) {
                        keyDispatcherState.startTracking(keyEvent, this);
                    }
                    return true;
                } else if (keyEvent.getAction() == 1) {
                    KeyEvent.DispatcherState keyDispatcherState2 = getKeyDispatcherState();
                    if (keyDispatcherState2 != null) {
                        keyDispatcherState2.handleUpEvent(keyEvent);
                    }
                    if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                        this.f621.clearFocus();
                        setImeVisibility(false);
                        return true;
                    }
                }
            }
            return super.onKeyPreIme(i, keyEvent);
        }

        public void onWindowFocusChanged(boolean z) {
            super.onWindowFocusChanged(z);
            if (z && this.f621.hasFocus() && getVisibility() == 0) {
                this.f624 = true;
                if (SearchView.m336(getContext())) {
                    m366();
                }
            }
        }

        public void performCompletion() {
        }

        public void replaceText(CharSequence charSequence) {
        }

        public void setImeVisibility(boolean z) {
            InputMethodManager inputMethodManager = (InputMethodManager) getContext().getSystemService("input_method");
            if (!z) {
                this.f624 = false;
                removeCallbacks(this.f622);
                inputMethodManager.hideSoftInputFromWindow(getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this)) {
                this.f624 = false;
                removeCallbacks(this.f622);
                inputMethodManager.showSoftInput(this, 0);
            } else {
                this.f624 = true;
            }
        }

        public void setSearchView(SearchView searchView) {
            this.f621 = searchView;
        }

        public void setThreshold(int i) {
            super.setThreshold(i);
            this.f623 = i;
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m364() {
            if (this.f624) {
                ((InputMethodManager) getContext().getSystemService("input_method")).showSoftInput(this, 0);
                this.f624 = false;
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean m365() {
            return TextUtils.getTrimmedLength(getText()) == 0;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m366() {
            if (Build.VERSION.SDK_INT >= 29) {
                setInputMethodMode(1);
                if (enoughToFilter()) {
                    showDropDown();
                    return;
                }
                return;
            }
            SearchView.f572.m368(this);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            this(context, attributeSet, R$attr.autoCompleteTextViewStyle);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int i) {
            super(context, attributeSet, i);
            this.f622 = new RunnableC0097();
            this.f623 = getThreshold();
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$ʬ  reason: contains not printable characters */
    public class RunnableC0098 implements Runnable {
        public RunnableC0098() {
        }

        public void run() {
            AbstractC2250 k = SearchView.this.f599;
            if (k instanceof View$OnClickListenerC2038) {
                k.m5874(null);
            }
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$ඓ  reason: contains not printable characters */
    public class View$OnLayoutChangeListenerC0100 implements View.OnLayoutChangeListener {
        public View$OnLayoutChangeListenerC0100() {
        }

        public void onLayoutChange(View view, int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
            SearchView.this.m337();
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$ᕣ  reason: contains not printable characters */
    public interface AbstractC0101 {
    }

    /* renamed from: androidx.appcompat.widget.SearchView$ᨨ  reason: contains not printable characters */
    public class C0102 implements AdapterView.OnItemClickListener {
        public C0102() {
        }

        @Override // android.widget.AdapterView.OnItemClickListener
        public void onItemClick(AdapterView<?> adapterView, View view, int i, long j) {
            SearchView.this.m355(i);
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$ῲ  reason: contains not printable characters */
    public class RunnableC0103 implements Runnable {
        public RunnableC0103() {
        }

        public void run() {
            SearchView.this.m363();
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$ⁱ  reason: contains not printable characters */
    public class View$OnKeyListenerC0104 implements View.OnKeyListener {
        public View$OnKeyListenerC0104() {
        }

        public boolean onKey(View view, int i, KeyEvent keyEvent) {
            SearchView searchView = SearchView.this;
            if (searchView.f586 == null) {
                return false;
            }
            if (searchView.f595.isPopupShowing() && SearchView.this.f595.getListSelection() != -1) {
                return SearchView.this.m356(i, keyEvent);
            }
            if (SearchView.this.f595.m365() || !keyEvent.hasNoModifiers() || keyEvent.getAction() != 1 || i != 66) {
                return false;
            }
            view.cancelLongPress();
            SearchView searchView2 = SearchView.this;
            searchView2.m351(0, null, searchView2.f595.getText().toString());
            return true;
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$K  reason: contains not printable characters */
    public class C0105 implements TextWatcher {
        public C0105() {
        }

        public void afterTextChanged(Editable editable) {
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            SearchView.this.m344(charSequence);
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$㑃  reason: contains not printable characters */
    public interface AbstractC0106 {
    }

    /* renamed from: androidx.appcompat.widget.SearchView$㗗  reason: contains not printable characters */
    public static class C0107 extends TouchDelegate {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final Rect f635 = new Rect();

        /* renamed from: ඓ  reason: contains not printable characters */
        public final int f636;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final Rect f637 = new Rect();

        /* renamed from: K  reason: contains not printable characters */
        public final View f638;

        /* renamed from: 㴹  reason: contains not printable characters */
        public boolean f639;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final Rect f640 = new Rect();

        public C0107(Rect rect, Rect rect2, View view) {
            super(rect, view);
            this.f636 = ViewConfiguration.get(view.getContext()).getScaledTouchSlop();
            m371(rect, rect2);
            this.f638 = view;
        }

        /* JADX WARNING: Removed duplicated region for block: B:17:0x003d  */
        /* JADX WARNING: Removed duplicated region for block: B:24:? A[RETURN, SYNTHETIC] */
        public boolean onTouchEvent(MotionEvent motionEvent) {
            boolean z;
            int x = (int) motionEvent.getX();
            int y = (int) motionEvent.getY();
            int action = motionEvent.getAction();
            boolean z2 = true;
            if (action != 0) {
                if (action == 1 || action == 2) {
                    z = this.f639;
                    if (z && !this.f640.contains(x, y)) {
                        z2 = false;
                    }
                    if (z) {
                        return false;
                    }
                    if (!z2 || this.f635.contains(x, y)) {
                        Rect rect = this.f635;
                        motionEvent.setLocation((float) (x - rect.left), (float) (y - rect.top));
                    } else {
                        motionEvent.setLocation((float) (this.f638.getWidth() / 2), (float) (this.f638.getHeight() / 2));
                    }
                    return this.f638.dispatchTouchEvent(motionEvent);
                } else if (action == 3) {
                    z = this.f639;
                    this.f639 = false;
                    if (z) {
                    }
                }
            } else if (this.f637.contains(x, y)) {
                this.f639 = true;
                z = true;
                if (z) {
                }
            }
            z = false;
            if (z) {
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m371(Rect rect, Rect rect2) {
            this.f637.set(rect);
            this.f640.set(rect);
            Rect rect3 = this.f640;
            int i = this.f636;
            rect3.inset(-i, -i);
            this.f635.set(rect2);
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$㳳  reason: contains not printable characters */
    public class C0108 implements AdapterView.OnItemSelectedListener {
        public C0108() {
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onItemSelected(AdapterView<?> adapterView, View view, int i, long j) {
            SearchView.this.m346(i);
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onNothingSelected(AdapterView<?> adapterView) {
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$㴹  reason: contains not printable characters */
    public class View$OnClickListenerC0109 implements View.OnClickListener {
        public View$OnClickListenerC0109() {
        }

        public void onClick(View view) {
            SearchView searchView = SearchView.this;
            if (view == searchView.f611) {
                searchView.m362();
            } else if (view == searchView.f616) {
                searchView.m347();
            } else if (view == searchView.f596) {
                searchView.m342();
            } else if (view == searchView.f593) {
                searchView.m341();
            } else if (view == searchView.f595) {
                searchView.m361();
            }
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$㸾  reason: contains not printable characters */
    public class View$OnFocusChangeListenerC0110 implements View.OnFocusChangeListener {
        public View$OnFocusChangeListenerC0110() {
        }

        public void onFocusChange(View view, boolean z) {
            SearchView searchView = SearchView.this;
            View.OnFocusChangeListener onFocusChangeListener = searchView.f589;
            if (onFocusChangeListener != null) {
                onFocusChangeListener.onFocusChange(searchView, z);
            }
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$㿎  reason: contains not printable characters */
    public class C0111 implements TextView.OnEditorActionListener {
        public C0111() {
        }

        public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
            SearchView.this.m342();
            return true;
        }
    }

    /* renamed from: androidx.appcompat.widget.SearchView$䁗  reason: contains not printable characters */
    public interface AbstractC0112 {
    }

    public SearchView(Context context) {
        this(context, null);
    }

    private int getPreferredHeight() {
        return getContext().getResources().getDimensionPixelSize(R$dimen.abc_search_view_preferred_height);
    }

    private int getPreferredWidth() {
        return getContext().getResources().getDimensionPixelSize(R$dimen.abc_search_view_preferred_width);
    }

    private void setQuery(CharSequence charSequence) {
        this.f595.setText(charSequence);
        this.f595.setSelection(TextUtils.isEmpty(charSequence) ? 0 : charSequence.length());
    }

    public void clearFocus() {
        this.f584 = true;
        super.clearFocus();
        this.f595.clearFocus();
        this.f595.setImeVisibility(false);
        this.f584 = false;
    }

    public int getImeOptions() {
        return this.f595.getImeOptions();
    }

    public int getInputType() {
        return this.f595.getInputType();
    }

    public int getMaxWidth() {
        return this.f597;
    }

    public CharSequence getQuery() {
        return this.f595.getText();
    }

    public CharSequence getQueryHint() {
        CharSequence charSequence = this.f619;
        if (charSequence != null) {
            return charSequence;
        }
        SearchableInfo searchableInfo = this.f586;
        if (searchableInfo == null || searchableInfo.getHintId() == 0) {
            return this.f612;
        }
        return getContext().getText(this.f586.getHintId());
    }

    public int getSuggestionCommitIconResId() {
        return this.f579;
    }

    public int getSuggestionRowLayout() {
        return this.f605;
    }

    public AbstractC2250 getSuggestionsAdapter() {
        return this.f599;
    }

    public void onDetachedFromWindow() {
        removeCallbacks(this.f602);
        post(this.f613);
        super.onDetachedFromWindow();
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        if (z) {
            SearchAutoComplete searchAutoComplete = this.f595;
            Rect rect = this.f601;
            searchAutoComplete.getLocationInWindow(this.f576);
            getLocationInWindow(this.f604);
            int[] iArr = this.f576;
            int i5 = iArr[1];
            int[] iArr2 = this.f604;
            int i6 = i5 - iArr2[1];
            int i7 = iArr[0] - iArr2[0];
            rect.set(i7, i6, searchAutoComplete.getWidth() + i7, searchAutoComplete.getHeight() + i6);
            Rect rect2 = this.f618;
            Rect rect3 = this.f601;
            rect2.set(rect3.left, 0, rect3.right, i4 - i2);
            C0107 r4 = this.f591;
            if (r4 == null) {
                this.f591 = new C0107(this.f618, this.f601, this.f595);
                setTouchDelegate(this.f591);
                return;
            }
            r4.m371(this.f618, this.f601);
        }
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat
    public void onMeasure(int i, int i2) {
        int i3;
        if (m340()) {
            super.onMeasure(i, i2);
            return;
        }
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        if (mode == Integer.MIN_VALUE) {
            int i4 = this.f597;
            size = i4 > 0 ? Math.min(i4, size) : Math.min(getPreferredWidth(), size);
        } else if (mode == 0) {
            size = this.f597;
            if (size <= 0) {
                size = getPreferredWidth();
            }
        } else if (mode == 1073741824 && (i3 = this.f597) > 0) {
            size = Math.min(i3, size);
        }
        int mode2 = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i2);
        if (mode2 == Integer.MIN_VALUE) {
            size2 = Math.min(getPreferredHeight(), size2);
        } else if (mode2 == 0) {
            size2 = getPreferredHeight();
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(size, 1073741824), View.MeasureSpec.makeMeasureSpec(size2, 1073741824));
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        m345(savedState.f620);
        requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.f620 = m340();
        return savedState;
    }

    public void onWindowFocusChanged(boolean z) {
        super.onWindowFocusChanged(z);
        post(this.f602);
    }

    public boolean requestFocus(int i, Rect rect) {
        if (this.f584 || !isFocusable()) {
            return false;
        }
        if (m340()) {
            return super.requestFocus(i, rect);
        }
        boolean requestFocus = this.f595.requestFocus(i, rect);
        if (requestFocus) {
            m345(false);
        }
        return requestFocus;
    }

    public void setAppSearchData(Bundle bundle) {
        this.f615 = bundle;
    }

    public void setIconified(boolean z) {
        if (z) {
            m347();
        } else {
            m362();
        }
    }

    public void setIconifiedByDefault(boolean z) {
        if (this.f587 != z) {
            this.f587 = z;
            m345(z);
            m339();
        }
    }

    public void setImeOptions(int i) {
        this.f595.setImeOptions(i);
    }

    public void setInputType(int i) {
        this.f595.setInputType(i);
    }

    public void setMaxWidth(int i) {
        this.f597 = i;
        requestLayout();
    }

    public void setOnCloseListener(AbstractC0101 r1) {
    }

    public void setOnQueryTextFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.f589 = onFocusChangeListener;
    }

    public void setOnQueryTextListener(AbstractC0106 r1) {
    }

    public void setOnSearchClickListener(View.OnClickListener onClickListener) {
        this.f610 = onClickListener;
    }

    public void setOnSuggestionListener(AbstractC0112 r1) {
    }

    public void setQueryHint(CharSequence charSequence) {
        this.f619 = charSequence;
        m339();
    }

    public void setQueryRefinementEnabled(boolean z) {
        this.f592 = z;
        AbstractC2250 k = this.f599;
        if (k instanceof View$OnClickListenerC2038) {
            ((View$OnClickListenerC2038) k).f6908 = z ? 2 : 1;
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:30:0x00a1, code lost:
        if (getContext().getPackageManager().resolveActivity(r2, com.facebook.internal.NativeProtocol.MESSAGE_GET_ACCESS_TOKEN_REQUEST) != null) goto L_0x00a5;
     */
    public void setSearchableInfo(SearchableInfo searchableInfo) {
        this.f586 = searchableInfo;
        SearchableInfo searchableInfo2 = this.f586;
        boolean z = true;
        Intent intent = null;
        if (searchableInfo2 != null) {
            this.f595.setThreshold(searchableInfo2.getSuggestThreshold());
            this.f595.setImeOptions(this.f586.getImeOptions());
            int inputType = this.f586.getInputType();
            if ((inputType & 15) == 1) {
                inputType &= -65537;
                if (this.f586.getSuggestAuthority() != null) {
                    inputType = inputType | NativeProtocol.MESSAGE_GET_ACCESS_TOKEN_REQUEST | 524288;
                }
            }
            this.f595.setInputType(inputType);
            AbstractC2250 k = this.f599;
            if (k != null) {
                k.m5874(null);
            }
            if (this.f586.getSuggestAuthority() != null) {
                this.f599 = new View$OnClickListenerC2038(getContext(), this, this.f586, this.f575);
                this.f595.setAdapter(this.f599);
                ((View$OnClickListenerC2038) this.f599).m5288(this.f592 ? 2 : 1);
            }
            m339();
        }
        SearchableInfo searchableInfo3 = this.f586;
        if (searchableInfo3 != null && searchableInfo3.getVoiceSearchEnabled()) {
            if (this.f586.getVoiceSearchLaunchWebSearch()) {
                intent = this.f617;
            } else if (this.f586.getVoiceSearchLaunchRecognizer()) {
                intent = this.f577;
            }
            if (intent != null) {
            }
        }
        z = false;
        this.f585 = z;
        if (this.f585) {
            this.f595.setPrivateImeOptions("nm");
        }
        m345(m340());
    }

    public void setSubmitButtonEnabled(boolean z) {
        this.f606 = z;
        m345(m340());
    }

    public void setSuggestionsAdapter(AbstractC2250 k) {
        this.f599 = k;
        this.f595.setAdapter(this.f599);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final void m338(boolean z) {
        int i;
        if (!this.f585 || m340() || !z) {
            i = 8;
        } else {
            i = 0;
            this.f596.setVisibility(8);
        }
        this.f593.setVisibility(i);
    }

    /* renamed from: Ԕ  reason: contains not printable characters */
    public final void m339() {
        SpannableStringBuilder queryHint = getQueryHint();
        SearchAutoComplete searchAutoComplete = this.f595;
        if (queryHint == null) {
            queryHint = "";
        }
        if (this.f587 && this.f590 != null) {
            int textSize = (int) (((double) this.f595.getTextSize()) * 1.25d);
            this.f590.setBounds(0, 0, textSize, textSize);
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder("   ");
            spannableStringBuilder.setSpan(new ImageSpan(this.f590), 1, 2, 33);
            spannableStringBuilder.append(queryHint);
            queryHint = spannableStringBuilder;
        }
        searchAutoComplete.setHint(queryHint);
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m340() {
        return this.f598;
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public void m341() {
        String str;
        SearchableInfo searchableInfo = this.f586;
        if (searchableInfo != null) {
            try {
                if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                    Intent intent = new Intent(this.f617);
                    ComponentName searchActivity = searchableInfo.getSearchActivity();
                    if (searchActivity == null) {
                        str = null;
                    } else {
                        str = searchActivity.flattenToShortString();
                    }
                    intent.putExtra("calling_package", str);
                    getContext().startActivity(intent);
                } else if (searchableInfo.getVoiceSearchLaunchRecognizer()) {
                    getContext().startActivity(m348(this.f577, searchableInfo));
                }
            } catch (ActivityNotFoundException unused) {
                Log.w("SearchView", "Could not find voice search activity");
            }
        }
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public void m342() {
        Editable text = this.f595.getText();
        if (text != null && TextUtils.getTrimmedLength(text) > 0) {
            if (this.f586 != null) {
                m351(0, null, text.toString());
            }
            this.f595.setImeVisibility(false);
            this.f595.dismissDropDown();
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m345(boolean z) {
        this.f598 = z;
        int i = 0;
        int i2 = z ? 0 : 8;
        boolean z2 = !TextUtils.isEmpty(this.f595.getText());
        this.f611.setVisibility(i2);
        m354(z2);
        this.f573.setVisibility(z ? 8 : 0);
        if (this.f578.getDrawable() == null || this.f587) {
            i = 8;
        }
        this.f578.setVisibility(i);
        m357();
        m338(!z2);
        m358();
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public void m347() {
        if (!TextUtils.isEmpty(this.f595.getText())) {
            this.f595.setText("");
            this.f595.requestFocus();
            this.f595.setImeVisibility(true);
        } else if (this.f587) {
            clearFocus();
            m345(true);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m353(CharSequence charSequence, boolean z) {
        this.f595.setText(charSequence);
        if (charSequence != null) {
            SearchAutoComplete searchAutoComplete = this.f595;
            searchAutoComplete.setSelection(searchAutoComplete.length());
            this.f574 = charSequence;
        }
        if (z && !TextUtils.isEmpty(charSequence)) {
            m342();
        }
    }

    /* renamed from: 㑃  reason: contains not printable characters */
    public final void m357() {
        boolean z = true;
        boolean z2 = !TextUtils.isEmpty(this.f595.getText());
        int i = 0;
        if (!z2 && (!this.f587 || this.f607)) {
            z = false;
        }
        ImageView imageView = this.f616;
        if (!z) {
            i = 8;
        }
        imageView.setVisibility(i);
        Drawable drawable = this.f616.getDrawable();
        if (drawable != null) {
            drawable.setState(z2 ? ViewGroup.ENABLED_STATE_SET : ViewGroup.EMPTY_STATE_SET);
        }
    }

    /* renamed from: 㗗  reason: contains not printable characters */
    public final void m358() {
        this.f582.setVisibility((!m360() || !(this.f596.getVisibility() == 0 || this.f593.getVisibility() == 0)) ? 8 : 0);
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public void m359() {
        m345(m340());
        post(this.f602);
        if (this.f595.hasFocus()) {
            m361();
        }
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public final boolean m360() {
        return (this.f606 || this.f585) && !m340();
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m361() {
        if (Build.VERSION.SDK_INT >= 29) {
            this.f595.refreshAutoCompleteResults();
            return;
        }
        f572.m369(this.f595);
        f572.m370(this.f595);
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public void m362() {
        m345(false);
        this.f595.requestFocus();
        this.f595.setImeVisibility(true);
        View.OnClickListener onClickListener = this.f610;
        if (onClickListener != null) {
            onClickListener.onClick(this);
        }
    }

    /* renamed from: 䁗  reason: contains not printable characters */
    public void m363() {
        int[] iArr = this.f595.hasFocus() ? ViewGroup.FOCUSED_STATE_SET : ViewGroup.EMPTY_STATE_SET;
        Drawable background = this.f614.getBackground();
        if (background != null) {
            background.setState(iArr);
        }
        Drawable background2 = this.f582.getBackground();
        if (background2 != null) {
            background2.setState(iArr);
        }
        invalidate();
    }

    public SearchView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.searchViewStyle);
    }

    /* renamed from: androidx.appcompat.widget.SearchView$Ԕ  reason: contains not printable characters */
    public static class C0099 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public Method f627 = null;

        /* renamed from: ῲ  reason: contains not printable characters */
        public Method f628 = null;

        /* renamed from: K  reason: contains not printable characters */
        public Method f629 = null;

        @SuppressLint({"DiscouragedPrivateApi", "SoonBlockedPrivateApi"})
        public C0099() {
            m367();
            try {
                this.f629 = AutoCompleteTextView.class.getDeclaredMethod("doBeforeTextChanged", new Class[0]);
                this.f629.setAccessible(true);
            } catch (NoSuchMethodException unused) {
            }
            try {
                this.f628 = AutoCompleteTextView.class.getDeclaredMethod("doAfterTextChanged", new Class[0]);
                this.f628.setAccessible(true);
            } catch (NoSuchMethodException unused2) {
            }
            try {
                this.f627 = AutoCompleteTextView.class.getMethod("ensureImeVisible", Boolean.TYPE);
                this.f627.setAccessible(true);
            } catch (NoSuchMethodException unused3) {
            }
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m368(AutoCompleteTextView autoCompleteTextView) {
            m367();
            Method method = this.f627;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, true);
                } catch (Exception unused) {
                }
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m369(AutoCompleteTextView autoCompleteTextView) {
            m367();
            Method method = this.f629;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, new Object[0]);
                } catch (Exception unused) {
                }
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m370(AutoCompleteTextView autoCompleteTextView) {
            m367();
            Method method = this.f628;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, new Object[0]);
                } catch (Exception unused) {
                }
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public static void m367() {
            if (Build.VERSION.SDK_INT >= 29) {
                throw new UnsupportedClassVersionError("This function can only be used for API Level < 29.");
            }
        }
    }

    public SearchView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f601 = new Rect();
        this.f618 = new Rect();
        this.f576 = new int[2];
        this.f604 = new int[2];
        this.f602 = new RunnableC0103();
        this.f613 = new RunnableC0098();
        this.f575 = new WeakHashMap<>();
        this.f594 = new View$OnClickListenerC0109();
        this.f580 = new View$OnKeyListenerC0104();
        this.f583 = new C0111();
        this.f608 = new C0102();
        this.f600 = new C0108();
        this.f603 = new C0105();
        C2019 r1 = new C2019(context, context.obtainStyledAttributes(attributeSet, R$styleable.SearchView, i, 0));
        LayoutInflater.from(context).inflate(r1.m5230(R$styleable.SearchView_layout, R$layout.abc_search_view), (ViewGroup) this, true);
        this.f595 = (SearchAutoComplete) findViewById(R$id.search_src_text);
        this.f595.setSearchView(this);
        this.f573 = findViewById(R$id.search_edit_frame);
        this.f614 = findViewById(R$id.search_plate);
        this.f582 = findViewById(R$id.submit_area);
        this.f611 = (ImageView) findViewById(R$id.search_button);
        this.f596 = (ImageView) findViewById(R$id.search_go_btn);
        this.f616 = (ImageView) findViewById(R$id.search_close_btn);
        this.f593 = (ImageView) findViewById(R$id.search_voice_btn);
        this.f578 = (ImageView) findViewById(R$id.search_mag_icon);
        C1729.m4478(this.f614, r1.m5229(R$styleable.SearchView_queryBackground));
        View view = this.f582;
        Drawable r5 = r1.m5229(R$styleable.SearchView_submitBackground);
        int i2 = Build.VERSION.SDK_INT;
        view.setBackground(r5);
        this.f611.setImageDrawable(r1.m5229(R$styleable.SearchView_searchIcon));
        this.f596.setImageDrawable(r1.m5229(R$styleable.SearchView_goIcon));
        this.f616.setImageDrawable(r1.m5229(R$styleable.SearchView_closeIcon));
        this.f593.setImageDrawable(r1.m5229(R$styleable.SearchView_voiceIcon));
        this.f578.setImageDrawable(r1.m5229(R$styleable.SearchView_searchIcon));
        this.f590 = r1.m5229(R$styleable.SearchView_searchHintIcon);
        C2369.m6331((View) this.f611, (CharSequence) getResources().getString(R$string.abc_searchview_description_search));
        this.f605 = r1.m5230(R$styleable.SearchView_suggestionRowLayout, R$layout.abc_search_dropdown_item_icons_2line);
        this.f579 = r1.m5230(R$styleable.SearchView_commitIcon, 0);
        this.f611.setOnClickListener(this.f594);
        this.f616.setOnClickListener(this.f594);
        this.f596.setOnClickListener(this.f594);
        this.f593.setOnClickListener(this.f594);
        this.f595.setOnClickListener(this.f594);
        this.f595.addTextChangedListener(this.f603);
        this.f595.setOnEditorActionListener(this.f583);
        this.f595.setOnItemClickListener(this.f608);
        this.f595.setOnItemSelectedListener(this.f600);
        this.f595.setOnKeyListener(this.f580);
        this.f595.setOnFocusChangeListener(new View$OnFocusChangeListenerC0110());
        setIconifiedByDefault(r1.m5235(R$styleable.SearchView_iconifiedByDefault, true));
        int r4 = r1.m5224(R$styleable.SearchView_android_maxWidth, -1);
        if (r4 != -1) {
            setMaxWidth(r4);
        }
        this.f612 = r1.m5227(R$styleable.SearchView_defaultQueryHint);
        this.f619 = r1.m5227(R$styleable.SearchView_queryHint);
        int r42 = r1.m5238(R$styleable.SearchView_android_imeOptions, -1);
        if (r42 != -1) {
            setImeOptions(r42);
        }
        int r43 = r1.m5238(R$styleable.SearchView_android_inputType, -1);
        if (r43 != -1) {
            setInputType(r43);
        }
        setFocusable(r1.m5235(R$styleable.SearchView_android_focusable, true));
        r1.f6846.recycle();
        this.f617 = new Intent("android.speech.action.WEB_SEARCH");
        this.f617.addFlags(268435456);
        this.f617.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.f577 = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.f577.addFlags(268435456);
        this.f609 = findViewById(this.f595.getDropDownAnchor());
        View view2 = this.f609;
        if (view2 != null) {
            view2.addOnLayoutChangeListener(new View$OnLayoutChangeListenerC0100());
        }
        m345(this.f587);
        m339();
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m337() {
        int i;
        int i2;
        if (this.f609.getWidth() > 1) {
            Resources resources = getContext().getResources();
            int paddingLeft = this.f614.getPaddingLeft();
            Rect rect = new Rect();
            boolean r3 = C2033.m5266(this);
            if (this.f587) {
                i = resources.getDimensionPixelSize(R$dimen.abc_dropdownitem_text_padding_left) + resources.getDimensionPixelSize(R$dimen.abc_dropdownitem_icon_width);
            } else {
                i = 0;
            }
            this.f595.getDropDownBackground().getPadding(rect);
            if (r3) {
                i2 = -rect.left;
            } else {
                i2 = paddingLeft - (rect.left + i);
            }
            this.f595.setDropDownHorizontalOffset(i2);
            this.f595.setDropDownWidth((((this.f609.getWidth() + rect.left) + rect.right) + i) - paddingLeft);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m354(boolean z) {
        this.f596.setVisibility((!this.f606 || !m360() || !hasFocus() || (!z && this.f585)) ? 8 : 0);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m352(CharSequence charSequence) {
        setQuery(charSequence);
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m356(int i, KeyEvent keyEvent) {
        int i2;
        if (this.f586 != null && this.f599 != null && keyEvent.getAction() == 0 && keyEvent.hasNoModifiers()) {
            if (i == 66 || i == 84 || i == 61) {
                return m355(this.f595.getListSelection());
            }
            if (i == 21 || i == 22) {
                if (i == 21) {
                    i2 = 0;
                } else {
                    i2 = this.f595.length();
                }
                this.f595.setSelection(i2);
                this.f595.setListSelection(0);
                this.f595.clearListSelection();
                this.f595.m366();
                return true;
            } else if (i != 19 || this.f595.getListSelection() == 0) {
                return false;
            }
        }
        return false;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m344(CharSequence charSequence) {
        Editable text = this.f595.getText();
        this.f574 = text;
        boolean z = !TextUtils.isEmpty(text);
        m354(z);
        m338(!z);
        m357();
        m358();
        this.f588 = charSequence.toString();
    }

    @Override // ῲ.ῲ.ඓ.AbstractC1887
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m343() {
        m353("", false);
        clearFocus();
        m345(true);
        this.f595.setImeOptions(this.f581);
        this.f607 = false;
    }

    @Override // ῲ.ῲ.ඓ.AbstractC1887
    /* renamed from: K  reason: contains not printable characters */
    public void m350() {
        if (!this.f607) {
            this.f607 = true;
            this.f581 = this.f595.getImeOptions();
            this.f595.setImeOptions(this.f581 | 33554432);
            this.f595.setText("");
            setIconified(false);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m346(int i) {
        Editable text = this.f595.getText();
        Cursor cursor = this.f599.f7756;
        if (cursor == null) {
            return true;
        }
        if (cursor.moveToPosition(i)) {
            CharSequence r3 = this.f599.m5872(cursor);
            if (r3 != null) {
                setQuery(r3);
                return true;
            }
            setQuery(text);
            return true;
        }
        setQuery(text);
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m355(int i) {
        int i2;
        Uri uri;
        String r3;
        Cursor cursor = this.f599.f7756;
        if (cursor != null && cursor.moveToPosition(i)) {
            Intent intent = null;
            try {
                String r2 = View$OnClickListenerC2038.m5280(cursor, "suggest_intent_action");
                if (r2 == null) {
                    r2 = this.f586.getSuggestIntentAction();
                }
                if (r2 == null) {
                    r2 = "android.intent.action.SEARCH";
                }
                String r22 = View$OnClickListenerC2038.m5279(cursor, cursor.getColumnIndex("suggest_intent_data"));
                if (r22 == null) {
                    r22 = this.f586.getSuggestIntentData();
                }
                if (!(r22 == null || (r3 = View$OnClickListenerC2038.m5279(cursor, cursor.getColumnIndex("suggest_intent_data_id"))) == null)) {
                    r22 = r22 + Constants.URL_PATH_DELIMITER + Uri.encode(r3);
                }
                if (r22 == null) {
                    uri = null;
                } else {
                    uri = Uri.parse(r22);
                }
                intent = m349(r2, uri, View$OnClickListenerC2038.m5279(cursor, cursor.getColumnIndex("suggest_intent_extra_data")), View$OnClickListenerC2038.m5279(cursor, cursor.getColumnIndex("suggest_intent_query")), 0, null);
            } catch (RuntimeException e) {
                try {
                    i2 = cursor.getPosition();
                } catch (RuntimeException unused) {
                    i2 = -1;
                }
                Log.w("SearchView", "Search suggestions cursor at row " + i2 + " returned exception.", e);
            }
            if (intent != null) {
                try {
                    getContext().startActivity(intent);
                } catch (RuntimeException e2) {
                    Log.e("SearchView", "Failed launch activity: " + intent, e2);
                }
            }
        }
        this.f595.setImeVisibility(false);
        this.f595.dismissDropDown();
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m351(int i, String str, String str2) {
        getContext().startActivity(m349("android.intent.action.SEARCH", null, null, str2, i, str));
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Intent m349(String str, Uri uri, String str2, String str3, int i, String str4) {
        Intent intent = new Intent(str);
        intent.addFlags(268435456);
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra("user_query", this.f574);
        if (str3 != null) {
            intent.putExtra("query", str3);
        }
        if (str2 != null) {
            intent.putExtra("intent_extra_data_key", str2);
        }
        Bundle bundle = this.f615;
        if (bundle != null) {
            intent.putExtra("app_data", bundle);
        }
        if (i != 0) {
            intent.putExtra("action_key", i);
            intent.putExtra("action_msg", str4);
        }
        intent.setComponent(this.f586.getSearchActivity());
        return intent;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Intent m348(Intent intent, SearchableInfo searchableInfo) {
        ComponentName searchActivity = searchableInfo.getSearchActivity();
        Intent intent2 = new Intent("android.intent.action.SEARCH");
        intent2.setComponent(searchActivity);
        PendingIntent activity = PendingIntent.getActivity(getContext(), 0, intent2, 1073741824);
        Bundle bundle = new Bundle();
        Bundle bundle2 = this.f615;
        if (bundle2 != null) {
            bundle.putParcelable("app_data", bundle2);
        }
        Intent intent3 = new Intent(intent);
        int i = 1;
        Resources resources = getResources();
        String string = searchableInfo.getVoiceLanguageModeId() != 0 ? resources.getString(searchableInfo.getVoiceLanguageModeId()) : "free_form";
        String str = null;
        String string2 = searchableInfo.getVoicePromptTextId() != 0 ? resources.getString(searchableInfo.getVoicePromptTextId()) : null;
        String string3 = searchableInfo.getVoiceLanguageId() != 0 ? resources.getString(searchableInfo.getVoiceLanguageId()) : null;
        if (searchableInfo.getVoiceMaxResults() != 0) {
            i = searchableInfo.getVoiceMaxResults();
        }
        intent3.putExtra("android.speech.extra.LANGUAGE_MODEL", string);
        intent3.putExtra("android.speech.extra.PROMPT", string2);
        intent3.putExtra("android.speech.extra.LANGUAGE", string3);
        intent3.putExtra("android.speech.extra.MAX_RESULTS", i);
        if (searchActivity != null) {
            str = searchActivity.flattenToShortString();
        }
        intent3.putExtra("calling_package", str);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", activity);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent3;
    }

    /* renamed from: K  reason: contains not printable characters */
    public static boolean m336(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }
}
