package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.appcompat.R$styleable;
import com.google.android.material.badge.BadgeDrawable;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.C2033;
import K.K.K.ʬ.C2369;

public class LinearLayoutCompat extends ViewGroup {
    public static final String ACCESSIBILITY_CLASS_NAME = "androidx.appcompat.widget.LinearLayoutCompat";
    public static final int HORIZONTAL = 0;
    public static final int INDEX_BOTTOM = 2;
    public static final int INDEX_CENTER_VERTICAL = 0;
    public static final int INDEX_FILL = 3;
    public static final int INDEX_TOP = 1;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int VERTICAL = 1;
    public static final int VERTICAL_GRAVITY_COUNT = 4;
    public boolean mBaselineAligned;
    public int mBaselineAlignedChildIndex;
    public int mBaselineChildTop;
    public Drawable mDivider;
    public int mDividerHeight;
    public int mDividerPadding;
    public int mDividerWidth;
    public int mGravity;
    public int[] mMaxAscent;
    public int[] mMaxDescent;
    public int mOrientation;
    public int mShowDividers;
    public int mTotalLength;
    public boolean mUseLargestChild;
    public float mWeightSum;

    public LinearLayoutCompat(Context context) {
        this(context, null);
    }

    private void forceUniformHeight(int i, int i2) {
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(getMeasuredHeight(), 1073741824);
        for (int i3 = 0; i3 < i; i3++) {
            View virtualChildAt = getVirtualChildAt(i3);
            if (virtualChildAt.getVisibility() != 8) {
                C0090 k = (C0090) virtualChildAt.getLayoutParams();
                if (((ViewGroup.MarginLayoutParams) k).height == -1) {
                    int i4 = ((ViewGroup.MarginLayoutParams) k).width;
                    ((ViewGroup.MarginLayoutParams) k).width = virtualChildAt.getMeasuredWidth();
                    measureChildWithMargins(virtualChildAt, i2, 0, makeMeasureSpec, 0);
                    ((ViewGroup.MarginLayoutParams) k).width = i4;
                }
            }
        }
    }

    private void forceUniformWidth(int i, int i2) {
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 1073741824);
        for (int i3 = 0; i3 < i; i3++) {
            View virtualChildAt = getVirtualChildAt(i3);
            if (virtualChildAt.getVisibility() != 8) {
                C0090 k = (C0090) virtualChildAt.getLayoutParams();
                if (((ViewGroup.MarginLayoutParams) k).width == -1) {
                    int i4 = ((ViewGroup.MarginLayoutParams) k).height;
                    ((ViewGroup.MarginLayoutParams) k).height = virtualChildAt.getMeasuredHeight();
                    measureChildWithMargins(virtualChildAt, makeMeasureSpec, 0, i2, 0);
                    ((ViewGroup.MarginLayoutParams) k).height = i4;
                }
            }
        }
    }

    private void setChildFrame(View view, int i, int i2, int i3, int i4) {
        view.layout(i, i2, i3 + i, i4 + i2);
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0090;
    }

    public void drawDividersHorizontal(Canvas canvas) {
        int i;
        int i2;
        int i3;
        int i4;
        int virtualChildCount = getVirtualChildCount();
        boolean r1 = C2033.m5266(this);
        for (int i5 = 0; i5 < virtualChildCount; i5++) {
            View virtualChildAt = getVirtualChildAt(i5);
            if (!(virtualChildAt == null || virtualChildAt.getVisibility() == 8 || !hasDividerBeforeChildAt(i5))) {
                C0090 k = (C0090) virtualChildAt.getLayoutParams();
                if (r1) {
                    i4 = virtualChildAt.getRight() + ((ViewGroup.MarginLayoutParams) k).rightMargin;
                } else {
                    i4 = (virtualChildAt.getLeft() - ((ViewGroup.MarginLayoutParams) k).leftMargin) - this.mDividerWidth;
                }
                drawVerticalDivider(canvas, i4);
            }
        }
        if (hasDividerBeforeChildAt(virtualChildCount)) {
            View virtualChildAt2 = getVirtualChildAt(virtualChildCount - 1);
            if (virtualChildAt2 != null) {
                C0090 k2 = (C0090) virtualChildAt2.getLayoutParams();
                if (r1) {
                    i3 = virtualChildAt2.getLeft() - ((ViewGroup.MarginLayoutParams) k2).leftMargin;
                    i2 = this.mDividerWidth;
                } else {
                    i = virtualChildAt2.getRight() + ((ViewGroup.MarginLayoutParams) k2).rightMargin;
                    drawVerticalDivider(canvas, i);
                }
            } else if (r1) {
                i = getPaddingLeft();
                drawVerticalDivider(canvas, i);
            } else {
                i3 = getWidth() - getPaddingRight();
                i2 = this.mDividerWidth;
            }
            i = i3 - i2;
            drawVerticalDivider(canvas, i);
        }
    }

    public void drawDividersVertical(Canvas canvas) {
        int i;
        int virtualChildCount = getVirtualChildCount();
        for (int i2 = 0; i2 < virtualChildCount; i2++) {
            View virtualChildAt = getVirtualChildAt(i2);
            if (!(virtualChildAt == null || virtualChildAt.getVisibility() == 8 || !hasDividerBeforeChildAt(i2))) {
                drawHorizontalDivider(canvas, (virtualChildAt.getTop() - ((ViewGroup.MarginLayoutParams) ((C0090) virtualChildAt.getLayoutParams())).topMargin) - this.mDividerHeight);
            }
        }
        if (hasDividerBeforeChildAt(virtualChildCount)) {
            View virtualChildAt2 = getVirtualChildAt(virtualChildCount - 1);
            if (virtualChildAt2 == null) {
                i = (getHeight() - getPaddingBottom()) - this.mDividerHeight;
            } else {
                i = virtualChildAt2.getBottom() + ((ViewGroup.MarginLayoutParams) ((C0090) virtualChildAt2.getLayoutParams())).bottomMargin;
            }
            drawHorizontalDivider(canvas, i);
        }
    }

    public void drawHorizontalDivider(Canvas canvas, int i) {
        this.mDivider.setBounds(getPaddingLeft() + this.mDividerPadding, i, (getWidth() - getPaddingRight()) - this.mDividerPadding, this.mDividerHeight + i);
        this.mDivider.draw(canvas);
    }

    public void drawVerticalDivider(Canvas canvas, int i) {
        this.mDivider.setBounds(i, getPaddingTop() + this.mDividerPadding, this.mDividerWidth + i, (getHeight() - getPaddingBottom()) - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    public int getBaseline() {
        int i;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        int childCount = getChildCount();
        int i2 = this.mBaselineAlignedChildIndex;
        if (childCount > i2) {
            View childAt = getChildAt(i2);
            int baseline = childAt.getBaseline();
            if (baseline != -1) {
                int i3 = this.mBaselineChildTop;
                if (this.mOrientation == 1 && (i = this.mGravity & 112) != 48) {
                    if (i == 16) {
                        i3 += ((((getBottom() - getTop()) - getPaddingTop()) - getPaddingBottom()) - this.mTotalLength) / 2;
                    } else if (i == 80) {
                        i3 = ((getBottom() - getTop()) - getPaddingBottom()) - this.mTotalLength;
                    }
                }
                return i3 + ((ViewGroup.MarginLayoutParams) ((C0090) childAt.getLayoutParams())).topMargin + baseline;
            } else if (this.mBaselineAlignedChildIndex == 0) {
                return -1;
            } else {
                throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
            }
        } else {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    public int getChildrenSkipCount(View view, int i) {
        return 0;
    }

    public Drawable getDividerDrawable() {
        return this.mDivider;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public int getLocationOffset(View view) {
        return 0;
    }

    public int getNextLocationOffset(View view) {
        return 0;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    public View getVirtualChildAt(int i) {
        return getChildAt(i);
    }

    public int getVirtualChildCount() {
        return getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    public boolean hasDividerBeforeChildAt(int i) {
        if (i == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (i == getChildCount()) {
            if ((this.mShowDividers & 4) != 0) {
                return true;
            }
            return false;
        } else if ((this.mShowDividers & 2) == 0) {
            return false;
        } else {
            for (int i2 = i - 1; i2 >= 0; i2--) {
                if (getChildAt(i2).getVisibility() != 8) {
                    return true;
                }
            }
            return false;
        }
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    /* JADX WARNING: Removed duplicated region for block: B:27:0x00a8  */
    /* JADX WARNING: Removed duplicated region for block: B:30:0x00b1  */
    /* JADX WARNING: Removed duplicated region for block: B:44:0x00e8  */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x00fc  */
    public void layoutHorizontal(int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int i10;
        int i11;
        int i12;
        int i13;
        int i14;
        boolean r0 = C2033.m5266(this);
        int paddingTop = getPaddingTop();
        int i15 = i4 - i2;
        int paddingBottom = i15 - getPaddingBottom();
        int paddingBottom2 = (i15 - paddingTop) - getPaddingBottom();
        int virtualChildCount = getVirtualChildCount();
        int i16 = this.mGravity;
        int i17 = i16 & 112;
        boolean z = this.mBaselineAligned;
        int[] iArr = this.mMaxAscent;
        int[] iArr2 = this.mMaxDescent;
        int r1 = C2369.m6293(8388615 & i16, C1729.m4511(this));
        if (r1 == 1) {
            i5 = getPaddingLeft() + (((i3 - i) - this.mTotalLength) / 2);
        } else if (r1 != 5) {
            i5 = getPaddingLeft();
        } else {
            i5 = ((getPaddingLeft() + i3) - i) - this.mTotalLength;
        }
        if (r0) {
            i7 = virtualChildCount - 1;
            i6 = -1;
        } else {
            i7 = 0;
            i6 = 1;
        }
        int i18 = 0;
        while (i18 < virtualChildCount) {
            int i19 = (i6 * i18) + i7;
            View virtualChildAt = getVirtualChildAt(i19);
            if (virtualChildAt == null) {
                i5 = measureNullChild(i19) + i5;
            } else if (virtualChildAt.getVisibility() != 8) {
                int measuredWidth = virtualChildAt.getMeasuredWidth();
                int measuredHeight = virtualChildAt.getMeasuredHeight();
                C0090 k = (C0090) virtualChildAt.getLayoutParams();
                if (z) {
                    i10 = virtualChildCount;
                    if (((ViewGroup.MarginLayoutParams) k).height != -1) {
                        i11 = virtualChildAt.getBaseline();
                        i12 = k.f541;
                        if (i12 < 0) {
                            i12 = i17;
                        }
                        i13 = i12 & 112;
                        i9 = i17;
                        if (i13 != 16) {
                            i14 = ((((paddingBottom2 - measuredHeight) / 2) + paddingTop) + ((ViewGroup.MarginLayoutParams) k).topMargin) - ((ViewGroup.MarginLayoutParams) k).bottomMargin;
                        } else if (i13 == 48) {
                            int i20 = ((ViewGroup.MarginLayoutParams) k).topMargin + paddingTop;
                            i14 = i11 != -1 ? (iArr[1] - i11) + i20 : i20;
                        } else if (i13 != 80) {
                            i14 = paddingTop;
                        } else {
                            int i21 = (paddingBottom - measuredHeight) - ((ViewGroup.MarginLayoutParams) k).bottomMargin;
                            if (i11 != -1) {
                                i21 -= iArr2[2] - (virtualChildAt.getMeasuredHeight() - i11);
                            }
                            i14 = i21;
                        }
                        if (hasDividerBeforeChildAt(i19)) {
                            i5 += this.mDividerWidth;
                        }
                        int i22 = ((ViewGroup.MarginLayoutParams) k).leftMargin + i5;
                        i8 = paddingTop;
                        setChildFrame(virtualChildAt, getLocationOffset(virtualChildAt) + i22, i14, measuredWidth, measuredHeight);
                        i5 = getNextLocationOffset(virtualChildAt) + measuredWidth + ((ViewGroup.MarginLayoutParams) k).rightMargin + i22;
                        i18 = getChildrenSkipCount(virtualChildAt, i19) + i18;
                        i18++;
                        virtualChildCount = i10;
                        i17 = i9;
                        paddingTop = i8;
                    }
                } else {
                    i10 = virtualChildCount;
                }
                i11 = -1;
                i12 = k.f541;
                if (i12 < 0) {
                }
                i13 = i12 & 112;
                i9 = i17;
                if (i13 != 16) {
                }
                if (hasDividerBeforeChildAt(i19)) {
                }
                int i222 = ((ViewGroup.MarginLayoutParams) k).leftMargin + i5;
                i8 = paddingTop;
                setChildFrame(virtualChildAt, getLocationOffset(virtualChildAt) + i222, i14, measuredWidth, measuredHeight);
                i5 = getNextLocationOffset(virtualChildAt) + measuredWidth + ((ViewGroup.MarginLayoutParams) k).rightMargin + i222;
                i18 = getChildrenSkipCount(virtualChildAt, i19) + i18;
                i18++;
                virtualChildCount = i10;
                i17 = i9;
                paddingTop = i8;
            }
            i8 = paddingTop;
            i10 = virtualChildCount;
            i9 = i17;
            i18++;
            virtualChildCount = i10;
            i17 = i9;
            paddingTop = i8;
        }
    }

    public void layoutVertical(int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        int i7;
        int i8;
        int paddingLeft = getPaddingLeft();
        int i9 = i3 - i;
        int paddingRight = i9 - getPaddingRight();
        int paddingRight2 = (i9 - paddingLeft) - getPaddingRight();
        int virtualChildCount = getVirtualChildCount();
        int i10 = this.mGravity;
        int i11 = i10 & 112;
        int i12 = i10 & 8388615;
        if (i11 == 16) {
            i5 = getPaddingTop() + (((i4 - i2) - this.mTotalLength) / 2);
        } else if (i11 != 80) {
            i5 = getPaddingTop();
        } else {
            i5 = ((getPaddingTop() + i4) - i2) - this.mTotalLength;
        }
        int i13 = 0;
        while (i13 < virtualChildCount) {
            View virtualChildAt = getVirtualChildAt(i13);
            if (virtualChildAt == null) {
                i5 = measureNullChild(i13) + i5;
            } else if (virtualChildAt.getVisibility() != 8) {
                int measuredWidth = virtualChildAt.getMeasuredWidth();
                int measuredHeight = virtualChildAt.getMeasuredHeight();
                C0090 k = (C0090) virtualChildAt.getLayoutParams();
                int i14 = k.f541;
                if (i14 < 0) {
                    i14 = i12;
                }
                int r1 = C2369.m6293(i14, C1729.m4511(this)) & 7;
                if (r1 == 1) {
                    i7 = ((paddingRight2 - measuredWidth) / 2) + paddingLeft + ((ViewGroup.MarginLayoutParams) k).leftMargin;
                    i6 = ((ViewGroup.MarginLayoutParams) k).rightMargin;
                    i8 = i7 - i6;
                } else if (r1 != 5) {
                    i8 = ((ViewGroup.MarginLayoutParams) k).leftMargin + paddingLeft;
                } else {
                    i7 = paddingRight - measuredWidth;
                    i6 = ((ViewGroup.MarginLayoutParams) k).rightMargin;
                    i8 = i7 - i6;
                }
                if (hasDividerBeforeChildAt(i13)) {
                    i5 += this.mDividerHeight;
                }
                int i15 = i5 + ((ViewGroup.MarginLayoutParams) k).topMargin;
                setChildFrame(virtualChildAt, i8, getLocationOffset(virtualChildAt) + i15, measuredWidth, measuredHeight);
                i5 = getNextLocationOffset(virtualChildAt) + measuredHeight + ((ViewGroup.MarginLayoutParams) k).bottomMargin + i15;
                i13 += getChildrenSkipCount(virtualChildAt, i13);
            }
            i13++;
        }
    }

    public void measureChildBeforeLayout(View view, int i, int i2, int i3, int i4, int i5) {
        measureChildWithMargins(view, i2, i3, i4, i5);
    }

    /* JADX WARNING: Removed duplicated region for block: B:65:0x0196  */
    /* JADX WARNING: Removed duplicated region for block: B:75:0x01ca  */
    /* JADX WARNING: Removed duplicated region for block: B:78:0x01d5  */
    public void measureHorizontal(int i, int i2) {
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int i10;
        float f;
        int i11;
        boolean z;
        int baseline;
        int i12;
        int i13;
        boolean z2;
        boolean z3;
        int i14;
        View view;
        int i15;
        boolean z4;
        int measuredHeight;
        int baseline2;
        int i16;
        int i17;
        this.mTotalLength = 0;
        int virtualChildCount = getVirtualChildCount();
        int mode = View.MeasureSpec.getMode(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        if (this.mMaxAscent == null || this.mMaxDescent == null) {
            this.mMaxAscent = new int[4];
            this.mMaxDescent = new int[4];
        }
        int[] iArr = this.mMaxAscent;
        int[] iArr2 = this.mMaxDescent;
        iArr[3] = -1;
        iArr[2] = -1;
        iArr[1] = -1;
        iArr[0] = -1;
        iArr2[3] = -1;
        iArr2[2] = -1;
        iArr2[1] = -1;
        iArr2[0] = -1;
        boolean z5 = this.mBaselineAligned;
        boolean z6 = this.mUseLargestChild;
        int i18 = 1073741824;
        boolean z7 = mode == 1073741824;
        float f2 = 0.0f;
        int i19 = 0;
        int i20 = 0;
        int i21 = 0;
        int i22 = 0;
        int i23 = 0;
        boolean z8 = false;
        int i24 = 0;
        boolean z9 = true;
        boolean z10 = false;
        while (i19 < virtualChildCount) {
            View virtualChildAt = getVirtualChildAt(i19);
            if (virtualChildAt == null) {
                this.mTotalLength = measureNullChild(i19) + this.mTotalLength;
            } else if (virtualChildAt.getVisibility() == 8) {
                i19 += getChildrenSkipCount(virtualChildAt, i19);
            } else {
                if (hasDividerBeforeChildAt(i19)) {
                    this.mTotalLength += this.mDividerWidth;
                }
                C0090 k = (C0090) virtualChildAt.getLayoutParams();
                float f3 = f2 + k.f542;
                if (mode == i18 && ((ViewGroup.MarginLayoutParams) k).width == 0 && k.f542 > 0.0f) {
                    if (z7) {
                        this.mTotalLength = ((ViewGroup.MarginLayoutParams) k).leftMargin + ((ViewGroup.MarginLayoutParams) k).rightMargin + this.mTotalLength;
                    } else {
                        int i25 = this.mTotalLength;
                        this.mTotalLength = Math.max(i25, ((ViewGroup.MarginLayoutParams) k).leftMargin + i25 + ((ViewGroup.MarginLayoutParams) k).rightMargin);
                    }
                    if (z5) {
                        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                        virtualChildAt.measure(makeMeasureSpec, makeMeasureSpec);
                        i14 = i19;
                        z3 = z6;
                        z2 = z5;
                        view = virtualChildAt;
                    } else {
                        i14 = i19;
                        z3 = z6;
                        z2 = z5;
                        view = virtualChildAt;
                        i15 = 1073741824;
                        z8 = true;
                        if (mode2 == i15 && ((ViewGroup.MarginLayoutParams) k).height == -1) {
                            z4 = true;
                            z10 = true;
                        } else {
                            z4 = false;
                        }
                        int i26 = ((ViewGroup.MarginLayoutParams) k).topMargin + ((ViewGroup.MarginLayoutParams) k).bottomMargin;
                        measuredHeight = view.getMeasuredHeight() + i26;
                        int combineMeasuredStates = View.combineMeasuredStates(i24, view.getMeasuredState());
                        if (z2 && (baseline2 = view.getBaseline()) != -1) {
                            i16 = k.f541;
                            if (i16 < 0) {
                                i16 = this.mGravity;
                            }
                            int i27 = (((i16 & 112) >> 4) & -2) >> 1;
                            iArr[i27] = Math.max(iArr[i27], baseline2);
                            iArr2[i27] = Math.max(iArr2[i27], measuredHeight - baseline2);
                        }
                        int max = Math.max(i21, measuredHeight);
                        boolean z11 = !z9 && ((ViewGroup.MarginLayoutParams) k).height == -1;
                        if (k.f542 <= 0.0f) {
                            if (!z4) {
                                i26 = measuredHeight;
                            }
                            i23 = Math.max(i23, i26);
                        } else {
                            if (z4) {
                                measuredHeight = i26;
                            }
                            i22 = Math.max(i22, measuredHeight);
                            i23 = i23;
                        }
                        i21 = max;
                        i24 = combineMeasuredStates;
                        z9 = z11;
                        i19 = getChildrenSkipCount(view, i14) + i14;
                        f2 = f3;
                        i19++;
                        iArr2 = iArr2;
                        z6 = z3;
                        z5 = z2;
                        i18 = 1073741824;
                    }
                } else {
                    if (((ViewGroup.MarginLayoutParams) k).width != 0 || k.f542 <= 0.0f) {
                        i17 = Integer.MIN_VALUE;
                    } else {
                        ((ViewGroup.MarginLayoutParams) k).width = -2;
                        i17 = 0;
                    }
                    i14 = i19;
                    z3 = z6;
                    z2 = z5;
                    measureChildBeforeLayout(virtualChildAt, i14, i, f3 == 0.0f ? this.mTotalLength : 0, i2, 0);
                    if (i17 != Integer.MIN_VALUE) {
                        ((ViewGroup.MarginLayoutParams) k).width = i17;
                    }
                    int measuredWidth = virtualChildAt.getMeasuredWidth();
                    if (z7) {
                        view = virtualChildAt;
                        this.mTotalLength = getNextLocationOffset(view) + ((ViewGroup.MarginLayoutParams) k).leftMargin + measuredWidth + ((ViewGroup.MarginLayoutParams) k).rightMargin + this.mTotalLength;
                    } else {
                        view = virtualChildAt;
                        int i28 = this.mTotalLength;
                        this.mTotalLength = Math.max(i28, getNextLocationOffset(view) + i28 + measuredWidth + ((ViewGroup.MarginLayoutParams) k).leftMargin + ((ViewGroup.MarginLayoutParams) k).rightMargin);
                    }
                    if (z3) {
                        i20 = Math.max(measuredWidth, i20);
                    }
                }
                i15 = 1073741824;
                if (mode2 == i15) {
                }
                z4 = false;
                int i262 = ((ViewGroup.MarginLayoutParams) k).topMargin + ((ViewGroup.MarginLayoutParams) k).bottomMargin;
                measuredHeight = view.getMeasuredHeight() + i262;
                int combineMeasuredStates2 = View.combineMeasuredStates(i24, view.getMeasuredState());
                i16 = k.f541;
                if (i16 < 0) {
                }
                int i272 = (((i16 & 112) >> 4) & -2) >> 1;
                iArr[i272] = Math.max(iArr[i272], baseline2);
                iArr2[i272] = Math.max(iArr2[i272], measuredHeight - baseline2);
                int max2 = Math.max(i21, measuredHeight);
                if (!z9) {
                }
                if (k.f542 <= 0.0f) {
                }
                i21 = max2;
                i24 = combineMeasuredStates2;
                z9 = z11;
                i19 = getChildrenSkipCount(view, i14) + i14;
                f2 = f3;
                i19++;
                iArr2 = iArr2;
                z6 = z3;
                z5 = z2;
                i18 = 1073741824;
            }
            z3 = z6;
            z2 = z5;
            i19++;
            iArr2 = iArr2;
            z6 = z3;
            z5 = z2;
            i18 = 1073741824;
        }
        int i29 = i21;
        if (this.mTotalLength > 0 && hasDividerBeforeChildAt(virtualChildCount)) {
            this.mTotalLength += this.mDividerWidth;
        }
        if (iArr[1] == -1 && iArr[0] == -1 && iArr[2] == -1 && iArr[3] == -1) {
            i3 = i24;
        } else {
            i3 = i24;
            i29 = Math.max(i29, Math.max(iArr2[3], Math.max(iArr2[0], Math.max(iArr2[1], iArr2[2]))) + Math.max(iArr[3], Math.max(iArr[0], Math.max(iArr[1], iArr[2]))));
        }
        if (z6 && (mode == Integer.MIN_VALUE || mode == 0)) {
            this.mTotalLength = 0;
            int i30 = 0;
            while (i30 < virtualChildCount) {
                View virtualChildAt2 = getVirtualChildAt(i30);
                if (virtualChildAt2 == null) {
                    this.mTotalLength = measureNullChild(i30) + this.mTotalLength;
                } else if (virtualChildAt2.getVisibility() == 8) {
                    i30 += getChildrenSkipCount(virtualChildAt2, i30);
                } else {
                    C0090 k2 = (C0090) virtualChildAt2.getLayoutParams();
                    if (z7) {
                        this.mTotalLength = getNextLocationOffset(virtualChildAt2) + ((ViewGroup.MarginLayoutParams) k2).leftMargin + i20 + ((ViewGroup.MarginLayoutParams) k2).rightMargin + this.mTotalLength;
                    } else {
                        int i31 = this.mTotalLength;
                        i13 = i29;
                        this.mTotalLength = Math.max(i31, getNextLocationOffset(virtualChildAt2) + i31 + i20 + ((ViewGroup.MarginLayoutParams) k2).leftMargin + ((ViewGroup.MarginLayoutParams) k2).rightMargin);
                        i30++;
                        i29 = i13;
                    }
                }
                i13 = i29;
                i30++;
                i29 = i13;
            }
        }
        this.mTotalLength = getPaddingRight() + getPaddingLeft() + this.mTotalLength;
        int resolveSizeAndState = View.resolveSizeAndState(Math.max(this.mTotalLength, getSuggestedMinimumWidth()), i, 0);
        int i32 = (16777215 & resolveSizeAndState) - this.mTotalLength;
        if (z8 || (i32 != 0 && f2 > 0.0f)) {
            float f4 = this.mWeightSum;
            if (f4 > 0.0f) {
                f2 = f4;
            }
            iArr[3] = -1;
            iArr[2] = -1;
            iArr[1] = -1;
            iArr[0] = -1;
            iArr2[3] = -1;
            iArr2[2] = -1;
            iArr2[1] = -1;
            iArr2[0] = -1;
            this.mTotalLength = 0;
            int i33 = i22;
            int i34 = i3;
            int i35 = -1;
            float f5 = f2;
            int i36 = 0;
            while (i36 < virtualChildCount) {
                View virtualChildAt3 = getVirtualChildAt(i36);
                if (virtualChildAt3 == null || virtualChildAt3.getVisibility() == 8) {
                    i10 = i32;
                    i9 = virtualChildCount;
                } else {
                    C0090 k3 = (C0090) virtualChildAt3.getLayoutParams();
                    float f6 = k3.f542;
                    if (f6 > 0.0f) {
                        int i37 = (int) ((((float) i32) * f6) / f5);
                        float f7 = f5 - f6;
                        int i38 = i32 - i37;
                        i9 = virtualChildCount;
                        int childMeasureSpec = ViewGroup.getChildMeasureSpec(i2, getPaddingBottom() + getPaddingTop() + ((ViewGroup.MarginLayoutParams) k3).topMargin + ((ViewGroup.MarginLayoutParams) k3).bottomMargin, ((ViewGroup.MarginLayoutParams) k3).height);
                        if (((ViewGroup.MarginLayoutParams) k3).width == 0) {
                            i12 = 1073741824;
                            if (mode == 1073741824) {
                                if (i37 <= 0) {
                                    i37 = 0;
                                }
                                virtualChildAt3.measure(View.MeasureSpec.makeMeasureSpec(i37, 1073741824), childMeasureSpec);
                                i34 = View.combineMeasuredStates(i34, virtualChildAt3.getMeasuredState() & -16777216);
                                f5 = f7;
                                i10 = i38;
                            }
                        } else {
                            i12 = 1073741824;
                        }
                        int measuredWidth2 = virtualChildAt3.getMeasuredWidth() + i37;
                        if (measuredWidth2 < 0) {
                            measuredWidth2 = 0;
                        }
                        virtualChildAt3.measure(View.MeasureSpec.makeMeasureSpec(measuredWidth2, i12), childMeasureSpec);
                        i34 = View.combineMeasuredStates(i34, virtualChildAt3.getMeasuredState() & -16777216);
                        f5 = f7;
                        i10 = i38;
                    } else {
                        i10 = i32;
                        i9 = virtualChildCount;
                    }
                    if (z7) {
                        this.mTotalLength = getNextLocationOffset(virtualChildAt3) + virtualChildAt3.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) k3).leftMargin + ((ViewGroup.MarginLayoutParams) k3).rightMargin + this.mTotalLength;
                        f = f5;
                    } else {
                        int i39 = this.mTotalLength;
                        f = f5;
                        this.mTotalLength = Math.max(i39, getNextLocationOffset(virtualChildAt3) + virtualChildAt3.getMeasuredWidth() + i39 + ((ViewGroup.MarginLayoutParams) k3).leftMargin + ((ViewGroup.MarginLayoutParams) k3).rightMargin);
                    }
                    boolean z12 = mode2 != 1073741824 && ((ViewGroup.MarginLayoutParams) k3).height == -1;
                    int i40 = ((ViewGroup.MarginLayoutParams) k3).topMargin + ((ViewGroup.MarginLayoutParams) k3).bottomMargin;
                    int measuredHeight2 = virtualChildAt3.getMeasuredHeight() + i40;
                    i35 = Math.max(i35, measuredHeight2);
                    if (!z12) {
                        i40 = measuredHeight2;
                    }
                    int max3 = Math.max(i33, i40);
                    if (z9) {
                        i11 = -1;
                        if (((ViewGroup.MarginLayoutParams) k3).height == -1) {
                            z = true;
                            if (!z5 && (baseline = virtualChildAt3.getBaseline()) != i11) {
                                int i41 = k3.f541;
                                if (i41 < 0) {
                                    i41 = this.mGravity;
                                }
                                int i42 = (((i41 & 112) >> 4) & -2) >> 1;
                                iArr[i42] = Math.max(iArr[i42], baseline);
                                iArr2[i42] = Math.max(iArr2[i42], measuredHeight2 - baseline);
                            }
                            i33 = max3;
                            z9 = z;
                            f5 = f;
                        }
                    } else {
                        i11 = -1;
                    }
                    z = false;
                    if (!z5) {
                    }
                    i33 = max3;
                    z9 = z;
                    f5 = f;
                }
                i36++;
                i32 = i10;
                virtualChildCount = i9;
            }
            i5 = i2;
            i4 = virtualChildCount;
            this.mTotalLength = getPaddingRight() + getPaddingLeft() + this.mTotalLength;
            if (iArr[1] == -1 && iArr[0] == -1 && iArr[2] == -1 && iArr[3] == -1) {
                i8 = i35;
            } else {
                i8 = Math.max(i35, Math.max(iArr2[3], Math.max(iArr2[0], Math.max(iArr2[1], iArr2[2]))) + Math.max(iArr[3], Math.max(iArr[0], Math.max(iArr[1], iArr[2]))));
            }
            i6 = i8;
            i3 = i34;
            i7 = i33;
        } else {
            i7 = Math.max(i22, i23);
            if (z6 && mode != 1073741824) {
                for (int i43 = 0; i43 < virtualChildCount; i43++) {
                    View virtualChildAt4 = getVirtualChildAt(i43);
                    if (!(virtualChildAt4 == null || virtualChildAt4.getVisibility() == 8 || ((C0090) virtualChildAt4.getLayoutParams()).f542 <= 0.0f)) {
                        virtualChildAt4.measure(View.MeasureSpec.makeMeasureSpec(i20, 1073741824), View.MeasureSpec.makeMeasureSpec(virtualChildAt4.getMeasuredHeight(), 1073741824));
                    }
                }
            }
            i5 = i2;
            i4 = virtualChildCount;
            i6 = i29;
        }
        if (z9 || mode2 == 1073741824) {
            i7 = i6;
        }
        setMeasuredDimension(resolveSizeAndState | (i3 & -16777216), View.resolveSizeAndState(Math.max(getPaddingBottom() + getPaddingTop() + i7, getSuggestedMinimumHeight()), i5, i3 << 16));
        if (z10) {
            forceUniformHeight(i4, i);
        }
    }

    public int measureNullChild(int i) {
        return 0;
    }

    /* JADX WARNING: Removed duplicated region for block: B:141:0x0330  */
    public void measureVertical(int i, int i2) {
        int i3;
        int i4;
        int i5;
        int i6;
        float f;
        int i7;
        int i8;
        boolean z;
        int i9;
        int i10;
        int i11;
        int i12;
        int i13;
        int i14;
        int i15;
        int i16;
        int i17;
        View view;
        int i18;
        boolean z2;
        int i19;
        int i20;
        this.mTotalLength = 0;
        int virtualChildCount = getVirtualChildCount();
        int mode = View.MeasureSpec.getMode(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        int i21 = this.mBaselineAlignedChildIndex;
        boolean z3 = this.mUseLargestChild;
        float f2 = 0.0f;
        int i22 = 0;
        int i23 = 0;
        int i24 = 0;
        int i25 = 0;
        int i26 = 0;
        int i27 = 0;
        boolean z4 = false;
        boolean z5 = true;
        boolean z6 = false;
        while (true) {
            int i28 = 8;
            if (i27 < virtualChildCount) {
                View virtualChildAt = getVirtualChildAt(i27);
                if (virtualChildAt == null) {
                    this.mTotalLength = measureNullChild(i27) + this.mTotalLength;
                    i11 = virtualChildCount;
                    i25 = i25;
                } else if (virtualChildAt.getVisibility() == 8) {
                    i27 += getChildrenSkipCount(virtualChildAt, i27);
                    i11 = virtualChildCount;
                    i25 = i25;
                    i22 = i22;
                } else {
                    if (hasDividerBeforeChildAt(i27)) {
                        this.mTotalLength += this.mDividerHeight;
                    }
                    C0090 k = (C0090) virtualChildAt.getLayoutParams();
                    float f3 = f2 + k.f542;
                    if (mode2 == 1073741824 && ((ViewGroup.MarginLayoutParams) k).height == 0 && k.f542 > 0.0f) {
                        int i29 = this.mTotalLength;
                        this.mTotalLength = Math.max(i29, ((ViewGroup.MarginLayoutParams) k).topMargin + i29 + ((ViewGroup.MarginLayoutParams) k).bottomMargin);
                        i18 = i24;
                        view = virtualChildAt;
                        i13 = i26;
                        i11 = virtualChildCount;
                        i17 = i22;
                        i14 = i23;
                        z4 = true;
                        i16 = i27;
                        i12 = mode2;
                        i15 = i25;
                    } else {
                        if (((ViewGroup.MarginLayoutParams) k).height != 0 || k.f542 <= 0.0f) {
                            i20 = Integer.MIN_VALUE;
                        } else {
                            ((ViewGroup.MarginLayoutParams) k).height = -2;
                            i20 = 0;
                        }
                        i17 = i22;
                        i14 = i23;
                        i11 = virtualChildCount;
                        i12 = mode2;
                        i15 = i25;
                        i13 = i26;
                        i16 = i27;
                        measureChildBeforeLayout(virtualChildAt, i27, i, 0, i2, f3 == 0.0f ? this.mTotalLength : 0);
                        if (i20 != Integer.MIN_VALUE) {
                            ((ViewGroup.MarginLayoutParams) k).height = i20;
                        }
                        int measuredHeight = virtualChildAt.getMeasuredHeight();
                        int i30 = this.mTotalLength;
                        view = virtualChildAt;
                        this.mTotalLength = Math.max(i30, getNextLocationOffset(view) + i30 + measuredHeight + ((ViewGroup.MarginLayoutParams) k).topMargin + ((ViewGroup.MarginLayoutParams) k).bottomMargin);
                        i18 = z3 ? Math.max(measuredHeight, i24) : i24;
                    }
                    if (i21 >= 0 && i21 == i16 + 1) {
                        this.mBaselineChildTop = this.mTotalLength;
                    }
                    if (i16 >= i21 || k.f542 <= 0.0f) {
                        if (mode == 1073741824 || ((ViewGroup.MarginLayoutParams) k).width != -1) {
                            z2 = false;
                        } else {
                            z2 = true;
                            z6 = true;
                        }
                        int i31 = ((ViewGroup.MarginLayoutParams) k).leftMargin + ((ViewGroup.MarginLayoutParams) k).rightMargin;
                        int measuredWidth = view.getMeasuredWidth() + i31;
                        int max = Math.max(i14, measuredWidth);
                        int combineMeasuredStates = View.combineMeasuredStates(i17, view.getMeasuredState());
                        boolean z7 = z5 && ((ViewGroup.MarginLayoutParams) k).width == -1;
                        if (k.f542 > 0.0f) {
                            if (!z2) {
                                i31 = measuredWidth;
                            }
                            i15 = Math.max(i15, i31);
                            i19 = i13;
                        } else {
                            if (!z2) {
                                i31 = measuredWidth;
                            }
                            i19 = Math.max(i13, i31);
                        }
                        i24 = i18;
                        z5 = z7;
                        i25 = i15;
                        f2 = f3;
                        i26 = i19;
                        i22 = combineMeasuredStates;
                        i27 = getChildrenSkipCount(view, i16) + i16;
                        i23 = max;
                        i27++;
                        mode2 = i12;
                        virtualChildCount = i11;
                    } else {
                        throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
                    }
                }
                i12 = mode2;
                i27++;
                mode2 = i12;
                virtualChildCount = i11;
            } else {
                int i32 = i23;
                if (this.mTotalLength > 0) {
                    i3 = virtualChildCount;
                    if (hasDividerBeforeChildAt(i3)) {
                        this.mTotalLength += this.mDividerHeight;
                    }
                } else {
                    i3 = virtualChildCount;
                }
                if (z3 && (mode2 == Integer.MIN_VALUE || mode2 == 0)) {
                    this.mTotalLength = 0;
                    int i33 = 0;
                    while (i33 < i3) {
                        View virtualChildAt2 = getVirtualChildAt(i33);
                        if (virtualChildAt2 == null) {
                            this.mTotalLength = measureNullChild(i33) + this.mTotalLength;
                        } else if (virtualChildAt2.getVisibility() == i28) {
                            i33 += getChildrenSkipCount(virtualChildAt2, i33);
                        } else {
                            C0090 k2 = (C0090) virtualChildAt2.getLayoutParams();
                            int i34 = this.mTotalLength;
                            this.mTotalLength = Math.max(i34, getNextLocationOffset(virtualChildAt2) + i34 + i24 + ((ViewGroup.MarginLayoutParams) k2).topMargin + ((ViewGroup.MarginLayoutParams) k2).bottomMargin);
                        }
                        i33++;
                        i28 = 8;
                    }
                }
                this.mTotalLength = getPaddingBottom() + getPaddingTop() + this.mTotalLength;
                int resolveSizeAndState = View.resolveSizeAndState(Math.max(this.mTotalLength, getSuggestedMinimumHeight()), i2, 0);
                int i35 = (16777215 & resolveSizeAndState) - this.mTotalLength;
                if (z4 || (i35 != 0 && f2 > 0.0f)) {
                    float f4 = this.mWeightSum;
                    if (f4 > 0.0f) {
                        f2 = f4;
                    }
                    this.mTotalLength = 0;
                    float f5 = f2;
                    int i36 = 0;
                    int i37 = i26;
                    i5 = i22;
                    while (i36 < i3) {
                        View virtualChildAt3 = getVirtualChildAt(i36);
                        if (virtualChildAt3.getVisibility() == 8) {
                            f = f5;
                        } else {
                            C0090 k3 = (C0090) virtualChildAt3.getLayoutParams();
                            float f6 = k3.f542;
                            if (f6 > 0.0f) {
                                int i38 = (int) ((((float) i35) * f6) / f5);
                                i7 = i35 - i38;
                                f = f5 - f6;
                                int childMeasureSpec = ViewGroup.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + ((ViewGroup.MarginLayoutParams) k3).leftMargin + ((ViewGroup.MarginLayoutParams) k3).rightMargin, ((ViewGroup.MarginLayoutParams) k3).width);
                                if (((ViewGroup.MarginLayoutParams) k3).height == 0) {
                                    i10 = 1073741824;
                                    if (mode2 == 1073741824) {
                                        if (i38 <= 0) {
                                            i38 = 0;
                                        }
                                        virtualChildAt3.measure(childMeasureSpec, View.MeasureSpec.makeMeasureSpec(i38, 1073741824));
                                        i5 = View.combineMeasuredStates(i5, virtualChildAt3.getMeasuredState() & -256);
                                    }
                                } else {
                                    i10 = 1073741824;
                                }
                                int measuredHeight2 = virtualChildAt3.getMeasuredHeight() + i38;
                                if (measuredHeight2 < 0) {
                                    measuredHeight2 = 0;
                                }
                                virtualChildAt3.measure(childMeasureSpec, View.MeasureSpec.makeMeasureSpec(measuredHeight2, i10));
                                i5 = View.combineMeasuredStates(i5, virtualChildAt3.getMeasuredState() & -256);
                            } else {
                                i7 = i35;
                                f = f5;
                            }
                            int i39 = ((ViewGroup.MarginLayoutParams) k3).leftMargin + ((ViewGroup.MarginLayoutParams) k3).rightMargin;
                            int measuredWidth2 = virtualChildAt3.getMeasuredWidth() + i39;
                            i32 = Math.max(i32, measuredWidth2);
                            if (mode != 1073741824) {
                                i8 = i5;
                                i9 = -1;
                                if (((ViewGroup.MarginLayoutParams) k3).width == -1) {
                                    z = true;
                                    if (!z) {
                                        i39 = measuredWidth2;
                                    }
                                    i37 = Math.max(i37, i39);
                                    boolean z8 = !z5 && ((ViewGroup.MarginLayoutParams) k3).width == i9;
                                    int i40 = this.mTotalLength;
                                    this.mTotalLength = Math.max(i40, getNextLocationOffset(virtualChildAt3) + virtualChildAt3.getMeasuredHeight() + i40 + ((ViewGroup.MarginLayoutParams) k3).topMargin + ((ViewGroup.MarginLayoutParams) k3).bottomMargin);
                                    z5 = z8;
                                    i35 = i7;
                                    i5 = i8;
                                }
                            } else {
                                i8 = i5;
                                i9 = -1;
                            }
                            z = false;
                            if (!z) {
                            }
                            i37 = Math.max(i37, i39);
                            if (!z5) {
                            }
                            int i402 = this.mTotalLength;
                            this.mTotalLength = Math.max(i402, getNextLocationOffset(virtualChildAt3) + virtualChildAt3.getMeasuredHeight() + i402 + ((ViewGroup.MarginLayoutParams) k3).topMargin + ((ViewGroup.MarginLayoutParams) k3).bottomMargin);
                            z5 = z8;
                            i35 = i7;
                            i5 = i8;
                        }
                        i36++;
                        f5 = f;
                    }
                    i4 = i;
                    this.mTotalLength = getPaddingBottom() + getPaddingTop() + this.mTotalLength;
                    i6 = i37;
                } else {
                    i6 = Math.max(i26, i25);
                    if (z3 && mode2 != 1073741824) {
                        for (int i41 = 0; i41 < i3; i41++) {
                            View virtualChildAt4 = getVirtualChildAt(i41);
                            if (!(virtualChildAt4 == null || virtualChildAt4.getVisibility() == 8 || ((C0090) virtualChildAt4.getLayoutParams()).f542 <= 0.0f)) {
                                virtualChildAt4.measure(View.MeasureSpec.makeMeasureSpec(virtualChildAt4.getMeasuredWidth(), 1073741824), View.MeasureSpec.makeMeasureSpec(i24, 1073741824));
                            }
                        }
                    }
                    i4 = i;
                    i5 = i22;
                }
                if (z5 || mode == 1073741824) {
                    i6 = i32;
                }
                setMeasuredDimension(View.resolveSizeAndState(Math.max(getPaddingRight() + getPaddingLeft() + i6, getSuggestedMinimumWidth()), i4, i5), resolveSizeAndState);
                if (z6) {
                    forceUniformWidth(i3, i2);
                    return;
                }
                return;
            }
        }
    }

    public void onDraw(Canvas canvas) {
        if (this.mDivider != null) {
            if (this.mOrientation == 1) {
                drawDividersVertical(canvas);
            } else {
                drawDividersHorizontal(canvas);
            }
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ACCESSIBILITY_CLASS_NAME);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ACCESSIBILITY_CLASS_NAME);
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        if (this.mOrientation == 1) {
            layoutVertical(i, i2, i3, i4);
        } else {
            layoutHorizontal(i, i2, i3, i4);
        }
    }

    public void onMeasure(int i, int i2) {
        if (this.mOrientation == 1) {
            measureVertical(i, i2);
        } else {
            measureHorizontal(i, i2);
        }
    }

    public void setBaselineAligned(boolean z) {
        this.mBaselineAligned = z;
    }

    public void setBaselineAlignedChildIndex(int i) {
        if (i < 0 || i >= getChildCount()) {
            StringBuilder r0 = C1293.m3416("base aligned child index out of range (0, ");
            r0.append(getChildCount());
            r0.append(")");
            throw new IllegalArgumentException(r0.toString());
        }
        this.mBaselineAlignedChildIndex = i;
    }

    public void setDividerDrawable(Drawable drawable) {
        if (drawable != this.mDivider) {
            this.mDivider = drawable;
            boolean z = false;
            if (drawable != null) {
                this.mDividerWidth = drawable.getIntrinsicWidth();
                this.mDividerHeight = drawable.getIntrinsicHeight();
            } else {
                this.mDividerWidth = 0;
                this.mDividerHeight = 0;
            }
            if (drawable == null) {
                z = true;
            }
            setWillNotDraw(z);
            requestLayout();
        }
    }

    public void setDividerPadding(int i) {
        this.mDividerPadding = i;
    }

    public void setGravity(int i) {
        if (this.mGravity != i) {
            if ((8388615 & i) == 0) {
                i |= 8388611;
            }
            if ((i & 112) == 0) {
                i |= 48;
            }
            this.mGravity = i;
            requestLayout();
        }
    }

    public void setHorizontalGravity(int i) {
        int i2 = i & 8388615;
        int i3 = this.mGravity;
        if ((8388615 & i3) != i2) {
            this.mGravity = i2 | (-8388616 & i3);
            requestLayout();
        }
    }

    public void setMeasureWithLargestChildEnabled(boolean z) {
        this.mUseLargestChild = z;
    }

    public void setOrientation(int i) {
        if (this.mOrientation != i) {
            this.mOrientation = i;
            requestLayout();
        }
    }

    public void setShowDividers(int i) {
        if (i != this.mShowDividers) {
            requestLayout();
        }
        this.mShowDividers = i;
    }

    public void setVerticalGravity(int i) {
        int i2 = i & 112;
        int i3 = this.mGravity;
        if ((i3 & 112) != i2) {
            this.mGravity = i2 | (i3 & -113);
            requestLayout();
        }
    }

    public void setWeightSum(float f) {
        this.mWeightSum = Math.max(0.0f, f);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public LinearLayoutCompat(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public C0090 generateDefaultLayoutParams() {
        int i = this.mOrientation;
        if (i == 0) {
            return new C0090(-2, -2);
        }
        if (i == 1) {
            return new C0090(-1, -2);
        }
        return null;
    }

    public LinearLayoutCompat(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        Drawable drawable;
        int resourceId;
        this.mBaselineAligned = true;
        this.mBaselineAlignedChildIndex = -1;
        this.mBaselineChildTop = 0;
        this.mGravity = BadgeDrawable.TOP_START;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.LinearLayoutCompat, i, 0);
        C1729.m4475(this, context, R$styleable.LinearLayoutCompat, attributeSet, obtainStyledAttributes, i, 0);
        int i2 = obtainStyledAttributes.getInt(R$styleable.LinearLayoutCompat_android_orientation, -1);
        if (i2 >= 0) {
            setOrientation(i2);
        }
        int i3 = obtainStyledAttributes.getInt(R$styleable.LinearLayoutCompat_android_gravity, -1);
        if (i3 >= 0) {
            setGravity(i3);
        }
        boolean z = obtainStyledAttributes.getBoolean(R$styleable.LinearLayoutCompat_android_baselineAligned, true);
        if (!z) {
            setBaselineAligned(z);
        }
        this.mWeightSum = obtainStyledAttributes.getFloat(R$styleable.LinearLayoutCompat_android_weightSum, -1.0f);
        this.mBaselineAlignedChildIndex = obtainStyledAttributes.getInt(R$styleable.LinearLayoutCompat_android_baselineAlignedChildIndex, -1);
        this.mUseLargestChild = obtainStyledAttributes.getBoolean(R$styleable.LinearLayoutCompat_measureWithLargestChild, false);
        int i4 = R$styleable.LinearLayoutCompat_divider;
        if (!obtainStyledAttributes.hasValue(i4) || (resourceId = obtainStyledAttributes.getResourceId(i4, 0)) == 0) {
            drawable = obtainStyledAttributes.getDrawable(i4);
        } else {
            drawable = C1940.m5017(context, resourceId);
        }
        setDividerDrawable(drawable);
        this.mShowDividers = obtainStyledAttributes.getInt(R$styleable.LinearLayoutCompat_showDividers, 0);
        this.mDividerPadding = obtainStyledAttributes.getDimensionPixelSize(R$styleable.LinearLayoutCompat_dividerPadding, 0);
        obtainStyledAttributes.recycle();
    }

    @Override // android.view.ViewGroup
    public C0090 generateLayoutParams(AttributeSet attributeSet) {
        return new C0090(getContext(), attributeSet);
    }

    @Override // android.view.ViewGroup
    public C0090 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new C0090(layoutParams);
    }

    /* renamed from: androidx.appcompat.widget.LinearLayoutCompat$K  reason: contains not printable characters */
    public static class C0090 extends ViewGroup.MarginLayoutParams {

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f541;

        /* renamed from: K  reason: contains not printable characters */
        public float f542;

        public C0090(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.f541 = -1;
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.LinearLayoutCompat_Layout);
            this.f542 = obtainStyledAttributes.getFloat(R$styleable.LinearLayoutCompat_Layout_android_layout_weight, 0.0f);
            this.f541 = obtainStyledAttributes.getInt(R$styleable.LinearLayoutCompat_Layout_android_layout_gravity, -1);
            obtainStyledAttributes.recycle();
        }

        public C0090(int i, int i2) {
            super(i, i2);
            this.f541 = -1;
            this.f542 = 0.0f;
        }

        public C0090(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.f541 = -1;
        }
    }
}
