package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.textclassifier.TextClassifier;
import android.widget.TextView;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import ῲ.ᨨ.ʬ.C1721;
import ῲ.ᨨ.ᨨ.AbstractC1740;
import ῲ.ᨨ.ⁱ.C1810;
import ῲ.ᨨ.㳳.AbstractC1835;
import ῲ.ᨨ.㳳.AbstractC1840;
import ῲ.ᨨ.㳳.C1841;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.C2009;
import ῲ.ῲ.㴹.C2029;
import ῲ.ῲ.㴹.C2032;
import ῲ.ῲ.㴹.C2048;
import ῲ.ῲ.㴹.C2054;
import ῲ.ῲ.㴹.C2056;
import K.K.K.ʬ.C2369;

public class AppCompatTextView extends TextView implements AbstractC1740, AbstractC1840, AbstractC1835 {
    public final C2048 mBackgroundTintHelper;
    public Future<C1810> mPrecomputedTextFuture;
    public final C2032 mTextClassifierHelper;
    public final C2054 mTextHelper;

    public AppCompatTextView(Context context) {
        this(context, null);
    }

    private void consumeTextFutureAndSetBlocking() {
        Future<C1810> future = this.mPrecomputedTextFuture;
        if (future != null) {
            try {
                this.mPrecomputedTextFuture = null;
                C1841.m4794(this, future.get());
            } catch (InterruptedException | ExecutionException unused) {
            }
        }
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5331();
        }
        C2054 r02 = this.mTextHelper;
        if (r02 != null) {
            r02.m5347();
        }
    }

    public int getAutoSizeMaxTextSize() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeMaxTextSize();
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            return r0.m5345();
        }
        return -1;
    }

    public int getAutoSizeMinTextSize() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeMinTextSize();
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            return r0.m5343();
        }
        return -1;
    }

    public int getAutoSizeStepGranularity() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeStepGranularity();
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            return r0.m5358();
        }
        return -1;
    }

    public int[] getAutoSizeTextAvailableSizes() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeTextAvailableSizes();
        }
        C2054 r0 = this.mTextHelper;
        return r0 != null ? r0.m5344() : new int[0];
    }

    @SuppressLint({"WrongConstant"})
    public int getAutoSizeTextType() {
        if (!AbstractC1835.f6227) {
            C2054 r0 = this.mTextHelper;
            if (r0 != null) {
                return r0.m5357();
            }
            return 0;
        } else if (super.getAutoSizeTextType() == 1) {
            return 1;
        } else {
            return 0;
        }
    }

    public int getFirstBaselineToTopHeight() {
        return getPaddingTop() - getPaint().getFontMetricsInt().top;
    }

    public int getLastBaselineToBottomHeight() {
        return getPaddingBottom() + getPaint().getFontMetricsInt().bottom;
    }

    public ColorStateList getSupportBackgroundTintList() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5329();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5328();
        }
        return null;
    }

    public ColorStateList getSupportCompoundDrawablesTintList() {
        C2029 r0 = this.mTextHelper.f6990;
        if (r0 != null) {
            return r0.f6876;
        }
        return null;
    }

    public PorterDuff.Mode getSupportCompoundDrawablesTintMode() {
        C2029 r0 = this.mTextHelper.f6990;
        if (r0 != null) {
            return r0.f6875;
        }
        return null;
    }

    public CharSequence getText() {
        consumeTextFutureAndSetBlocking();
        return super.getText();
    }

    public TextClassifier getTextClassifier() {
        C2032 r0;
        if (Build.VERSION.SDK_INT >= 28 || (r0 = this.mTextClassifierHelper) == null) {
            return super.getTextClassifier();
        }
        return r0.m5263();
    }

    public C1810.C1811 getTextMetricsParamsCompat() {
        return C1841.m4740(this);
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection onCreateInputConnection = super.onCreateInputConnection(editorInfo);
        C2369.m6310(onCreateInputConnection, editorInfo, this);
        return onCreateInputConnection;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        C2054 r1 = this.mTextHelper;
        if (r1 != null && !AbstractC1835.f6227) {
            r1.f6982.m5151();
        }
    }

    public void onMeasure(int i, int i2) {
        consumeTextFutureAndSetBlocking();
        super.onMeasure(i, i2);
    }

    public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        super.onTextChanged(charSequence, i, i2, i3);
        C2054 r1 = this.mTextHelper;
        if (r1 != null && !AbstractC1835.f6227 && r1.m5346()) {
            this.mTextHelper.f6982.m5151();
        }
    }

    public void setAutoSizeTextTypeUniformWithConfiguration(int i, int i2, int i3, int i4) throws IllegalArgumentException {
        if (AbstractC1835.f6227) {
            super.setAutoSizeTextTypeUniformWithConfiguration(i, i2, i3, i4);
            return;
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5349(i, i2, i3, i4);
        }
    }

    public void setAutoSizeTextTypeUniformWithPresetSizes(int[] iArr, int i) throws IllegalArgumentException {
        if (AbstractC1835.f6227) {
            super.setAutoSizeTextTypeUniformWithPresetSizes(iArr, i);
            return;
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5356(iArr, i);
        }
    }

    public void setAutoSizeTextTypeWithDefaults(int i) {
        if (AbstractC1835.f6227) {
            super.setAutoSizeTextTypeWithDefaults(i);
            return;
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5348(i);
        }
    }

    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        C2048 r1 = this.mBackgroundTintHelper;
        if (r1 != null) {
            r1.m5336();
        }
    }

    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5332(i);
        }
    }

    public void setCompoundDrawables(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawables(drawable, drawable2, drawable3, drawable4);
        C2054 r1 = this.mTextHelper;
        if (r1 != null) {
            r1.m5347();
        }
    }

    public void setCompoundDrawablesRelative(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesRelative(drawable, drawable2, drawable3, drawable4);
        C2054 r1 = this.mTextHelper;
        if (r1 != null) {
            r1.m5347();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        C2054 r1 = this.mTextHelper;
        if (r1 != null) {
            r1.m5347();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        C2054 r1 = this.mTextHelper;
        if (r1 != null) {
            r1.m5347();
        }
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback callback) {
        super.setCustomSelectionActionModeCallback(C1841.m4779(this, callback));
    }

    public void setFirstBaselineToTopHeight(int i) {
        if (Build.VERSION.SDK_INT >= 28) {
            super.setFirstBaselineToTopHeight(i);
        } else {
            C1841.m4793(this, i);
        }
    }

    public void setLastBaselineToBottomHeight(int i) {
        if (Build.VERSION.SDK_INT >= 28) {
            super.setLastBaselineToBottomHeight(i);
        } else {
            C1841.m4759(this, i);
        }
    }

    public void setLineHeight(int i) {
        C1841.m4742(this, i);
    }

    public void setPrecomputedText(C1810 r1) {
        C1841.m4794(this, r1);
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5330(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5334(mode);
        }
    }

    @Override // ῲ.ᨨ.㳳.AbstractC1840
    public void setSupportCompoundDrawablesTintList(ColorStateList colorStateList) {
        this.mTextHelper.m5352(colorStateList);
        this.mTextHelper.m5347();
    }

    @Override // ῲ.ᨨ.㳳.AbstractC1840
    public void setSupportCompoundDrawablesTintMode(PorterDuff.Mode mode) {
        this.mTextHelper.m5353(mode);
        this.mTextHelper.m5347();
    }

    public void setTextAppearance(Context context, int i) {
        super.setTextAppearance(context, i);
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5350(context, i);
        }
    }

    public void setTextClassifier(TextClassifier textClassifier) {
        C2032 r0;
        if (Build.VERSION.SDK_INT >= 28 || (r0 = this.mTextClassifierHelper) == null) {
            super.setTextClassifier(textClassifier);
        } else {
            r0.f6886 = textClassifier;
        }
    }

    public void setTextFuture(Future<C1810> future) {
        this.mPrecomputedTextFuture = future;
        if (future != null) {
            requestLayout();
        }
    }

    public void setTextMetricsParamsCompat(C1810.C1811 k) {
        int i = Build.VERSION.SDK_INT;
        TextDirectionHeuristic r0 = k.m4693();
        int i2 = 1;
        if (!(r0 == TextDirectionHeuristics.FIRSTSTRONG_RTL || r0 == TextDirectionHeuristics.FIRSTSTRONG_LTR)) {
            if (r0 == TextDirectionHeuristics.ANYRTL_LTR) {
                i2 = 2;
            } else if (r0 == TextDirectionHeuristics.LTR) {
                i2 = 3;
            } else if (r0 == TextDirectionHeuristics.RTL) {
                i2 = 4;
            } else if (r0 == TextDirectionHeuristics.LOCALE) {
                i2 = 5;
            } else if (r0 == TextDirectionHeuristics.FIRSTSTRONG_LTR) {
                i2 = 6;
            } else if (r0 == TextDirectionHeuristics.FIRSTSTRONG_RTL) {
                i2 = 7;
            }
        }
        setTextDirection(i2);
        if (Build.VERSION.SDK_INT < 23) {
            float textScaleX = k.f6176.getTextScaleX();
            getPaint().set(k.f6176);
            if (textScaleX == getTextScaleX()) {
                setTextScaleX((textScaleX / 2.0f) + 1.0f);
            }
            setTextScaleX(textScaleX);
            return;
        }
        getPaint().set(k.f6176);
        setBreakStrategy(k.m4695());
        setHyphenationFrequency(k.m4694());
    }

    public void setTextSize(int i, float f) {
        boolean z = AbstractC1835.f6227;
        if (z) {
            super.setTextSize(i, f);
            return;
        }
        C2054 r1 = this.mTextHelper;
        if (r1 != null && !z && !r1.m5346()) {
            r1.f6982.m5153(i, f);
        }
    }

    public void setTypeface(Typeface typeface, int i) {
        Typeface r0 = (typeface == null || i <= 0) ? null : C1721.m4424(getContext(), typeface, i);
        if (r0 != null) {
            typeface = r0;
        }
        super.setTypeface(typeface, i);
    }

    public AppCompatTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    /* JADX INFO: super call moved to the top of the method (can break code semantics) */
    public AppCompatTextView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        C2009.m5199(context);
        C2056.m5362(this, getContext());
        this.mBackgroundTintHelper = new C2048(this);
        this.mBackgroundTintHelper.m5335(attributeSet, i);
        this.mTextHelper = new C2054(this);
        this.mTextHelper.m5355(attributeSet, i);
        this.mTextHelper.m5347();
        this.mTextClassifierHelper = new C2032(this);
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int i, int i2, int i3, int i4) {
        Context context = getContext();
        Drawable drawable = null;
        Drawable r3 = i != 0 ? C1940.m5017(context, i) : null;
        Drawable r4 = i2 != 0 ? C1940.m5017(context, i2) : null;
        Drawable r5 = i3 != 0 ? C1940.m5017(context, i3) : null;
        if (i4 != 0) {
            drawable = C1940.m5017(context, i4);
        }
        setCompoundDrawablesRelativeWithIntrinsicBounds(r3, r4, r5, drawable);
        C2054 r32 = this.mTextHelper;
        if (r32 != null) {
            r32.m5347();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesWithIntrinsicBounds(int i, int i2, int i3, int i4) {
        Context context = getContext();
        Drawable drawable = null;
        Drawable r3 = i != 0 ? C1940.m5017(context, i) : null;
        Drawable r4 = i2 != 0 ? C1940.m5017(context, i2) : null;
        Drawable r5 = i3 != 0 ? C1940.m5017(context, i3) : null;
        if (i4 != 0) {
            drawable = C1940.m5017(context, i4);
        }
        setCompoundDrawablesWithIntrinsicBounds(r3, r4, r5, drawable);
        C2054 r32 = this.mTextHelper;
        if (r32 != null) {
            r32.m5347();
        }
    }
}
