package androidx.appcompat.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.ThemedSpinnerAdapter;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$layout;
import androidx.appcompat.R$styleable;
import ῲ.ᨨ.ᨨ.AbstractC1740;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.ඓ.C1937;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.K.DialogInterfaceC1958;
import ῲ.ῲ.㴹.AbstractC2023;
import ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051;
import ῲ.ῲ.㴹.C1995;
import ῲ.ῲ.㴹.C2019;
import ῲ.ῲ.㴹.C2022;
import ῲ.ῲ.㴹.C2033;
import ῲ.ῲ.㴹.C2048;
import ῲ.ῲ.㴹.C2056;

public class AppCompatSpinner extends Spinner implements AbstractC1740 {

    /* renamed from: 㳳  reason: contains not printable characters */
    public static final int[] f501 = {16843505};

    /* renamed from: ʬ  reason: contains not printable characters */
    public final Context f502;

    /* renamed from: ඓ  reason: contains not printable characters */
    public SpinnerAdapter f503;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final Rect f504;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final C2048 f505;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public AbstractC0082 f506;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final boolean f507;

    /* renamed from: 㸾  reason: contains not printable characters */
    public AbstractView$OnTouchListenerC2051 f508;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f509;

    public static class SavedState extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0080();

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f510;

        /* renamed from: androidx.appcompat.widget.AppCompatSpinner$SavedState$K  reason: contains not printable characters */
        public class C0080 implements Parcelable.Creator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            /* Return type fixed from 'java.lang.Object[]' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeByte(this.f510 ? (byte) 1 : 0);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.f510 = parcel.readByte() != 0;
        }
    }

    /* renamed from: androidx.appcompat.widget.AppCompatSpinner$ʬ  reason: contains not printable characters */
    public static class C0081 implements ListAdapter, SpinnerAdapter {

        /* renamed from: ʬ  reason: contains not printable characters */
        public ListAdapter f511;

        /* renamed from: ῲ  reason: contains not printable characters */
        public SpinnerAdapter f512;

        public C0081(SpinnerAdapter spinnerAdapter, Resources.Theme theme) {
            this.f512 = spinnerAdapter;
            if (spinnerAdapter instanceof ListAdapter) {
                this.f511 = (ListAdapter) spinnerAdapter;
            }
            if (theme == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 23 && (spinnerAdapter instanceof ThemedSpinnerAdapter)) {
                ThemedSpinnerAdapter themedSpinnerAdapter = (ThemedSpinnerAdapter) spinnerAdapter;
                if (themedSpinnerAdapter.getDropDownViewTheme() != theme) {
                    themedSpinnerAdapter.setDropDownViewTheme(theme);
                }
            } else if (spinnerAdapter instanceof AbstractC2023) {
                AbstractC2023 r3 = (AbstractC2023) spinnerAdapter;
                if (r3.getDropDownViewTheme() == null) {
                    r3.setDropDownViewTheme(theme);
                }
            }
        }

        public boolean areAllItemsEnabled() {
            ListAdapter listAdapter = this.f511;
            if (listAdapter != null) {
                return listAdapter.areAllItemsEnabled();
            }
            return true;
        }

        public int getCount() {
            SpinnerAdapter spinnerAdapter = this.f512;
            if (spinnerAdapter == null) {
                return 0;
            }
            return spinnerAdapter.getCount();
        }

        public View getDropDownView(int i, View view, ViewGroup viewGroup) {
            SpinnerAdapter spinnerAdapter = this.f512;
            if (spinnerAdapter == null) {
                return null;
            }
            return spinnerAdapter.getDropDownView(i, view, viewGroup);
        }

        public Object getItem(int i) {
            SpinnerAdapter spinnerAdapter = this.f512;
            if (spinnerAdapter == null) {
                return null;
            }
            return spinnerAdapter.getItem(i);
        }

        public long getItemId(int i) {
            SpinnerAdapter spinnerAdapter = this.f512;
            if (spinnerAdapter == null) {
                return -1;
            }
            return spinnerAdapter.getItemId(i);
        }

        public int getItemViewType(int i) {
            return 0;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            SpinnerAdapter spinnerAdapter = this.f512;
            if (spinnerAdapter == null) {
                return null;
            }
            return spinnerAdapter.getDropDownView(i, view, viewGroup);
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean hasStableIds() {
            SpinnerAdapter spinnerAdapter = this.f512;
            return spinnerAdapter != null && spinnerAdapter.hasStableIds();
        }

        public boolean isEmpty() {
            return getCount() == 0;
        }

        public boolean isEnabled(int i) {
            ListAdapter listAdapter = this.f511;
            if (listAdapter != null) {
                return listAdapter.isEnabled(i);
            }
            return true;
        }

        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            SpinnerAdapter spinnerAdapter = this.f512;
            if (spinnerAdapter != null) {
                spinnerAdapter.registerDataSetObserver(dataSetObserver);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            SpinnerAdapter spinnerAdapter = this.f512;
            if (spinnerAdapter != null) {
                spinnerAdapter.unregisterDataSetObserver(dataSetObserver);
            }
        }
    }

    /* renamed from: androidx.appcompat.widget.AppCompatSpinner$ඓ  reason: contains not printable characters */
    public interface AbstractC0082 {
        void dismiss();

        void setBackgroundDrawable(Drawable drawable);

        /* renamed from: ʬ  reason: contains not printable characters */
        int m290();

        /* renamed from: ʬ  reason: contains not printable characters */
        void m291(int i);

        /* renamed from: ඓ  reason: contains not printable characters */
        CharSequence m292();

        /* renamed from: ῲ  reason: contains not printable characters */
        int m293();

        /* renamed from: ῲ  reason: contains not printable characters */
        void m294(int i);

        /* renamed from: K  reason: contains not printable characters */
        void m295(int i);

        /* renamed from: K  reason: contains not printable characters */
        void m296(int i, int i2);

        /* renamed from: K  reason: contains not printable characters */
        void m297(ListAdapter listAdapter);

        /* renamed from: K  reason: contains not printable characters */
        void m298(CharSequence charSequence);

        /* renamed from: K  reason: contains not printable characters */
        boolean m299();

        /* renamed from: 㸾  reason: contains not printable characters */
        Drawable m300();
    }

    /* renamed from: androidx.appcompat.widget.AppCompatSpinner$ῲ  reason: contains not printable characters */
    public class DialogInterface$OnClickListenerC0083 implements AbstractC0082, DialogInterface.OnClickListener {

        /* renamed from: ʬ  reason: contains not printable characters */
        public ListAdapter f513;

        /* renamed from: ῲ  reason: contains not printable characters */
        public DialogInterfaceC1958 f515;

        /* renamed from: 㸾  reason: contains not printable characters */
        public CharSequence f516;

        public DialogInterface$OnClickListenerC0083() {
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        public void dismiss() {
            DialogInterfaceC1958 r0 = this.f515;
            if (r0 != null) {
                r0.dismiss();
                this.f515 = null;
            }
        }

        public void onClick(DialogInterface dialogInterface, int i) {
            AppCompatSpinner.this.setSelection(i);
            if (AppCompatSpinner.this.getOnItemClickListener() != null) {
                AppCompatSpinner.this.performItemClick(null, i, this.f513.getItemId(i));
            }
            dismiss();
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        public void setBackgroundDrawable(Drawable drawable) {
            Log.e("AppCompatSpinner", "Cannot set popup background for MODE_DIALOG, ignoring");
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: ʬ  reason: contains not printable characters */
        public int m301() {
            return 0;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: ʬ  reason: contains not printable characters */
        public void m302(int i) {
            Log.e("AppCompatSpinner", "Cannot set horizontal (original) offset for MODE_DIALOG, ignoring");
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: ඓ  reason: contains not printable characters */
        public CharSequence m303() {
            return this.f516;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: ῲ  reason: contains not printable characters */
        public int m304() {
            return 0;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: ῲ  reason: contains not printable characters */
        public void m305(int i) {
            Log.e("AppCompatSpinner", "Cannot set vertical offset for MODE_DIALOG, ignoring");
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: K  reason: contains not printable characters */
        public boolean m310() {
            DialogInterfaceC1958 r0 = this.f515;
            if (r0 != null) {
                return r0.isShowing();
            }
            return false;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: 㸾  reason: contains not printable characters */
        public Drawable m311() {
            return null;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: K  reason: contains not printable characters */
        public void m308(ListAdapter listAdapter) {
            this.f513 = listAdapter;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: K  reason: contains not printable characters */
        public void m309(CharSequence charSequence) {
            this.f516 = charSequence;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: K  reason: contains not printable characters */
        public void m307(int i, int i2) {
            if (this.f513 != null) {
                DialogInterfaceC1958.C1959 k = new DialogInterfaceC1958.C1959(AppCompatSpinner.this.getPopupContext());
                CharSequence charSequence = this.f516;
                if (charSequence != null) {
                    k.setTitle(charSequence);
                }
                this.f515 = k.setSingleChoiceItems(this.f513, AppCompatSpinner.this.getSelectedItemPosition(), this).create();
                ListView listView = this.f515.f6686.f164;
                int i3 = Build.VERSION.SDK_INT;
                listView.setTextDirection(i);
                listView.setTextAlignment(i2);
                this.f515.show();
            }
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: K  reason: contains not printable characters */
        public void m306(int i) {
            Log.e("AppCompatSpinner", "Cannot set horizontal offset for MODE_DIALOG, ignoring");
        }
    }

    /* renamed from: androidx.appcompat.widget.AppCompatSpinner$K  reason: contains not printable characters */
    public class ViewTreeObserver$OnGlobalLayoutListenerC0084 implements ViewTreeObserver.OnGlobalLayoutListener {
        public ViewTreeObserver$OnGlobalLayoutListenerC0084() {
        }

        public void onGlobalLayout() {
            if (!AppCompatSpinner.this.getInternalPopup().m299()) {
                AppCompatSpinner.this.m289();
            }
            ViewTreeObserver viewTreeObserver = AppCompatSpinner.this.getViewTreeObserver();
            if (viewTreeObserver != null) {
                int i = Build.VERSION.SDK_INT;
                viewTreeObserver.removeOnGlobalLayoutListener(this);
            }
        }
    }

    /* renamed from: androidx.appcompat.widget.AppCompatSpinner$㸾  reason: contains not printable characters */
    public class C0085 extends C1995 implements AbstractC0082 {

        /* renamed from: ಯ  reason: contains not printable characters */
        public ListAdapter f518;

        /* renamed from: ጒ  reason: contains not printable characters */
        public final Rect f519 = new Rect();

        /* renamed from: 㮝  reason: contains not printable characters */
        public CharSequence f521;

        /* renamed from: 㹎  reason: contains not printable characters */
        public int f522;

        /* renamed from: androidx.appcompat.widget.AppCompatSpinner$㸾$ʬ  reason: contains not printable characters */
        public class C0086 implements PopupWindow.OnDismissListener {

            /* renamed from: ῲ  reason: contains not printable characters */
            public final /* synthetic */ ViewTreeObserver.OnGlobalLayoutListener f524;

            public C0086(ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
                this.f524 = onGlobalLayoutListener;
            }

            public void onDismiss() {
                ViewTreeObserver viewTreeObserver = AppCompatSpinner.this.getViewTreeObserver();
                if (viewTreeObserver != null) {
                    viewTreeObserver.removeGlobalOnLayoutListener(this.f524);
                }
            }
        }

        /* renamed from: androidx.appcompat.widget.AppCompatSpinner$㸾$ῲ  reason: contains not printable characters */
        public class ViewTreeObserver$OnGlobalLayoutListenerC0087 implements ViewTreeObserver.OnGlobalLayoutListener {
            public ViewTreeObserver$OnGlobalLayoutListenerC0087() {
            }

            public void onGlobalLayout() {
                C0085 r0 = C0085.this;
                if (!r0.m314(AppCompatSpinner.this)) {
                    C0085.this.dismiss();
                    return;
                }
                C0085.this.m315();
                C0085.super.show();
            }
        }

        /* renamed from: androidx.appcompat.widget.AppCompatSpinner$㸾$K  reason: contains not printable characters */
        public class C0088 implements AdapterView.OnItemClickListener {
            public C0088(AppCompatSpinner appCompatSpinner) {
            }

            @Override // android.widget.AdapterView.OnItemClickListener
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long j) {
                AppCompatSpinner.this.setSelection(i);
                if (AppCompatSpinner.this.getOnItemClickListener() != null) {
                    C0085 r3 = C0085.this;
                    AppCompatSpinner.this.performItemClick(view, i, r3.f518.getItemId(i));
                }
                C0085.this.dismiss();
            }
        }

        public C0085(Context context, AttributeSet attributeSet, int i) {
            super(context, attributeSet, i, 0);
            m5170(AppCompatSpinner.this);
            m5179(true);
            m5167(0);
            setOnItemClickListener(new C0088(AppCompatSpinner.this));
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean m314(View view) {
            return C1729.m4498(view) && view.getGlobalVisibleRect(this.f519);
        }

        /* renamed from: ؿ  reason: contains not printable characters */
        public void m315() {
            int i;
            int i2;
            Drawable r0 = m5187();
            int i3 = 0;
            if (r0 != null) {
                r0.getPadding(AppCompatSpinner.this.f504);
                if (C2033.m5266(AppCompatSpinner.this)) {
                    i2 = AppCompatSpinner.this.f504.right;
                } else {
                    i2 = -AppCompatSpinner.this.f504.left;
                }
                i3 = i2;
            } else {
                Rect rect = AppCompatSpinner.this.f504;
                rect.right = 0;
                rect.left = 0;
            }
            int paddingLeft = AppCompatSpinner.this.getPaddingLeft();
            int paddingRight = AppCompatSpinner.this.getPaddingRight();
            int width = AppCompatSpinner.this.getWidth();
            AppCompatSpinner appCompatSpinner = AppCompatSpinner.this;
            int i4 = appCompatSpinner.f509;
            if (i4 == -2) {
                int r4 = appCompatSpinner.m288((SpinnerAdapter) this.f518, m5187());
                int i5 = AppCompatSpinner.this.getContext().getResources().getDisplayMetrics().widthPixels;
                Rect rect2 = AppCompatSpinner.this.f504;
                int i6 = (i5 - rect2.left) - rect2.right;
                if (r4 > i6) {
                    r4 = i6;
                }
                m5163(Math.max(r4, (width - paddingLeft) - paddingRight));
            } else if (i4 == -1) {
                m5163((width - paddingLeft) - paddingRight);
            } else {
                m5163(i4);
            }
            if (C2033.m5266(AppCompatSpinner.this)) {
                i = (((width - paddingRight) - m5191()) - m317()) + i3;
            } else {
                i = m317() + paddingLeft + i3;
            }
            m5176(i);
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: ඓ  reason: contains not printable characters */
        public CharSequence m316() {
            return this.f521;
        }

        /* renamed from: ᓣ  reason: contains not printable characters */
        public int m317() {
            return this.f522;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: ʬ  reason: contains not printable characters */
        public void m313(int i) {
            this.f522 = i;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082, ῲ.ῲ.㴹.C1995
        /* renamed from: K  reason: contains not printable characters */
        public void m319(ListAdapter listAdapter) {
            super.m5178(listAdapter);
            this.f518 = listAdapter;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: K  reason: contains not printable characters */
        public void m320(CharSequence charSequence) {
            this.f521 = charSequence;
        }

        @Override // androidx.appcompat.widget.AppCompatSpinner.AbstractC0082
        /* renamed from: K  reason: contains not printable characters */
        public void m318(int i, int i2) {
            ViewTreeObserver viewTreeObserver;
            boolean r0 = m5180();
            m315();
            m5190(2);
            super.show();
            ListView r1 = m5185();
            r1.setChoiceMode(1);
            int i3 = Build.VERSION.SDK_INT;
            r1.setTextDirection(i);
            r1.setTextAlignment(i2);
            m5184(AppCompatSpinner.this.getSelectedItemPosition());
            if (!r0 && (viewTreeObserver = AppCompatSpinner.this.getViewTreeObserver()) != null) {
                ViewTreeObserver$OnGlobalLayoutListenerC0087 r5 = new ViewTreeObserver$OnGlobalLayoutListenerC0087();
                viewTreeObserver.addOnGlobalLayoutListener(r5);
                setOnDismissListener(new C0086(r5));
            }
        }
    }

    public AppCompatSpinner(Context context) {
        this(context, null);
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        C2048 r0 = this.f505;
        if (r0 != null) {
            r0.m5331();
        }
    }

    public int getDropDownHorizontalOffset() {
        AbstractC0082 r0 = this.f506;
        if (r0 != null) {
            return r0.m293();
        }
        int i = Build.VERSION.SDK_INT;
        return super.getDropDownHorizontalOffset();
    }

    public int getDropDownVerticalOffset() {
        AbstractC0082 r0 = this.f506;
        if (r0 != null) {
            return r0.m290();
        }
        int i = Build.VERSION.SDK_INT;
        return super.getDropDownVerticalOffset();
    }

    public int getDropDownWidth() {
        if (this.f506 != null) {
            return this.f509;
        }
        int i = Build.VERSION.SDK_INT;
        return super.getDropDownWidth();
    }

    public final AbstractC0082 getInternalPopup() {
        return this.f506;
    }

    public Drawable getPopupBackground() {
        AbstractC0082 r0 = this.f506;
        if (r0 != null) {
            return r0.m300();
        }
        int i = Build.VERSION.SDK_INT;
        return super.getPopupBackground();
    }

    public Context getPopupContext() {
        return this.f502;
    }

    public CharSequence getPrompt() {
        AbstractC0082 r0 = this.f506;
        return r0 != null ? r0.m292() : super.getPrompt();
    }

    public ColorStateList getSupportBackgroundTintList() {
        C2048 r0 = this.f505;
        if (r0 != null) {
            return r0.m5329();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        C2048 r0 = this.f505;
        if (r0 != null) {
            return r0.m5328();
        }
        return null;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        AbstractC0082 r0 = this.f506;
        if (r0 != null && r0.m299()) {
            this.f506.dismiss();
        }
    }

    public void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
        if (this.f506 != null && View.MeasureSpec.getMode(i) == Integer.MIN_VALUE) {
            setMeasuredDimension(Math.min(Math.max(getMeasuredWidth(), m288(getAdapter(), getBackground())), View.MeasureSpec.getSize(i)), getMeasuredHeight());
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        ViewTreeObserver viewTreeObserver;
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.f510 && (viewTreeObserver = getViewTreeObserver()) != null) {
            viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver$OnGlobalLayoutListenerC0084());
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        AbstractC0082 r1 = this.f506;
        savedState.f510 = r1 != null && r1.m299();
        return savedState;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        AbstractView$OnTouchListenerC2051 r0 = this.f508;
        if (r0 == null || !r0.onTouch(this, motionEvent)) {
            return super.onTouchEvent(motionEvent);
        }
        return true;
    }

    public boolean performClick() {
        AbstractC0082 r0 = this.f506;
        if (r0 == null) {
            return super.performClick();
        }
        if (r0.m299()) {
            return true;
        }
        m289();
        return true;
    }

    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        C2048 r1 = this.f505;
        if (r1 != null) {
            r1.m5336();
        }
    }

    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        C2048 r0 = this.f505;
        if (r0 != null) {
            r0.m5332(i);
        }
    }

    public void setDropDownHorizontalOffset(int i) {
        AbstractC0082 r0 = this.f506;
        if (r0 != null) {
            r0.m291(i);
            this.f506.m295(i);
            return;
        }
        int i2 = Build.VERSION.SDK_INT;
        super.setDropDownHorizontalOffset(i);
    }

    public void setDropDownVerticalOffset(int i) {
        AbstractC0082 r0 = this.f506;
        if (r0 != null) {
            r0.m294(i);
            return;
        }
        int i2 = Build.VERSION.SDK_INT;
        super.setDropDownVerticalOffset(i);
    }

    public void setDropDownWidth(int i) {
        if (this.f506 != null) {
            this.f509 = i;
            return;
        }
        int i2 = Build.VERSION.SDK_INT;
        super.setDropDownWidth(i);
    }

    public void setPopupBackgroundDrawable(Drawable drawable) {
        AbstractC0082 r0 = this.f506;
        if (r0 != null) {
            r0.setBackgroundDrawable(drawable);
            return;
        }
        int i = Build.VERSION.SDK_INT;
        super.setPopupBackgroundDrawable(drawable);
    }

    public void setPopupBackgroundResource(int i) {
        setPopupBackgroundDrawable(C1940.m5017(getPopupContext(), i));
    }

    public void setPrompt(CharSequence charSequence) {
        AbstractC0082 r0 = this.f506;
        if (r0 != null) {
            r0.m298(charSequence);
        } else {
            super.setPrompt(charSequence);
        }
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        C2048 r0 = this.f505;
        if (r0 != null) {
            r0.m5330(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        C2048 r0 = this.f505;
        if (r0 != null) {
            r0.m5334(mode);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m288(SpinnerAdapter spinnerAdapter, Drawable drawable) {
        int i = 0;
        if (spinnerAdapter == null) {
            return 0;
        }
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 0);
        int makeMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(getMeasuredHeight(), 0);
        int max = Math.max(0, getSelectedItemPosition());
        int min = Math.min(spinnerAdapter.getCount(), max + 15);
        View view = null;
        int i2 = 0;
        for (int max2 = Math.max(0, max - (15 - (min - max))); max2 < min; max2++) {
            int itemViewType = spinnerAdapter.getItemViewType(max2);
            if (itemViewType != i) {
                view = null;
                i = itemViewType;
            }
            view = spinnerAdapter.getView(max2, view, this);
            if (view.getLayoutParams() == null) {
                view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            view.measure(makeMeasureSpec, makeMeasureSpec2);
            i2 = Math.max(i2, view.getMeasuredWidth());
        }
        if (drawable == null) {
            return i2;
        }
        drawable.getPadding(this.f504);
        Rect rect = this.f504;
        return i2 + rect.left + rect.right;
    }

    public AppCompatSpinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.spinnerStyle);
    }

    @Override // android.widget.Spinner, android.widget.AbsSpinner
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        if (!this.f507) {
            this.f503 = spinnerAdapter;
            return;
        }
        super.setAdapter(spinnerAdapter);
        if (this.f506 != null) {
            Context context = this.f502;
            if (context == null) {
                context = getContext();
            }
            this.f506.m297(new C0081(spinnerAdapter, context.getTheme()));
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:20:0x0057, code lost:
        if (r4 != null) goto L_0x0059;
     */
    /* JADX WARNING: Removed duplicated region for block: B:36:0x00db  */
    public AppCompatSpinner(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        Throwable th;
        TypedArray typedArray;
        Exception e;
        this.f504 = new Rect();
        C2056.m5362(this, getContext());
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.Spinner, i, 0);
        this.f505 = new C2048(this);
        int resourceId = obtainStyledAttributes.getResourceId(R$styleable.Spinner_popupTheme, 0);
        if (resourceId != 0) {
            this.f502 = new C1937(context, resourceId);
        } else {
            this.f502 = context;
        }
        TypedArray typedArray2 = null;
        int i2 = -1;
        try {
            typedArray = context.obtainStyledAttributes(attributeSet, f501, i, 0);
            try {
                if (typedArray.hasValue(0)) {
                    i2 = typedArray.getInt(0, 0);
                }
            } catch (Exception e2) {
                e = e2;
                try {
                    Log.i("AppCompatSpinner", "Could not read android:spinnerMode", e);
                } catch (Throwable th2) {
                    th = th2;
                    typedArray2 = typedArray;
                    if (typedArray2 != null) {
                        typedArray2.recycle();
                    }
                    throw th;
                }
            }
        } catch (Exception e3) {
            e = e3;
            typedArray = null;
            Log.i("AppCompatSpinner", "Could not read android:spinnerMode", e);
        } catch (Throwable th3) {
            th = th3;
            if (typedArray2 != null) {
            }
            throw th;
        }
        typedArray.recycle();
        if (i2 == 0) {
            this.f506 = new DialogInterface$OnClickListenerC0083();
            this.f506.m298(obtainStyledAttributes.getString(R$styleable.Spinner_android_prompt));
        } else if (i2 == 1) {
            C0085 r3 = new C0085(this.f502, attributeSet, i);
            C2019 r1 = C2019.m5223(this.f502, attributeSet, R$styleable.Spinner, i, 0);
            this.f509 = r1.m5236(R$styleable.Spinner_android_dropDownWidth, -2);
            r3.setBackgroundDrawable(r1.m5229(R$styleable.Spinner_android_popupBackground));
            r3.m320(obtainStyledAttributes.getString(R$styleable.Spinner_android_prompt));
            r1.f6846.recycle();
            this.f506 = r3;
            this.f508 = new C2022(this, this, r3);
        }
        CharSequence[] textArray = obtainStyledAttributes.getTextArray(R$styleable.Spinner_android_entries);
        if (textArray != null) {
            ArrayAdapter arrayAdapter = new ArrayAdapter(context, 17367048, textArray);
            arrayAdapter.setDropDownViewResource(R$layout.support_simple_spinner_dropdown_item);
            setAdapter((SpinnerAdapter) arrayAdapter);
        }
        obtainStyledAttributes.recycle();
        this.f507 = true;
        SpinnerAdapter spinnerAdapter = this.f503;
        if (spinnerAdapter != null) {
            setAdapter(spinnerAdapter);
            this.f503 = null;
        }
        this.f505.m5335(attributeSet, i);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m289() {
        int i = Build.VERSION.SDK_INT;
        this.f506.m296(getTextDirection(), getTextAlignment());
    }
}
