package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import ῲ.ᨨ.ᨨ.AbstractC1740;
import ῲ.ᨨ.㳳.AbstractC1836;
import ῲ.ῲ.㴹.C2009;
import ῲ.ῲ.㴹.C2026;
import ῲ.ῲ.㴹.C2029;
import ῲ.ῲ.㴹.C2048;
import ῲ.ῲ.㴹.C2056;

public class AppCompatImageView extends ImageView implements AbstractC1740, AbstractC1836 {
    public final C2048 mBackgroundTintHelper;
    public final C2026 mImageHelper;

    public AppCompatImageView(Context context) {
        this(context, null);
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5331();
        }
        C2026 r02 = this.mImageHelper;
        if (r02 != null) {
            r02.m5248();
        }
    }

    public ColorStateList getSupportBackgroundTintList() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5329();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5328();
        }
        return null;
    }

    public ColorStateList getSupportImageTintList() {
        C2029 r0;
        C2026 r02 = this.mImageHelper;
        if (r02 == null || (r0 = r02.f6859) == null) {
            return null;
        }
        return r0.f6876;
    }

    public PorterDuff.Mode getSupportImageTintMode() {
        C2029 r0;
        C2026 r02 = this.mImageHelper;
        if (r02 == null || (r0 = r02.f6859) == null) {
            return null;
        }
        return r0.f6875;
    }

    public boolean hasOverlappingRendering() {
        Drawable background = this.mImageHelper.f6861.getBackground();
        int i = Build.VERSION.SDK_INT;
        if (!(!(background instanceof RippleDrawable)) || !super.hasOverlappingRendering()) {
            return false;
        }
        return true;
    }

    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        C2048 r1 = this.mBackgroundTintHelper;
        if (r1 != null) {
            r1.m5336();
        }
    }

    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5332(i);
        }
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        C2026 r1 = this.mImageHelper;
        if (r1 != null) {
            r1.m5248();
        }
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        C2026 r1 = this.mImageHelper;
        if (r1 != null) {
            r1.m5248();
        }
    }

    public void setImageResource(int i) {
        C2026 r0 = this.mImageHelper;
        if (r0 != null) {
            r0.m5249(i);
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        C2026 r1 = this.mImageHelper;
        if (r1 != null) {
            r1.m5248();
        }
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5330(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5334(mode);
        }
    }

    public void setSupportImageTintList(ColorStateList colorStateList) {
        C2026 r0 = this.mImageHelper;
        if (r0 != null) {
            r0.m5250(colorStateList);
        }
    }

    public void setSupportImageTintMode(PorterDuff.Mode mode) {
        C2026 r0 = this.mImageHelper;
        if (r0 != null) {
            r0.m5251(mode);
        }
    }

    public AppCompatImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /* JADX INFO: super call moved to the top of the method (can break code semantics) */
    public AppCompatImageView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        C2009.m5199(context);
        C2056.m5362(this, getContext());
        this.mBackgroundTintHelper = new C2048(this);
        this.mBackgroundTintHelper.m5335(attributeSet, i);
        this.mImageHelper = new C2026(this);
        this.mImageHelper.m5252(attributeSet, i);
    }
}
