package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import androidx.appcompat.R$attr;
import ῲ.ᨨ.ᨨ.AbstractC1740;
import ῲ.ᨨ.㳳.AbstractC1835;
import ῲ.ᨨ.㳳.AbstractC1840;
import ῲ.ᨨ.㳳.C1841;
import ῲ.ῲ.㴹.C2009;
import ῲ.ῲ.㴹.C2029;
import ῲ.ῲ.㴹.C2048;
import ῲ.ῲ.㴹.C2054;
import ῲ.ῲ.㴹.C2056;

public class AppCompatButton extends Button implements AbstractC1740, AbstractC1835, AbstractC1840 {
    public final C2048 mBackgroundTintHelper;
    public final C2054 mTextHelper;

    public AppCompatButton(Context context) {
        this(context, null);
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5331();
        }
        C2054 r02 = this.mTextHelper;
        if (r02 != null) {
            r02.m5347();
        }
    }

    public int getAutoSizeMaxTextSize() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeMaxTextSize();
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            return r0.m5345();
        }
        return -1;
    }

    public int getAutoSizeMinTextSize() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeMinTextSize();
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            return r0.m5343();
        }
        return -1;
    }

    public int getAutoSizeStepGranularity() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeStepGranularity();
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            return r0.m5358();
        }
        return -1;
    }

    public int[] getAutoSizeTextAvailableSizes() {
        if (AbstractC1835.f6227) {
            return super.getAutoSizeTextAvailableSizes();
        }
        C2054 r0 = this.mTextHelper;
        return r0 != null ? r0.m5344() : new int[0];
    }

    @SuppressLint({"WrongConstant"})
    public int getAutoSizeTextType() {
        if (!AbstractC1835.f6227) {
            C2054 r0 = this.mTextHelper;
            if (r0 != null) {
                return r0.m5357();
            }
            return 0;
        } else if (super.getAutoSizeTextType() == 1) {
            return 1;
        } else {
            return 0;
        }
    }

    public ColorStateList getSupportBackgroundTintList() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5329();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5328();
        }
        return null;
    }

    public ColorStateList getSupportCompoundDrawablesTintList() {
        C2029 r0 = this.mTextHelper.f6990;
        if (r0 != null) {
            return r0.f6876;
        }
        return null;
    }

    public PorterDuff.Mode getSupportCompoundDrawablesTintMode() {
        C2029 r0 = this.mTextHelper.f6990;
        if (r0 != null) {
            return r0.f6875;
        }
        return null;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(Button.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(Button.class.getName());
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        C2054 r1 = this.mTextHelper;
        if (r1 != null && !AbstractC1835.f6227) {
            r1.f6982.m5151();
        }
    }

    public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        super.onTextChanged(charSequence, i, i2, i3);
        C2054 r1 = this.mTextHelper;
        if (r1 != null && !AbstractC1835.f6227 && r1.m5346()) {
            this.mTextHelper.f6982.m5151();
        }
    }

    public void setAutoSizeTextTypeUniformWithConfiguration(int i, int i2, int i3, int i4) throws IllegalArgumentException {
        if (AbstractC1835.f6227) {
            super.setAutoSizeTextTypeUniformWithConfiguration(i, i2, i3, i4);
            return;
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5349(i, i2, i3, i4);
        }
    }

    public void setAutoSizeTextTypeUniformWithPresetSizes(int[] iArr, int i) throws IllegalArgumentException {
        if (AbstractC1835.f6227) {
            super.setAutoSizeTextTypeUniformWithPresetSizes(iArr, i);
            return;
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5356(iArr, i);
        }
    }

    public void setAutoSizeTextTypeWithDefaults(int i) {
        if (AbstractC1835.f6227) {
            super.setAutoSizeTextTypeWithDefaults(i);
            return;
        }
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5348(i);
        }
    }

    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        C2048 r1 = this.mBackgroundTintHelper;
        if (r1 != null) {
            r1.m5336();
        }
    }

    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5332(i);
        }
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback callback) {
        super.setCustomSelectionActionModeCallback(C1841.m4779(this, callback));
    }

    public void setSupportAllCaps(boolean z) {
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.f6985.setAllCaps(z);
        }
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5330(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5334(mode);
        }
    }

    @Override // ῲ.ᨨ.㳳.AbstractC1840
    public void setSupportCompoundDrawablesTintList(ColorStateList colorStateList) {
        this.mTextHelper.m5352(colorStateList);
        this.mTextHelper.m5347();
    }

    @Override // ῲ.ᨨ.㳳.AbstractC1840
    public void setSupportCompoundDrawablesTintMode(PorterDuff.Mode mode) {
        this.mTextHelper.m5353(mode);
        this.mTextHelper.m5347();
    }

    public void setTextAppearance(Context context, int i) {
        super.setTextAppearance(context, i);
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5350(context, i);
        }
    }

    public void setTextSize(int i, float f) {
        boolean z = AbstractC1835.f6227;
        if (z) {
            super.setTextSize(i, f);
            return;
        }
        C2054 r1 = this.mTextHelper;
        if (r1 != null && !z && !r1.m5346()) {
            r1.f6982.m5153(i, f);
        }
    }

    public AppCompatButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.buttonStyle);
    }

    /* JADX INFO: super call moved to the top of the method (can break code semantics) */
    public AppCompatButton(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        C2009.m5199(context);
        C2056.m5362(this, getContext());
        this.mBackgroundTintHelper = new C2048(this);
        this.mBackgroundTintHelper.m5335(attributeSet, i);
        this.mTextHelper = new C2054(this);
        this.mTextHelper.m5355(attributeSet, i);
        this.mTextHelper.m5347();
    }
}
