package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.AutoCompleteTextView;
import androidx.appcompat.R$attr;
import ῲ.ᨨ.ᨨ.AbstractC1740;
import ῲ.ᨨ.㳳.C1841;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.C2009;
import ῲ.ῲ.㴹.C2019;
import ῲ.ῲ.㴹.C2048;
import ῲ.ῲ.㴹.C2054;
import ῲ.ῲ.㴹.C2056;
import K.K.K.ʬ.C2369;

public class AppCompatAutoCompleteTextView extends AutoCompleteTextView implements AbstractC1740 {
    public static final int[] TINT_ATTRS = {16843126};
    public final C2048 mBackgroundTintHelper;
    public final C2054 mTextHelper;

    public AppCompatAutoCompleteTextView(Context context) {
        this(context, null);
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5331();
        }
        C2054 r02 = this.mTextHelper;
        if (r02 != null) {
            r02.m5347();
        }
    }

    public ColorStateList getSupportBackgroundTintList() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5329();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5328();
        }
        return null;
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection onCreateInputConnection = super.onCreateInputConnection(editorInfo);
        C2369.m6310(onCreateInputConnection, editorInfo, this);
        return onCreateInputConnection;
    }

    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        C2048 r1 = this.mBackgroundTintHelper;
        if (r1 != null) {
            r1.m5336();
        }
    }

    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5332(i);
        }
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback callback) {
        super.setCustomSelectionActionModeCallback(C1841.m4779(this, callback));
    }

    public void setDropDownBackgroundResource(int i) {
        setDropDownBackgroundDrawable(C1940.m5017(getContext(), i));
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5330(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5334(mode);
        }
    }

    public void setTextAppearance(Context context, int i) {
        super.setTextAppearance(context, i);
        C2054 r0 = this.mTextHelper;
        if (r0 != null) {
            r0.m5350(context, i);
        }
    }

    public AppCompatAutoCompleteTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.autoCompleteTextViewStyle);
    }

    /* JADX INFO: super call moved to the top of the method (can break code semantics) */
    public AppCompatAutoCompleteTextView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        C2009.m5199(context);
        C2056.m5362(this, getContext());
        C2019 r3 = C2019.m5223(getContext(), attributeSet, TINT_ATTRS, i, 0);
        if (r3.m5237(0)) {
            setDropDownBackgroundDrawable(r3.m5229(0));
        }
        r3.f6846.recycle();
        this.mBackgroundTintHelper = new C2048(this);
        this.mBackgroundTintHelper.m5335(attributeSet, i);
        this.mTextHelper = new C2054(this);
        this.mTextHelper.m5355(attributeSet, i);
        this.mTextHelper.m5347();
    }
}
