package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.R$id;
import androidx.appcompat.widget.LinearLayoutCompat;
import ῲ.ᨨ.ᨨ.C1729;
import K.K.K.ʬ.C2369;

public class AlertDialogLayout extends LinearLayoutCompat {
    public AlertDialogLayout(Context context) {
        super(context);
    }

    /* renamed from: K  reason: contains not printable characters */
    public static int m287(View view) {
        int r0 = C1729.m4442(view);
        if (r0 > 0) {
            return r0;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup) view;
            if (viewGroup.getChildCount() == 1) {
                return m287(viewGroup.getChildAt(0));
            }
        }
        return 0;
    }

    public final void forceUniformWidth(int i, int i2) {
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 1073741824);
        for (int i3 = 0; i3 < i; i3++) {
            View childAt = getChildAt(i3);
            if (childAt.getVisibility() != 8) {
                LinearLayoutCompat.C0090 k = (LinearLayoutCompat.C0090) childAt.getLayoutParams();
                if (((ViewGroup.MarginLayoutParams) k).width == -1) {
                    int i4 = ((ViewGroup.MarginLayoutParams) k).height;
                    ((ViewGroup.MarginLayoutParams) k).height = childAt.getMeasuredHeight();
                    measureChildWithMargins(childAt, makeMeasureSpec, 0, i2, 0);
                    ((ViewGroup.MarginLayoutParams) k).height = i4;
                }
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:29:0x009d  */
    @Override // androidx.appcompat.widget.LinearLayoutCompat
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int paddingLeft = getPaddingLeft();
        int i10 = i3 - i;
        int paddingRight = i10 - getPaddingRight();
        int paddingRight2 = (i10 - paddingLeft) - getPaddingRight();
        int measuredHeight = getMeasuredHeight();
        int childCount = getChildCount();
        int gravity = getGravity();
        int i11 = gravity & 112;
        int i12 = gravity & 8388615;
        if (i11 == 16) {
            i5 = (((i4 - i2) - measuredHeight) / 2) + getPaddingTop();
        } else if (i11 != 80) {
            i5 = getPaddingTop();
        } else {
            i5 = ((getPaddingTop() + i4) - i2) - measuredHeight;
        }
        Drawable dividerDrawable = getDividerDrawable();
        if (dividerDrawable == null) {
            i6 = 0;
        } else {
            i6 = dividerDrawable.getIntrinsicHeight();
        }
        for (int i13 = 0; i13 < childCount; i13++) {
            View childAt = getChildAt(i13);
            if (!(childAt == null || childAt.getVisibility() == 8)) {
                int measuredWidth = childAt.getMeasuredWidth();
                int measuredHeight2 = childAt.getMeasuredHeight();
                LinearLayoutCompat.C0090 k = (LinearLayoutCompat.C0090) childAt.getLayoutParams();
                int i14 = k.f541;
                if (i14 < 0) {
                    i14 = i12;
                }
                int r7 = C2369.m6293(i14, C1729.m4511(this)) & 7;
                if (r7 == 1) {
                    i9 = ((paddingRight2 - measuredWidth) / 2) + paddingLeft + ((ViewGroup.MarginLayoutParams) k).leftMargin;
                    i8 = ((ViewGroup.MarginLayoutParams) k).rightMargin;
                } else if (r7 != 5) {
                    i7 = ((ViewGroup.MarginLayoutParams) k).leftMargin + paddingLeft;
                    if (hasDividerBeforeChildAt(i13)) {
                        i5 += i6;
                    }
                    int i15 = i5 + ((ViewGroup.MarginLayoutParams) k).topMargin;
                    childAt.layout(i7, i15, measuredWidth + i7, measuredHeight2 + i15);
                    i5 = measuredHeight2 + ((ViewGroup.MarginLayoutParams) k).bottomMargin + i15;
                } else {
                    i9 = paddingRight - measuredWidth;
                    i8 = ((ViewGroup.MarginLayoutParams) k).rightMargin;
                }
                i7 = i9 - i8;
                if (hasDividerBeforeChildAt(i13)) {
                }
                int i152 = i5 + ((ViewGroup.MarginLayoutParams) k).topMargin;
                childAt.layout(i7, i152, measuredWidth + i7, measuredHeight2 + i152);
                i5 = measuredHeight2 + ((ViewGroup.MarginLayoutParams) k).bottomMargin + i152;
            }
        }
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat
    public void onMeasure(int i, int i2) {
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int childCount = getChildCount();
        boolean z = false;
        View view = null;
        View view2 = null;
        View view3 = null;
        int i8 = 0;
        while (true) {
            if (i8 < childCount) {
                View childAt = getChildAt(i8);
                if (childAt.getVisibility() != 8) {
                    int id = childAt.getId();
                    if (id == R$id.topPanel) {
                        view = childAt;
                    } else if (id != R$id.buttonPanel) {
                        if (!((id == R$id.contentPanel || id == R$id.customPanel) && view3 == null)) {
                            break;
                        }
                        view3 = childAt;
                    } else {
                        view2 = childAt;
                    }
                }
                i8++;
            } else {
                int mode = View.MeasureSpec.getMode(i2);
                int size = View.MeasureSpec.getSize(i2);
                int mode2 = View.MeasureSpec.getMode(i);
                int paddingBottom = getPaddingBottom() + getPaddingTop();
                if (view != null) {
                    view.measure(i, 0);
                    paddingBottom += view.getMeasuredHeight();
                    i3 = View.combineMeasuredStates(0, view.getMeasuredState());
                } else {
                    i3 = 0;
                }
                if (view2 != null) {
                    view2.measure(i, 0);
                    i5 = m287(view2);
                    i4 = view2.getMeasuredHeight() - i5;
                    paddingBottom += i5;
                    i3 = View.combineMeasuredStates(i3, view2.getMeasuredState());
                } else {
                    i5 = 0;
                    i4 = 0;
                }
                if (view3 != null) {
                    if (mode == 0) {
                        i7 = 0;
                    } else {
                        i7 = View.MeasureSpec.makeMeasureSpec(Math.max(0, size - paddingBottom), mode);
                    }
                    view3.measure(i, i7);
                    i6 = view3.getMeasuredHeight();
                    paddingBottom += i6;
                    i3 = View.combineMeasuredStates(i3, view3.getMeasuredState());
                } else {
                    i6 = 0;
                }
                int i9 = size - paddingBottom;
                if (view2 != null) {
                    int i10 = paddingBottom - i5;
                    int min = Math.min(i9, i4);
                    if (min > 0) {
                        i9 -= min;
                        i5 += min;
                    }
                    view2.measure(i, View.MeasureSpec.makeMeasureSpec(i5, 1073741824));
                    paddingBottom = i10 + view2.getMeasuredHeight();
                    i3 = View.combineMeasuredStates(i3, view2.getMeasuredState());
                }
                if (view3 != null && i9 > 0) {
                    view3.measure(i, View.MeasureSpec.makeMeasureSpec(i6 + i9, mode));
                    paddingBottom = (paddingBottom - i6) + view3.getMeasuredHeight();
                    i3 = View.combineMeasuredStates(i3, view3.getMeasuredState());
                }
                int i11 = 0;
                for (int i12 = 0; i12 < childCount; i12++) {
                    View childAt2 = getChildAt(i12);
                    if (childAt2.getVisibility() != 8) {
                        i11 = Math.max(i11, childAt2.getMeasuredWidth());
                    }
                }
                setMeasuredDimension(View.resolveSizeAndState(getPaddingRight() + getPaddingLeft() + i11, i, i3), View.resolveSizeAndState(paddingBottom, i2, 0));
                if (mode2 != 1073741824) {
                    forceUniformWidth(childCount, i2);
                }
                z = true;
            }
        }
        if (!z) {
            super.onMeasure(i, i2);
        }
    }

    public AlertDialogLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }
}
