package androidx.appcompat.widget;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$dimen;
import androidx.appcompat.R$id;
import androidx.appcompat.R$layout;
import androidx.appcompat.R$string;
import androidx.appcompat.R$styleable;
import ῲ.ᨨ.ᨨ.AbstractC1743;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ῲ.ඓ.㳳.AbstractC1903;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051;
import ῲ.ῲ.㴹.C1984;
import ῲ.ῲ.㴹.C1995;

public class ActivityChooserView extends ViewGroup implements C1984.AbstractC1988 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final View$OnClickListenerC0076 f464;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public C1995 f465;

    /* renamed from: ؿ  reason: contains not printable characters */
    public boolean f466;

    /* renamed from: ݜ  reason: contains not printable characters */
    public int f467;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final Drawable f468;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f469;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public AbstractC1743 f470;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final ImageView f471;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final C0078 f472;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final ImageView f473;

    /* renamed from: 㑃  reason: contains not printable characters */
    public final DataSetObserver f474;

    /* renamed from: 㗗  reason: contains not printable characters */
    public PopupWindow.OnDismissListener f475;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f476;

    /* renamed from: 㳳  reason: contains not printable characters */
    public final int f477;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final FrameLayout f478;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final View f479;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final FrameLayout f480;

    /* renamed from: 䁗  reason: contains not printable characters */
    public final ViewTreeObserver.OnGlobalLayoutListener f481;

    public static class InnerLayout extends LinearLayout {

        /* renamed from: ῲ  reason: contains not printable characters */
        public static final int[] f482 = {16842964};

        public InnerLayout(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            Drawable drawable;
            int resourceId;
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, f482);
            if (!obtainStyledAttributes.hasValue(0) || (resourceId = obtainStyledAttributes.getResourceId(0, 0)) == 0) {
                drawable = obtainStyledAttributes.getDrawable(0);
            } else {
                drawable = C1940.m5017(context, resourceId);
            }
            setBackgroundDrawable(drawable);
            obtainStyledAttributes.recycle();
        }
    }

    /* renamed from: androidx.appcompat.widget.ActivityChooserView$ʬ  reason: contains not printable characters */
    public class C0073 extends View.AccessibilityDelegate {
        public C0073(ActivityChooserView activityChooserView) {
        }

        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfo);
            C1782 r2 = new C1782(accessibilityNodeInfo);
            int i = Build.VERSION.SDK_INT;
            r2.f6124.setCanOpenPopup(true);
        }
    }

    /* renamed from: androidx.appcompat.widget.ActivityChooserView$ඓ  reason: contains not printable characters */
    public class C0074 extends DataSetObserver {
        public C0074() {
        }

        public void onChanged() {
            super.onChanged();
            ActivityChooserView.this.m283();
        }
    }

    /* renamed from: androidx.appcompat.widget.ActivityChooserView$ῲ  reason: contains not printable characters */
    public class ViewTreeObserver$OnGlobalLayoutListenerC0075 implements ViewTreeObserver.OnGlobalLayoutListener {
        public ViewTreeObserver$OnGlobalLayoutListenerC0075() {
        }

        public void onGlobalLayout() {
            if (!ActivityChooserView.this.m280()) {
                return;
            }
            if (!ActivityChooserView.this.isShown()) {
                ActivityChooserView.this.getListPopupWindow().dismiss();
                return;
            }
            ActivityChooserView.this.getListPopupWindow().show();
            AbstractC1743 r0 = ActivityChooserView.this.f470;
            if (r0 != null) {
                r0.m4543(true);
            }
        }
    }

    /* renamed from: androidx.appcompat.widget.ActivityChooserView$ⁱ  reason: contains not printable characters */
    public class View$OnClickListenerC0076 implements AdapterView.OnItemClickListener, View.OnClickListener, View.OnLongClickListener, PopupWindow.OnDismissListener {
        public View$OnClickListenerC0076() {
        }

        public void onClick(View view) {
            ActivityChooserView activityChooserView = ActivityChooserView.this;
            if (view == activityChooserView.f480) {
                activityChooserView.m282();
                Intent r3 = ActivityChooserView.this.f472.f489.m5142(ActivityChooserView.this.f472.f489.m5141(ActivityChooserView.this.f472.f489.m5136()));
                if (r3 != null) {
                    r3.addFlags(524288);
                    ActivityChooserView.this.getContext().startActivity(r3);
                }
            } else if (view == activityChooserView.f478) {
                activityChooserView.f466 = false;
                activityChooserView.m281(activityChooserView.f469);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public void onDismiss() {
            PopupWindow.OnDismissListener onDismissListener = ActivityChooserView.this.f475;
            if (onDismissListener != null) {
                onDismissListener.onDismiss();
            }
            AbstractC1743 r0 = ActivityChooserView.this.f470;
            if (r0 != null) {
                r0.m4543(false);
            }
        }

        @Override // android.widget.AdapterView.OnItemClickListener
        public void onItemClick(AdapterView<?> adapterView, View view, int i, long j) {
            int itemViewType = ((C0078) adapterView.getAdapter()).getItemViewType(i);
            if (itemViewType == 0) {
                ActivityChooserView.this.m282();
                ActivityChooserView activityChooserView = ActivityChooserView.this;
                if (!activityChooserView.f466) {
                    if (!activityChooserView.f472.f492) {
                        i++;
                    }
                    Intent r1 = ActivityChooserView.this.f472.f489.m5142(i);
                    if (r1 != null) {
                        r1.addFlags(524288);
                        ActivityChooserView.this.getContext().startActivity(r1);
                    }
                } else if (i > 0) {
                    activityChooserView.f472.f489.m5137(i);
                }
            } else if (itemViewType == 1) {
                ActivityChooserView.this.m281(Integer.MAX_VALUE);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public boolean onLongClick(View view) {
            ActivityChooserView activityChooserView = ActivityChooserView.this;
            if (view == activityChooserView.f480) {
                if (activityChooserView.f472.getCount() > 0) {
                    ActivityChooserView activityChooserView2 = ActivityChooserView.this;
                    activityChooserView2.f466 = true;
                    activityChooserView2.m281(activityChooserView2.f469);
                }
                return true;
            }
            throw new IllegalArgumentException();
        }
    }

    /* renamed from: androidx.appcompat.widget.ActivityChooserView$K  reason: contains not printable characters */
    public class C0077 extends DataSetObserver {
        public C0077() {
        }

        public void onChanged() {
            super.onChanged();
            ActivityChooserView.this.f472.notifyDataSetChanged();
        }

        public void onInvalidated() {
            super.onInvalidated();
            ActivityChooserView.this.f472.notifyDataSetInvalidated();
        }
    }

    /* renamed from: androidx.appcompat.widget.ActivityChooserView$㴹  reason: contains not printable characters */
    public class C0078 extends BaseAdapter {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f487 = 4;

        /* renamed from: ඓ  reason: contains not printable characters */
        public boolean f488;

        /* renamed from: ῲ  reason: contains not printable characters */
        public C1984 f489;

        /* renamed from: 㴹  reason: contains not printable characters */
        public boolean f491;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f492;

        public C0078() {
        }

        public int getCount() {
            int r0 = this.f489.m5139();
            if (!this.f492 && this.f489.m5136() != null) {
                r0--;
            }
            int min = Math.min(r0, this.f487);
            return this.f491 ? min + 1 : min;
        }

        public Object getItem(int i) {
            int itemViewType = getItemViewType(i);
            if (itemViewType == 0) {
                if (!this.f492 && this.f489.m5136() != null) {
                    i++;
                }
                return this.f489.m5140(i);
            } else if (itemViewType == 1) {
                return null;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public long getItemId(int i) {
            return (long) i;
        }

        public int getItemViewType(int i) {
            return (!this.f491 || i != getCount() - 1) ? 0 : 1;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            int itemViewType = getItemViewType(i);
            if (itemViewType == 0) {
                if (view == null || view.getId() != R$id.list_item) {
                    view = LayoutInflater.from(ActivityChooserView.this.getContext()).inflate(R$layout.abc_activity_chooser_view_list_item, viewGroup, false);
                }
                PackageManager packageManager = ActivityChooserView.this.getContext().getPackageManager();
                ResolveInfo resolveInfo = (ResolveInfo) getItem(i);
                ((ImageView) view.findViewById(R$id.icon)).setImageDrawable(resolveInfo.loadIcon(packageManager));
                ((TextView) view.findViewById(R$id.title)).setText(resolveInfo.loadLabel(packageManager));
                if (!this.f492 || i != 0 || !this.f488) {
                    view.setActivated(false);
                } else {
                    view.setActivated(true);
                }
                return view;
            } else if (itemViewType != 1) {
                throw new IllegalArgumentException();
            } else if (view != null && view.getId() == 1) {
                return view;
            } else {
                View inflate = LayoutInflater.from(ActivityChooserView.this.getContext()).inflate(R$layout.abc_activity_chooser_view_list_item, viewGroup, false);
                inflate.setId(1);
                ((TextView) inflate.findViewById(R$id.title)).setText(ActivityChooserView.this.getContext().getString(R$string.abc_activity_chooser_view_see_all));
                return inflate;
            }
        }

        public int getViewTypeCount() {
            return 3;
        }
    }

    /* renamed from: androidx.appcompat.widget.ActivityChooserView$㸾  reason: contains not printable characters */
    public class C0079 extends AbstractView$OnTouchListenerC2051 {
        public C0079(View view) {
            super(view);
        }

        @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean m284() {
            ActivityChooserView.this.m279();
            return true;
        }

        @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
        /* renamed from: ῲ  reason: contains not printable characters */
        public AbstractC1903 m285() {
            return ActivityChooserView.this.getListPopupWindow();
        }

        @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean m286() {
            ActivityChooserView.this.m282();
            return true;
        }
    }

    public ActivityChooserView(Context context) {
        this(context, null);
    }

    public C1984 getDataModel() {
        return this.f472.f489;
    }

    public C1995 getListPopupWindow() {
        if (this.f465 == null) {
            this.f465 = new C1995(getContext(), null, R$attr.listPopupWindowStyle, 0);
            this.f465.m5178(this.f472);
            this.f465.m5170(this);
            this.f465.m5179(true);
            this.f465.setOnItemClickListener(this.f464);
            this.f465.setOnDismissListener(this.f464);
        }
        return this.f465;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        C1984 r0 = this.f472.f489;
        if (r0 != null) {
            r0.registerObserver(this.f474);
        }
        this.f476 = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        C1984 r0 = this.f472.f489;
        if (r0 != null) {
            r0.unregisterObserver(this.f474);
        }
        ViewTreeObserver viewTreeObserver = getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.removeGlobalOnLayoutListener(this.f481);
        }
        if (m280()) {
            m282();
        }
        this.f476 = false;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        this.f479.layout(0, 0, i3 - i, i4 - i2);
        if (!m280()) {
            m282();
        }
    }

    public void onMeasure(int i, int i2) {
        View view = this.f479;
        if (this.f480.getVisibility() != 0) {
            i2 = View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(i2), 1073741824);
        }
        measureChild(view, i, i2);
        setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    public void setActivityChooserModel(C1984 r4) {
        C0078 r0 = this.f472;
        ActivityChooserView activityChooserView = ActivityChooserView.this;
        C1984 r2 = activityChooserView.f472.f489;
        if (r2 != null && activityChooserView.isShown()) {
            r2.unregisterObserver(ActivityChooserView.this.f474);
        }
        r0.f489 = r4;
        if (r4 != null && ActivityChooserView.this.isShown()) {
            r4.registerObserver(ActivityChooserView.this.f474);
        }
        r0.notifyDataSetChanged();
        if (m280()) {
            m282();
            m279();
        }
    }

    public void setDefaultActionButtonContentDescription(int i) {
        this.f467 = i;
    }

    public void setExpandActivityOverflowButtonContentDescription(int i) {
        this.f473.setContentDescription(getContext().getString(i));
    }

    public void setExpandActivityOverflowButtonDrawable(Drawable drawable) {
        this.f473.setImageDrawable(drawable);
    }

    public void setInitialActivityCount(int i) {
        this.f469 = i;
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.f475 = onDismissListener;
    }

    public void setProvider(AbstractC1743 r1) {
        this.f470 = r1;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m279() {
        if (m280() || !this.f476) {
            return false;
        }
        this.f466 = false;
        m281(this.f469);
        return true;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m280() {
        return getListPopupWindow().m5180();
    }

    /* JADX WARNING: Removed duplicated region for block: B:24:0x0065  */
    /* JADX WARNING: Removed duplicated region for block: B:48:? A[RETURN, SYNTHETIC] */
    /* renamed from: K  reason: contains not printable characters */
    public void m281(int i) {
        C1995 listPopupWindow;
        if (this.f472.f489 != null) {
            getViewTreeObserver().addOnGlobalLayoutListener(this.f481);
            boolean z = this.f480.getVisibility() == 0;
            int r3 = this.f472.f489.m5139();
            if (i != Integer.MAX_VALUE) {
                int i2 = z ? 1 : 0;
                int i3 = z ? 1 : 0;
                int i4 = z ? 1 : 0;
                if (r3 > i + i2) {
                    C0078 r32 = this.f472;
                    if (!r32.f491) {
                        r32.f491 = true;
                        r32.notifyDataSetChanged();
                    }
                    C0078 r33 = this.f472;
                    int i5 = i - 1;
                    if (r33.f487 != i5) {
                        r33.f487 = i5;
                        r33.notifyDataSetChanged();
                    }
                    listPopupWindow = getListPopupWindow();
                    if (listPopupWindow.m5180()) {
                        if (this.f466 || !z) {
                            C0078 r34 = this.f472;
                            if (!(r34.f492 && r34.f488 == z)) {
                                r34.f492 = true;
                                r34.f488 = z;
                                r34.notifyDataSetChanged();
                            }
                        } else {
                            C0078 r0 = this.f472;
                            if (r0.f492 || r0.f488) {
                                r0.f492 = false;
                                r0.f488 = false;
                                r0.notifyDataSetChanged();
                            }
                        }
                        C0078 r02 = this.f472;
                        int i6 = r02.f487;
                        r02.f487 = Integer.MAX_VALUE;
                        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                        int makeMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(0, 0);
                        int count = r02.getCount();
                        View view = null;
                        int i7 = 0;
                        for (int i8 = 0; i8 < count; i8++) {
                            view = r02.getView(i8, view, null);
                            view.measure(makeMeasureSpec, makeMeasureSpec2);
                            i7 = Math.max(i7, view.getMeasuredWidth());
                        }
                        r02.f487 = i6;
                        listPopupWindow.m5163(Math.min(i7, this.f477));
                        listPopupWindow.show();
                        AbstractC1743 r03 = this.f470;
                        if (r03 != null) {
                            r03.m4543(true);
                        }
                        listPopupWindow.m5185().setContentDescription(getContext().getString(R$string.abc_activitychooserview_choose_application));
                        listPopupWindow.m5185().setSelector(new ColorDrawable(0));
                        return;
                    }
                    return;
                }
            }
            C0078 r35 = this.f472;
            if (r35.f491) {
                r35.f491 = false;
                r35.notifyDataSetChanged();
            }
            C0078 r36 = this.f472;
            if (r36.f487 != i) {
                r36.f487 = i;
                r36.notifyDataSetChanged();
            }
            listPopupWindow = getListPopupWindow();
            if (listPopupWindow.m5180()) {
            }
        } else {
            throw new IllegalStateException("No data model. Did you call #setDataModel?");
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m283() {
        if (this.f472.getCount() > 0) {
            this.f478.setEnabled(true);
        } else {
            this.f478.setEnabled(false);
        }
        int r0 = this.f472.f489.m5139();
        int r3 = this.f472.f489.m5145();
        if (r0 == 1 || (r0 > 1 && r3 > 0)) {
            this.f480.setVisibility(0);
            ResolveInfo r02 = this.f472.f489.m5136();
            PackageManager packageManager = getContext().getPackageManager();
            this.f471.setImageDrawable(r02.loadIcon(packageManager));
            if (this.f467 != 0) {
                CharSequence loadLabel = r02.loadLabel(packageManager);
                this.f480.setContentDescription(getContext().getString(this.f467, loadLabel));
            }
        } else {
            this.f480.setVisibility(8);
        }
        if (this.f480.getVisibility() == 0) {
            this.f479.setBackgroundDrawable(this.f468);
        } else {
            this.f479.setBackgroundDrawable(null);
        }
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f474 = new C0077();
        this.f481 = new ViewTreeObserver$OnGlobalLayoutListenerC0075();
        this.f469 = 4;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.ActivityChooserView, i, 0);
        C1729.m4475(this, context, R$styleable.ActivityChooserView, attributeSet, obtainStyledAttributes, i, 0);
        this.f469 = obtainStyledAttributes.getInt(R$styleable.ActivityChooserView_initialActivityCount, 4);
        Drawable drawable = obtainStyledAttributes.getDrawable(R$styleable.ActivityChooserView_expandActivityOverflowButtonDrawable);
        obtainStyledAttributes.recycle();
        LayoutInflater.from(getContext()).inflate(R$layout.abc_activity_chooser_view, (ViewGroup) this, true);
        this.f464 = new View$OnClickListenerC0076();
        this.f479 = findViewById(R$id.activity_chooser_view_content);
        this.f468 = this.f479.getBackground();
        this.f480 = (FrameLayout) findViewById(R$id.default_activity_button);
        this.f480.setOnClickListener(this.f464);
        this.f480.setOnLongClickListener(this.f464);
        this.f471 = (ImageView) this.f480.findViewById(R$id.image);
        FrameLayout frameLayout = (FrameLayout) findViewById(R$id.expand_activities_button);
        frameLayout.setOnClickListener(this.f464);
        frameLayout.setAccessibilityDelegate(new C0073(this));
        frameLayout.setOnTouchListener(new C0079(frameLayout));
        this.f478 = frameLayout;
        this.f473 = (ImageView) frameLayout.findViewById(R$id.image);
        this.f473.setImageDrawable(drawable);
        this.f472 = new C0078();
        this.f472.registerDataSetObserver(new C0074());
        Resources resources = context.getResources();
        this.f477 = Math.max(resources.getDisplayMetrics().widthPixels / 2, resources.getDimensionPixelSize(R$dimen.abc_config_prefDialogWidth));
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m282() {
        if (!m280()) {
            return true;
        }
        getListPopupWindow().dismiss();
        ViewTreeObserver viewTreeObserver = getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return true;
        }
        viewTreeObserver.removeGlobalOnLayoutListener(this.f481);
        return true;
    }
}
