package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.ActionMenuPresenter;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.Toolbar;
import ῲ.ῲ.ඓ.㳳.AbstractC1897;
import ῲ.ῲ.ඓ.㳳.AbstractC1917;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ඓ.㳳.C1922;
import ῲ.ῲ.K.C1974;
import ῲ.ῲ.㴹.C2033;

public class ActionMenuView extends LinearLayoutCompat implements C1912.AbstractC1913, AbstractC1917 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public Context f445;

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean f446;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f447;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f448;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C1912 f449;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public AbstractC1897.AbstractC1898 f450;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f451;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f452;

    /* renamed from: 㴹  reason: contains not printable characters */
    public ActionMenuPresenter f453;

    /* renamed from: 㸾  reason: contains not printable characters */
    public int f454;

    /* renamed from: 㿎  reason: contains not printable characters */
    public C1912.AbstractC1914 f455;

    /* renamed from: 䁗  reason: contains not printable characters */
    public AbstractC0069 f456;

    /* renamed from: androidx.appcompat.widget.ActionMenuView$ʬ  reason: contains not printable characters */
    public static class C0068 extends LinearLayoutCompat.C0090 {
        @ViewDebug.ExportedProperty

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f457;
        @ViewDebug.ExportedProperty

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f458;
        @ViewDebug.ExportedProperty

        /* renamed from: ⁱ  reason: contains not printable characters */
        public boolean f459;
        @ViewDebug.ExportedProperty

        /* renamed from: 㴹  reason: contains not printable characters */
        public boolean f460;
        @ViewDebug.ExportedProperty

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f461;

        /* renamed from: 㿎  reason: contains not printable characters */
        public boolean f462;

        public C0068(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public C0068(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public C0068(C0068 r1) {
            super(r1);
            this.f457 = r1.f457;
        }

        public C0068(int i, int i2) {
            super(i, i2);
            this.f457 = false;
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuView$ඓ  reason: contains not printable characters */
    public interface AbstractC0069 {
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuView$ῲ  reason: contains not printable characters */
    public static class C0070 implements AbstractC1897.AbstractC1898 {
        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        public void onCloseMenu(C1912 r1, boolean z) {
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        /* renamed from: K  reason: contains not printable characters */
        public boolean m276(C1912 r1) {
            return false;
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuView$K  reason: contains not printable characters */
    public interface AbstractC0071 {
        /* renamed from: ῲ  reason: contains not printable characters */
        boolean m277();

        /* renamed from: K  reason: contains not printable characters */
        boolean m278();
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuView$㸾  reason: contains not printable characters */
    public class C0072 implements C1912.AbstractC1914 {
        public C0072() {
        }

        @Override // ῲ.ῲ.ඓ.㳳.C1912.AbstractC1914
        public boolean onMenuItemSelected(C1912 r2, MenuItem menuItem) {
            AbstractC0069 r22 = ActionMenuView.this.f456;
            if (r22 == null) {
                return false;
            }
            Toolbar.AbstractC0119 r23 = Toolbar.this.mOnMenuItemClickListener;
            if (r23 != null ? C1974.this.f6710.onMenuItemSelected(0, menuItem) : false) {
                return true;
            }
            return false;
        }

        @Override // ῲ.ῲ.ඓ.㳳.C1912.AbstractC1914
        public void onMenuModeChange(C1912 r2) {
            C1912.AbstractC1914 k = ActionMenuView.this.f455;
            if (k != null) {
                k.onMenuModeChange(r2);
            }
        }
    }

    public ActionMenuView(Context context) {
        this(context, null);
    }

    /* renamed from: K  reason: contains not printable characters */
    public static int m264(View view, int i, int i2, int i3, int i4) {
        C0068 r0 = (C0068) view.getLayoutParams();
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(i3) - i4, View.MeasureSpec.getMode(i3));
        ActionMenuItemView actionMenuItemView = view instanceof ActionMenuItemView ? (ActionMenuItemView) view : null;
        boolean z = true;
        boolean z2 = actionMenuItemView != null && actionMenuItemView.m208();
        int i5 = 2;
        if (i2 <= 0 || (z2 && i2 < 2)) {
            i5 = 0;
        } else {
            view.measure(View.MeasureSpec.makeMeasureSpec(i2 * i, Integer.MIN_VALUE), makeMeasureSpec);
            int measuredWidth = view.getMeasuredWidth();
            int i6 = measuredWidth / i;
            if (measuredWidth % i != 0) {
                i6++;
            }
            if (!z2 || i6 >= 2) {
                i5 = i6;
            }
        }
        if (r0.f457 || !z2) {
            z = false;
        }
        r0.f460 = z;
        r0.f461 = i5;
        view.measure(View.MeasureSpec.makeMeasureSpec(i * i5, 1073741824), makeMeasureSpec);
        return i5;
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat
    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0068;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return false;
    }

    public Menu getMenu() {
        if (this.f449 == null) {
            Context context = getContext();
            this.f449 = new C1912(context);
            this.f449.setCallback(new C0072());
            this.f453 = new ActionMenuPresenter(context);
            ActionMenuPresenter actionMenuPresenter = this.f453;
            actionMenuPresenter.f416 = true;
            actionMenuPresenter.f428 = true;
            AbstractC1897.AbstractC1898 k = this.f450;
            if (k == null) {
                k = new C0070();
            }
            actionMenuPresenter.f6468 = k;
            this.f449.addMenuPresenter(this.f453, this.f445);
            ActionMenuPresenter actionMenuPresenter2 = this.f453;
            actionMenuPresenter2.f6464 = this;
            initialize(actionMenuPresenter2.f6469);
        }
        return this.f449;
    }

    public Drawable getOverflowIcon() {
        getMenu();
        ActionMenuPresenter actionMenuPresenter = this.f453;
        ActionMenuPresenter.C0066 r1 = actionMenuPresenter.f423;
        if (r1 != null) {
            return r1.getDrawable();
        }
        if (actionMenuPresenter.f434) {
            return actionMenuPresenter.f427;
        }
        return null;
    }

    public int getPopupTheme() {
        return this.f454;
    }

    public int getWindowAnimations() {
        return 0;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917
    public void initialize(C1912 r1) {
        this.f449 = r1;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        ActionMenuPresenter actionMenuPresenter = this.f453;
        if (actionMenuPresenter != null) {
            actionMenuPresenter.updateMenuView(false);
            if (this.f453.m249()) {
                this.f453.m250();
                this.f453.m255();
            }
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        m265();
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        int i7;
        int i8;
        if (!this.f448) {
            super.onLayout(z, i, i2, i3, i4);
            return;
        }
        int childCount = getChildCount();
        int i9 = (i4 - i2) / 2;
        int dividerWidth = getDividerWidth();
        int i10 = i3 - i;
        int paddingRight = (i10 - getPaddingRight()) - getPaddingLeft();
        boolean r6 = C2033.m5266(this);
        int i11 = paddingRight;
        int i12 = 0;
        int i13 = 0;
        for (int i14 = 0; i14 < childCount; i14++) {
            View childAt = getChildAt(i14);
            if (childAt.getVisibility() != 8) {
                C0068 r11 = (C0068) childAt.getLayoutParams();
                if (r11.f457) {
                    int measuredWidth = childAt.getMeasuredWidth();
                    if (m270(i14)) {
                        measuredWidth += dividerWidth;
                    }
                    int measuredHeight = childAt.getMeasuredHeight();
                    if (r6) {
                        i7 = getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r11).leftMargin;
                        i8 = i7 + measuredWidth;
                    } else {
                        i8 = (getWidth() - getPaddingRight()) - ((ViewGroup.MarginLayoutParams) r11).rightMargin;
                        i7 = i8 - measuredWidth;
                    }
                    int i15 = i9 - (measuredHeight / 2);
                    childAt.layout(i7, i15, i8, measuredHeight + i15);
                    i11 -= measuredWidth;
                    i12 = 1;
                } else {
                    i11 -= (childAt.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) r11).leftMargin) + ((ViewGroup.MarginLayoutParams) r11).rightMargin;
                    m270(i14);
                    i13++;
                }
            }
        }
        if (childCount == 1 && i12 == 0) {
            View childAt2 = getChildAt(0);
            int measuredWidth2 = childAt2.getMeasuredWidth();
            int measuredHeight2 = childAt2.getMeasuredHeight();
            int i16 = (i10 / 2) - (measuredWidth2 / 2);
            int i17 = i9 - (measuredHeight2 / 2);
            childAt2.layout(i16, i17, measuredWidth2 + i16, measuredHeight2 + i17);
            return;
        }
        int i18 = i13 - (i12 ^ 1);
        if (i18 > 0) {
            i5 = i11 / i18;
            i6 = 0;
        } else {
            i6 = 0;
            i5 = 0;
        }
        int max = Math.max(i6, i5);
        if (r6) {
            int width = getWidth() - getPaddingRight();
            while (i6 < childCount) {
                View childAt3 = getChildAt(i6);
                C0068 r7 = (C0068) childAt3.getLayoutParams();
                if (childAt3.getVisibility() != 8 && !r7.f457) {
                    int i19 = width - ((ViewGroup.MarginLayoutParams) r7).rightMargin;
                    int measuredWidth3 = childAt3.getMeasuredWidth();
                    int measuredHeight3 = childAt3.getMeasuredHeight();
                    int i20 = i9 - (measuredHeight3 / 2);
                    childAt3.layout(i19 - measuredWidth3, i20, i19, measuredHeight3 + i20);
                    width = i19 - ((measuredWidth3 + ((ViewGroup.MarginLayoutParams) r7).leftMargin) + max);
                }
                i6++;
            }
            return;
        }
        int paddingLeft = getPaddingLeft();
        while (i6 < childCount) {
            View childAt4 = getChildAt(i6);
            C0068 r72 = (C0068) childAt4.getLayoutParams();
            if (childAt4.getVisibility() != 8 && !r72.f457) {
                int i21 = paddingLeft + ((ViewGroup.MarginLayoutParams) r72).leftMargin;
                int measuredWidth4 = childAt4.getMeasuredWidth();
                int measuredHeight4 = childAt4.getMeasuredHeight();
                int i22 = i9 - (measuredHeight4 / 2);
                childAt4.layout(i21, i22, i21 + measuredWidth4, measuredHeight4 + i22);
                paddingLeft = measuredWidth4 + ((ViewGroup.MarginLayoutParams) r72).rightMargin + max + i21;
            }
            i6++;
        }
    }

    /* JADX WARN: Type inference failed for: r6v15, types: [boolean, int] */
    /* JADX WARN: Type inference failed for: r6v18 */
    /* JADX WARN: Type inference failed for: r6v19 */
    /* JADX WARNING: Unknown variable types count: 1 */
    @Override // androidx.appcompat.widget.LinearLayoutCompat
    public void onMeasure(int i, int i2) {
        int i3;
        boolean z;
        int i4;
        int i5;
        int i6;
        int i7;
        ?? r6;
        C1912 r2;
        boolean z2 = this.f448;
        this.f448 = View.MeasureSpec.getMode(i) == 1073741824;
        if (z2 != this.f448) {
            this.f452 = 0;
        }
        int size = View.MeasureSpec.getSize(i);
        if (!(!this.f448 || (r2 = this.f449) == null || size == this.f452)) {
            this.f452 = size;
            r2.onItemsChanged(true);
        }
        int childCount = getChildCount();
        if (!this.f448 || childCount <= 0) {
            for (int i8 = 0; i8 < childCount; i8++) {
                C0068 r3 = (C0068) getChildAt(i8).getLayoutParams();
                ((ViewGroup.MarginLayoutParams) r3).rightMargin = 0;
                ((ViewGroup.MarginLayoutParams) r3).leftMargin = 0;
            }
            super.onMeasure(i, i2);
            return;
        }
        int mode = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i);
        int size3 = View.MeasureSpec.getSize(i2);
        int paddingRight = getPaddingRight() + getPaddingLeft();
        int paddingBottom = getPaddingBottom() + getPaddingTop();
        int childMeasureSpec = ViewGroup.getChildMeasureSpec(i2, paddingBottom, -2);
        int i9 = size2 - paddingRight;
        int i10 = this.f447;
        int i11 = i9 / i10;
        int i12 = i9 % i10;
        if (i11 == 0) {
            setMeasuredDimension(i9, 0);
            return;
        }
        int i13 = (i12 / i11) + i10;
        int childCount2 = getChildCount();
        int i14 = i11;
        int i15 = 0;
        int i16 = 0;
        int i17 = 0;
        boolean z3 = false;
        int i18 = 0;
        int i19 = 0;
        long j = 0;
        while (i16 < childCount2) {
            View childAt = getChildAt(i16);
            if (childAt.getVisibility() == 8) {
                i7 = size3;
            } else {
                boolean z4 = childAt instanceof ActionMenuItemView;
                i18++;
                if (z4) {
                    int i20 = this.f451;
                    i7 = size3;
                    r6 = 0;
                    childAt.setPadding(i20, 0, i20, 0);
                } else {
                    i7 = size3;
                    r6 = 0;
                }
                C0068 r5 = (C0068) childAt.getLayoutParams();
                r5.f462 = r6;
                int i21 = r6 == true ? 1 : 0;
                int i22 = r6 == true ? 1 : 0;
                int i23 = r6 == true ? 1 : 0;
                r5.f458 = i21;
                r5.f461 = r6;
                r5.f460 = r6;
                ((ViewGroup.MarginLayoutParams) r5).leftMargin = r6;
                ((ViewGroup.MarginLayoutParams) r5).rightMargin = r6;
                r5.f459 = z4 && ((ActionMenuItemView) childAt).m208();
                int r4 = m264(childAt, i13, r5.f457 ? 1 : i14, childMeasureSpec, paddingBottom);
                i15 = Math.max(i15, r4);
                if (r5.f460) {
                    i19++;
                }
                if (r5.f457) {
                    z3 = true;
                }
                i14 -= r4;
                int max = Math.max(i17, childAt.getMeasuredHeight());
                if (r4 == 1) {
                    j |= (long) (1 << i16);
                }
                i17 = max;
            }
            i16++;
            size3 = i7;
        }
        boolean z5 = z3 && i18 == 2;
        int i24 = i14;
        boolean z6 = false;
        while (true) {
            if (i19 <= 0 || i24 <= 0) {
                i5 = mode;
                i3 = i9;
                z = z6;
                i4 = i17;
            } else {
                int i25 = Integer.MAX_VALUE;
                int i26 = 0;
                int i27 = 0;
                long j2 = 0;
                while (i26 < childCount2) {
                    C0068 r9 = (C0068) getChildAt(i26).getLayoutParams();
                    if (r9.f460) {
                        int i28 = r9.f461;
                        if (i28 < i25) {
                            i25 = i28;
                            j2 = 1 << i26;
                            i27 = 1;
                        } else if (i28 == i25) {
                            j2 |= 1 << i26;
                            i27++;
                        }
                    }
                    i26++;
                    i17 = i17;
                    z6 = z6;
                }
                z = z6;
                i4 = i17;
                j |= j2;
                if (i27 > i24) {
                    i5 = mode;
                    i3 = i9;
                    break;
                }
                int i29 = i25 + 1;
                int i30 = i24;
                int i31 = 0;
                while (i31 < childCount2) {
                    View childAt2 = getChildAt(i31);
                    C0068 r12 = (C0068) childAt2.getLayoutParams();
                    long j3 = (long) (1 << i31);
                    if ((j2 & j3) == 0) {
                        if (r12.f461 == i29) {
                            j |= j3;
                        }
                        i6 = i29;
                    } else {
                        if (!z5 || !r12.f459 || i30 != 1) {
                            i6 = i29;
                        } else {
                            int i32 = this.f451;
                            i6 = i29;
                            childAt2.setPadding(i32 + i13, 0, i32, 0);
                        }
                        r12.f461++;
                        r12.f462 = true;
                        i30--;
                    }
                    i31++;
                    mode = mode;
                    i29 = i6;
                    i9 = i9;
                }
                i24 = i30;
                i17 = i4;
                z6 = true;
            }
        }
        boolean z7 = !z3 && i18 == 1;
        if (i24 > 0 && j != 0 && (i24 < i18 - 1 || z7 || i15 > 1)) {
            float bitCount = (float) Long.bitCount(j);
            if (!z7) {
                if ((j & 1) != 0 && !((C0068) getChildAt(0).getLayoutParams()).f459) {
                    bitCount -= 0.5f;
                }
                int i33 = childCount2 - 1;
                if ((j & ((long) (1 << i33))) != 0 && !((C0068) getChildAt(i33).getLayoutParams()).f459) {
                    bitCount -= 0.5f;
                }
            }
            int i34 = bitCount > 0.0f ? (int) (((float) (i24 * i13)) / bitCount) : 0;
            boolean z8 = z;
            for (int i35 = 0; i35 < childCount2; i35++) {
                if ((j & ((long) (1 << i35))) != 0) {
                    View childAt3 = getChildAt(i35);
                    C0068 r32 = (C0068) childAt3.getLayoutParams();
                    if (childAt3 instanceof ActionMenuItemView) {
                        r32.f458 = i34;
                        r32.f462 = true;
                        if (i35 == 0 && !r32.f459) {
                            ((ViewGroup.MarginLayoutParams) r32).leftMargin = (-i34) / 2;
                        }
                    } else if (r32.f457) {
                        r32.f458 = i34;
                        r32.f462 = true;
                        ((ViewGroup.MarginLayoutParams) r32).rightMargin = (-i34) / 2;
                    } else {
                        if (i35 != 0) {
                            ((ViewGroup.MarginLayoutParams) r32).leftMargin = i34 / 2;
                        }
                        if (i35 != childCount2 - 1) {
                            ((ViewGroup.MarginLayoutParams) r32).rightMargin = i34 / 2;
                        }
                    }
                    z8 = true;
                }
            }
            z = z8;
        }
        if (z) {
            for (int i36 = 0; i36 < childCount2; i36++) {
                View childAt4 = getChildAt(i36);
                C0068 r33 = (C0068) childAt4.getLayoutParams();
                if (r33.f462) {
                    childAt4.measure(View.MeasureSpec.makeMeasureSpec((r33.f461 * i13) + r33.f458, 1073741824), childMeasureSpec);
                }
            }
        }
        setMeasuredDimension(i3, i5 != 1073741824 ? i4 : size3);
    }

    public void setExpandedActionViewsExclusive(boolean z) {
        this.f453.f432 = z;
    }

    public void setOnMenuItemClickListener(AbstractC0069 r1) {
        this.f456 = r1;
    }

    public void setOverflowIcon(Drawable drawable) {
        getMenu();
        ActionMenuPresenter actionMenuPresenter = this.f453;
        ActionMenuPresenter.C0066 r1 = actionMenuPresenter.f423;
        if (r1 != null) {
            r1.setImageDrawable(drawable);
            return;
        }
        actionMenuPresenter.f434 = true;
        actionMenuPresenter.f427 = drawable;
    }

    public void setOverflowReserved(boolean z) {
        this.f446 = z;
    }

    public void setPopupTheme(int i) {
        if (this.f454 != i) {
            this.f454 = i;
            if (i == 0) {
                this.f445 = getContext();
            } else {
                this.f445 = new ContextThemeWrapper(getContext(), i);
            }
        }
    }

    public void setPresenter(ActionMenuPresenter actionMenuPresenter) {
        this.f453 = actionMenuPresenter;
        ActionMenuPresenter actionMenuPresenter2 = this.f453;
        actionMenuPresenter2.f6464 = this;
        initialize(actionMenuPresenter2.f6469);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m265() {
        ActionMenuPresenter actionMenuPresenter = this.f453;
        if (actionMenuPresenter != null) {
            actionMenuPresenter.m253();
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m266() {
        ActionMenuPresenter actionMenuPresenter = this.f453;
        return actionMenuPresenter != null && actionMenuPresenter.m250();
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public C1912 m267() {
        return this.f449;
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean m268() {
        ActionMenuPresenter actionMenuPresenter = this.f453;
        return actionMenuPresenter != null && actionMenuPresenter.m249();
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean m272() {
        ActionMenuPresenter actionMenuPresenter = this.f453;
        return actionMenuPresenter != null && actionMenuPresenter.m255();
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean m273() {
        ActionMenuPresenter actionMenuPresenter = this.f453;
        if (actionMenuPresenter != null) {
            if (actionMenuPresenter.f426 != null || actionMenuPresenter.m249()) {
                return true;
            }
        }
        return false;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public C0068 m274() {
        C0068 generateDefaultLayoutParams = generateDefaultLayoutParams();
        generateDefaultLayoutParams.f457 = true;
        return generateDefaultLayoutParams;
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean m275() {
        return this.f446;
    }

    public ActionMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        setBaselineAligned(false);
        float f = context.getResources().getDisplayMetrics().density;
        this.f447 = (int) (56.0f * f);
        this.f451 = (int) (f * 4.0f);
        this.f445 = context;
        this.f454 = 0;
    }

    @Override // androidx.appcompat.widget.LinearLayoutCompat, androidx.appcompat.widget.LinearLayoutCompat
    public C0068 generateDefaultLayoutParams() {
        C0068 r0 = new C0068(-2, -2);
        r0.f541 = 16;
        return r0;
    }

    @Override // android.view.ViewGroup, androidx.appcompat.widget.LinearLayoutCompat, androidx.appcompat.widget.LinearLayoutCompat
    public C0068 generateLayoutParams(AttributeSet attributeSet) {
        return new C0068(getContext(), attributeSet);
    }

    @Override // android.view.ViewGroup, androidx.appcompat.widget.LinearLayoutCompat, androidx.appcompat.widget.LinearLayoutCompat
    public C0068 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        C0068 r0;
        if (layoutParams == null) {
            return generateDefaultLayoutParams();
        }
        if (layoutParams instanceof C0068) {
            r0 = new C0068((C0068) layoutParams);
        } else {
            r0 = new C0068(layoutParams);
        }
        if (r0.f541 <= 0) {
            r0.f541 = 16;
        }
        return r0;
    }

    @Override // ῲ.ῲ.ඓ.㳳.C1912.AbstractC1913
    /* renamed from: K  reason: contains not printable characters */
    public boolean m271(C1922 r3) {
        return this.f449.performItemAction(r3, 0);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m269(AbstractC1897.AbstractC1898 k, C1912.AbstractC1914 k2) {
        this.f450 = k;
        this.f455 = k2;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m270(int i) {
        boolean z = false;
        if (i == 0) {
            return false;
        }
        View childAt = getChildAt(i - 1);
        View childAt2 = getChildAt(i);
        if (i < getChildCount() && (childAt instanceof AbstractC0071)) {
            z = false | ((AbstractC0071) childAt).m278();
        }
        return (i <= 0 || !(childAt2 instanceof AbstractC0071)) ? z : z | ((AbstractC0071) childAt2).m277();
    }
}
