package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseBooleanArray;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$layout;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.ActionMenuView;
import java.util.ArrayList;
import ῲ.ᨨ.ᨨ.AbstractC1743;
import ῲ.ῲ.ඓ.㳳.AbstractC1897;
import ῲ.ῲ.ඓ.㳳.AbstractC1903;
import ῲ.ῲ.ඓ.㳳.AbstractC1911;
import ῲ.ῲ.ඓ.㳳.AbstractC1917;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ඓ.㳳.C1922;
import ῲ.ῲ.ඓ.㳳.C1933;
import ῲ.ῲ.ඓ.㳳.SubMenuC1900;
import ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051;
import K.K.K.ʬ.C2369;

public class ActionMenuPresenter extends AbstractC1911 implements AbstractC1743.AbstractC1745 {

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f416;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public boolean f417;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f418;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f419;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public C0062 f420;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public int f421;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f422;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public C0066 f423;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public int f424;

    /* renamed from: ゎ  reason: contains not printable characters */
    public C0064 f425;

    /* renamed from: ト  reason: contains not printable characters */
    public RunnableC0061 f426;

    /* renamed from: 㑃  reason: contains not printable characters */
    public Drawable f427;

    /* renamed from: 㗗  reason: contains not printable characters */
    public boolean f428;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f429;

    /* renamed from: 㮔  reason: contains not printable characters */
    public C0063 f430;

    /* renamed from: 㴪  reason: contains not printable characters */
    public final SparseBooleanArray f431 = new SparseBooleanArray();

    /* renamed from: 㶋  reason: contains not printable characters */
    public boolean f432;

    /* renamed from: 䀟  reason: contains not printable characters */
    public boolean f433;

    /* renamed from: 䁗  reason: contains not printable characters */
    public boolean f434;

    /* renamed from: 䃖  reason: contains not printable characters */
    public final C0065 f435 = new C0065();

    @SuppressLint({"BanParcelableUsage"})
    public static class SavedState implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0060();

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f436;

        /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$SavedState$K  reason: contains not printable characters */
        public class C0060 implements Parcelable.Creator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            /* Return type fixed from 'java.lang.Object[]' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState() {
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.f436);
        }

        public SavedState(Parcel parcel) {
            this.f436 = parcel.readInt();
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$ʬ  reason: contains not printable characters */
    public class RunnableC0061 implements Runnable {

        /* renamed from: ῲ  reason: contains not printable characters */
        public C0062 f438;

        public RunnableC0061(C0062 r2) {
            this.f438 = r2;
        }

        public void run() {
            C1912 r0 = ActionMenuPresenter.this.f6469;
            if (r0 != null) {
                r0.changeMenuMode();
            }
            View view = (View) ActionMenuPresenter.this.f6464;
            if (!(view == null || view.getWindowToken() == null || !this.f438.m5003())) {
                ActionMenuPresenter.this.f420 = this.f438;
            }
            ActionMenuPresenter.this.f426 = null;
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$ඓ  reason: contains not printable characters */
    public class C0062 extends C1933 {
        public C0062(Context context, C1912 r10, View view, boolean z) {
            super(context, r10, view, z, R$attr.actionOverflowMenuStyle, 0);
            m4997(8388613);
            m5000(ActionMenuPresenter.this.f435);
        }

        @Override // ῲ.ῲ.ඓ.㳳.C1933
        /* renamed from: 㸾  reason: contains not printable characters */
        public void m256() {
            C1912 r0 = ActionMenuPresenter.this.f6469;
            if (r0 != null) {
                r0.close();
            }
            ActionMenuPresenter.this.f420 = null;
            super.m5004();
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$ῲ  reason: contains not printable characters */
    public class C0063 extends ActionMenuItemView.AbstractC0052 {
        public C0063() {
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$K  reason: contains not printable characters */
    public class C0064 extends C1933 {
        public C0064(Context context, SubMenuC1900 r10, View view) {
            super(context, r10, view, false, R$attr.actionOverflowMenuStyle, 0);
            if (!((C1922) r10.getItem()).m4973()) {
                View view2 = ActionMenuPresenter.this.f423;
                m4999(view2 == null ? (View) ActionMenuPresenter.this.f6464 : view2);
            }
            m5000(ActionMenuPresenter.this.f435);
        }

        @Override // ῲ.ῲ.ඓ.㳳.C1933
        /* renamed from: 㸾  reason: contains not printable characters */
        public void m257() {
            ActionMenuPresenter actionMenuPresenter = ActionMenuPresenter.this;
            actionMenuPresenter.f425 = null;
            actionMenuPresenter.f424 = 0;
            super.m5004();
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$㴹  reason: contains not printable characters */
    public class C0065 implements AbstractC1897.AbstractC1898 {
        public C0065() {
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        public void onCloseMenu(C1912 r3, boolean z) {
            if (r3 instanceof SubMenuC1900) {
                r3.getRootMenu().close(false);
            }
            AbstractC1897.AbstractC1898 k = ActionMenuPresenter.this.f6468;
            if (k != null) {
                k.onCloseMenu(r3, z);
            }
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        /* renamed from: K  reason: contains not printable characters */
        public boolean m258(C1912 r4) {
            ActionMenuPresenter actionMenuPresenter = ActionMenuPresenter.this;
            if (r4 == actionMenuPresenter.f6469) {
                return false;
            }
            actionMenuPresenter.f424 = ((SubMenuC1900) r4).getItem().getItemId();
            AbstractC1897.AbstractC1898 k = ActionMenuPresenter.this.f6468;
            if (k != null) {
                return k.m4922(r4);
            }
            return false;
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$㸾  reason: contains not printable characters */
    public class C0066 extends AppCompatImageView implements ActionMenuView.AbstractC0071 {

        /* renamed from: androidx.appcompat.widget.ActionMenuPresenter$㸾$K  reason: contains not printable characters */
        public class C0067 extends AbstractView$OnTouchListenerC2051 {
            public C0067(View view, ActionMenuPresenter actionMenuPresenter) {
                super(view);
            }

            @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
            /* renamed from: ʬ  reason: contains not printable characters */
            public boolean m261() {
                ActionMenuPresenter.this.m255();
                return true;
            }

            @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
            /* renamed from: ῲ  reason: contains not printable characters */
            public AbstractC1903 m262() {
                C0062 r0 = ActionMenuPresenter.this.f420;
                if (r0 == null) {
                    return null;
                }
                return r0.m4995();
            }

            @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
            /* renamed from: 㸾  reason: contains not printable characters */
            public boolean m263() {
                ActionMenuPresenter actionMenuPresenter = ActionMenuPresenter.this;
                if (actionMenuPresenter.f426 != null) {
                    return false;
                }
                actionMenuPresenter.m250();
                return true;
            }
        }

        public C0066(Context context) {
            super(context, null, R$attr.actionOverflowButtonStyle);
            setClickable(true);
            setFocusable(true);
            setVisibility(0);
            setEnabled(true);
            C2369.m6331((View) this, getContentDescription());
            setOnTouchListener(new C0067(this, ActionMenuPresenter.this));
        }

        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            playSoundEffect(0);
            ActionMenuPresenter.this.m255();
            return true;
        }

        public boolean setFrame(int i, int i2, int i3, int i4) {
            boolean frame = super.setFrame(i, i2, i3, i4);
            Drawable drawable = getDrawable();
            Drawable background = getBackground();
            if (!(drawable == null || background == null)) {
                int width = getWidth();
                int height = getHeight();
                int max = Math.max(width, height) / 2;
                int paddingLeft = (width + (getPaddingLeft() - getPaddingRight())) / 2;
                int paddingTop = (height + (getPaddingTop() - getPaddingBottom())) / 2;
                int i5 = paddingLeft - max;
                int i6 = paddingTop - max;
                int i7 = paddingLeft + max;
                int i8 = paddingTop + max;
                int i9 = Build.VERSION.SDK_INT;
                background.setHotspotBounds(i5, i6, i7, i8);
            }
            return frame;
        }

        @Override // androidx.appcompat.widget.ActionMenuView.AbstractC0071
        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean m259() {
            return false;
        }

        @Override // androidx.appcompat.widget.ActionMenuView.AbstractC0071
        /* renamed from: K  reason: contains not printable characters */
        public boolean m260() {
            return false;
        }
    }

    public ActionMenuPresenter(Context context) {
        super(context, R$layout.abc_action_menu_layout, R$layout.abc_action_menu_item_layout);
    }

    /* JADX WARNING: Removed duplicated region for block: B:79:0x00fb  */
    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public boolean flagActionItems() {
        int i;
        ArrayList<C1922> arrayList;
        int i2;
        int i3;
        int i4;
        int i5;
        boolean z;
        ActionMenuPresenter actionMenuPresenter = this;
        C1912 r1 = actionMenuPresenter.f6469;
        View view = null;
        if (r1 != null) {
            arrayList = r1.getVisibleItems();
            i = arrayList.size();
        } else {
            arrayList = null;
            i = 0;
        }
        int i6 = actionMenuPresenter.f429;
        int i7 = actionMenuPresenter.f422;
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        ViewGroup viewGroup = (ViewGroup) actionMenuPresenter.f6464;
        int i8 = i6;
        int i9 = 0;
        boolean z2 = false;
        int i10 = 0;
        int i11 = 0;
        while (true) {
            i2 = 2;
            if (i9 >= i) {
                break;
            }
            C1922 r15 = arrayList.get(i9);
            if ((r15.f6530 & 2) == 2) {
                i10++;
            } else if ((r15.f6530 & 1) == 1) {
                i11++;
            } else {
                z2 = true;
            }
            if (actionMenuPresenter.f432 && r15.f6525) {
                i8 = 0;
            }
            i9++;
        }
        if (actionMenuPresenter.f416 && (z2 || i11 + i10 > i8)) {
            i8--;
        }
        int i12 = i8 - i10;
        SparseBooleanArray sparseBooleanArray = actionMenuPresenter.f431;
        sparseBooleanArray.clear();
        if (actionMenuPresenter.f433) {
            int i13 = actionMenuPresenter.f421;
            i3 = i7 / i13;
            i4 = i13 + ((i7 % i13) / i3);
        } else {
            i4 = 0;
            i3 = 0;
        }
        int i14 = i7;
        int i15 = 0;
        int i16 = 0;
        while (i15 < i) {
            C1922 r152 = arrayList.get(i15);
            if ((r152.f6530 & i2) == i2) {
                View r14 = actionMenuPresenter.m251(r152, view, viewGroup);
                if (actionMenuPresenter.f433) {
                    i3 -= ActionMenuView.m264(r14, i4, i3, makeMeasureSpec, 0);
                } else {
                    r14.measure(makeMeasureSpec, makeMeasureSpec);
                }
                int measuredWidth = r14.getMeasuredWidth();
                i14 -= measuredWidth;
                if (i16 == 0) {
                    i16 = measuredWidth;
                }
                int i17 = r152.f6527;
                if (i17 != 0) {
                    sparseBooleanArray.put(i17, true);
                }
                r152.m4963(true);
                i5 = i;
            } else if ((r152.f6530 & 1) == 1) {
                int i18 = r152.f6527;
                boolean z3 = sparseBooleanArray.get(i18);
                boolean z4 = (i12 > 0 || z3) && i14 > 0 && (!actionMenuPresenter.f433 || i3 > 0);
                i5 = i;
                if (z4) {
                    View r4 = actionMenuPresenter.m251(r152, null, viewGroup);
                    if (actionMenuPresenter.f433) {
                        int r18 = ActionMenuView.m264(r4, i4, i3, makeMeasureSpec, 0);
                        i3 -= r18;
                        if (r18 == 0) {
                            z = false;
                            int measuredWidth2 = r4.getMeasuredWidth();
                            i14 -= measuredWidth2;
                            if (i16 == 0) {
                                i16 = measuredWidth2;
                            }
                        }
                    } else {
                        r4.measure(makeMeasureSpec, makeMeasureSpec);
                    }
                    z = z4;
                    int measuredWidth22 = r4.getMeasuredWidth();
                    i14 -= measuredWidth22;
                    if (i16 == 0) {
                    }
                    z4 = actionMenuPresenter.f433 ? z & (actionMenuPresenter.f433 ? i14 + i16 > 0 : i14 >= 0) : z & (actionMenuPresenter.f433 ? i14 + i16 > 0 : i14 >= 0);
                }
                if (z4 && i18 != 0) {
                    sparseBooleanArray.put(i18, true);
                } else if (z3) {
                    sparseBooleanArray.put(i18, false);
                    for (int i19 = 0; i19 < i15; i19++) {
                        C1922 r142 = arrayList.get(i19);
                        if (r142.f6527 == i18) {
                            if (r142.m4973()) {
                                i12++;
                            }
                            r142.m4963(false);
                        }
                    }
                }
                if (z4) {
                    i12--;
                }
                r152.m4963(z4);
            } else {
                i5 = i;
                r152.m4963(false);
                i15++;
                view = null;
                i2 = 2;
                actionMenuPresenter = this;
                i = i5;
            }
            i15++;
            view = null;
            i2 = 2;
            actionMenuPresenter = this;
            i = i5;
        }
        return true;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897, ῲ.ῲ.ඓ.㳳.AbstractC1911
    public void initForMenu(Context context, C1912 r6) {
        super.initForMenu(context, r6);
        Resources resources = context.getResources();
        if (!this.f428) {
            int i = Build.VERSION.SDK_INT;
            this.f416 = true;
        }
        int i2 = 2;
        if (!this.f417) {
            this.f418 = context.getResources().getDisplayMetrics().widthPixels / 2;
        }
        if (!this.f419) {
            Configuration configuration = context.getResources().getConfiguration();
            int i3 = configuration.screenWidthDp;
            int i4 = configuration.screenHeightDp;
            if (configuration.smallestScreenWidthDp > 600 || i3 > 600 || ((i3 > 960 && i4 > 720) || (i3 > 720 && i4 > 960))) {
                i2 = 5;
            } else if (i3 >= 500 || ((i3 > 640 && i4 > 480) || (i3 > 480 && i4 > 640))) {
                i2 = 4;
            } else if (i3 >= 360) {
                i2 = 3;
            }
            this.f429 = i2;
        }
        int i5 = this.f418;
        if (this.f416) {
            if (this.f423 == null) {
                this.f423 = new C0066(this.f6465);
                if (this.f434) {
                    this.f423.setImageDrawable(this.f427);
                    this.f427 = null;
                    this.f434 = false;
                }
                int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.f423.measure(makeMeasureSpec, makeMeasureSpec);
            }
            i5 -= this.f423.getMeasuredWidth();
        } else {
            this.f423 = null;
        }
        this.f422 = i5;
        this.f421 = (int) (resources.getDisplayMetrics().density * 56.0f);
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897, ῲ.ῲ.ඓ.㳳.AbstractC1911
    public void onCloseMenu(C1912 r1, boolean z) {
        m253();
        super.onCloseMenu(r1, z);
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public void onRestoreInstanceState(Parcelable parcelable) {
        int i;
        MenuItem findItem;
        if ((parcelable instanceof SavedState) && (i = ((SavedState) parcelable).f436) > 0 && (findItem = this.f6469.findItem(i)) != null) {
            onSubMenuSelected((SubMenuC1900) findItem.getSubMenu());
        }
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState();
        savedState.f436 = this.f424;
        return savedState;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897, ῲ.ῲ.ඓ.㳳.AbstractC1911
    public boolean onSubMenuSelected(SubMenuC1900 r9) {
        boolean z = false;
        if (!r9.hasVisibleItems()) {
            return false;
        }
        SubMenuC1900 r0 = r9;
        while (r0.getParentMenu() != this.f6469) {
            r0 = (SubMenuC1900) r0.getParentMenu();
        }
        MenuItem item = r0.getItem();
        ViewGroup viewGroup = (ViewGroup) this.f6464;
        View view = null;
        if (viewGroup != null) {
            int childCount = viewGroup.getChildCount();
            int i = 0;
            while (true) {
                if (i >= childCount) {
                    break;
                }
                View childAt = viewGroup.getChildAt(i);
                if ((childAt instanceof AbstractC1917.AbstractC1918) && ((AbstractC1917.AbstractC1918) childAt).getItemData() == item) {
                    view = childAt;
                    break;
                }
                i++;
            }
        }
        if (view == null) {
            return false;
        }
        this.f424 = r9.getItem().getItemId();
        int size = r9.size();
        int i2 = 0;
        while (true) {
            if (i2 >= size) {
                break;
            }
            MenuItem item2 = r9.getItem(i2);
            if (item2.isVisible() && item2.getIcon() != null) {
                z = true;
                break;
            }
            i2++;
        }
        this.f425 = new C0064(this.f6462, r9, view);
        this.f425.m5001(z);
        this.f425.m4994();
        super.onSubMenuSelected(r9);
        return true;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897, ῲ.ῲ.ඓ.㳳.AbstractC1911
    public void updateMenuView(boolean z) {
        AbstractC1917 r0;
        super.updateMenuView(z);
        ((View) this.f6464).requestLayout();
        C1912 r5 = this.f6469;
        boolean z2 = false;
        if (r5 != null) {
            ArrayList<C1922> actionItems = r5.getActionItems();
            int size = actionItems.size();
            for (int i = 0; i < size; i++) {
                AbstractC1743 r3 = actionItems.get(i).f6535;
                if (r3 != null) {
                    r3.f6063 = this;
                }
            }
        }
        C1912 r52 = this.f6469;
        ArrayList<C1922> nonActionItems = r52 != null ? r52.getNonActionItems() : null;
        if (this.f416 && nonActionItems != null) {
            int size2 = nonActionItems.size();
            if (size2 == 1) {
                z2 = !nonActionItems.get(0).f6525;
            } else if (size2 > 0) {
                z2 = true;
            }
        }
        if (z2) {
            if (this.f423 == null) {
                this.f423 = new C0066(this.f6465);
            }
            ViewGroup viewGroup = (ViewGroup) this.f423.getParent();
            if (viewGroup != this.f6464) {
                if (viewGroup != null) {
                    viewGroup.removeView(this.f423);
                }
                ActionMenuView actionMenuView = (ActionMenuView) this.f6464;
                actionMenuView.addView(this.f423, actionMenuView.m274());
            }
        } else {
            C0066 r53 = this.f423;
            if (r53 != null && r53.getParent() == (r0 = this.f6464)) {
                ((ViewGroup) r0).removeView(this.f423);
            }
        }
        ((ActionMenuView) this.f6464).setOverflowReserved(this.f416);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m249() {
        C0062 r0 = this.f420;
        return r0 != null && r0.m4993();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m250() {
        AbstractC1917 r2;
        RunnableC0061 r0 = this.f426;
        if (r0 == null || (r2 = this.f6464) == null) {
            C0062 r02 = this.f420;
            if (r02 == null) {
                return false;
            }
            r02.m4996();
            return true;
        }
        ((View) r2).removeCallbacks(r0);
        this.f426 = null;
        return true;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1911
    /* renamed from: K  reason: contains not printable characters */
    public View m251(C1922 r3, View view, ViewGroup viewGroup) {
        View actionView = r3.getActionView();
        if (actionView == null || r3.m4964()) {
            actionView = super.m4933(r3, view, viewGroup);
        }
        actionView.setVisibility(r3.f6525 ? 8 : 0);
        ActionMenuView actionMenuView = (ActionMenuView) viewGroup;
        ViewGroup.LayoutParams layoutParams = actionView.getLayoutParams();
        if (!actionMenuView.checkLayoutParams(layoutParams)) {
            actionView.setLayoutParams(actionMenuView.generateLayoutParams(layoutParams));
        }
        return actionView;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m255() {
        C1912 r0;
        if (!this.f416 || m249() || (r0 = this.f6469) == null || this.f6464 == null || this.f426 != null || r0.getNonActionItems().isEmpty()) {
            return false;
        }
        this.f426 = new RunnableC0061(new C0062(this.f6462, this.f6469, this.f423, true));
        ((View) this.f6464).post(this.f426);
        return true;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1911
    /* renamed from: K  reason: contains not printable characters */
    public boolean m254(ViewGroup viewGroup, int i) {
        if (viewGroup.getChildAt(i) == this.f423) {
            return false;
        }
        super.m4934(viewGroup, i);
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m253() {
        boolean z;
        boolean r0 = m250();
        C0064 k = this.f425;
        if (k != null) {
            k.m4996();
            z = true;
        } else {
            z = false;
        }
        return r0 | z;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m252(boolean z) {
        if (z) {
            super.onSubMenuSelected(null);
            return;
        }
        C1912 r2 = this.f6469;
        if (r2 != null) {
            r2.close(false);
        }
    }
}
