package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$id;
import androidx.appcompat.R$layout;
import androidx.appcompat.R$styleable;
import androidx.appcompat.widget.ActionMenuPresenter;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.ඓ.AbstractC1890;
import ῲ.ῲ.ඓ.㳳.AbstractC1917;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.AbstractC2027;
import ῲ.ῲ.㴹.C2033;

public class ActionBarContextView extends AbstractC2027 {

    /* renamed from: Ԕ  reason: contains not printable characters */
    public LinearLayout f369;

    /* renamed from: ؿ  reason: contains not printable characters */
    public TextView f370;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f371;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f372;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public CharSequence f373;

    /* renamed from: 㑃  reason: contains not printable characters */
    public View f374;

    /* renamed from: 㗗  reason: contains not printable characters */
    public TextView f375;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f376;

    /* renamed from: 㳳  reason: contains not printable characters */
    public CharSequence f377;

    /* renamed from: 䀟  reason: contains not printable characters */
    public int f378;

    /* renamed from: 䁗  reason: contains not printable characters */
    public View f379;

    /* renamed from: androidx.appcompat.widget.ActionBarContextView$K  reason: contains not printable characters */
    public class View$OnClickListenerC0054 implements View.OnClickListener {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ AbstractC1890 f380;

        public View$OnClickListenerC0054(ActionBarContextView actionBarContextView, AbstractC1890 r2) {
            this.f380 = r2;
        }

        public void onClick(View view) {
            this.f380.m4901();
        }
    }

    public ActionBarContextView(Context context) {
        this(context, null);
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -2);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(getContext(), attributeSet);
    }

    @Override // ῲ.ῲ.㴹.AbstractC2027
    public /* bridge */ /* synthetic */ int getAnimatedVisibility() {
        return super.getAnimatedVisibility();
    }

    @Override // ῲ.ῲ.㴹.AbstractC2027
    public /* bridge */ /* synthetic */ int getContentHeight() {
        return super.getContentHeight();
    }

    public CharSequence getSubtitle() {
        return this.f373;
    }

    public CharSequence getTitle() {
        return this.f377;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ActionMenuPresenter actionMenuPresenter = this.f6864;
        if (actionMenuPresenter != null) {
            actionMenuPresenter.m250();
            ActionMenuPresenter.C0064 k = this.f6864.f425;
            if (k != null) {
                k.m4996();
            }
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 32) {
            accessibilityEvent.setSource(this);
            accessibilityEvent.setClassName(ActionBarContextView.class.getName());
            accessibilityEvent.setPackageName(getContext().getPackageName());
            accessibilityEvent.setContentDescription(this.f377);
            return;
        }
        super.onInitializeAccessibilityEvent(accessibilityEvent);
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        boolean r10 = C2033.m5266(this);
        int paddingRight = r10 ? (i3 - i) - getPaddingRight() : getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingTop2 = ((i4 - i2) - getPaddingTop()) - getPaddingBottom();
        View view = this.f374;
        if (view == null || view.getVisibility() == 8) {
            i5 = paddingRight;
        } else {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.f374.getLayoutParams();
            int i6 = r10 ? marginLayoutParams.rightMargin : marginLayoutParams.leftMargin;
            int i7 = r10 ? marginLayoutParams.leftMargin : marginLayoutParams.rightMargin;
            int i8 = r10 ? paddingRight - i6 : paddingRight + i6;
            int r8 = i8 + m5256(this.f374, i8, paddingTop, paddingTop2, r10);
            i5 = r10 ? r8 - i7 : r8 + i7;
        }
        LinearLayout linearLayout = this.f369;
        if (!(linearLayout == null || this.f379 != null || linearLayout.getVisibility() == 8)) {
            i5 += m5256(this.f369, i5, paddingTop, paddingTop2, r10);
        }
        View view2 = this.f379;
        if (view2 != null) {
            m5256(view2, i5, paddingTop, paddingTop2, r10);
        }
        int paddingLeft = r10 ? getPaddingLeft() : (i3 - i) - getPaddingRight();
        ActionMenuView actionMenuView = this.f6869;
        if (actionMenuView != null) {
            m5256(actionMenuView, paddingLeft, paddingTop, paddingTop2, !r10);
        }
    }

    public void onMeasure(int i, int i2) {
        int i3 = 1073741824;
        if (View.MeasureSpec.getMode(i) != 1073741824) {
            throw new IllegalStateException(ActionBarContextView.class.getSimpleName() + " can only be used with android:layout_width=\"match_parent\" (or fill_parent)");
        } else if (View.MeasureSpec.getMode(i2) != 0) {
            int size = View.MeasureSpec.getSize(i);
            int i4 = this.f6868;
            if (i4 <= 0) {
                i4 = View.MeasureSpec.getSize(i2);
            }
            int paddingBottom = getPaddingBottom() + getPaddingTop();
            int paddingLeft = (size - getPaddingLeft()) - getPaddingRight();
            int i5 = i4 - paddingBottom;
            int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i5, Integer.MIN_VALUE);
            View view = this.f374;
            if (view != null) {
                int r12 = m5255(view, paddingLeft, makeMeasureSpec, 0);
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.f374.getLayoutParams();
                paddingLeft = r12 - (marginLayoutParams.leftMargin + marginLayoutParams.rightMargin);
            }
            ActionMenuView actionMenuView = this.f6869;
            if (actionMenuView != null && actionMenuView.getParent() == this) {
                paddingLeft = m5255(this.f6869, paddingLeft, makeMeasureSpec, 0);
            }
            LinearLayout linearLayout = this.f369;
            if (linearLayout != null && this.f379 == null) {
                if (this.f371) {
                    this.f369.measure(View.MeasureSpec.makeMeasureSpec(0, 0), makeMeasureSpec);
                    int measuredWidth = this.f369.getMeasuredWidth();
                    boolean z = measuredWidth <= paddingLeft;
                    if (z) {
                        paddingLeft -= measuredWidth;
                    }
                    this.f369.setVisibility(z ? 0 : 8);
                } else {
                    paddingLeft = m5255(linearLayout, paddingLeft, makeMeasureSpec, 0);
                }
            }
            View view2 = this.f379;
            if (view2 != null) {
                ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                int i6 = layoutParams.width != -2 ? 1073741824 : Integer.MIN_VALUE;
                int i7 = layoutParams.width;
                if (i7 >= 0) {
                    paddingLeft = Math.min(i7, paddingLeft);
                }
                if (layoutParams.height == -2) {
                    i3 = Integer.MIN_VALUE;
                }
                int i8 = layoutParams.height;
                if (i8 >= 0) {
                    i5 = Math.min(i8, i5);
                }
                this.f379.measure(View.MeasureSpec.makeMeasureSpec(paddingLeft, i6), View.MeasureSpec.makeMeasureSpec(i5, i3));
            }
            if (this.f6868 <= 0) {
                int childCount = getChildCount();
                int i9 = 0;
                for (int i10 = 0; i10 < childCount; i10++) {
                    int measuredHeight = getChildAt(i10).getMeasuredHeight() + paddingBottom;
                    if (measuredHeight > i9) {
                        i9 = measuredHeight;
                    }
                }
                setMeasuredDimension(size, i9);
                return;
            }
            setMeasuredDimension(size, i4);
        } else {
            throw new IllegalStateException(ActionBarContextView.class.getSimpleName() + " can only be used with android:layout_height=\"wrap_content\"");
        }
    }

    @Override // ῲ.ῲ.㴹.AbstractC2027
    public void setContentHeight(int i) {
        this.f6868 = i;
    }

    public void setCustomView(View view) {
        LinearLayout linearLayout;
        View view2 = this.f379;
        if (view2 != null) {
            removeView(view2);
        }
        this.f379 = view;
        if (!(view == null || (linearLayout = this.f369) == null)) {
            removeView(linearLayout);
            this.f369 = null;
        }
        if (view != null) {
            addView(view);
        }
        requestLayout();
    }

    public void setSubtitle(CharSequence charSequence) {
        this.f373 = charSequence;
        m225();
    }

    public void setTitle(CharSequence charSequence) {
        this.f377 = charSequence;
        m225();
    }

    public void setTitleOptional(boolean z) {
        if (z != this.f371) {
            requestLayout();
        }
        this.f371 = z;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2027
    public /* bridge */ /* synthetic */ void setVisibility(int i) {
        super.setVisibility(i);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m223() {
        return this.f371;
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m224() {
        ActionMenuPresenter actionMenuPresenter = this.f6864;
        if (actionMenuPresenter != null) {
            return actionMenuPresenter.m255();
        }
        return false;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m225() {
        if (this.f369 == null) {
            LayoutInflater.from(getContext()).inflate(R$layout.abc_action_bar_title_item, this);
            this.f369 = (LinearLayout) getChildAt(getChildCount() - 1);
            this.f375 = (TextView) this.f369.findViewById(R$id.action_bar_title);
            this.f370 = (TextView) this.f369.findViewById(R$id.action_bar_subtitle);
            if (this.f372 != 0) {
                this.f375.setTextAppearance(getContext(), this.f372);
            }
            if (this.f376 != 0) {
                this.f370.setTextAppearance(getContext(), this.f376);
            }
        }
        this.f375.setText(this.f377);
        this.f370.setText(this.f373);
        boolean z = !TextUtils.isEmpty(this.f377);
        boolean z2 = !TextUtils.isEmpty(this.f373);
        int i = 0;
        this.f370.setVisibility(z2 ? 0 : 8);
        LinearLayout linearLayout = this.f369;
        if (!z && !z2) {
            i = 8;
        }
        linearLayout.setVisibility(i);
        if (this.f369.getParent() == null) {
            addView(this.f369);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m227(AbstractC1890 r7) {
        View view = this.f374;
        if (view == null) {
            this.f374 = LayoutInflater.from(getContext()).inflate(this.f378, (ViewGroup) this, false);
            addView(this.f374);
        } else if (view.getParent() == null) {
            addView(this.f374);
        }
        this.f374.findViewById(R$id.action_mode_close_button).setOnClickListener(new View$OnClickListenerC0054(this, r7));
        C1912 r72 = (C1912) r7.m4895();
        ActionMenuPresenter actionMenuPresenter = this.f6864;
        if (actionMenuPresenter != null) {
            actionMenuPresenter.m253();
        }
        this.f6864 = new ActionMenuPresenter(getContext());
        ActionMenuPresenter actionMenuPresenter2 = this.f6864;
        actionMenuPresenter2.f416 = true;
        actionMenuPresenter2.f428 = true;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        r72.addMenuPresenter(this.f6864, this.f6863);
        ActionMenuPresenter actionMenuPresenter3 = this.f6864;
        AbstractC1917 r3 = actionMenuPresenter3.f6464;
        if (r3 == null) {
            actionMenuPresenter3.f6464 = (AbstractC1917) actionMenuPresenter3.f6463.inflate(actionMenuPresenter3.f6466, (ViewGroup) this, false);
            actionMenuPresenter3.f6464.initialize(actionMenuPresenter3.f6469);
            actionMenuPresenter3.updateMenuView(true);
        }
        AbstractC1917 r1 = actionMenuPresenter3.f6464;
        if (r3 != r1) {
            ((ActionMenuView) r1).setPresenter(actionMenuPresenter3);
        }
        this.f6869 = (ActionMenuView) r1;
        C1729.m4478(this.f6869, (Drawable) null);
        addView(this.f6869, layoutParams);
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m228() {
        removeAllViews();
        this.f379 = null;
        this.f6869 = null;
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.actionModeStyle);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        Drawable drawable;
        int resourceId;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.ActionMode, i, 0);
        int i2 = R$styleable.ActionMode_background;
        if (!obtainStyledAttributes.hasValue(i2) || (resourceId = obtainStyledAttributes.getResourceId(i2, 0)) == 0) {
            drawable = obtainStyledAttributes.getDrawable(i2);
        } else {
            drawable = C1940.m5017(context, resourceId);
        }
        C1729.m4478(this, drawable);
        this.f372 = obtainStyledAttributes.getResourceId(R$styleable.ActionMode_titleTextStyle, 0);
        this.f376 = obtainStyledAttributes.getResourceId(R$styleable.ActionMode_subtitleTextStyle, 0);
        this.f6868 = obtainStyledAttributes.getLayoutDimension(R$styleable.ActionMode_height, 0);
        this.f378 = obtainStyledAttributes.getResourceId(R$styleable.ActionMode_closeItemLayout, R$layout.abc_action_mode_close_item_material);
        obtainStyledAttributes.recycle();
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m226() {
        if (this.f374 == null) {
            m228();
        }
    }
}
