package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.R$id;
import androidx.appcompat.R$styleable;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.㴹.C2025;

public class ActionBarContainer extends FrameLayout {

    /* renamed from: ʬ  reason: contains not printable characters */
    public View f359;

    /* renamed from: ඓ  reason: contains not printable characters */
    public View f360;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f361;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f362;

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean f363;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public Drawable f364;

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean f365;

    /* renamed from: 㴹  reason: contains not printable characters */
    public Drawable f366;

    /* renamed from: 㸾  reason: contains not printable characters */
    public View f367;

    /* renamed from: 㿎  reason: contains not printable characters */
    public Drawable f368;

    public ActionBarContainer(Context context) {
        this(context, null);
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.f366;
        if (drawable != null && drawable.isStateful()) {
            this.f366.setState(getDrawableState());
        }
        Drawable drawable2 = this.f364;
        if (drawable2 != null && drawable2.isStateful()) {
            this.f364.setState(getDrawableState());
        }
        Drawable drawable3 = this.f368;
        if (drawable3 != null && drawable3.isStateful()) {
            this.f368.setState(getDrawableState());
        }
    }

    public View getTabContainer() {
        return this.f359;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        Drawable drawable = this.f366;
        if (drawable != null) {
            drawable.jumpToCurrentState();
        }
        Drawable drawable2 = this.f364;
        if (drawable2 != null) {
            drawable2.jumpToCurrentState();
        }
        Drawable drawable3 = this.f368;
        if (drawable3 != null) {
            drawable3.jumpToCurrentState();
        }
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.f367 = findViewById(R$id.action_bar);
        this.f360 = findViewById(R$id.action_context_bar);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        super.onHoverEvent(motionEvent);
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.f363 || super.onInterceptTouchEvent(motionEvent);
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        Drawable drawable;
        super.onLayout(z, i, i2, i3, i4);
        View view = this.f359;
        boolean z2 = true;
        boolean z3 = false;
        boolean z4 = (view == null || view.getVisibility() == 8) ? false : true;
        if (!(view == null || view.getVisibility() == 8)) {
            int measuredHeight = getMeasuredHeight();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) view.getLayoutParams();
            view.layout(i, (measuredHeight - view.getMeasuredHeight()) - layoutParams.bottomMargin, i3, measuredHeight - layoutParams.bottomMargin);
        }
        if (this.f362) {
            Drawable drawable2 = this.f368;
            if (drawable2 != null) {
                drawable2.setBounds(0, 0, getMeasuredWidth(), getMeasuredHeight());
            } else {
                z2 = false;
            }
        } else {
            if (this.f366 != null) {
                if (this.f367.getVisibility() == 0) {
                    this.f366.setBounds(this.f367.getLeft(), this.f367.getTop(), this.f367.getRight(), this.f367.getBottom());
                } else {
                    View view2 = this.f360;
                    if (view2 == null || view2.getVisibility() != 0) {
                        this.f366.setBounds(0, 0, 0, 0);
                    } else {
                        this.f366.setBounds(this.f360.getLeft(), this.f360.getTop(), this.f360.getRight(), this.f360.getBottom());
                    }
                }
                z3 = true;
            }
            this.f365 = z4;
            if (!z4 || (drawable = this.f364) == null) {
                z2 = z3;
            } else {
                drawable.setBounds(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            }
        }
        if (z2) {
            invalidate();
        }
    }

    public void onMeasure(int i, int i2) {
        int i3;
        int i4;
        if (this.f367 == null && View.MeasureSpec.getMode(i2) == Integer.MIN_VALUE && (i4 = this.f361) >= 0) {
            i2 = View.MeasureSpec.makeMeasureSpec(Math.min(i4, View.MeasureSpec.getSize(i2)), Integer.MIN_VALUE);
        }
        super.onMeasure(i, i2);
        if (this.f367 != null) {
            int mode = View.MeasureSpec.getMode(i2);
            View view = this.f359;
            if (view != null && view.getVisibility() != 8 && mode != 1073741824) {
                if (!m221(this.f367)) {
                    i3 = m222(this.f367);
                } else {
                    i3 = !m221(this.f360) ? m222(this.f360) : 0;
                }
                setMeasuredDimension(getMeasuredWidth(), Math.min(m222(this.f359) + i3, mode == Integer.MIN_VALUE ? View.MeasureSpec.getSize(i2) : Integer.MAX_VALUE));
            }
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return true;
    }

    public void setPrimaryBackground(Drawable drawable) {
        Drawable drawable2 = this.f366;
        if (drawable2 != null) {
            drawable2.setCallback(null);
            unscheduleDrawable(this.f366);
        }
        this.f366 = drawable;
        if (drawable != null) {
            drawable.setCallback(this);
            View view = this.f367;
            if (view != null) {
                this.f366.setBounds(view.getLeft(), this.f367.getTop(), this.f367.getRight(), this.f367.getBottom());
            }
        }
        boolean z = true;
        if (!this.f362 ? !(this.f366 == null && this.f364 == null) : this.f368 != null) {
            z = false;
        }
        setWillNotDraw(z);
        invalidate();
        int i = Build.VERSION.SDK_INT;
        invalidateOutline();
    }

    public void setSplitBackground(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.f368;
        if (drawable3 != null) {
            drawable3.setCallback(null);
            unscheduleDrawable(this.f368);
        }
        this.f368 = drawable;
        boolean z = false;
        if (drawable != null) {
            drawable.setCallback(this);
            if (this.f362 && (drawable2 = this.f368) != null) {
                drawable2.setBounds(0, 0, getMeasuredWidth(), getMeasuredHeight());
            }
        }
        if (!this.f362 ? this.f366 == null && this.f364 == null : this.f368 == null) {
            z = true;
        }
        setWillNotDraw(z);
        invalidate();
        int i = Build.VERSION.SDK_INT;
        invalidateOutline();
    }

    public void setStackedBackground(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.f364;
        if (drawable3 != null) {
            drawable3.setCallback(null);
            unscheduleDrawable(this.f364);
        }
        this.f364 = drawable;
        if (drawable != null) {
            drawable.setCallback(this);
            if (this.f365 && (drawable2 = this.f364) != null) {
                drawable2.setBounds(this.f359.getLeft(), this.f359.getTop(), this.f359.getRight(), this.f359.getBottom());
            }
        }
        boolean z = true;
        if (!this.f362 ? !(this.f366 == null && this.f364 == null) : this.f368 != null) {
            z = false;
        }
        setWillNotDraw(z);
        invalidate();
        int i = Build.VERSION.SDK_INT;
        invalidateOutline();
    }

    public void setTabContainer(ScrollingTabContainerView scrollingTabContainerView) {
        View view = this.f359;
        if (view != null) {
            removeView(view);
        }
        this.f359 = scrollingTabContainerView;
        if (scrollingTabContainerView != null) {
            addView(scrollingTabContainerView);
            ViewGroup.LayoutParams layoutParams = scrollingTabContainerView.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -2;
            scrollingTabContainerView.setAllowCollapse(false);
        }
    }

    public void setTransitioning(boolean z) {
        this.f363 = z;
        setDescendantFocusability(z ? 393216 : 262144);
    }

    public void setVisibility(int i) {
        super.setVisibility(i);
        boolean z = i == 0;
        Drawable drawable = this.f366;
        if (drawable != null) {
            drawable.setVisible(z, false);
        }
        Drawable drawable2 = this.f364;
        if (drawable2 != null) {
            drawable2.setVisible(z, false);
        }
        Drawable drawable3 = this.f368;
        if (drawable3 != null) {
            drawable3.setVisible(z, false);
        }
    }

    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return null;
    }

    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback, int i) {
        if (i != 0) {
            return super.startActionModeForChild(view, callback, i);
        }
        return null;
    }

    public boolean verifyDrawable(Drawable drawable) {
        return (drawable == this.f366 && !this.f362) || (drawable == this.f364 && this.f365) || ((drawable == this.f368 && this.f362) || super.verifyDrawable(drawable));
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final boolean m221(View view) {
        return view == null || view.getVisibility() == 8 || view.getMeasuredHeight() == 0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m222(View view) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) view.getLayoutParams();
        return view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
    }

    public ActionBarContainer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        C1729.m4478(this, new C2025(this));
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.ActionBar);
        this.f366 = obtainStyledAttributes.getDrawable(R$styleable.ActionBar_background);
        this.f364 = obtainStyledAttributes.getDrawable(R$styleable.ActionBar_backgroundStacked);
        this.f361 = obtainStyledAttributes.getDimensionPixelSize(R$styleable.ActionBar_height, -1);
        if (getId() == R$id.split_action_bar) {
            this.f362 = true;
            this.f368 = obtainStyledAttributes.getDrawable(R$styleable.ActionBar_backgroundSplit);
        }
        obtainStyledAttributes.recycle();
        boolean z = false;
        if (!this.f362 ? this.f366 == null && this.f364 == null : this.f368 == null) {
            z = true;
        }
        setWillNotDraw(z);
    }
}
