package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$id;
import androidx.appcompat.R$layout;
import androidx.appcompat.R$string;
import androidx.appcompat.R$styleable;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.internal.NativeProtocol;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.ඓ.㳳.AbstractC1917;
import ῲ.ῲ.ඓ.㳳.C1922;
import ῲ.ῲ.㴹.C2019;

public class ListMenuItemView extends LinearLayout implements AbstractC1917.AbstractC1918, AbsListView.SelectionBoundsAdjuster {

    /* renamed from: ʬ  reason: contains not printable characters */
    public ImageView f342;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f343;

    /* renamed from: ؿ  reason: contains not printable characters */
    public boolean f344;

    /* renamed from: ඓ  reason: contains not printable characters */
    public TextView f345;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public LayoutInflater f346;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public Drawable f347;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public ImageView f348;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C1922 f349;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public TextView f350;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f351;

    /* renamed from: 㗗  reason: contains not printable characters */
    public Drawable f352;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f353;

    /* renamed from: 㳳  reason: contains not printable characters */
    public LinearLayout f354;

    /* renamed from: 㴹  reason: contains not printable characters */
    public CheckBox f355;

    /* renamed from: 㸾  reason: contains not printable characters */
    public RadioButton f356;

    /* renamed from: 㿎  reason: contains not printable characters */
    public ImageView f357;

    /* renamed from: 䁗  reason: contains not printable characters */
    public Context f358;

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.listMenuViewStyle);
    }

    private LayoutInflater getInflater() {
        if (this.f346 == null) {
            this.f346 = LayoutInflater.from(getContext());
        }
        return this.f346;
    }

    private void setSubMenuArrowVisible(boolean z) {
        ImageView imageView = this.f357;
        if (imageView != null) {
            imageView.setVisibility(z ? 0 : 8);
        }
    }

    public void adjustListItemSelectionBounds(Rect rect) {
        ImageView imageView = this.f348;
        if (imageView != null && imageView.getVisibility() == 0) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) this.f348.getLayoutParams();
            rect.top = this.f348.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin + rect.top;
        }
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public C1922 getItemData() {
        return this.f349;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public void initialize(C1922 r1, int i) {
        CharSequence charSequence;
        this.f349 = r1;
        setVisibility(r1.isVisible() ? 0 : 8);
        if (prefersCondensedTitle()) {
            charSequence = r1.getTitleCondensed();
        } else {
            charSequence = r1.f6519;
        }
        setTitle(charSequence);
        setCheckable(r1.isCheckable());
        boolean r2 = r1.m4972();
        r1.m4966();
        m220(r2);
        setIcon(r1.getIcon());
        setEnabled(r1.isEnabled());
        setSubMenuArrowVisible(r1.hasSubMenu());
        setContentDescription(r1.f6534);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        C1729.m4478(this, this.f347);
        this.f345 = (TextView) findViewById(R$id.title);
        int i = this.f351;
        if (i != -1) {
            this.f345.setTextAppearance(this.f358, i);
        }
        this.f350 = (TextView) findViewById(R$id.shortcut);
        this.f357 = (ImageView) findViewById(R$id.submenuarrow);
        ImageView imageView = this.f357;
        if (imageView != null) {
            imageView.setImageDrawable(this.f352);
        }
        this.f348 = (ImageView) findViewById(R$id.group_divider);
        this.f354 = (LinearLayout) findViewById(R$id.content);
    }

    public void onMeasure(int i, int i2) {
        if (this.f342 != null && this.f343) {
            ViewGroup.LayoutParams layoutParams = getLayoutParams();
            LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) this.f342.getLayoutParams();
            if (layoutParams.height > 0 && layoutParams2.width <= 0) {
                layoutParams2.width = layoutParams.height;
            }
        }
        super.onMeasure(i, i2);
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public boolean prefersCondensedTitle() {
        return false;
    }

    public void setCheckable(boolean z) {
        CompoundButton compoundButton;
        CompoundButton compoundButton2;
        if (z || this.f356 != null || this.f355 != null) {
            if (this.f349.m4965()) {
                if (this.f356 == null) {
                    m216();
                }
                compoundButton2 = this.f356;
                compoundButton = this.f355;
            } else {
                if (this.f355 == null) {
                    m217();
                }
                compoundButton2 = this.f355;
                compoundButton = this.f356;
            }
            if (z) {
                compoundButton2.setChecked(this.f349.isChecked());
                if (compoundButton2.getVisibility() != 0) {
                    compoundButton2.setVisibility(0);
                }
                if (compoundButton != null && compoundButton.getVisibility() != 8) {
                    compoundButton.setVisibility(8);
                    return;
                }
                return;
            }
            CheckBox checkBox = this.f355;
            if (checkBox != null) {
                checkBox.setVisibility(8);
            }
            RadioButton radioButton = this.f356;
            if (radioButton != null) {
                radioButton.setVisibility(8);
            }
        }
    }

    public void setChecked(boolean z) {
        CompoundButton compoundButton;
        if (this.f349.m4965()) {
            if (this.f356 == null) {
                m216();
            }
            compoundButton = this.f356;
        } else {
            if (this.f355 == null) {
                m217();
            }
            compoundButton = this.f355;
        }
        compoundButton.setChecked(z);
    }

    public void setForceShowIcon(boolean z) {
        this.f353 = z;
        this.f343 = z;
    }

    public void setGroupDividerEnabled(boolean z) {
        ImageView imageView = this.f348;
        if (imageView != null) {
            imageView.setVisibility((this.f344 || !z) ? 8 : 0);
        }
    }

    public void setIcon(Drawable drawable) {
        boolean z = this.f349.f6515.getOptionalIconsVisible() || this.f353;
        if (!z && !this.f343) {
            return;
        }
        if (this.f342 != null || drawable != null || this.f343) {
            if (this.f342 == null) {
                this.f342 = (ImageView) getInflater().inflate(R$layout.abc_list_menu_item_icon, (ViewGroup) this, false);
                m219(this.f342, 0);
            }
            if (drawable != null || this.f343) {
                ImageView imageView = this.f342;
                if (!z) {
                    drawable = null;
                }
                imageView.setImageDrawable(drawable);
                if (this.f342.getVisibility() != 0) {
                    this.f342.setVisibility(0);
                    return;
                }
                return;
            }
            this.f342.setVisibility(8);
        }
    }

    public void setTitle(CharSequence charSequence) {
        if (charSequence != null) {
            this.f345.setText(charSequence);
            if (this.f345.getVisibility() != 0) {
                this.f345.setVisibility(0);
            }
        } else if (this.f345.getVisibility() != 8) {
            this.f345.setVisibility(8);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m216() {
        this.f356 = (RadioButton) getInflater().inflate(R$layout.abc_list_menu_item_radio, (ViewGroup) this, false);
        m218(this.f356);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m218(View view) {
        LinearLayout linearLayout = this.f354;
        if (linearLayout != null) {
            linearLayout.addView(view, -1);
        } else {
            addView(view, -1);
        }
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet);
        C2019 r5 = C2019.m5223(getContext(), attributeSet, R$styleable.MenuView, i, 0);
        this.f347 = r5.m5229(R$styleable.MenuView_android_itemBackground);
        this.f351 = r5.m5230(R$styleable.MenuView_android_itemTextAppearance, -1);
        this.f343 = r5.m5235(R$styleable.MenuView_preserveIconSpacing, false);
        this.f358 = context;
        this.f352 = r5.m5229(R$styleable.MenuView_subMenuArrow);
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(null, new int[]{16843049}, R$attr.dropDownListViewStyle, 0);
        this.f344 = obtainStyledAttributes.hasValue(0);
        r5.f6846.recycle();
        obtainStyledAttributes.recycle();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m219(View view, int i) {
        LinearLayout linearLayout = this.f354;
        if (linearLayout != null) {
            linearLayout.addView(view, i);
        } else {
            addView(view, i);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m220(boolean z) {
        String str;
        int i = (!z || !this.f349.m4972()) ? 8 : 0;
        if (i == 0) {
            TextView textView = this.f350;
            C1922 r2 = this.f349;
            char r3 = r2.m4966();
            if (r3 == 0) {
                str = "";
            } else {
                Resources resources = r2.f6515.getContext().getResources();
                StringBuilder sb = new StringBuilder();
                if (ViewConfiguration.get(r2.f6515.getContext()).hasPermanentMenuKey()) {
                    sb.append(resources.getString(R$string.abc_prepend_shortcut_label));
                }
                int i2 = r2.f6515.isQwertyMode() ? r2.f6524 : r2.f6526;
                C1922.m4962(sb, i2, NativeProtocol.MESSAGE_GET_ACCESS_TOKEN_REQUEST, resources.getString(R$string.abc_menu_meta_shortcut_label));
                C1922.m4962(sb, i2, RecyclerView.AbstractC0269.FLAG_APPEARED_IN_PRE_LAYOUT, resources.getString(R$string.abc_menu_ctrl_shortcut_label));
                C1922.m4962(sb, i2, 2, resources.getString(R$string.abc_menu_alt_shortcut_label));
                C1922.m4962(sb, i2, 1, resources.getString(R$string.abc_menu_shift_shortcut_label));
                C1922.m4962(sb, i2, 4, resources.getString(R$string.abc_menu_sym_shortcut_label));
                C1922.m4962(sb, i2, 8, resources.getString(R$string.abc_menu_function_shortcut_label));
                if (r3 == '\b') {
                    sb.append(resources.getString(R$string.abc_menu_delete_shortcut_label));
                } else if (r3 == '\n') {
                    sb.append(resources.getString(R$string.abc_menu_enter_shortcut_label));
                } else if (r3 != ' ') {
                    sb.append(r3);
                } else {
                    sb.append(resources.getString(R$string.abc_menu_space_shortcut_label));
                }
                str = sb.toString();
            }
            textView.setText(str);
        }
        if (this.f350.getVisibility() != i) {
            this.f350.setVisibility(i);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m217() {
        this.f355 = (CheckBox) getInflater().inflate(R$layout.abc_list_menu_item_checkbox, (ViewGroup) this, false);
        m218(this.f355);
    }
}
