package androidx.appcompat.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.location.LocationManager;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$color;
import androidx.appcompat.R$id;
import androidx.appcompat.R$layout;
import androidx.appcompat.R$style;
import androidx.appcompat.R$styleable;
import androidx.appcompat.view.menu.ExpandedMenuView;
import androidx.appcompat.widget.ActionBarContextView;
import androidx.appcompat.widget.ContentFrameLayout;
import androidx.appcompat.widget.ViewStubCompat;
import androidx.lifecycle.Lifecycle;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.places.internal.LocationPackageRequestParams;
import com.facebook.places.model.PlaceFields;
import java.lang.Thread;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import ඓ.K.K.K.C1293;
import ῲ.ؿ.AbstractC1574;
import ῲ.ؿ.C1584;
import ῲ.ᨨ.ᨨ.AbstractC1738;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1749;
import ῲ.ᨨ.ᨨ.C1754;
import ῲ.ᨨ.ᨨ.C1768;
import ῲ.ᨨ.ᨨ.C1773;
import ῲ.ᨨ.ῲ.C1806;
import ῲ.ᨨ.K.C1826;
import ῲ.ῲ.ඓ.AbstractC1890;
import ῲ.ῲ.ඓ.C1888;
import ῲ.ῲ.ඓ.C1935;
import ῲ.ῲ.ඓ.C1937;
import ῲ.ῲ.ඓ.Window$CallbackC1889;
import ῲ.ῲ.ඓ.㳳.AbstractC1897;
import ῲ.ῲ.ඓ.㳳.C1901;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.K.AbstractC1963;
import ῲ.ῲ.K.AbstractC1967;
import ῲ.ῲ.K.AbstractC1983;
import ῲ.ῲ.K.C1943;
import ῲ.ῲ.K.C1944;
import ῲ.ῲ.K.C1946;
import ῲ.ῲ.K.C1950;
import ῲ.ῲ.K.C1955;
import ῲ.ῲ.K.C1969;
import ῲ.ῲ.K.C1971;
import ῲ.ῲ.K.C1974;
import ῲ.ῲ.K.DialogC1947;
import ῲ.ῲ.K.RunnableC1956;
import ῲ.ῲ.㴹.AbstractC2034;
import ῲ.ῲ.㴹.C2019;
import ῲ.ῲ.㴹.C2033;
import ῲ.ῲ.㴹.C2044;
import ῲ.ῲ.㴹.C2049;
import ῲ.㴹.C2288;
import K.K.K.ʬ.C2369;

public class AppCompatDelegateImpl extends AbstractC1983 implements C1912.AbstractC1914, LayoutInflater.Factory2 {

    /* renamed from: ݰ  reason: contains not printable characters */
    public static final boolean f234 = true;

    /* renamed from: ᔝ  reason: contains not printable characters */
    public static final boolean f235 = false;

    /* renamed from: ₱  reason: contains not printable characters */
    public static final boolean f236 = (!"robolectric".equals(Build.FINGERPRINT));

    /* renamed from: を  reason: contains not printable characters */
    public static boolean f237 = true;

    /* renamed from: 㗼  reason: contains not printable characters */
    public static final int[] f238 = {16842836};

    /* renamed from: 㵟  reason: contains not printable characters */
    public static final C2288<String, Integer> f239 = new C2288<>();

    /* renamed from: Ϸ  reason: contains not printable characters */
    public boolean f240;

    /* renamed from: В  reason: contains not printable characters */
    public boolean f241;

    /* renamed from: ѷ  reason: contains not printable characters */
    public boolean f242;

    /* renamed from: ӯ  reason: contains not printable characters */
    public C1944 f243;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public C0047 f244;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public boolean f245;

    /* renamed from: ؿ  reason: contains not printable characters */
    public ActionBarContextView f246;

    /* renamed from: ݜ  reason: contains not printable characters */
    public C1768 f247 = null;

    /* renamed from: ࠋ  reason: contains not printable characters */
    public AbstractC0044 f248;

    /* renamed from: ಯ  reason: contains not printable characters */
    public boolean f249;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final Context f250;

    /* renamed from: ผ  reason: contains not printable characters */
    public AbstractC0044 f251;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public boolean f252;

    /* renamed from: ሽ  reason: contains not printable characters */
    public PanelFeatureState[] f253;

    /* renamed from: ጒ  reason: contains not printable characters */
    public boolean f254;

    /* renamed from: Ꮝ  reason: contains not printable characters */
    public Rect f255;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public boolean f256;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public PanelFeatureState f257;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public TextView f258;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public PopupWindow f259;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public CharSequence f260;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public boolean f261;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public AbstractC1963 f262;

    /* renamed from: ᴊ  reason: contains not printable characters */
    public Rect f263;

    /* renamed from: ᶲ  reason: contains not printable characters */
    public boolean f264;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public C0041 f265;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public boolean f266;

    /* renamed from: ゎ  reason: contains not printable characters */
    public boolean f267;

    /* renamed from: ト  reason: contains not printable characters */
    public boolean f268;

    /* renamed from: ピ  reason: contains not printable characters */
    public int f269;

    /* renamed from: 㑃  reason: contains not printable characters */
    public AbstractC2034 f270;

    /* renamed from: 㒁  reason: contains not printable characters */
    public int f271 = -100;

    /* renamed from: 㓚  reason: contains not printable characters */
    public final Runnable f272 = new RunnableC0043();

    /* renamed from: 㗗  reason: contains not printable characters */
    public AbstractC1890 f273;

    /* renamed from: 㗽  reason: contains not printable characters */
    public Runnable f274;

    /* renamed from: 㮔  reason: contains not printable characters */
    public boolean f275;

    /* renamed from: 㮝  reason: contains not printable characters */
    public boolean f276;

    /* renamed from: 㱶  reason: contains not printable characters */
    public boolean f277;

    /* renamed from: 㳳  reason: contains not printable characters */
    public MenuInflater f278;

    /* renamed from: 㴪  reason: contains not printable characters */
    public View f279;

    /* renamed from: 㴹  reason: contains not printable characters */
    public Window f280;

    /* renamed from: 㶋  reason: contains not printable characters */
    public ViewGroup f281;

    /* renamed from: 㷛  reason: contains not printable characters */
    public int f282;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final Object f283;

    /* renamed from: 㹎  reason: contains not printable characters */
    public boolean f284;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final AbstractC1967 f285;

    /* renamed from: 䀟  reason: contains not printable characters */
    public boolean f286 = true;

    /* renamed from: 䁗  reason: contains not printable characters */
    public C0040 f287;

    /* renamed from: 䃖  reason: contains not printable characters */
    public boolean f288;

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$ʬ  reason: contains not printable characters */
    public final class C0040 implements AbstractC1897.AbstractC1898 {
        public C0040() {
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        public void onCloseMenu(C1912 r1, boolean z) {
            AppCompatDelegateImpl.this.m173(r1);
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        /* renamed from: K  reason: contains not printable characters */
        public boolean m189(C1912 r3) {
            Window.Callback r0 = AppCompatDelegateImpl.this.m149();
            if (r0 == null) {
                return true;
            }
            r0.onMenuOpened(108, r3);
            return true;
        }
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$ᨨ  reason: contains not printable characters */
    public class C0042 extends ContentFrameLayout {
        public C0042(Context context) {
            super(context);
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return AppCompatDelegateImpl.this.m175(keyEvent) || super.dispatchKeyEvent(keyEvent);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0) {
                int x = (int) motionEvent.getX();
                int y = (int) motionEvent.getY();
                if (x < -5 || y < -5 || x > getWidth() + 5 || y > getHeight() + 5) {
                    AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
                    appCompatDelegateImpl.m171(appCompatDelegateImpl.m182(0), true);
                    return true;
                }
            }
            return super.onInterceptTouchEvent(motionEvent);
        }

        public void setBackgroundResource(int i) {
            setBackgroundDrawable(C1940.m5017(getContext(), i));
        }
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$ῲ  reason: contains not printable characters */
    public class RunnableC0043 implements Runnable {
        public RunnableC0043() {
        }

        public void run() {
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if ((appCompatDelegateImpl.f269 & 1) != 0) {
                appCompatDelegateImpl.m145(0);
            }
            AppCompatDelegateImpl appCompatDelegateImpl2 = AppCompatDelegateImpl.this;
            if ((appCompatDelegateImpl2.f269 & RecyclerView.AbstractC0269.FLAG_APPEARED_IN_PRE_LAYOUT) != 0) {
                appCompatDelegateImpl2.m145(108);
            }
            AppCompatDelegateImpl appCompatDelegateImpl3 = AppCompatDelegateImpl.this;
            appCompatDelegateImpl3.f277 = false;
            appCompatDelegateImpl3.f269 = 0;
        }
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$ⁱ  reason: contains not printable characters */
    public abstract class AbstractC0044 {

        /* renamed from: K  reason: contains not printable characters */
        public BroadcastReceiver f316;

        /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$ⁱ$K  reason: contains not printable characters */
        public class C0045 extends BroadcastReceiver {
            public C0045() {
            }

            public void onReceive(Context context, Intent intent) {
                AbstractC0044.this.m195();
            }
        }

        public AbstractC0044() {
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public abstract int m191();

        /* renamed from: ඓ  reason: contains not printable characters */
        public void m192() {
            m194();
            IntentFilter r0 = m193();
            if (r0 != null && r0.countActions() != 0) {
                if (this.f316 == null) {
                    this.f316 = new C0045();
                }
                AppCompatDelegateImpl.this.f250.registerReceiver(this.f316, r0);
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public abstract IntentFilter m193();

        /* renamed from: K  reason: contains not printable characters */
        public void m194() {
            BroadcastReceiver broadcastReceiver = this.f316;
            if (broadcastReceiver != null) {
                try {
                    AppCompatDelegateImpl.this.f250.unregisterReceiver(broadcastReceiver);
                } catch (IllegalArgumentException unused) {
                }
                this.f316 = null;
            }
        }

        /* renamed from: 㸾  reason: contains not printable characters */
        public abstract void m195();
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$K  reason: contains not printable characters */
    public class C0046 implements Thread.UncaughtExceptionHandler {

        /* renamed from: K  reason: contains not printable characters */
        public final /* synthetic */ Thread.UncaughtExceptionHandler f318;

        public C0046(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.f318 = uncaughtExceptionHandler;
        }

        public void uncaughtException(Thread thread, Throwable th) {
            String message;
            boolean z = false;
            if ((th instanceof Resources.NotFoundException) && (message = th.getMessage()) != null && (message.contains("drawable") || message.contains("Drawable"))) {
                z = true;
            }
            if (z) {
                Resources.NotFoundException notFoundException = new Resources.NotFoundException(th.getMessage() + ". If the resource you are trying to use is a vector resource, you may be referencing it in an unsupported way. See AppCompatDelegate.setCompatVectorFromResourcesEnabled() for more info.");
                notFoundException.initCause(th.getCause());
                notFoundException.setStackTrace(th.getStackTrace());
                this.f318.uncaughtException(thread, notFoundException);
                return;
            }
            this.f318.uncaughtException(thread, th);
        }
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$㳳  reason: contains not printable characters */
    public final class C0047 implements AbstractC1897.AbstractC1898 {
        public C0047() {
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        public void onCloseMenu(C1912 r5, boolean z) {
            C1912 rootMenu = r5.getRootMenu();
            boolean z2 = rootMenu != r5;
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if (z2) {
                r5 = rootMenu;
            }
            PanelFeatureState r52 = appCompatDelegateImpl.m161((Menu) r5);
            if (r52 == null) {
                return;
            }
            if (z2) {
                AppCompatDelegateImpl.this.m165(r52.f299, r52, rootMenu);
                AppCompatDelegateImpl.this.m171(r52, true);
                return;
            }
            AppCompatDelegateImpl.this.m171(r52, z);
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897.AbstractC1898
        /* renamed from: K  reason: contains not printable characters */
        public boolean m196(C1912 r3) {
            Window.Callback r0;
            if (r3 != r3.getRootMenu()) {
                return true;
            }
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if (!appCompatDelegateImpl.f268 || (r0 = appCompatDelegateImpl.m149()) == null || AppCompatDelegateImpl.this.f284) {
                return true;
            }
            r0.onMenuOpened(108, r3);
            return true;
        }
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$㴹  reason: contains not printable characters */
    public class C0048 extends AbstractC0044 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final PowerManager f320;

        public C0048(Context context) {
            super();
            this.f320 = (PowerManager) context.getApplicationContext().getSystemService("power");
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.AbstractC0044
        /* renamed from: ʬ  reason: contains not printable characters */
        public int m197() {
            int i = Build.VERSION.SDK_INT;
            return this.f320.isPowerSaveMode() ? 2 : 1;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.AbstractC0044
        /* renamed from: ῲ  reason: contains not printable characters */
        public IntentFilter m198() {
            int i = Build.VERSION.SDK_INT;
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
            return intentFilter;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.AbstractC0044
        /* renamed from: 㸾  reason: contains not printable characters */
        public void m199() {
            AppCompatDelegateImpl.this.m183();
        }
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$㿎  reason: contains not printable characters */
    public class C0051 extends AbstractC0044 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final C1971 f325;

        public C0051(C1971 r2) {
            super();
            this.f325 = r2;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.AbstractC0044
        /* renamed from: ʬ  reason: contains not printable characters */
        public int m205() {
            boolean z;
            long j;
            C1971 r1 = this.f325;
            C1971.C1972 k = r1.f6698;
            boolean z2 = false;
            if (k.f6705 > System.currentTimeMillis()) {
                z = k.f6704;
            } else {
                Location location = null;
                Location r3 = C2369.m6296(r1.f6700, "android.permission.ACCESS_COARSE_LOCATION") == 0 ? r1.m5098("network") : null;
                if (C2369.m6296(r1.f6700, "android.permission.ACCESS_FINE_LOCATION") == 0) {
                    location = r1.m5098("gps");
                }
                if (location == null || r3 == null ? location != null : location.getTime() > r3.getTime()) {
                    r3 = location;
                }
                if (r3 != null) {
                    C1971.C1972 k2 = r1.f6698;
                    long currentTimeMillis = System.currentTimeMillis();
                    if (C1955.f6680 == null) {
                        C1955.f6680 = new C1955();
                    }
                    C1955 r6 = C1955.f6680;
                    r6.m5069(currentTimeMillis - 86400000, r3.getLatitude(), r3.getLongitude());
                    long j2 = r6.f6683;
                    r6.m5069(currentTimeMillis, r3.getLatitude(), r3.getLongitude());
                    if (r6.f6681 == 1) {
                        z2 = true;
                    }
                    long j3 = r6.f6682;
                    long j4 = r6.f6683;
                    r6.m5069(currentTimeMillis + 86400000, r3.getLatitude(), r3.getLongitude());
                    long j5 = r6.f6682;
                    if (j3 == -1 || j4 == -1) {
                        j = 43200000;
                    } else {
                        currentTimeMillis = currentTimeMillis > j4 ? j5 + 0 : currentTimeMillis > j3 ? j4 + 0 : j3 + 0;
                        j = LocationPackageRequestParams.DEFAULT_LAST_LOCATION_MAX_AGE_MS;
                    }
                    k2.f6704 = z2;
                    k2.f6703 = j2;
                    k2.f6701 = j3;
                    k2.f6706 = j4;
                    k2.f6702 = j5;
                    k2.f6705 = currentTimeMillis + j;
                    z = k.f6704;
                } else {
                    Log.i("TwilightManager", "Could not get last known location. This is probably because the app does not have any location permissions. Falling back to hardcoded sunrise/sunset values.");
                    int i = Calendar.getInstance().get(11);
                    z = i < 6 || i >= 22;
                }
            }
            return z ? 2 : 1;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.AbstractC0044
        /* renamed from: ῲ  reason: contains not printable characters */
        public IntentFilter m206() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            intentFilter.addAction("android.intent.action.TIME_TICK");
            return intentFilter;
        }

        @Override // androidx.appcompat.app.AppCompatDelegateImpl.AbstractC0044
        /* renamed from: 㸾  reason: contains not printable characters */
        public void m207() {
            AppCompatDelegateImpl.this.m183();
        }
    }

    static {
        int i = Build.VERSION.SDK_INT;
        int i2 = Build.VERSION.SDK_INT;
        if (f235 && !f237) {
            Thread.setDefaultUncaughtExceptionHandler(new C0046(Thread.getDefaultUncaughtExceptionHandler()));
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:12:0x003a, code lost:
        r4 = null;
     */
    public AppCompatDelegateImpl(Context context, Window window, AbstractC1967 r6, Object obj) {
        Integer orDefault;
        AppCompatActivity appCompatActivity;
        this.f250 = context;
        this.f285 = r6;
        this.f283 = obj;
        if (this.f271 == -100 && (this.f283 instanceof Dialog)) {
            Context context2 = this.f250;
            while (true) {
                if (context2 != null) {
                    if (!(context2 instanceof AppCompatActivity)) {
                        if (!(context2 instanceof ContextWrapper)) {
                            break;
                        }
                        context2 = ((ContextWrapper) context2).getBaseContext();
                    } else {
                        appCompatActivity = (AppCompatActivity) context2;
                        break;
                    }
                } else {
                    break;
                }
            }
            if (appCompatActivity != null) {
                this.f271 = ((AppCompatDelegateImpl) appCompatActivity.m142()).f271;
            }
        }
        if (this.f271 == -100 && (orDefault = f239.getOrDefault(this.f283.getClass().getName(), null)) != null) {
            this.f271 = orDefault.intValue();
            f239.remove(this.f283.getClass().getName());
        }
        if (window != null) {
            m169(window);
        }
        C2044.m5311();
    }

    /* JADX WARNING: Code restructure failed: missing block: B:14:0x0065, code lost:
        if (((org.xmlpull.v1.XmlPullParser) r15).getDepth() > 1) goto L_0x0076;
     */
    public final View onCreateView(View view, String str, Context context, AttributeSet attributeSet) {
        boolean z;
        boolean z2 = false;
        if (this.f243 == null) {
            String string = this.f250.obtainStyledAttributes(R$styleable.AppCompatTheme).getString(R$styleable.AppCompatTheme_viewInflaterClass);
            if (string == null) {
                this.f243 = new C1944();
            } else {
                try {
                    this.f243 = (C1944) Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } catch (Throwable th) {
                    Log.i("AppCompatDelegate", "Failed to instantiate custom view inflater " + string + ". Falling back to default.", th);
                    this.f243 = new C1944();
                }
            }
        }
        if (f235) {
            if (!(attributeSet instanceof XmlPullParser)) {
                ViewParent viewParent = (ViewParent) view;
                if (viewParent != null) {
                    View decorView = this.f280.getDecorView();
                    while (true) {
                        if (viewParent != null) {
                            if (viewParent == decorView || !(viewParent instanceof View) || C1729.m4498((View) viewParent)) {
                                break;
                            }
                            viewParent = viewParent.getParent();
                        } else {
                            break;
                        }
                    }
                }
                z = z2;
            }
            z2 = true;
            z = z2;
        } else {
            z = false;
        }
        C1944 r2 = this.f243;
        boolean z3 = f235;
        C2049.m5337();
        return r2.createView(view, str, context, attributeSet, z, z3, true, false);
    }

    @Override // ῲ.ῲ.ඓ.㳳.C1912.AbstractC1914
    public boolean onMenuItemSelected(C1912 r3, MenuItem menuItem) {
        PanelFeatureState r32;
        Window.Callback r0 = m149();
        if (r0 == null || this.f284 || (r32 = m161((Menu) r3.getRootMenu())) == null) {
            return false;
        }
        return r0.onMenuItemSelected(r32.f299, menuItem);
    }

    @Override // ῲ.ῲ.ඓ.㳳.C1912.AbstractC1914
    public void onMenuModeChange(C1912 r6) {
        AbstractC2034 r62 = this.f270;
        if (r62 == null || !r62.m5270() || (ViewConfiguration.get(this.f250).hasPermanentMenuKey() && !this.f270.m5273())) {
            PanelFeatureState r63 = m182(0);
            r63.f294 = true;
            m171(r63, false);
            m170(r63, (KeyEvent) null);
            return;
        }
        Window.Callback r64 = m149();
        if (this.f270.m5269()) {
            this.f270.m5267();
            if (!this.f284) {
                r64.onPanelClosed(108, m182(0).f303);
            }
        } else if (r64 != null && !this.f284) {
            if (this.f277 && (1 & this.f269) != 0) {
                this.f280.getDecorView().removeCallbacks(this.f272);
                this.f272.run();
            }
            PanelFeatureState r0 = m182(0);
            C1912 r2 = r0.f303;
            if (r2 != null && !r0.f302 && r64.onPreparePanel(0, r0.f296, r2)) {
                r64.onMenuOpened(108, r0.f303);
                this.f270.m5275();
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:16:0x005b  */
    /* JADX WARNING: Removed duplicated region for block: B:19:0x0062  */
    /* JADX WARNING: Removed duplicated region for block: B:22:0x0069  */
    /* JADX WARNING: Removed duplicated region for block: B:24:? A[RETURN, SYNTHETIC] */
    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: ʬ  reason: contains not printable characters */
    public void m144() {
        AbstractC1963 k;
        AbstractC0044 r0;
        AbstractC0044 r02;
        if (this.f283 instanceof Activity) {
            AbstractC1983.m5121(this);
        }
        if (this.f277) {
            this.f280.getDecorView().removeCallbacks(this.f272);
        }
        this.f254 = false;
        this.f284 = true;
        if (this.f271 != -100) {
            Object obj = this.f283;
            if ((obj instanceof Activity) && ((Activity) obj).isChangingConfigurations()) {
                f239.put(this.f283.getClass().getName(), Integer.valueOf(this.f271));
                k = this.f262;
                if (k != null) {
                    k.m5085();
                }
                r0 = this.f248;
                if (r0 != null) {
                    r0.m194();
                }
                r02 = this.f251;
                if (r02 == null) {
                    r02.m194();
                    return;
                }
                return;
            }
        }
        f239.remove(this.f283.getClass().getName());
        k = this.f262;
        if (k != null) {
        }
        r0 = this.f248;
        if (r0 != null) {
        }
        r02 = this.f251;
        if (r02 == null) {
        }
    }

    /* renamed from: Ԕ  reason: contains not printable characters */
    public final void m146() {
        if (this.f245) {
            throw new AndroidRuntimeException("Window feature must be requested before adding content");
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final void m148(int i) {
        this.f269 = (1 << i) | this.f269;
        if (!this.f277) {
            C1729.m4479(this.f280.getDecorView(), this.f272);
            this.f277 = true;
        }
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public final Window.Callback m149() {
        return this.f280.getCallback();
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final Context m150() {
        m178();
        AbstractC1963 k = this.f262;
        Context r0 = k != null ? k.m5089() : null;
        return r0 == null ? this.f250 : r0;
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m151() {
        m178();
        AbstractC1963 k = this.f262;
        if (k == null || !k.m5077()) {
            m148(0);
        }
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m153(Bundle bundle) {
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public void m157(int i) {
        if (i == 108) {
            m178();
            AbstractC1963 k = this.f262;
            if (k != null) {
                k.m5078(false);
            }
        } else if (i == 0) {
            PanelFeatureState r3 = m182(i);
            if (r3.f301) {
                m171(r3, false);
            }
        }
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: K  reason: contains not printable characters */
    public void m166(Bundle bundle) {
        this.f276 = true;
        m177(false);
        m184();
        Object obj = this.f283;
        if (obj instanceof Activity) {
            String str = null;
            try {
                Activity activity = (Activity) obj;
                try {
                    str = C2369.m6283((Context) activity, activity.getComponentName());
                } catch (PackageManager.NameNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            } catch (IllegalArgumentException unused) {
            }
            if (str != null) {
                AbstractC1963 k = this.f262;
                if (k == null) {
                    this.f240 = true;
                } else {
                    k.m5073(true);
                }
            }
            AbstractC1983.m5124(this);
        }
        this.f249 = true;
    }

    /* renamed from: 㑃  reason: contains not printable characters */
    public final void m178() {
        m156();
        if (this.f268 && this.f262 == null) {
            Object obj = this.f283;
            if (obj instanceof Activity) {
                this.f262 = new C1950((Activity) obj, this.f275);
            } else if (obj instanceof Dialog) {
                this.f262 = new C1950((Dialog) obj);
            }
            AbstractC1963 k = this.f262;
            if (k != null) {
                k.m5073(this.f240);
            }
        }
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public final CharSequence m179() {
        Object obj = this.f283;
        if (obj instanceof Activity) {
            return ((Activity) obj).getTitle();
        }
        return this.f260;
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m181(int i) {
        if (i == 108) {
            m178();
            AbstractC1963 k = this.f262;
            if (k != null) {
                k.m5078(true);
            }
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public PanelFeatureState m182(int i) {
        PanelFeatureState[] panelFeatureStateArr = this.f253;
        if (panelFeatureStateArr == null || panelFeatureStateArr.length <= i) {
            PanelFeatureState[] panelFeatureStateArr2 = new PanelFeatureState[(i + 1)];
            if (panelFeatureStateArr != null) {
                System.arraycopy(panelFeatureStateArr, 0, panelFeatureStateArr2, 0, panelFeatureStateArr.length);
            }
            this.f253 = panelFeatureStateArr2;
            panelFeatureStateArr = panelFeatureStateArr2;
        }
        PanelFeatureState panelFeatureState = panelFeatureStateArr[i];
        if (panelFeatureState != null) {
            return panelFeatureState;
        }
        PanelFeatureState panelFeatureState2 = new PanelFeatureState(i);
        panelFeatureStateArr[i] = panelFeatureState2;
        return panelFeatureState2;
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public final void m184() {
        if (this.f280 == null) {
            Object obj = this.f283;
            if (obj instanceof Activity) {
                m169(((Activity) obj).getWindow());
            }
        }
        if (this.f280 == null) {
            throw new IllegalStateException("We have not been given a Window");
        }
    }

    /* renamed from: 䁗  reason: contains not printable characters */
    public final boolean m185() {
        ViewGroup viewGroup;
        return this.f245 && (viewGroup = this.f281) != null && C1729.m4512(viewGroup);
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$㸾  reason: contains not printable characters */
    public class C0049 implements AbstractC1890.AbstractC1891 {

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC1890.AbstractC1891 f323;

        /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$㸾$K  reason: contains not printable characters */
        public class C0050 extends C1749 {
            public C0050() {
            }

            @Override // ῲ.ᨨ.ᨨ.AbstractC1738
            /* renamed from: K  reason: contains not printable characters */
            public void m204(View view) {
                AppCompatDelegateImpl.this.f246.setVisibility(8);
                AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
                PopupWindow popupWindow = appCompatDelegateImpl.f259;
                if (popupWindow != null) {
                    popupWindow.dismiss();
                } else if (appCompatDelegateImpl.f246.getParent() instanceof View) {
                    C1729.m4451((View) AppCompatDelegateImpl.this.f246.getParent());
                }
                AppCompatDelegateImpl.this.f246.removeAllViews();
                AppCompatDelegateImpl.this.f247.m4619((AbstractC1738) null);
                AppCompatDelegateImpl appCompatDelegateImpl2 = AppCompatDelegateImpl.this;
                appCompatDelegateImpl2.f247 = null;
                C1729.m4451(appCompatDelegateImpl2.f281);
            }
        }

        public C0049(AbstractC1890.AbstractC1891 k) {
            this.f323 = k;
        }

        @Override // ῲ.ῲ.ඓ.AbstractC1890.AbstractC1891
        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean m200(AbstractC1890 r2, Menu menu) {
            return this.f323.m4909(r2, menu);
        }

        @Override // ῲ.ῲ.ඓ.AbstractC1890.AbstractC1891
        /* renamed from: K  reason: contains not printable characters */
        public boolean m202(AbstractC1890 r2, Menu menu) {
            C1729.m4451(AppCompatDelegateImpl.this.f281);
            return this.f323.m4911(r2, menu);
        }

        @Override // ῲ.ῲ.ඓ.AbstractC1890.AbstractC1891
        /* renamed from: K  reason: contains not printable characters */
        public boolean m203(AbstractC1890 r2, MenuItem menuItem) {
            return this.f323.m4912(r2, menuItem);
        }

        @Override // ῲ.ῲ.ඓ.AbstractC1890.AbstractC1891
        /* renamed from: K  reason: contains not printable characters */
        public void m201(AbstractC1890 r3) {
            this.f323.m4910(r3);
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if (appCompatDelegateImpl.f259 != null) {
                appCompatDelegateImpl.f280.getDecorView().removeCallbacks(AppCompatDelegateImpl.this.f274);
            }
            AppCompatDelegateImpl appCompatDelegateImpl2 = AppCompatDelegateImpl.this;
            if (appCompatDelegateImpl2.f246 != null) {
                appCompatDelegateImpl2.m180();
                AppCompatDelegateImpl appCompatDelegateImpl3 = AppCompatDelegateImpl.this;
                C1768 r0 = C1729.m4470(appCompatDelegateImpl3.f246);
                r0.m4617(0.0f);
                appCompatDelegateImpl3.f247 = r0;
                AppCompatDelegateImpl.this.f247.m4619(new C0050());
            }
            AppCompatDelegateImpl appCompatDelegateImpl4 = AppCompatDelegateImpl.this;
            AbstractC1967 r02 = appCompatDelegateImpl4.f285;
            if (r02 != null) {
                r02.onSupportActionModeFinished(appCompatDelegateImpl4.f273);
            }
            AppCompatDelegateImpl appCompatDelegateImpl5 = AppCompatDelegateImpl.this;
            appCompatDelegateImpl5.f273 = null;
            C1729.m4451(appCompatDelegateImpl5.f281);
        }
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m180() {
        C1768 r0 = this.f247;
        if (r0 != null) {
            r0.m4621();
        }
    }

    /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$ඓ  reason: contains not printable characters */
    public class C0041 extends Window$CallbackC1889 {
        public C0041(Window.Callback callback) {
            super(callback);
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return AppCompatDelegateImpl.this.m175(keyEvent) || this.f6391.dispatchKeyEvent(keyEvent);
        }

        /* JADX WARNING: Code restructure failed: missing block: B:17:0x0049, code lost:
            if (r6 != false) goto L_0x001d;
         */
        /* JADX WARNING: Removed duplicated region for block: B:21:? A[RETURN, SYNTHETIC] */
        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
            boolean z;
            if (!this.f6391.dispatchKeyShortcutEvent(keyEvent)) {
                AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
                int keyCode = keyEvent.getKeyCode();
                appCompatDelegateImpl.m178();
                AbstractC1963 k = appCompatDelegateImpl.f262;
                if (k == null || !k.m5083(keyCode, keyEvent)) {
                    PanelFeatureState panelFeatureState = appCompatDelegateImpl.f257;
                    if (panelFeatureState == null || !appCompatDelegateImpl.m176(panelFeatureState, keyEvent.getKeyCode(), keyEvent, 1)) {
                        if (appCompatDelegateImpl.f257 == null) {
                            PanelFeatureState r3 = appCompatDelegateImpl.m182(0);
                            appCompatDelegateImpl.m155(r3, keyEvent);
                            boolean r6 = appCompatDelegateImpl.m176(r3, keyEvent.getKeyCode(), keyEvent, 1);
                            r3.f307 = false;
                        }
                        z = false;
                        if (!z) {
                            return true;
                        }
                        return false;
                    }
                    PanelFeatureState panelFeatureState2 = appCompatDelegateImpl.f257;
                    if (panelFeatureState2 != null) {
                        panelFeatureState2.f290 = true;
                    }
                }
                z = true;
                if (!z) {
                }
            }
            return true;
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public void onContentChanged() {
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public boolean onCreatePanelMenu(int i, Menu menu) {
            if (i != 0 || (menu instanceof C1912)) {
                return this.f6391.onCreatePanelMenu(i, menu);
            }
            return false;
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public boolean onMenuOpened(int i, Menu menu) {
            this.f6391.onMenuOpened(i, menu);
            AppCompatDelegateImpl.this.m181(i);
            return true;
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public void onPanelClosed(int i, Menu menu) {
            this.f6391.onPanelClosed(i, menu);
            AppCompatDelegateImpl.this.m157(i);
        }

        public boolean onPreparePanel(int i, View view, Menu menu) {
            C1912 r0 = menu instanceof C1912 ? (C1912) menu : null;
            if (i == 0 && r0 == null) {
                return false;
            }
            if (r0 != null) {
                r0.setOverrideVisibleItems(true);
            }
            boolean onPreparePanel = this.f6391.onPreparePanel(i, view, menu);
            if (r0 != null) {
                r0.setOverrideVisibleItems(false);
            }
            return onPreparePanel;
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889, android.view.Window.Callback
        public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> list, Menu menu, int i) {
            C1912 r0;
            PanelFeatureState r02 = AppCompatDelegateImpl.this.m182(0);
            if (r02 == null || (r0 = r02.f303) == null) {
                this.f6391.onProvideKeyboardShortcuts(list, menu, i);
            } else {
                this.f6391.onProvideKeyboardShortcuts(list, r0, i);
            }
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
            if (Build.VERSION.SDK_INT >= 23) {
                return null;
            }
            if (AppCompatDelegateImpl.this.f286) {
                return m190(callback);
            }
            return this.f6391.onWindowStartingActionMode(callback);
        }

        /* renamed from: K  reason: contains not printable characters */
        public final ActionMode m190(ActionMode.Callback callback) {
            C1935.C1936 k = new C1935.C1936(AppCompatDelegateImpl.this.f250, callback);
            AbstractC1890 r3 = AppCompatDelegateImpl.this.m163(k);
            if (r3 != null) {
                return k.m5005(r3);
            }
            return null;
        }

        @Override // ῲ.ῲ.ඓ.Window$CallbackC1889
        public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int i) {
            if (!AppCompatDelegateImpl.this.f286 || i != 0) {
                return this.f6391.onWindowStartingActionMode(callback, i);
            }
            return m190(callback);
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final int m147() {
        int i = this.f271;
        if (i != -100) {
            return i;
        }
        return -100;
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m152(int i) {
        m156();
        ViewGroup viewGroup = (ViewGroup) this.f281.findViewById(16908290);
        viewGroup.removeAllViews();
        LayoutInflater.from(this.f250).inflate(i, viewGroup);
        this.f265.f6391.onContentChanged();
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final void m156() {
        ViewGroup viewGroup;
        CharSequence charSequence;
        Context context;
        if (!this.f245) {
            TypedArray obtainStyledAttributes = this.f250.obtainStyledAttributes(R$styleable.AppCompatTheme);
            if (obtainStyledAttributes.hasValue(R$styleable.AppCompatTheme_windowActionBar)) {
                if (obtainStyledAttributes.getBoolean(R$styleable.AppCompatTheme_windowNoTitle, false)) {
                    m174(1);
                } else if (obtainStyledAttributes.getBoolean(R$styleable.AppCompatTheme_windowActionBar, false)) {
                    m174(108);
                }
                if (obtainStyledAttributes.getBoolean(R$styleable.AppCompatTheme_windowActionBarOverlay, false)) {
                    m174(109);
                }
                if (obtainStyledAttributes.getBoolean(R$styleable.AppCompatTheme_windowActionModeOverlay, false)) {
                    m174(10);
                }
                this.f261 = obtainStyledAttributes.getBoolean(R$styleable.AppCompatTheme_android_windowIsFloating, false);
                obtainStyledAttributes.recycle();
                m184();
                this.f280.getDecorView();
                LayoutInflater from = LayoutInflater.from(this.f250);
                if (this.f252) {
                    viewGroup = this.f288 ? (ViewGroup) from.inflate(R$layout.abc_screen_simple_overlay_action_mode, (ViewGroup) null) : (ViewGroup) from.inflate(R$layout.abc_screen_simple, (ViewGroup) null);
                } else if (this.f261) {
                    viewGroup = (ViewGroup) from.inflate(R$layout.abc_dialog_title_material, (ViewGroup) null);
                    this.f275 = false;
                    this.f268 = false;
                } else if (this.f268) {
                    TypedValue typedValue = new TypedValue();
                    this.f250.getTheme().resolveAttribute(R$attr.actionBarTheme, typedValue, true);
                    int i = typedValue.resourceId;
                    if (i != 0) {
                        context = new C1937(this.f250, i);
                    } else {
                        context = this.f250;
                    }
                    viewGroup = (ViewGroup) LayoutInflater.from(context).inflate(R$layout.abc_screen_toolbar, (ViewGroup) null);
                    this.f270 = (AbstractC2034) viewGroup.findViewById(R$id.decor_content_parent);
                    this.f270.setWindowCallback(m149());
                    if (this.f275) {
                        this.f270.m5271(109);
                    }
                    if (this.f256) {
                        this.f270.m5271(2);
                    }
                    if (this.f267) {
                        this.f270.m5271(5);
                    }
                } else {
                    viewGroup = null;
                }
                if (viewGroup != null) {
                    int i2 = Build.VERSION.SDK_INT;
                    C1729.m4484(viewGroup, new C1943(this));
                    if (this.f270 == null) {
                        this.f258 = (TextView) viewGroup.findViewById(R$id.title);
                    }
                    C2033.m5264(viewGroup);
                    ContentFrameLayout contentFrameLayout = (ContentFrameLayout) viewGroup.findViewById(R$id.action_bar_activity_content);
                    ViewGroup viewGroup2 = (ViewGroup) this.f280.findViewById(16908290);
                    if (viewGroup2 != null) {
                        while (viewGroup2.getChildCount() > 0) {
                            View childAt = viewGroup2.getChildAt(0);
                            viewGroup2.removeViewAt(0);
                            contentFrameLayout.addView(childAt);
                        }
                        viewGroup2.setId(-1);
                        contentFrameLayout.setId(16908290);
                        if (viewGroup2 instanceof FrameLayout) {
                            ((FrameLayout) viewGroup2).setForeground(null);
                        }
                    }
                    this.f280.setContentView(viewGroup);
                    contentFrameLayout.setAttachListener(new C1946(this));
                    this.f281 = viewGroup;
                    Object obj = this.f283;
                    if (obj instanceof Activity) {
                        charSequence = ((Activity) obj).getTitle();
                    } else {
                        charSequence = this.f260;
                    }
                    if (!TextUtils.isEmpty(charSequence)) {
                        AbstractC2034 r1 = this.f270;
                        if (r1 != null) {
                            r1.setWindowTitle(charSequence);
                        } else {
                            AbstractC1963 k = this.f262;
                            if (k != null) {
                                k.m5082(charSequence);
                            } else {
                                TextView textView = this.f258;
                                if (textView != null) {
                                    textView.setText(charSequence);
                                }
                            }
                        }
                    }
                    ContentFrameLayout contentFrameLayout2 = (ContentFrameLayout) this.f281.findViewById(16908290);
                    View decorView = this.f280.getDecorView();
                    contentFrameLayout2.m323(decorView.getPaddingLeft(), decorView.getPaddingTop(), decorView.getPaddingRight(), decorView.getPaddingBottom());
                    TypedArray obtainStyledAttributes2 = this.f250.obtainStyledAttributes(R$styleable.AppCompatTheme);
                    obtainStyledAttributes2.getValue(R$styleable.AppCompatTheme_windowMinWidthMajor, contentFrameLayout2.getMinWidthMajor());
                    obtainStyledAttributes2.getValue(R$styleable.AppCompatTheme_windowMinWidthMinor, contentFrameLayout2.getMinWidthMinor());
                    if (obtainStyledAttributes2.hasValue(R$styleable.AppCompatTheme_windowFixedWidthMajor)) {
                        obtainStyledAttributes2.getValue(R$styleable.AppCompatTheme_windowFixedWidthMajor, contentFrameLayout2.getFixedWidthMajor());
                    }
                    if (obtainStyledAttributes2.hasValue(R$styleable.AppCompatTheme_windowFixedWidthMinor)) {
                        obtainStyledAttributes2.getValue(R$styleable.AppCompatTheme_windowFixedWidthMinor, contentFrameLayout2.getFixedWidthMinor());
                    }
                    if (obtainStyledAttributes2.hasValue(R$styleable.AppCompatTheme_windowFixedHeightMajor)) {
                        obtainStyledAttributes2.getValue(R$styleable.AppCompatTheme_windowFixedHeightMajor, contentFrameLayout2.getFixedHeightMajor());
                    }
                    if (obtainStyledAttributes2.hasValue(R$styleable.AppCompatTheme_windowFixedHeightMinor)) {
                        obtainStyledAttributes2.getValue(R$styleable.AppCompatTheme_windowFixedHeightMinor, contentFrameLayout2.getFixedHeightMinor());
                    }
                    obtainStyledAttributes2.recycle();
                    contentFrameLayout2.requestLayout();
                    this.f245 = true;
                    PanelFeatureState r0 = m182(0);
                    if (this.f284) {
                        return;
                    }
                    if (r0 == null || r0.f303 == null) {
                        m148(108);
                        return;
                    }
                    return;
                }
                StringBuilder r12 = C1293.m3416("AppCompat does not support the current theme features: { windowActionBar: ");
                r12.append(this.f268);
                r12.append(", windowActionBarOverlay: ");
                r12.append(this.f275);
                r12.append(", android:windowIsFloating: ");
                r12.append(this.f261);
                r12.append(", windowActionModeOverlay: ");
                r12.append(this.f288);
                r12.append(", windowNoTitle: ");
                r12.append(this.f252);
                r12.append(" }");
                throw new IllegalArgumentException(r12.toString());
            }
            obtainStyledAttributes.recycle();
            throw new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m183() {
        return m177(true);
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m154(View view, ViewGroup.LayoutParams layoutParams) {
        m156();
        ViewGroup viewGroup = (ViewGroup) this.f281.findViewById(16908290);
        viewGroup.removeAllViews();
        viewGroup.addView(view, layoutParams);
        this.f265.f6391.onContentChanged();
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: K  reason: contains not printable characters */
    public void m167(View view) {
        m156();
        ViewGroup viewGroup = (ViewGroup) this.f281.findViewById(16908290);
        viewGroup.removeAllViews();
        viewGroup.addView(view);
        this.f265.f6391.onContentChanged();
    }

    public static final class PanelFeatureState {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f289;

        /* renamed from: Ԕ  reason: contains not printable characters */
        public boolean f290;

        /* renamed from: ؿ  reason: contains not printable characters */
        public boolean f291;

        /* renamed from: ݜ  reason: contains not printable characters */
        public Bundle f292;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f293;

        /* renamed from: ᓣ  reason: contains not printable characters */
        public boolean f294 = false;

        /* renamed from: ᕣ  reason: contains not printable characters */
        public C1901 f295;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public View f296;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f297;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public ViewGroup f298;

        /* renamed from: K  reason: contains not printable characters */
        public int f299;

        /* renamed from: 㑃  reason: contains not printable characters */
        public Context f300;

        /* renamed from: 㗗  reason: contains not printable characters */
        public boolean f301;

        /* renamed from: 㗽  reason: contains not printable characters */
        public boolean f302;

        /* renamed from: 㳳  reason: contains not printable characters */
        public C1912 f303;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f304;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f305;

        /* renamed from: 㿎  reason: contains not printable characters */
        public View f306;

        /* renamed from: 䁗  reason: contains not printable characters */
        public boolean f307;

        @SuppressLint({"BanParcelableUsage"})
        public static class SavedState implements Parcelable {
            public static final Parcelable.Creator<SavedState> CREATOR = new C0039();

            /* renamed from: ʬ  reason: contains not printable characters */
            public boolean f308;

            /* renamed from: ῲ  reason: contains not printable characters */
            public int f309;

            /* renamed from: 㸾  reason: contains not printable characters */
            public Bundle f310;

            /* renamed from: androidx.appcompat.app.AppCompatDelegateImpl$PanelFeatureState$SavedState$K  reason: contains not printable characters */
            public class C0039 implements Parcelable.ClassLoaderCreator<SavedState> {
                /* Return type fixed from 'java.lang.Object' to match base method */
                @Override // android.os.Parcelable.ClassLoaderCreator
                public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                    return SavedState.m188(parcel, classLoader);
                }

                @Override // android.os.Parcelable.Creator
                public Object[] newArray(int i) {
                    return new SavedState[i];
                }

                @Override // android.os.Parcelable.Creator
                public Object createFromParcel(Parcel parcel) {
                    return SavedState.m188(parcel, null);
                }
            }

            /* renamed from: K  reason: contains not printable characters */
            public static SavedState m188(Parcel parcel, ClassLoader classLoader) {
                SavedState savedState = new SavedState();
                savedState.f309 = parcel.readInt();
                boolean z = true;
                if (parcel.readInt() != 1) {
                    z = false;
                }
                savedState.f308 = z;
                if (savedState.f308) {
                    savedState.f310 = parcel.readBundle(classLoader);
                }
                return savedState;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel parcel, int i) {
                parcel.writeInt(this.f309);
                parcel.writeInt(this.f308 ? 1 : 0);
                if (this.f308) {
                    parcel.writeBundle(this.f310);
                }
            }
        }

        public PanelFeatureState(int i) {
            this.f299 = i;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m186(Context context) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme newTheme = context.getResources().newTheme();
            newTheme.setTo(context.getTheme());
            newTheme.resolveAttribute(R$attr.actionBarPopupTheme, typedValue, true);
            int i = typedValue.resourceId;
            if (i != 0) {
                newTheme.applyStyle(i, true);
            }
            newTheme.resolveAttribute(R$attr.panelMenuListTheme, typedValue, true);
            int i2 = typedValue.resourceId;
            if (i2 != 0) {
                newTheme.applyStyle(i2, true);
            } else {
                newTheme.applyStyle(R$style.Theme_AppCompat_CompactMenu, true);
            }
            C1937 r0 = new C1937(context, 0);
            r0.getTheme().setTo(newTheme);
            this.f300 = r0;
            TypedArray obtainStyledAttributes = r0.obtainStyledAttributes(R$styleable.AppCompatTheme);
            this.f297 = obtainStyledAttributes.getResourceId(R$styleable.AppCompatTheme_panelBackground, 0);
            this.f304 = obtainStyledAttributes.getResourceId(R$styleable.AppCompatTheme_android_windowAnimationStyle, 0);
            obtainStyledAttributes.recycle();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m187(C1912 r3) {
            C1901 r0;
            C1912 r02 = this.f303;
            if (r3 != r02) {
                if (r02 != null) {
                    r02.removeMenuPresenter(this.f295);
                }
                this.f303 = r3;
                if (r3 != null && (r0 = this.f295) != null) {
                    r3.addMenuPresenter(r0);
                }
            }
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m145(int i) {
        PanelFeatureState r0;
        PanelFeatureState r02 = m182(i);
        if (r02.f303 != null) {
            Bundle bundle = new Bundle();
            r02.f303.saveActionViewStates(bundle);
            if (bundle.size() > 0) {
                r02.f292 = bundle;
            }
            r02.f303.stopDispatchingItemsChanged();
            r02.f303.clear();
        }
        r02.f302 = true;
        r02.f294 = true;
        if ((i == 108 || i == 0) && this.f270 != null && (r0 = m182(0)) != null) {
            r0.f307 = false;
            m155(r0, (KeyEvent) null);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:52:0x00c0 A[RETURN] */
    /* renamed from: ῲ  reason: contains not printable characters */
    public final boolean m155(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        AbstractC2034 r12;
        AbstractC2034 r11;
        C1937 r4;
        Resources.Theme theme;
        AbstractC2034 r5;
        if (this.f284) {
            return false;
        }
        if (panelFeatureState.f307) {
            return true;
        }
        PanelFeatureState panelFeatureState2 = this.f257;
        if (!(panelFeatureState2 == null || panelFeatureState2 == panelFeatureState)) {
            m171(panelFeatureState2, false);
        }
        Window.Callback r0 = m149();
        if (r0 != null) {
            panelFeatureState.f296 = r0.onCreatePanelView(panelFeatureState.f299);
        }
        int i = panelFeatureState.f299;
        boolean z = i == 0 || i == 108;
        if (z && (r5 = this.f270) != null) {
            r5.m5274();
        }
        if (panelFeatureState.f296 == null && (!z || !(this.f262 instanceof C1974))) {
            if (panelFeatureState.f303 == null || panelFeatureState.f302) {
                if (panelFeatureState.f303 == null) {
                    Context context = this.f250;
                    int i2 = panelFeatureState.f299;
                    if ((i2 == 0 || i2 == 108) && this.f270 != null) {
                        TypedValue typedValue = new TypedValue();
                        Resources.Theme theme2 = context.getTheme();
                        theme2.resolveAttribute(R$attr.actionBarTheme, typedValue, true);
                        if (typedValue.resourceId != 0) {
                            theme = context.getResources().newTheme();
                            theme.setTo(theme2);
                            theme.applyStyle(typedValue.resourceId, true);
                            theme.resolveAttribute(R$attr.actionBarWidgetTheme, typedValue, true);
                        } else {
                            theme2.resolveAttribute(R$attr.actionBarWidgetTheme, typedValue, true);
                            theme = null;
                        }
                        if (typedValue.resourceId != 0) {
                            if (theme == null) {
                                theme = context.getResources().newTheme();
                                theme.setTo(theme2);
                            }
                            theme.applyStyle(typedValue.resourceId, true);
                        }
                        if (theme != null) {
                            C1937 r42 = new C1937(context, 0);
                            r42.getTheme().setTo(theme);
                            r4 = r42;
                            C1912 r52 = new C1912(r4);
                            r52.setCallback(this);
                            panelFeatureState.m187(r52);
                            if (panelFeatureState.f303 == null) {
                                return false;
                            }
                        }
                    }
                    r4 = context;
                    C1912 r522 = new C1912(r4);
                    r522.setCallback(this);
                    panelFeatureState.m187(r522);
                    if (panelFeatureState.f303 == null) {
                    }
                }
                if (z && this.f270 != null) {
                    if (this.f287 == null) {
                        this.f287 = new C0040();
                    }
                    this.f270.m5272(panelFeatureState.f303, this.f287);
                }
                panelFeatureState.f303.stopDispatchingItemsChanged();
                if (!r0.onCreatePanelMenu(panelFeatureState.f299, panelFeatureState.f303)) {
                    panelFeatureState.m187((C1912) null);
                    if (z && (r11 = this.f270) != null) {
                        r11.m5272(null, this.f287);
                    }
                    return false;
                }
                panelFeatureState.f302 = false;
            }
            panelFeatureState.f303.stopDispatchingItemsChanged();
            Bundle bundle = panelFeatureState.f292;
            if (bundle != null) {
                panelFeatureState.f303.restoreActionViewStates(bundle);
                panelFeatureState.f292 = null;
            }
            if (!r0.onPreparePanel(0, panelFeatureState.f296, panelFeatureState.f303)) {
                if (z && (r12 = this.f270) != null) {
                    r12.m5272(null, this.f287);
                }
                panelFeatureState.f303.startDispatchingItemsChanged();
                return false;
            }
            panelFeatureState.f291 = KeyCharacterMap.load(keyEvent != null ? keyEvent.getDeviceId() : -1).getKeyboardType() != 1;
            panelFeatureState.f303.setQwertyMode(panelFeatureState.f291);
            panelFeatureState.f303.startDispatchingItemsChanged();
        }
        panelFeatureState.f307 = true;
        panelFeatureState.f290 = false;
        this.f257 = panelFeatureState;
        return true;
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: K  reason: contains not printable characters */
    public void m168(View view, ViewGroup.LayoutParams layoutParams) {
        m156();
        ((ViewGroup) this.f281.findViewById(16908290)).addView(view, layoutParams);
        this.f265.f6391.onContentChanged();
    }

    public View onCreateView(String str, Context context, AttributeSet attributeSet) {
        return onCreateView(null, str, context, attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m169(Window window) {
        if (this.f280 == null) {
            Window.Callback callback = window.getCallback();
            if (!(callback instanceof C0041)) {
                this.f265 = new C0041(callback);
                window.setCallback(this.f265);
                C2019 r0 = C2019.m5222(this.f250, (AttributeSet) null, f238);
                Drawable r1 = r0.m5225(0);
                if (r1 != null) {
                    window.setBackgroundDrawable(r1);
                }
                r0.f6846.recycle();
                this.f280 = window;
                return;
            }
            throw new IllegalStateException("AppCompat has already installed itself into the Window");
        }
        throw new IllegalStateException("AppCompat has already installed itself into the Window");
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: K  reason: contains not printable characters */
    public final void m172(CharSequence charSequence) {
        this.f260 = charSequence;
        AbstractC2034 r0 = this.f270;
        if (r0 != null) {
            r0.setWindowTitle(charSequence);
            return;
        }
        AbstractC1963 k = this.f262;
        if (k != null) {
            k.m5082(charSequence);
            return;
        }
        TextView textView = this.f258;
        if (textView != null) {
            textView.setText(charSequence);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:25:0x0045  */
    /* JADX WARNING: Removed duplicated region for block: B:26:0x0049  */
    /* renamed from: K  reason: contains not printable characters */
    public AbstractC1890 m163(AbstractC1890.AbstractC1891 k) {
        AbstractC1890 r8;
        AbstractC1890 r82;
        AbstractC1967 r0;
        C1937 r4;
        AbstractC1967 r1;
        if (k != null) {
            AbstractC1890 r02 = this.f273;
            if (r02 != null) {
                r02.m4901();
            }
            C0049 r03 = new C0049(k);
            m178();
            AbstractC1963 k2 = this.f262;
            if (k2 != null) {
                this.f273 = k2.m5080(r03);
                AbstractC1890 r83 = this.f273;
                if (!(r83 == null || (r1 = this.f285) == null)) {
                    r1.onSupportActionModeStarted(r83);
                }
            }
            if (this.f273 == null) {
                m180();
                AbstractC1890 r84 = this.f273;
                if (r84 != null) {
                    r84.m4901();
                }
                AbstractC1967 r85 = this.f285;
                if (r85 != null && !this.f284) {
                    try {
                        r8 = r85.onWindowStartingSupportActionMode(r03);
                    } catch (AbstractMethodError unused) {
                    }
                    if (r8 == null) {
                        this.f273 = r8;
                    } else {
                        boolean z = true;
                        if (this.f246 == null) {
                            if (this.f261) {
                                TypedValue typedValue = new TypedValue();
                                Resources.Theme theme = this.f250.getTheme();
                                theme.resolveAttribute(R$attr.actionBarTheme, typedValue, true);
                                if (typedValue.resourceId != 0) {
                                    Resources.Theme newTheme = this.f250.getResources().newTheme();
                                    newTheme.setTo(theme);
                                    newTheme.applyStyle(typedValue.resourceId, true);
                                    C1937 r42 = new C1937(this.f250, 0);
                                    r42.getTheme().setTo(newTheme);
                                    r4 = r42;
                                } else {
                                    r4 = this.f250;
                                }
                                this.f246 = new ActionBarContextView(r4);
                                this.f259 = new PopupWindow(r4, (AttributeSet) null, R$attr.actionModePopupWindowStyle);
                                C2369.m6332(this.f259, 2);
                                this.f259.setContentView(this.f246);
                                this.f259.setWidth(-1);
                                r4.getTheme().resolveAttribute(R$attr.actionBarSize, typedValue, true);
                                this.f246.setContentHeight(TypedValue.complexToDimensionPixelSize(typedValue.data, r4.getResources().getDisplayMetrics()));
                                this.f259.setHeight(-2);
                                this.f274 = new RunnableC1956(this);
                            } else {
                                ViewStubCompat viewStubCompat = (ViewStubCompat) this.f281.findViewById(R$id.action_mode_bar_stub);
                                if (viewStubCompat != null) {
                                    m178();
                                    AbstractC1963 k3 = this.f262;
                                    Context r43 = k3 != null ? k3.m5089() : null;
                                    if (r43 == null) {
                                        r43 = this.f250;
                                    }
                                    viewStubCompat.setLayoutInflater(LayoutInflater.from(r43));
                                    this.f246 = (ActionBarContextView) viewStubCompat.m372();
                                }
                            }
                        }
                        if (this.f246 != null) {
                            m180();
                            this.f246.m228();
                            Context context = this.f246.getContext();
                            ActionBarContextView actionBarContextView = this.f246;
                            if (this.f259 != null) {
                                z = false;
                            }
                            C1888 r86 = new C1888(context, actionBarContextView, r03, z);
                            if (r03.f323.m4909(r86, r86.f6386)) {
                                r86.m4886();
                                this.f246.m227(r86);
                                this.f273 = r86;
                                if (m185()) {
                                    this.f246.setAlpha(0.0f);
                                    C1768 r87 = C1729.m4470(this.f246);
                                    r87.m4617(1.0f);
                                    this.f247 = r87;
                                    this.f247.m4619(new C1969(this));
                                } else {
                                    this.f246.setAlpha(1.0f);
                                    this.f246.setVisibility(0);
                                    this.f246.sendAccessibilityEvent(32);
                                    if (this.f246.getParent() instanceof View) {
                                        C1729.m4451((View) this.f246.getParent());
                                    }
                                }
                                if (this.f259 != null) {
                                    this.f280.getDecorView().post(this.f274);
                                }
                            } else {
                                this.f273 = null;
                            }
                        }
                    }
                    r82 = this.f273;
                    if (!(r82 == null || (r0 = this.f285) == null)) {
                        r0.onSupportActionModeStarted(r82);
                    }
                    this.f273 = this.f273;
                }
                r8 = null;
                if (r8 == null) {
                }
                r82 = this.f273;
                r0.onSupportActionModeStarted(r82);
                this.f273 = this.f273;
            }
            return this.f273;
        }
        throw new IllegalArgumentException("ActionMode callback can not be null.");
    }

    /* JADX WARNING: Removed duplicated region for block: B:65:0x00d3  */
    /* JADX WARNING: Removed duplicated region for block: B:88:? A[RETURN, SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:93:? A[RETURN, SYNTHETIC] */
    /* renamed from: K  reason: contains not printable characters */
    public boolean m175(KeyEvent keyEvent) {
        boolean z;
        boolean z2;
        boolean z3;
        View decorView;
        Object obj = this.f283;
        boolean z4 = true;
        if (((obj instanceof C1773.AbstractC1774) || (obj instanceof DialogC1947)) && (decorView = this.f280.getDecorView()) != null && C1729.m4464(decorView, keyEvent)) {
            return true;
        }
        if (keyEvent.getKeyCode() == 82 && this.f265.f6391.dispatchKeyEvent(keyEvent)) {
            return true;
        }
        int keyCode = keyEvent.getKeyCode();
        if (keyEvent.getAction() == 0) {
            if (keyCode == 4) {
                if ((keyEvent.getFlags() & 128) == 0) {
                    z4 = false;
                }
                this.f241 = z4;
            } else if (keyCode == 82) {
                if (keyEvent.getRepeatCount() != 0) {
                    return true;
                }
                PanelFeatureState r0 = m182(0);
                if (r0.f301) {
                    return true;
                }
                m155(r0, keyEvent);
                return true;
            }
        } else if (keyCode == 4) {
            boolean z5 = this.f241;
            this.f241 = false;
            PanelFeatureState r02 = m182(0);
            if (r02 == null || !r02.f301) {
                AbstractC1890 r7 = this.f273;
                if (r7 != null) {
                    r7.m4901();
                } else {
                    m178();
                    AbstractC1963 k = this.f262;
                    if (k == null || !k.m5087()) {
                        z = false;
                        if (!z) {
                            return true;
                        }
                    }
                }
                z = true;
                if (!z) {
                    return false;
                }
            } else if (z5) {
                return true;
            } else {
                m171(r02, true);
                return true;
            }
        } else if (keyCode == 82) {
            if (this.f273 != null) {
                return true;
            }
            PanelFeatureState r03 = m182(0);
            AbstractC2034 r1 = this.f270;
            if (r1 != null && r1.m5270() && !ViewConfiguration.get(this.f250).hasPermanentMenuKey()) {
                if (this.f270.m5269()) {
                    z2 = this.f270.m5267();
                } else if (!this.f284 && m155(r03, keyEvent)) {
                    z2 = this.f270.m5275();
                }
                if (z2) {
                }
            } else if (r03.f301 || r03.f290) {
                z2 = r03.f301;
                m171(r03, true);
                if (z2) {
                    return true;
                }
                AudioManager audioManager = (AudioManager) this.f250.getApplicationContext().getSystemService("audio");
                if (audioManager != null) {
                    audioManager.playSoundEffect(0);
                    return true;
                }
                Log.w("AppCompatDelegate", "Couldn't get audio manager");
                return true;
            } else if (r03.f307) {
                if (r03.f302) {
                    r03.f307 = false;
                    z3 = m155(r03, keyEvent);
                } else {
                    z3 = true;
                }
                if (z3) {
                    m170(r03, keyEvent);
                    z2 = true;
                    if (z2) {
                    }
                }
            }
            z2 = false;
            if (z2) {
            }
        }
        return false;
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: K  reason: contains not printable characters */
    public void m164() {
        LayoutInflater from = LayoutInflater.from(this.f250);
        if (from.getFactory() == null) {
            from.setFactory2(this);
            int i = Build.VERSION.SDK_INT;
        } else if (!(from.getFactory2() instanceof AppCompatDelegateImpl)) {
            Log.i("AppCompatDelegate", "The Activity's LayoutInflater already has a Factory installed so we can not install AppCompat's");
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:67:0x00ff, code lost:
        if (r14.f306 != null) goto L_0x0101;
     */
    /* JADX WARNING: Removed duplicated region for block: B:71:0x0106  */
    /* renamed from: K  reason: contains not printable characters */
    public final void m170(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        int i;
        boolean z;
        ExpandedMenuView expandedMenuView;
        ViewGroup.LayoutParams layoutParams;
        if (!panelFeatureState.f301 && !this.f284) {
            if (panelFeatureState.f299 == 0) {
                if ((this.f250.getResources().getConfiguration().screenLayout & 15) == 4) {
                    return;
                }
            }
            Window.Callback r0 = m149();
            if (r0 == null || r0.onMenuOpened(panelFeatureState.f299, panelFeatureState.f303)) {
                WindowManager windowManager = (WindowManager) this.f250.getSystemService("window");
                if (windowManager != null && m155(panelFeatureState, keyEvent)) {
                    if (panelFeatureState.f298 == null || panelFeatureState.f294) {
                        ViewGroup viewGroup = panelFeatureState.f298;
                        if (viewGroup == null) {
                            panelFeatureState.m186(m150());
                            panelFeatureState.f298 = new C0042(panelFeatureState.f300);
                            panelFeatureState.f289 = 81;
                            if (panelFeatureState.f298 == null) {
                                return;
                            }
                        } else if (panelFeatureState.f294 && viewGroup.getChildCount() > 0) {
                            panelFeatureState.f298.removeAllViews();
                        }
                        View view = panelFeatureState.f296;
                        if (view != null) {
                            panelFeatureState.f306 = view;
                        } else {
                            if (panelFeatureState.f303 != null) {
                                if (this.f244 == null) {
                                    this.f244 = new C0047();
                                }
                                C0047 r15 = this.f244;
                                if (panelFeatureState.f303 == null) {
                                    expandedMenuView = null;
                                } else {
                                    if (panelFeatureState.f295 == null) {
                                        panelFeatureState.f295 = new C1901(panelFeatureState.f300, R$layout.abc_list_menu_item_layout);
                                        C1901 r3 = panelFeatureState.f295;
                                        r3.f6443 = r15;
                                        panelFeatureState.f303.addMenuPresenter(r3);
                                    }
                                    C1901 r152 = panelFeatureState.f295;
                                    ViewGroup viewGroup2 = panelFeatureState.f298;
                                    if (r152.f6441 == null) {
                                        r152.f6441 = (ExpandedMenuView) r152.f6440.inflate(R$layout.abc_expanded_menu_layout, viewGroup2, false);
                                        if (r152.f6446 == null) {
                                            r152.f6446 = new C1901.C1902();
                                        }
                                        r152.f6441.setAdapter((ListAdapter) r152.f6446);
                                        r152.f6441.setOnItemClickListener(r152);
                                    }
                                    expandedMenuView = r152.f6441;
                                }
                                panelFeatureState.f306 = expandedMenuView;
                            }
                            z = false;
                            if (z) {
                                if (panelFeatureState.f306 != null && (panelFeatureState.f296 != null || panelFeatureState.f295.m4923().getCount() > 0)) {
                                    ViewGroup.LayoutParams layoutParams2 = panelFeatureState.f306.getLayoutParams();
                                    if (layoutParams2 == null) {
                                        layoutParams2 = new ViewGroup.LayoutParams(-2, -2);
                                    }
                                    panelFeatureState.f298.setBackgroundResource(panelFeatureState.f297);
                                    ViewParent parent = panelFeatureState.f306.getParent();
                                    if (parent instanceof ViewGroup) {
                                        ((ViewGroup) parent).removeView(panelFeatureState.f306);
                                    }
                                    panelFeatureState.f298.addView(panelFeatureState.f306, layoutParams2);
                                    if (!panelFeatureState.f306.hasFocus()) {
                                        panelFeatureState.f306.requestFocus();
                                    }
                                }
                            }
                            panelFeatureState.f294 = true;
                            return;
                        }
                        z = true;
                        if (z) {
                        }
                        panelFeatureState.f294 = true;
                        return;
                    }
                    View view2 = panelFeatureState.f296;
                    if (!(view2 == null || (layoutParams = view2.getLayoutParams()) == null || layoutParams.width != -1)) {
                        i = -1;
                        panelFeatureState.f290 = false;
                        WindowManager.LayoutParams layoutParams3 = new WindowManager.LayoutParams(i, -2, panelFeatureState.f305, panelFeatureState.f293, 1002, 8519680, -3);
                        layoutParams3.gravity = panelFeatureState.f289;
                        layoutParams3.windowAnimations = panelFeatureState.f304;
                        windowManager.addView(panelFeatureState.f298, layoutParams3);
                        panelFeatureState.f301 = true;
                        return;
                    }
                    i = -2;
                    panelFeatureState.f290 = false;
                    WindowManager.LayoutParams layoutParams32 = new WindowManager.LayoutParams(i, -2, panelFeatureState.f305, panelFeatureState.f293, 1002, 8519680, -3);
                    layoutParams32.gravity = panelFeatureState.f289;
                    layoutParams32.windowAnimations = panelFeatureState.f304;
                    windowManager.addView(panelFeatureState.f298, layoutParams32);
                    panelFeatureState.f301 = true;
                    return;
                }
                return;
            }
            m171(panelFeatureState, true);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m173(C1912 r3) {
        if (!this.f266) {
            this.f266 = true;
            this.f270.m5268();
            Window.Callback r0 = m149();
            if (r0 != null && !this.f284) {
                r0.onPanelClosed(108, r3);
            }
            this.f266 = false;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m171(PanelFeatureState panelFeatureState, boolean z) {
        ViewGroup viewGroup;
        AbstractC2034 r0;
        if (!z || panelFeatureState.f299 != 0 || (r0 = this.f270) == null || !r0.m5269()) {
            WindowManager windowManager = (WindowManager) this.f250.getSystemService("window");
            if (!(windowManager == null || !panelFeatureState.f301 || (viewGroup = panelFeatureState.f298) == null)) {
                windowManager.removeView(viewGroup);
                if (z) {
                    m165(panelFeatureState.f299, panelFeatureState, (Menu) null);
                }
            }
            panelFeatureState.f307 = false;
            panelFeatureState.f290 = false;
            panelFeatureState.f301 = false;
            panelFeatureState.f306 = null;
            panelFeatureState.f294 = true;
            if (this.f257 == panelFeatureState) {
                this.f257 = null;
                return;
            }
            return;
        }
        m173(panelFeatureState.f303);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m165(int i, PanelFeatureState panelFeatureState, Menu menu) {
        if (menu == null) {
            if (panelFeatureState == null && i >= 0) {
                PanelFeatureState[] panelFeatureStateArr = this.f253;
                if (i < panelFeatureStateArr.length) {
                    panelFeatureState = panelFeatureStateArr[i];
                }
            }
            if (panelFeatureState != null) {
                menu = panelFeatureState.f303;
            }
        }
        if ((panelFeatureState == null || panelFeatureState.f301) && !this.f284) {
            this.f265.f6391.onPanelClosed(i, menu);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public PanelFeatureState m161(Menu menu) {
        PanelFeatureState[] panelFeatureStateArr = this.f253;
        int length = panelFeatureStateArr != null ? panelFeatureStateArr.length : 0;
        for (int i = 0; i < length; i++) {
            PanelFeatureState panelFeatureState = panelFeatureStateArr[i];
            if (panelFeatureState != null && panelFeatureState.f303 == menu) {
                return panelFeatureState;
            }
        }
        return null;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m176(PanelFeatureState panelFeatureState, int i, KeyEvent keyEvent, int i2) {
        C1912 r0;
        boolean z = false;
        if (keyEvent.isSystem()) {
            return false;
        }
        if ((panelFeatureState.f307 || m155(panelFeatureState, keyEvent)) && (r0 = panelFeatureState.f303) != null) {
            z = r0.performShortcut(i, keyEvent, i2);
        }
        if (z && (i2 & 1) == 0 && this.f270 == null) {
            m171(panelFeatureState, true);
        }
        return z;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m159(C1754 r11, Rect rect) {
        int i;
        boolean z;
        boolean z2;
        int i2;
        int i3;
        int i4;
        int i5 = 0;
        if (r11 != null) {
            i = r11.m4557();
        } else {
            i = rect != null ? rect.top : 0;
        }
        ActionBarContextView actionBarContextView = this.f246;
        if (actionBarContextView == null || !(actionBarContextView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
            z = false;
        } else {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.f246.getLayoutParams();
            boolean z3 = true;
            if (this.f246.isShown()) {
                if (this.f255 == null) {
                    this.f255 = new Rect();
                    this.f263 = new Rect();
                }
                Rect rect2 = this.f255;
                Rect rect3 = this.f263;
                if (r11 == null) {
                    rect2.set(rect);
                } else {
                    rect2.set(r11.m4556(), r11.m4557(), r11.m4563(), r11.m4558());
                }
                C2033.m5265(this.f281, rect2, rect3);
                int i6 = rect2.top;
                int i7 = rect2.left;
                int i8 = rect2.right;
                C1754 r6 = C1729.m4510(this.f281);
                if (r6 == null) {
                    i2 = 0;
                } else {
                    i2 = r6.m4556();
                }
                if (r6 == null) {
                    i3 = 0;
                } else {
                    i3 = r6.m4563();
                }
                if (marginLayoutParams.topMargin == i6 && marginLayoutParams.leftMargin == i7 && marginLayoutParams.rightMargin == i8) {
                    z2 = false;
                } else {
                    marginLayoutParams.topMargin = i6;
                    marginLayoutParams.leftMargin = i7;
                    marginLayoutParams.rightMargin = i8;
                    z2 = true;
                }
                if (i6 <= 0 || this.f279 != null) {
                    View view = this.f279;
                    if (view != null) {
                        ViewGroup.MarginLayoutParams marginLayoutParams2 = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
                        if (!(marginLayoutParams2.height == marginLayoutParams.topMargin && marginLayoutParams2.leftMargin == i2 && marginLayoutParams2.rightMargin == i3)) {
                            marginLayoutParams2.height = marginLayoutParams.topMargin;
                            marginLayoutParams2.leftMargin = i2;
                            marginLayoutParams2.rightMargin = i3;
                            this.f279.setLayoutParams(marginLayoutParams2);
                        }
                    }
                } else {
                    this.f279 = new View(this.f250);
                    this.f279.setVisibility(8);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, marginLayoutParams.topMargin, 51);
                    layoutParams.leftMargin = i2;
                    layoutParams.rightMargin = i3;
                    this.f281.addView(this.f279, -1, layoutParams);
                }
                z = this.f279 != null;
                if (z && this.f279.getVisibility() != 0) {
                    View view2 = this.f279;
                    if ((C1729.m4452(view2) & 8192) == 0) {
                        z3 = false;
                    }
                    if (z3) {
                        i4 = C1806.m4686(this.f250, R$color.abc_decor_view_status_guard_light);
                    } else {
                        i4 = C1806.m4686(this.f250, R$color.abc_decor_view_status_guard);
                    }
                    view2.setBackgroundColor(i4);
                }
                if (!this.f288 && z) {
                    i = 0;
                }
            } else if (marginLayoutParams.topMargin != 0) {
                marginLayoutParams.topMargin = 0;
                z = false;
                z2 = true;
            } else {
                z = false;
                z2 = false;
            }
            if (z2) {
                this.f246.setLayoutParams(marginLayoutParams);
            }
        }
        View view3 = this.f279;
        if (view3 != null) {
            if (!z) {
                i5 = 8;
            }
            view3.setVisibility(i5);
        }
        return i;
    }

    @Override // ῲ.ῲ.K.AbstractC1983
    /* renamed from: K  reason: contains not printable characters */
    public boolean m174(int i) {
        if (i == 8) {
            Log.i("AppCompatDelegate", "You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR id when requesting this feature.");
            i = 108;
        } else if (i == 9) {
            Log.i("AppCompatDelegate", "You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR_OVERLAY id when requesting this feature.");
            i = 109;
        }
        if (this.f252 && i == 108) {
            return false;
        }
        if (this.f268 && i == 1) {
            this.f268 = false;
        }
        if (i == 1) {
            m146();
            this.f252 = true;
            return true;
        } else if (i == 2) {
            m146();
            this.f256 = true;
            return true;
        } else if (i == 5) {
            m146();
            this.f267 = true;
            return true;
        } else if (i == 10) {
            m146();
            this.f288 = true;
            return true;
        } else if (i == 108) {
            m146();
            this.f268 = true;
            return true;
        } else if (i != 109) {
            return this.f280.requestFeature(i);
        } else {
            m146();
            this.f275 = true;
            return true;
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:120:0x01a6  */
    /* JADX WARNING: Removed duplicated region for block: B:124:0x01bc  */
    /* JADX WARNING: Removed duplicated region for block: B:136:0x01e9  */
    /* JADX WARNING: Removed duplicated region for block: B:140:0x01f6  */
    /* JADX WARNING: Removed duplicated region for block: B:141:0x0200  */
    /* JADX WARNING: Removed duplicated region for block: B:146:0x020a  */
    /* JADX WARNING: Removed duplicated region for block: B:150:0x021d  */
    /* JADX WARNING: Removed duplicated region for block: B:54:0x00e0  */
    /* JADX WARNING: Removed duplicated region for block: B:84:0x0143  */
    /* renamed from: K  reason: contains not printable characters */
    public final boolean m177(boolean z) {
        boolean z2;
        int i;
        int i2;
        int i3;
        Map map;
        Object obj;
        int i4;
        boolean z3 = false;
        if (this.f284) {
            return false;
        }
        int i5 = this.f271;
        if (i5 == -100) {
            i5 = -100;
        }
        Object obj2 = null;
        Configuration r2 = m160(this.f250, m158(this.f250, i5), (Configuration) null);
        if (!this.f264 && (this.f283 instanceof Activity)) {
            PackageManager packageManager = this.f250.getPackageManager();
            if (packageManager == null) {
                z2 = false;
                int i6 = this.f250.getResources().getConfiguration().uiMode & 48;
                i = r2.uiMode & 48;
                if (i6 != i && z && !z2 && this.f276 && (f236 || this.f249)) {
                    Object obj3 = this.f283;
                    if ((obj3 instanceof Activity) && !((Activity) obj3).isChild()) {
                        C1826.m4715((Activity) this.f283);
                        z3 = true;
                    }
                }
                if (!z3 && i6 != i) {
                    Resources resources = this.f250.getResources();
                    Configuration configuration = new Configuration(resources.getConfiguration());
                    configuration.uiMode = i | (resources.getConfiguration().uiMode & -49);
                    resources.updateConfiguration(configuration, null);
                    i2 = Build.VERSION.SDK_INT;
                    if (i2 < 26 && i2 < 28) {
                        if (i2 < 24) {
                            if (!C2369.f8193) {
                                try {
                                    C2369.f8186 = Resources.class.getDeclaredField("mResourcesImpl");
                                    C2369.f8186.setAccessible(true);
                                } catch (NoSuchFieldException e) {
                                    Log.e("ResourcesFlusher", "Could not retrieve Resources#mResourcesImpl field", e);
                                }
                                C2369.f8193 = true;
                            }
                            Field field = C2369.f8186;
                            if (field != null) {
                                try {
                                    obj = field.get(resources);
                                } catch (IllegalAccessException e2) {
                                    Log.e("ResourcesFlusher", "Could not retrieve value from Resources#mResourcesImpl", e2);
                                    obj = null;
                                }
                                if (obj != null) {
                                    if (!C2369.f8195) {
                                        try {
                                            C2369.f8179 = obj.getClass().getDeclaredField("mDrawableCache");
                                            C2369.f8179.setAccessible(true);
                                        } catch (NoSuchFieldException e3) {
                                            Log.e("ResourcesFlusher", "Could not retrieve ResourcesImpl#mDrawableCache field", e3);
                                        }
                                        C2369.f8195 = true;
                                    }
                                    Field field2 = C2369.f8179;
                                    if (field2 != null) {
                                        try {
                                            obj2 = field2.get(obj);
                                        } catch (IllegalAccessException e4) {
                                            Log.e("ResourcesFlusher", "Could not retrieve value from ResourcesImpl#mDrawableCache", e4);
                                        }
                                    }
                                    if (obj2 != null) {
                                        C2369.m6285(obj2);
                                    }
                                }
                            }
                        } else if (i2 >= 23) {
                            if (!C2369.f8195) {
                                try {
                                    C2369.f8179 = Resources.class.getDeclaredField("mDrawableCache");
                                    C2369.f8179.setAccessible(true);
                                } catch (NoSuchFieldException e5) {
                                    Log.e("ResourcesFlusher", "Could not retrieve Resources#mDrawableCache field", e5);
                                }
                                C2369.f8195 = true;
                            }
                            Field field3 = C2369.f8179;
                            if (field3 != null) {
                                try {
                                    obj2 = field3.get(resources);
                                } catch (IllegalAccessException e6) {
                                    Log.e("ResourcesFlusher", "Could not retrieve value from Resources#mDrawableCache", e6);
                                }
                            }
                            if (obj2 != null) {
                                C2369.m6285(obj2);
                            }
                        } else {
                            if (!C2369.f8195) {
                                try {
                                    C2369.f8179 = Resources.class.getDeclaredField("mDrawableCache");
                                    C2369.f8179.setAccessible(true);
                                } catch (NoSuchFieldException e7) {
                                    Log.e("ResourcesFlusher", "Could not retrieve Resources#mDrawableCache field", e7);
                                }
                                C2369.f8195 = true;
                            }
                            Field field4 = C2369.f8179;
                            if (field4 != null) {
                                try {
                                    map = (Map) field4.get(resources);
                                } catch (IllegalAccessException e8) {
                                    Log.e("ResourcesFlusher", "Could not retrieve value from Resources#mDrawableCache", e8);
                                    map = null;
                                }
                                if (map != null) {
                                    map.clear();
                                }
                            }
                        }
                    }
                    i3 = this.f282;
                    if (i3 != 0) {
                        this.f250.setTheme(i3);
                        if (Build.VERSION.SDK_INT >= 23) {
                            this.f250.getTheme().applyStyle(this.f282, true);
                        }
                    }
                    if (z2) {
                        Object obj4 = this.f283;
                        if (obj4 instanceof Activity) {
                            Activity activity = (Activity) obj4;
                            if (activity instanceof AbstractC1574) {
                                if (((C1584) ((AbstractC1574) activity).getLifecycle()).f5751.isAtLeast(Lifecycle.State.STARTED)) {
                                    activity.onConfigurationChanged(configuration);
                                }
                            } else if (this.f254) {
                                activity.onConfigurationChanged(configuration);
                            }
                        }
                    }
                    z3 = true;
                }
                if (z3) {
                    Object obj5 = this.f283;
                    if (obj5 instanceof AppCompatActivity) {
                        ((AppCompatActivity) obj5).m140();
                    }
                }
                if (i5 != 0) {
                    m162(this.f250).m192();
                } else {
                    AbstractC0044 r12 = this.f248;
                    if (r12 != null) {
                        r12.m194();
                    }
                }
                if (i5 != 3) {
                    Context context = this.f250;
                    if (this.f251 == null) {
                        this.f251 = new C0048(context);
                    }
                    this.f251.m192();
                } else {
                    AbstractC0044 r122 = this.f251;
                    if (r122 != null) {
                        r122.m194();
                    }
                }
                return z3;
            }
            try {
                if (Build.VERSION.SDK_INT >= 29) {
                    i4 = 269221888;
                } else {
                    i4 = Build.VERSION.SDK_INT >= 24 ? 786432 : 0;
                }
                ActivityInfo activityInfo = packageManager.getActivityInfo(new ComponentName(this.f250, this.f283.getClass()), i4);
                this.f242 = (activityInfo == null || (activityInfo.configChanges & 512) == 0) ? false : true;
            } catch (PackageManager.NameNotFoundException e9) {
                Log.d("AppCompatDelegate", "Exception while getting ActivityInfo", e9);
                this.f242 = false;
            }
        }
        this.f264 = true;
        z2 = this.f242;
        int i62 = this.f250.getResources().getConfiguration().uiMode & 48;
        i = r2.uiMode & 48;
        Object obj32 = this.f283;
        C1826.m4715((Activity) this.f283);
        z3 = true;
        Resources resources2 = this.f250.getResources();
        Configuration configuration2 = new Configuration(resources2.getConfiguration());
        configuration2.uiMode = i | (resources2.getConfiguration().uiMode & -49);
        resources2.updateConfiguration(configuration2, null);
        i2 = Build.VERSION.SDK_INT;
        if (i2 < 24) {
        }
        i3 = this.f282;
        if (i3 != 0) {
        }
        if (z2) {
        }
        z3 = true;
        if (z3) {
        }
        if (i5 != 0) {
        }
        if (i5 != 3) {
        }
        return z3;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Configuration m160(Context context, int i, Configuration configuration) {
        int i2 = i != 1 ? i != 2 ? context.getApplicationContext().getResources().getConfiguration().uiMode & 48 : 32 : 16;
        Configuration configuration2 = new Configuration();
        configuration2.fontScale = 0.0f;
        if (configuration != null) {
            configuration2.setTo(configuration);
        }
        configuration2.uiMode = i2 | (configuration2.uiMode & -49);
        return configuration2;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final AbstractC0044 m162(Context context) {
        if (this.f248 == null) {
            if (C1971.f6697 == null) {
                Context applicationContext = context.getApplicationContext();
                C1971.f6697 = new C1971(applicationContext, (LocationManager) applicationContext.getSystemService(PlaceFields.LOCATION));
            }
            this.f248 = new C0051(C1971.f6697);
        }
        return this.f248;
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m158(Context context, int i) {
        if (i == -100) {
            return -1;
        }
        if (i != -1) {
            if (i != 0) {
                if (!(i == 1 || i == 2)) {
                    if (i == 3) {
                        if (this.f251 == null) {
                            this.f251 = new C0048(context);
                        }
                        return this.f251.m191();
                    }
                    throw new IllegalStateException("Unknown value set for night mode. Please use one of the MODE_NIGHT values from AppCompatDelegate.");
                }
            } else if (Build.VERSION.SDK_INT < 23 || ((UiModeManager) context.getApplicationContext().getSystemService(UiModeManager.class)).getNightMode() != 0) {
                return m162(context).m191();
            } else {
                return -1;
            }
        }
        return i;
    }
}
