package androidx.appcompat.app;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.LocaleList;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.appcompat.R$style;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import java.util.ArrayList;
import ῲ.ᨨ.ῲ.C1806;
import ῲ.ᨨ.ῲ.ῲ.C1805;
import ῲ.ᨨ.K.C1826;
import ῲ.ᨨ.K.C1831;
import ῲ.ῲ.ඓ.AbstractC1890;
import ῲ.ῲ.ඓ.C1892;
import ῲ.ῲ.ඓ.C1937;
import ῲ.ῲ.K.AbstractC1961;
import ῲ.ῲ.K.AbstractC1963;
import ῲ.ῲ.K.AbstractC1967;
import ῲ.ῲ.K.AbstractC1983;
import ῲ.ῲ.K.C1950;
import ῲ.ῲ.K.C1974;
import ῲ.ῲ.㴹.C2044;
import ῲ.ῲ.㴹.C2049;
import K.K.K.ʬ.C2369;

public class AppCompatActivity extends FragmentActivity implements AbstractC1967, C1831.AbstractC1832, AbstractC1961 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public Resources f232;

    /* renamed from: ῲ  reason: contains not printable characters */
    public AbstractC1983 f233;

    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        m142().m5133(view, layoutParams);
    }

    public void attachBaseContext(Context context) {
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        appCompatDelegateImpl.f276 = true;
        int r2 = appCompatDelegateImpl.m158(context, appCompatDelegateImpl.m147());
        Configuration configuration = null;
        if (AppCompatDelegateImpl.f234 && (context instanceof ContextThemeWrapper)) {
            try {
                ((ContextThemeWrapper) context).applyOverrideConfiguration(appCompatDelegateImpl.m160(context, r2, (Configuration) null));
            } catch (IllegalStateException unused) {
            }
            super.attachBaseContext(context);
        }
        if (context instanceof C1937) {
            try {
                ((C1937) context).m5012(appCompatDelegateImpl.m160(context, r2, (Configuration) null));
            } catch (IllegalStateException unused2) {
            }
            super.attachBaseContext(context);
        }
        if (AppCompatDelegateImpl.f236) {
            try {
                Configuration configuration2 = context.getPackageManager().getResourcesForApplication(context.getApplicationInfo()).getConfiguration();
                Configuration configuration3 = context.getResources().getConfiguration();
                if (!configuration2.equals(configuration3)) {
                    configuration = new Configuration();
                    configuration.fontScale = 0.0f;
                    if (!(configuration3 == null || configuration2.diff(configuration3) == 0)) {
                        float f = configuration2.fontScale;
                        float f2 = configuration3.fontScale;
                        if (f != f2) {
                            configuration.fontScale = f2;
                        }
                        int i = configuration2.mcc;
                        int i2 = configuration3.mcc;
                        if (i != i2) {
                            configuration.mcc = i2;
                        }
                        int i3 = configuration2.mnc;
                        int i4 = configuration3.mnc;
                        if (i3 != i4) {
                            configuration.mnc = i4;
                        }
                        if (Build.VERSION.SDK_INT >= 24) {
                            LocaleList locales = configuration2.getLocales();
                            LocaleList locales2 = configuration3.getLocales();
                            if (!locales.equals(locales2)) {
                                configuration.setLocales(locales2);
                                configuration.locale = configuration3.locale;
                            }
                        } else if (!C2369.m6287(configuration2.locale, configuration3.locale)) {
                            configuration.locale = configuration3.locale;
                        }
                        int i5 = configuration2.touchscreen;
                        int i6 = configuration3.touchscreen;
                        if (i5 != i6) {
                            configuration.touchscreen = i6;
                        }
                        int i7 = configuration2.keyboard;
                        int i8 = configuration3.keyboard;
                        if (i7 != i8) {
                            configuration.keyboard = i8;
                        }
                        int i9 = configuration2.keyboardHidden;
                        int i10 = configuration3.keyboardHidden;
                        if (i9 != i10) {
                            configuration.keyboardHidden = i10;
                        }
                        int i11 = configuration2.navigation;
                        int i12 = configuration3.navigation;
                        if (i11 != i12) {
                            configuration.navigation = i12;
                        }
                        int i13 = configuration2.navigationHidden;
                        int i14 = configuration3.navigationHidden;
                        if (i13 != i14) {
                            configuration.navigationHidden = i14;
                        }
                        int i15 = configuration2.orientation;
                        int i16 = configuration3.orientation;
                        if (i15 != i16) {
                            configuration.orientation = i16;
                        }
                        int i17 = configuration2.screenLayout & 15;
                        int i18 = configuration3.screenLayout & 15;
                        if (i17 != i18) {
                            configuration.screenLayout |= i18;
                        }
                        int i19 = configuration2.screenLayout & 192;
                        int i20 = configuration3.screenLayout & 192;
                        if (i19 != i20) {
                            configuration.screenLayout |= i20;
                        }
                        int i21 = configuration2.screenLayout & 48;
                        int i22 = configuration3.screenLayout & 48;
                        if (i21 != i22) {
                            configuration.screenLayout |= i22;
                        }
                        int i23 = configuration2.screenLayout & 768;
                        int i24 = configuration3.screenLayout & 768;
                        if (i23 != i24) {
                            configuration.screenLayout |= i24;
                        }
                        if (Build.VERSION.SDK_INT >= 26) {
                            int i25 = configuration2.colorMode & 3;
                            int i26 = configuration3.colorMode & 3;
                            if (i25 != i26) {
                                configuration.colorMode |= i26;
                            }
                            int i27 = configuration2.colorMode & 12;
                            int i28 = configuration3.colorMode & 12;
                            if (i27 != i28) {
                                configuration.colorMode |= i28;
                            }
                        }
                        int i29 = configuration2.uiMode & 15;
                        int i30 = configuration3.uiMode & 15;
                        if (i29 != i30) {
                            configuration.uiMode |= i30;
                        }
                        int i31 = configuration2.uiMode & 48;
                        int i32 = configuration3.uiMode & 48;
                        if (i31 != i32) {
                            configuration.uiMode |= i32;
                        }
                        int i33 = configuration2.screenWidthDp;
                        int i34 = configuration3.screenWidthDp;
                        if (i33 != i34) {
                            configuration.screenWidthDp = i34;
                        }
                        int i35 = configuration2.screenHeightDp;
                        int i36 = configuration3.screenHeightDp;
                        if (i35 != i36) {
                            configuration.screenHeightDp = i36;
                        }
                        int i37 = configuration2.smallestScreenWidthDp;
                        int i38 = configuration3.smallestScreenWidthDp;
                        if (i37 != i38) {
                            configuration.smallestScreenWidthDp = i38;
                        }
                        int i39 = Build.VERSION.SDK_INT;
                        int i40 = configuration2.densityDpi;
                        int i41 = configuration3.densityDpi;
                        if (i40 != i41) {
                            configuration.densityDpi = i41;
                        }
                    }
                }
                Configuration r0 = appCompatDelegateImpl.m160(context, r2, configuration);
                C1937 r22 = new C1937(context, R$style.Theme_AppCompat_Empty);
                r22.m5012(r0);
                boolean z = false;
                try {
                    if (context.getTheme() != null) {
                        z = true;
                    }
                } catch (NullPointerException unused3) {
                }
                if (z) {
                    Resources.Theme theme = r22.getTheme();
                    int i42 = Build.VERSION.SDK_INT;
                    if (i42 >= 29) {
                        theme.rebase();
                    } else if (i42 >= 23) {
                        C1805.m4682(theme);
                    }
                }
                context = r22;
            } catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException("Application failed to obtain resources from itself", e);
            }
        }
        super.attachBaseContext(context);
    }

    public void closeOptionsMenu() {
        AbstractC1963 r0 = m134();
        if (!getWindow().hasFeature(0)) {
            return;
        }
        if (r0 == null || !r0.m5075()) {
            super.closeOptionsMenu();
        }
    }

    @Override // androidx.core.app.ComponentActivity
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        AbstractC1963 r1 = m134();
        if (keyCode != 82 || r1 == null || !r1.m5084(keyEvent)) {
            return super.dispatchKeyEvent(keyEvent);
        }
        return true;
    }

    @Override // android.app.Activity
    public <T extends View> T findViewById(int i) {
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        appCompatDelegateImpl.m156();
        return (T) appCompatDelegateImpl.f280.findViewById(i);
    }

    public MenuInflater getMenuInflater() {
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        if (appCompatDelegateImpl.f278 == null) {
            appCompatDelegateImpl.m178();
            AbstractC1963 k = appCompatDelegateImpl.f262;
            appCompatDelegateImpl.f278 = new C1892(k != null ? k.m5089() : appCompatDelegateImpl.f250);
        }
        return appCompatDelegateImpl.f278;
    }

    public Resources getResources() {
        if (this.f232 == null) {
            C2049.m5337();
        }
        Resources resources = this.f232;
        return resources == null ? super.getResources() : resources;
    }

    public void invalidateOptionsMenu() {
        m142().m5126();
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.f232 != null) {
            this.f232.updateConfiguration(configuration, super.getResources().getDisplayMetrics());
        }
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        if (appCompatDelegateImpl.f268 && appCompatDelegateImpl.f245) {
            appCompatDelegateImpl.m178();
            AbstractC1963 k = appCompatDelegateImpl.f262;
            if (k != null) {
                k.m5081(configuration);
            }
        }
        C2044.m5313().m5318(appCompatDelegateImpl.f250);
        appCompatDelegateImpl.m177(false);
    }

    public void onContentChanged() {
        m133();
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, androidx.fragment.app.FragmentActivity
    public void onCreate(Bundle bundle) {
        AbstractC1983 r0 = m142();
        r0.m5130();
        r0.m5131(bundle);
        super.onCreate(bundle);
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onDestroy() {
        super.onDestroy();
        m142().m5125();
    }

    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        Window window;
        if (Build.VERSION.SDK_INT < 26 && !keyEvent.isCtrlPressed() && !KeyEvent.metaStateHasNoModifiers(keyEvent.getMetaState()) && keyEvent.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyEvent.getKeyCode()) && (window = getWindow()) != null && window.getDecorView() != null && window.getDecorView().dispatchKeyShortcutEvent(keyEvent)) {
            return true;
        }
        return super.onKeyDown(i, keyEvent);
    }

    @Override // androidx.fragment.app.FragmentActivity
    public final boolean onMenuItemSelected(int i, MenuItem menuItem) {
        if (super.onMenuItemSelected(i, menuItem)) {
            return true;
        }
        AbstractC1963 r2 = m134();
        if (menuItem.getItemId() != 16908332 || r2 == null || (r2.m5079() & 4) == 0) {
            return false;
        }
        return m141();
    }

    public boolean onMenuOpened(int i, Menu menu) {
        return super.onMenuOpened(i, menu);
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onPanelClosed(int i, Menu menu) {
        super.onPanelClosed(i, menu);
    }

    public void onPostCreate(Bundle bundle) {
        super.onPostCreate(bundle);
        ((AppCompatDelegateImpl) m142()).m156();
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onPostResume() {
        super.onPostResume();
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        appCompatDelegateImpl.m178();
        AbstractC1963 k = appCompatDelegateImpl.f262;
        if (k != null) {
            k.m5086(true);
        }
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, androidx.fragment.app.FragmentActivity
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        m142().m5128(bundle);
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onStart() {
        super.onStart();
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        appCompatDelegateImpl.f254 = true;
        appCompatDelegateImpl.m183();
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onStop() {
        super.onStop();
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        appCompatDelegateImpl.f254 = false;
        appCompatDelegateImpl.m178();
        AbstractC1963 k = appCompatDelegateImpl.f262;
        if (k != null) {
            k.m5086(false);
        }
    }

    @Override // ῲ.ῲ.K.AbstractC1967
    public void onSupportActionModeFinished(AbstractC1890 r1) {
    }

    @Override // ῲ.ῲ.K.AbstractC1967
    public void onSupportActionModeStarted(AbstractC1890 r1) {
    }

    public void onTitleChanged(CharSequence charSequence, int i) {
        super.onTitleChanged(charSequence, i);
        m142().m5134(charSequence);
    }

    @Override // ῲ.ῲ.K.AbstractC1967
    public AbstractC1890 onWindowStartingSupportActionMode(AbstractC1890.AbstractC1891 k) {
        return null;
    }

    public void openOptionsMenu() {
        AbstractC1963 r0 = m134();
        if (!getWindow().hasFeature(0)) {
            return;
        }
        if (r0 == null || !r0.m5076()) {
            super.openOptionsMenu();
        }
    }

    @Override // android.app.Activity
    public void setContentView(int i) {
        m142().m5127(i);
    }

    @Override // android.view.ContextThemeWrapper, android.app.Activity
    public void setTheme(int i) {
        super.setTheme(i);
        ((AppCompatDelegateImpl) m142()).f282 = i;
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void supportInvalidateOptionsMenu() {
        m142().m5126();
    }

    @Deprecated
    /* renamed from: Ԕ  reason: contains not printable characters */
    public void m133() {
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public AbstractC1963 m134() {
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        appCompatDelegateImpl.m178();
        return appCompatDelegateImpl.f262;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m136(Intent intent) {
        int i = Build.VERSION.SDK_INT;
        return shouldUpRecreateTask(intent);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m137(Intent intent) {
        int i = Build.VERSION.SDK_INT;
        navigateUpTo(intent);
    }

    /* renamed from: 㑃  reason: contains not printable characters */
    public void m140() {
    }

    /* renamed from: 㗗  reason: contains not printable characters */
    public boolean m141() {
        Intent r0 = m135();
        if (r0 == null) {
            return false;
        }
        if (m136(r0)) {
            C1831 r02 = new C1831(this);
            m139(r02);
            m143();
            if (!r02.f6225.isEmpty()) {
                ArrayList<Intent> arrayList = r02.f6225;
                Intent[] intentArr = (Intent[]) arrayList.toArray(new Intent[arrayList.size()]);
                intentArr[0] = new Intent(intentArr[0]).addFlags(268484608);
                C1806.m4690(r02.f6224, intentArr, (Bundle) null);
                try {
                    C1826.m4719((Activity) this);
                    return true;
                } catch (IllegalStateException unused) {
                    finish();
                    return true;
                }
            } else {
                throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
            }
        } else {
            m137(r0);
            return true;
        }
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public AbstractC1983 m142() {
        if (this.f233 == null) {
            this.f233 = AbstractC1983.m5122(this, this);
        }
        return this.f233;
    }

    /* renamed from: 䁗  reason: contains not printable characters */
    public void m143() {
    }

    @Override // android.app.Activity
    public void setContentView(View view) {
        m142().m5132(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        m142().m5129(view, layoutParams);
    }

    @Override // ῲ.ᨨ.K.C1831.AbstractC1832
    /* renamed from: ῲ  reason: contains not printable characters */
    public Intent m135() {
        return C2369.m6301((Activity) this);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m138(Toolbar toolbar) {
        AppCompatDelegateImpl appCompatDelegateImpl = (AppCompatDelegateImpl) m142();
        if (appCompatDelegateImpl.f283 instanceof Activity) {
            appCompatDelegateImpl.m178();
            AbstractC1963 k = appCompatDelegateImpl.f262;
            if (!(k instanceof C1950)) {
                appCompatDelegateImpl.f278 = null;
                if (k != null) {
                    k.m5085();
                }
                if (toolbar != null) {
                    C1974 r1 = new C1974(toolbar, appCompatDelegateImpl.m179(), appCompatDelegateImpl.f265);
                    appCompatDelegateImpl.f262 = r1;
                    appCompatDelegateImpl.f280.setCallback(r1.m5118());
                } else {
                    appCompatDelegateImpl.f262 = null;
                    appCompatDelegateImpl.f280.setCallback(appCompatDelegateImpl.f265);
                }
                appCompatDelegateImpl.m151();
                return;
            }
            throw new IllegalStateException("This Activity already has an action bar supplied by the window decor. Do not request Window.FEATURE_SUPPORT_ACTION_BAR and set windowActionBar to false in your theme to use a Toolbar instead.");
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m139(C1831 r1) {
        r1.m4727(this);
    }
}
