package 㿎;

import com.facebook.internal.security.CertificateUtil;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import okio.ByteString;
import ඓ.K.K.K.C1293;
import 㿎.ሽ.C2540;
import 㿎.ሽ.㳳.AbstractC2571;

/* renamed from: 㿎.ⁱ  reason: contains not printable characters */
/* compiled from: CertificatePinner */
public final class C2638 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public static final C2638 f8956 = new C2638(new LinkedHashSet(new ArrayList()), null);

    /* renamed from: ῲ  reason: contains not printable characters */
    public final AbstractC2571 f8957;

    /* renamed from: K  reason: contains not printable characters */
    public final Set<C2639> f8958;

    /* renamed from: 㿎.ⁱ$K  reason: contains not printable characters */
    /* compiled from: CertificatePinner */
    public static final class C2639 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final String f8959;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final String f8960;

        /* renamed from: K  reason: contains not printable characters */
        public final String f8961;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final ByteString f8962;

        public boolean equals(Object obj) {
            if (obj instanceof C2639) {
                C2639 k = (C2639) obj;
                return this.f8961.equals(k.f8961) && this.f8959.equals(k.f8959) && this.f8962.equals(k.f8962);
            }
        }

        public int hashCode() {
            int hashCode = this.f8959.hashCode();
            return this.f8962.hashCode() + ((hashCode + ((this.f8961.hashCode() + 527) * 31)) * 31);
        }

        public String toString() {
            return this.f8959 + this.f8962.base64();
        }
    }

    public C2638(Set<C2639> set, AbstractC2571 r2) {
        this.f8958 = set;
        this.f8957 = r2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof C2638) {
            C2638 r4 = (C2638) obj;
            if (!C2540.m6654(this.f8957, r4.f8957) || !this.f8958.equals(r4.f8958)) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        AbstractC2571 r0 = this.f8957;
        return this.f8958.hashCode() + ((r0 != null ? r0.hashCode() : 0) * 31);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m6948(String str, List<Certificate> list) throws SSLPeerUnverifiedException {
        int i;
        List emptyList = Collections.emptyList();
        Iterator<C2639> it2 = this.f8958.iterator();
        while (true) {
            r3 = false;
            boolean z = false;
            if (!it2.hasNext()) {
                break;
            }
            C2639 next = it2.next();
            if (next.f8961.startsWith("*.")) {
                int indexOf = str.indexOf(46);
                if ((str.length() - indexOf) - 1 == next.f8960.length()) {
                    String str2 = next.f8960;
                    if (str.regionMatches(false, indexOf + 1, str2, 0, str2.length())) {
                        z = true;
                    }
                }
            } else {
                z = str.equals(next.f8960);
            }
            if (z) {
                if (emptyList.isEmpty()) {
                    emptyList = new ArrayList();
                }
                emptyList.add(next);
            }
        }
        if (!emptyList.isEmpty()) {
            AbstractC2571 r1 = this.f8957;
            if (r1 != null) {
                list = r1.m6766(list, str);
            }
            int size = list.size();
            for (int i2 = 0; i2 < size; i2++) {
                X509Certificate x509Certificate = (X509Certificate) list.get(i2);
                int size2 = emptyList.size();
                ByteString byteString = null;
                ByteString byteString2 = null;
                for (int i3 = 0; i3 < size2; i3++) {
                    C2639 k = (C2639) emptyList.get(i3);
                    if (k.f8959.equals("sha256/")) {
                        if (byteString == null) {
                            byteString = ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
                        }
                        if (k.f8962.equals(byteString)) {
                            return;
                        }
                    } else if (k.f8959.equals("sha1/")) {
                        if (byteString2 == null) {
                            byteString2 = ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
                        }
                        if (k.f8962.equals(byteString2)) {
                            return;
                        }
                    } else {
                        StringBuilder r15 = C1293.m3416("unsupported hashAlgorithm: ");
                        r15.append(k.f8959);
                        throw new AssertionError(r15.toString());
                    }
                }
            }
            StringBuilder r12 = C1293.m3402("Certificate pinning failure!", "\n  Peer certificate chain:");
            int size3 = list.size();
            for (int i4 = 0; i4 < size3; i4++) {
                X509Certificate x509Certificate2 = (X509Certificate) list.get(i4);
                r12.append("\n    ");
                r12.append(m6947(x509Certificate2));
                r12.append(": ");
                r12.append(x509Certificate2.getSubjectDN().getName());
            }
            r12.append("\n  Pinned certificates for ");
            r12.append(str);
            r12.append(CertificateUtil.DELIMITER);
            int size4 = emptyList.size();
            for (i = 0; i < size4; i++) {
                r12.append("\n    ");
                r12.append((C2639) emptyList.get(i));
            }
            throw new SSLPeerUnverifiedException(r12.toString());
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static String m6947(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            StringBuilder r0 = C1293.m3416("sha256/");
            r0.append(ByteString.of(((X509Certificate) certificate).getPublicKey().getEncoded()).sha256().base64());
            return r0.toString();
        }
        throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
    }
}
