package ῲ.ῲ.K;

import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$id;
import androidx.appcompat.app.AlertController;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.widget.NestedScrollView;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import ῲ.ᨨ.ᨨ.C1729;

/* renamed from: ῲ.ῲ.K.ᕣ  reason: contains not printable characters */
/* compiled from: AlertDialog */
public class DialogInterfaceC1958 extends DialogC1947 implements DialogInterface {

    /* renamed from: ῲ  reason: contains not printable characters */
    public final AlertController f6686 = new AlertController(getContext(), this, getWindow());

    /* renamed from: ῲ.ῲ.K.ᕣ$K  reason: contains not printable characters */
    /* compiled from: AlertDialog */
    public static class C1959 {
        public final AlertController.C0036 P;
        public final int mTheme;

        public C1959(Context context) {
            this(context, DialogInterfaceC1958.m5072(context, 0));
        }

        public DialogInterfaceC1958 create() {
            ListAdapter listAdapter;
            int i;
            DialogInterfaceC1958 r0 = new DialogInterfaceC1958(this.P.f210, this.mTheme);
            AlertController.C0036 r1 = this.P;
            AlertController alertController = r0.f6686;
            View view = r1.f209;
            if (view != null) {
                alertController.f153 = view;
            } else {
                CharSequence charSequence = r1.f222;
                if (charSequence != null) {
                    alertController.m131(charSequence);
                }
                Drawable drawable = r1.f225;
                if (drawable != null) {
                    alertController.f185 = drawable;
                    alertController.f173 = 0;
                    ImageView imageView = alertController.f160;
                    if (imageView != null) {
                        imageView.setVisibility(0);
                        alertController.f160.setImageDrawable(drawable);
                    }
                }
                int i2 = r1.f189;
                if (i2 != 0) {
                    alertController.m126(i2);
                }
                int i3 = r1.f197;
                if (i3 != 0) {
                    alertController.m126(alertController.m127(i3));
                }
            }
            CharSequence charSequence2 = r1.f227;
            if (charSequence2 != null) {
                alertController.f177 = charSequence2;
                TextView textView = alertController.f166;
                if (textView != null) {
                    textView.setText(charSequence2);
                }
            }
            if (!(r1.f207 == null && r1.f220 == null)) {
                alertController.m129(-1, r1.f207, r1.f205, null, r1.f220);
            }
            if (!(r1.f214 == null && r1.f229 == null)) {
                alertController.m129(-2, r1.f214, r1.f192, null, r1.f229);
            }
            if (!(r1.f216 == null && r1.f194 == null)) {
                alertController.m129(-3, r1.f216, r1.f204, null, r1.f194);
            }
            if (!(r1.f223 == null && r1.f196 == null && r1.f203 == null)) {
                AlertController.RecycleListView recycleListView = (AlertController.RecycleListView) r1.f208.inflate(alertController.f154, (ViewGroup) null);
                if (r1.f199) {
                    Cursor cursor = r1.f196;
                    if (cursor == null) {
                        listAdapter = new C1962(r1, r1.f210, alertController.f181, 16908308, r1.f223, recycleListView);
                    } else {
                        listAdapter = new C1981(r1, r1.f210, cursor, false, recycleListView, alertController);
                    }
                } else {
                    if (r1.f202) {
                        i = alertController.f170;
                    } else {
                        i = alertController.f179;
                    }
                    Cursor cursor2 = r1.f196;
                    if (cursor2 != null) {
                        listAdapter = new SimpleCursorAdapter(r1.f210, i, cursor2, new String[]{r1.f200}, new int[]{16908308});
                    } else {
                        listAdapter = r1.f203;
                        if (listAdapter == null) {
                            listAdapter = new AlertController.C0038(r1.f210, i, 16908308, r1.f223);
                        }
                    }
                }
                alertController.f156 = listAdapter;
                alertController.f142 = r1.f190;
                if (r1.f221 != null) {
                    recycleListView.setOnItemClickListener(new C1960(r1, alertController));
                } else if (r1.f219 != null) {
                    recycleListView.setOnItemClickListener(new C1970(r1, recycleListView, alertController));
                }
                AdapterView.OnItemSelectedListener onItemSelectedListener = r1.f224;
                if (onItemSelectedListener != null) {
                    recycleListView.setOnItemSelectedListener(onItemSelectedListener);
                }
                if (r1.f202) {
                    recycleListView.setChoiceMode(1);
                } else if (r1.f199) {
                    recycleListView.setChoiceMode(2);
                }
                alertController.f164 = recycleListView;
            }
            View view2 = r1.f212;
            if (view2 == null) {
                int i4 = r1.f201;
                if (i4 != 0) {
                    alertController.f182 = null;
                    alertController.f161 = i4;
                    alertController.f144 = false;
                }
            } else if (r1.f198) {
                int i5 = r1.f213;
                int i6 = r1.f218;
                int i7 = r1.f230;
                int i8 = r1.f206;
                alertController.f182 = view2;
                alertController.f161 = 0;
                alertController.f144 = true;
                alertController.f175 = i5;
                alertController.f159 = i6;
                alertController.f169 = i7;
                alertController.f184 = i8;
            } else {
                alertController.f182 = view2;
                alertController.f161 = 0;
                alertController.f144 = false;
            }
            r0.setCancelable(this.P.f217);
            if (this.P.f217) {
                r0.setCanceledOnTouchOutside(true);
            }
            r0.setOnCancelListener(this.P.f195);
            r0.setOnDismissListener(this.P.f228);
            DialogInterface.OnKeyListener onKeyListener = this.P.f193;
            if (onKeyListener != null) {
                r0.setOnKeyListener(onKeyListener);
            }
            return r0;
        }

        public Context getContext() {
            return this.P.f210;
        }

        public C1959 setAdapter(ListAdapter listAdapter, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f203 = listAdapter;
            r0.f221 = onClickListener;
            return this;
        }

        public C1959 setCancelable(boolean z) {
            this.P.f217 = z;
            return this;
        }

        public C1959 setCursor(Cursor cursor, DialogInterface.OnClickListener onClickListener, String str) {
            AlertController.C0036 r0 = this.P;
            r0.f196 = cursor;
            r0.f200 = str;
            r0.f221 = onClickListener;
            return this;
        }

        public C1959 setCustomTitle(View view) {
            this.P.f209 = view;
            return this;
        }

        public C1959 setIcon(int i) {
            this.P.f189 = i;
            return this;
        }

        public C1959 setIconAttribute(int i) {
            TypedValue typedValue = new TypedValue();
            this.P.f210.getTheme().resolveAttribute(i, typedValue, true);
            this.P.f189 = typedValue.resourceId;
            return this;
        }

        @Deprecated
        public C1959 setInverseBackgroundForced(boolean z) {
            this.P.f215 = z;
            return this;
        }

        public C1959 setItems(int i, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f223 = r0.f210.getResources().getTextArray(i);
            this.P.f221 = onClickListener;
            return this;
        }

        public C1959 setMessage(int i) {
            AlertController.C0036 r0 = this.P;
            r0.f227 = r0.f210.getText(i);
            return this;
        }

        public C1959 setMultiChoiceItems(int i, boolean[] zArr, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f223 = r0.f210.getResources().getTextArray(i);
            AlertController.C0036 r3 = this.P;
            r3.f219 = onMultiChoiceClickListener;
            r3.f211 = zArr;
            r3.f199 = true;
            return this;
        }

        public C1959 setNegativeButton(int i, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f214 = r0.f210.getText(i);
            this.P.f192 = onClickListener;
            return this;
        }

        public C1959 setNegativeButtonIcon(Drawable drawable) {
            this.P.f229 = drawable;
            return this;
        }

        public C1959 setNeutralButton(int i, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f216 = r0.f210.getText(i);
            this.P.f204 = onClickListener;
            return this;
        }

        public C1959 setNeutralButtonIcon(Drawable drawable) {
            this.P.f194 = drawable;
            return this;
        }

        public C1959 setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.P.f195 = onCancelListener;
            return this;
        }

        public C1959 setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
            this.P.f228 = onDismissListener;
            return this;
        }

        public C1959 setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
            this.P.f224 = onItemSelectedListener;
            return this;
        }

        public C1959 setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
            this.P.f193 = onKeyListener;
            return this;
        }

        public C1959 setPositiveButton(int i, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f207 = r0.f210.getText(i);
            this.P.f205 = onClickListener;
            return this;
        }

        public C1959 setPositiveButtonIcon(Drawable drawable) {
            this.P.f220 = drawable;
            return this;
        }

        public C1959 setRecycleOnMeasureEnabled(boolean z) {
            this.P.f191 = z;
            return this;
        }

        public C1959 setSingleChoiceItems(int i, int i2, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f223 = r0.f210.getResources().getTextArray(i);
            AlertController.C0036 r3 = this.P;
            r3.f221 = onClickListener;
            r3.f190 = i2;
            r3.f202 = true;
            return this;
        }

        public C1959 setTitle(int i) {
            AlertController.C0036 r0 = this.P;
            r0.f222 = r0.f210.getText(i);
            return this;
        }

        public C1959 setView(int i) {
            AlertController.C0036 r0 = this.P;
            r0.f212 = null;
            r0.f201 = i;
            r0.f198 = false;
            return this;
        }

        public DialogInterfaceC1958 show() {
            DialogInterfaceC1958 create = create();
            create.show();
            return create;
        }

        public C1959(Context context, int i) {
            this.P = new AlertController.C0036(new ContextThemeWrapper(context, DialogInterfaceC1958.m5072(context, i)));
            this.mTheme = i;
        }

        public C1959 setIcon(Drawable drawable) {
            this.P.f225 = drawable;
            return this;
        }

        public C1959 setMessage(CharSequence charSequence) {
            this.P.f227 = charSequence;
            return this;
        }

        public C1959 setTitle(CharSequence charSequence) {
            this.P.f222 = charSequence;
            return this;
        }

        public C1959 setItems(CharSequence[] charSequenceArr, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f223 = charSequenceArr;
            r0.f221 = onClickListener;
            return this;
        }

        public C1959 setNegativeButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f214 = charSequence;
            r0.f192 = onClickListener;
            return this;
        }

        public C1959 setNeutralButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f216 = charSequence;
            r0.f204 = onClickListener;
            return this;
        }

        public C1959 setPositiveButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f207 = charSequence;
            r0.f205 = onClickListener;
            return this;
        }

        public C1959 setView(View view) {
            AlertController.C0036 r0 = this.P;
            r0.f212 = view;
            r0.f201 = 0;
            r0.f198 = false;
            return this;
        }

        public C1959 setMultiChoiceItems(CharSequence[] charSequenceArr, boolean[] zArr, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f223 = charSequenceArr;
            r0.f219 = onMultiChoiceClickListener;
            r0.f211 = zArr;
            r0.f199 = true;
            return this;
        }

        public C1959 setSingleChoiceItems(Cursor cursor, int i, String str, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f196 = cursor;
            r0.f221 = onClickListener;
            r0.f190 = i;
            r0.f200 = str;
            r0.f202 = true;
            return this;
        }

        @Deprecated
        public C1959 setView(View view, int i, int i2, int i3, int i4) {
            AlertController.C0036 r0 = this.P;
            r0.f212 = view;
            r0.f201 = 0;
            r0.f198 = true;
            r0.f213 = i;
            r0.f218 = i2;
            r0.f230 = i3;
            r0.f206 = i4;
            return this;
        }

        public C1959 setMultiChoiceItems(Cursor cursor, String str, String str2, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f196 = cursor;
            r0.f219 = onMultiChoiceClickListener;
            r0.f226 = str;
            r0.f200 = str2;
            r0.f199 = true;
            return this;
        }

        public C1959 setSingleChoiceItems(CharSequence[] charSequenceArr, int i, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f223 = charSequenceArr;
            r0.f221 = onClickListener;
            r0.f190 = i;
            r0.f202 = true;
            return this;
        }

        public C1959 setSingleChoiceItems(ListAdapter listAdapter, int i, DialogInterface.OnClickListener onClickListener) {
            AlertController.C0036 r0 = this.P;
            r0.f203 = listAdapter;
            r0.f221 = onClickListener;
            r0.f190 = i;
            r0.f202 = true;
            return this;
        }
    }

    public DialogInterfaceC1958(Context context, int i) {
        super(context, m5072(context, i));
    }

    /* renamed from: K  reason: contains not printable characters */
    public static int m5072(Context context, int i) {
        if (((i >>> 24) & BaseProgressIndicator.MAX_ALPHA) >= 1) {
            return i;
        }
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R$attr.alertDialogTheme, typedValue, true);
        return typedValue.resourceId;
    }

    @Override // ῲ.ῲ.K.DialogC1947
    public void onCreate(Bundle bundle) {
        boolean z;
        ListAdapter listAdapter;
        View view;
        View findViewById;
        super.onCreate(bundle);
        AlertController alertController = this.f6686;
        int i = alertController.f149;
        if (i == 0) {
            i = alertController.f174;
        } else if (alertController.f162 != 1) {
            i = alertController.f174;
        }
        alertController.f163.setContentView(i);
        View findViewById2 = alertController.f141.findViewById(R$id.parentPanel);
        View findViewById3 = findViewById2.findViewById(R$id.topPanel);
        View findViewById4 = findViewById2.findViewById(R$id.contentPanel);
        View findViewById5 = findViewById2.findViewById(R$id.buttonPanel);
        ViewGroup viewGroup = (ViewGroup) findViewById2.findViewById(R$id.customPanel);
        View view2 = alertController.f182;
        int i2 = 0;
        if (view2 == null) {
            view2 = alertController.f161 != 0 ? LayoutInflater.from(alertController.f165).inflate(alertController.f161, viewGroup, false) : null;
        }
        boolean z2 = view2 != null;
        if (!z2 || !AlertController.m125(view2)) {
            alertController.f141.setFlags(131072, 131072);
        }
        if (z2) {
            FrameLayout frameLayout = (FrameLayout) alertController.f141.findViewById(R$id.custom);
            frameLayout.addView(view2, new ViewGroup.LayoutParams(-1, -1));
            if (alertController.f144) {
                frameLayout.setPadding(alertController.f175, alertController.f159, alertController.f169, alertController.f184);
            }
            if (alertController.f164 != null) {
                ((LinearLayoutCompat.C0090) viewGroup.getLayoutParams()).f542 = 0.0f;
            }
        } else {
            viewGroup.setVisibility(8);
        }
        View findViewById6 = viewGroup.findViewById(R$id.topPanel);
        View findViewById7 = viewGroup.findViewById(R$id.contentPanel);
        View findViewById8 = viewGroup.findViewById(R$id.buttonPanel);
        ViewGroup r4 = alertController.m128(findViewById6, findViewById3);
        ViewGroup r5 = alertController.m128(findViewById7, findViewById4);
        ViewGroup r6 = alertController.m128(findViewById8, findViewById5);
        alertController.f168 = (NestedScrollView) alertController.f141.findViewById(R$id.scrollView);
        alertController.f168.setFocusable(false);
        alertController.f168.setNestedScrollingEnabled(false);
        alertController.f166 = (TextView) r5.findViewById(16908299);
        TextView textView = alertController.f166;
        if (textView != null) {
            CharSequence charSequence = alertController.f177;
            if (charSequence != null) {
                textView.setText(charSequence);
            } else {
                textView.setVisibility(8);
                alertController.f168.removeView(alertController.f166);
                if (alertController.f164 != null) {
                    ViewGroup viewGroup2 = (ViewGroup) alertController.f168.getParent();
                    int indexOfChild = viewGroup2.indexOfChild(alertController.f168);
                    viewGroup2.removeViewAt(indexOfChild);
                    viewGroup2.addView(alertController.f164, indexOfChild, new ViewGroup.LayoutParams(-1, -1));
                } else {
                    r5.setVisibility(8);
                }
            }
        }
        alertController.f171 = (Button) r6.findViewById(16908313);
        alertController.f171.setOnClickListener(alertController.f151);
        if (!TextUtils.isEmpty(alertController.f146) || alertController.f172 != null) {
            alertController.f171.setText(alertController.f146);
            Drawable drawable = alertController.f172;
            if (drawable != null) {
                int i3 = alertController.f180;
                drawable.setBounds(0, 0, i3, i3);
                alertController.f171.setCompoundDrawables(alertController.f172, null, null, null);
            }
            alertController.f171.setVisibility(0);
            z = true;
        } else {
            alertController.f171.setVisibility(8);
            z = false;
        }
        alertController.f147 = (Button) r6.findViewById(16908314);
        alertController.f147.setOnClickListener(alertController.f151);
        if (!TextUtils.isEmpty(alertController.f183) || alertController.f178 != null) {
            alertController.f147.setText(alertController.f183);
            Drawable drawable2 = alertController.f178;
            if (drawable2 != null) {
                int i4 = alertController.f180;
                drawable2.setBounds(0, 0, i4, i4);
                alertController.f147.setCompoundDrawables(alertController.f178, null, null, null);
            }
            alertController.f147.setVisibility(0);
            z |= true;
        } else {
            alertController.f147.setVisibility(8);
        }
        alertController.f157 = (Button) r6.findViewById(16908315);
        alertController.f157.setOnClickListener(alertController.f151);
        if (!TextUtils.isEmpty(alertController.f176) || alertController.f167 != null) {
            alertController.f157.setText(alertController.f176);
            Drawable drawable3 = alertController.f167;
            if (drawable3 != null) {
                int i5 = alertController.f180;
                drawable3.setBounds(0, 0, i5, i5);
                alertController.f157.setCompoundDrawables(alertController.f167, null, null, null);
            }
            alertController.f157.setVisibility(0);
            z |= true;
        } else {
            alertController.f157.setVisibility(8);
        }
        Context context = alertController.f165;
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R$attr.alertDialogCenterButtons, typedValue, true);
        if (typedValue.data != 0) {
            if (z) {
                alertController.m130(alertController.f171);
            } else if (z) {
                alertController.m130(alertController.f147);
            } else if (z) {
                alertController.m130(alertController.f157);
            }
        }
        if (!(z)) {
            r6.setVisibility(8);
        }
        if (alertController.f153 != null) {
            r4.addView(alertController.f153, 0, new ViewGroup.LayoutParams(-1, -2));
            alertController.f141.findViewById(R$id.title_template).setVisibility(8);
        } else {
            alertController.f160 = (ImageView) alertController.f141.findViewById(16908294);
            if (!(!TextUtils.isEmpty(alertController.f150)) || !alertController.f143) {
                alertController.f141.findViewById(R$id.title_template).setVisibility(8);
                alertController.f160.setVisibility(8);
                r4.setVisibility(8);
            } else {
                alertController.f152 = (TextView) alertController.f141.findViewById(R$id.alertTitle);
                alertController.f152.setText(alertController.f150);
                int i6 = alertController.f173;
                if (i6 != 0) {
                    alertController.f160.setImageResource(i6);
                } else {
                    Drawable drawable4 = alertController.f185;
                    if (drawable4 != null) {
                        alertController.f160.setImageDrawable(drawable4);
                    } else {
                        alertController.f152.setPadding(alertController.f160.getPaddingLeft(), alertController.f160.getPaddingTop(), alertController.f160.getPaddingRight(), alertController.f160.getPaddingBottom());
                        alertController.f160.setVisibility(8);
                    }
                }
            }
        }
        boolean z3 = viewGroup.getVisibility() != 8;
        boolean z4 = (r4 == null || r4.getVisibility() == 8) ? false : true;
        boolean z5 = r6.getVisibility() != 8;
        if (!z5 && (findViewById = r5.findViewById(R$id.textSpacerNoButtons)) != null) {
            findViewById.setVisibility(0);
        }
        if (z4) {
            NestedScrollView nestedScrollView = alertController.f168;
            if (nestedScrollView != null) {
                nestedScrollView.setClipToPadding(true);
            }
            if (alertController.f177 == null && alertController.f164 == null) {
                view = null;
            } else {
                view = r4.findViewById(R$id.titleDividerNoCustom);
            }
            if (view != null) {
                view.setVisibility(0);
            }
        } else {
            View findViewById9 = r5.findViewById(R$id.textSpacerNoTitle);
            if (findViewById9 != null) {
                findViewById9.setVisibility(0);
            }
        }
        ListView listView = alertController.f164;
        if (listView instanceof AlertController.RecycleListView) {
            ((AlertController.RecycleListView) listView).m132(z4, z5);
        }
        if (!z3) {
            View view3 = alertController.f164;
            if (view3 == null) {
                view3 = alertController.f168;
            }
            if (view3 != null) {
                if (z5) {
                    i2 = 2;
                }
                int i7 = z4 ? 1 : 0;
                char c = z4 ? 1 : 0;
                char c2 = z4 ? 1 : 0;
                int i8 = i7 | i2;
                View findViewById10 = alertController.f141.findViewById(R$id.scrollIndicatorUp);
                View findViewById11 = alertController.f141.findViewById(R$id.scrollIndicatorDown);
                if (Build.VERSION.SDK_INT >= 23) {
                    C1729.m4473(view3, i8, 3);
                    if (findViewById10 != null) {
                        r5.removeView(findViewById10);
                    }
                    if (findViewById11 != null) {
                        r5.removeView(findViewById11);
                    }
                } else {
                    if (findViewById10 != null && (i8 & 1) == 0) {
                        r5.removeView(findViewById10);
                        findViewById10 = null;
                    }
                    if (findViewById11 != null && (i8 & 2) == 0) {
                        r5.removeView(findViewById11);
                        findViewById11 = null;
                    }
                    if (!(findViewById10 == null && findViewById11 == null)) {
                        if (alertController.f177 != null) {
                            alertController.f168.setOnScrollChangeListener(new C1942(alertController, findViewById10, findViewById11));
                            alertController.f168.post(new RunnableC1980(alertController, findViewById10, findViewById11));
                        } else {
                            ListView listView2 = alertController.f164;
                            if (listView2 != null) {
                                listView2.setOnScrollListener(new C1949(alertController, findViewById10, findViewById11));
                                alertController.f164.post(new RunnableC1973(alertController, findViewById10, findViewById11));
                            } else {
                                if (findViewById10 != null) {
                                    r5.removeView(findViewById10);
                                }
                                if (findViewById11 != null) {
                                    r5.removeView(findViewById11);
                                }
                            }
                        }
                    }
                }
            }
        }
        ListView listView3 = alertController.f164;
        if (listView3 != null && (listAdapter = alertController.f156) != null) {
            listView3.setAdapter(listAdapter);
            int i9 = alertController.f142;
            if (i9 > -1) {
                listView3.setItemChecked(i9, true);
                listView3.setSelection(i9);
            }
        }
    }

    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        NestedScrollView nestedScrollView = this.f6686.f168;
        if (nestedScrollView != null && nestedScrollView.m633(keyEvent)) {
            return true;
        }
        return super.onKeyDown(i, keyEvent);
    }

    public boolean onKeyUp(int i, KeyEvent keyEvent) {
        NestedScrollView nestedScrollView = this.f6686.f168;
        if (nestedScrollView != null && nestedScrollView.m633(keyEvent)) {
            return true;
        }
        return super.onKeyUp(i, keyEvent);
    }

    @Override // android.app.Dialog, ῲ.ῲ.K.DialogC1947
    public void setTitle(CharSequence charSequence) {
        super.setTitle(charSequence);
        AlertController alertController = this.f6686;
        alertController.f150 = charSequence;
        TextView textView = alertController.f152;
        if (textView != null) {
            textView.setText(charSequence);
        }
    }
}
