package ῲ.ᨨ.ᨨ;

import android.os.Build;
import android.os.Bundle;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import androidx.core.R$id;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ῲ.ᨨ.ᨨ.䃖.AbstractC1787;
import ῲ.ᨨ.ᨨ.䃖.C1778;
import ῲ.ᨨ.ᨨ.䃖.C1782;

/* renamed from: ῲ.ᨨ.ᨨ.K  reason: contains not printable characters */
/* compiled from: AccessibilityDelegateCompat */
public class C1747 {
    public static final View.AccessibilityDelegate DEFAULT_DELEGATE = new View.AccessibilityDelegate();
    public final View.AccessibilityDelegate mBridge;
    public final View.AccessibilityDelegate mOriginalDelegate;

    /* renamed from: ῲ.ᨨ.ᨨ.K$K  reason: contains not printable characters */
    /* compiled from: AccessibilityDelegateCompat */
    public static final class C1748 extends View.AccessibilityDelegate {

        /* renamed from: K  reason: contains not printable characters */
        public final C1747 f6064;

        public C1748(C1747 k) {
            this.f6064 = k;
        }

        public boolean dispatchPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            return this.f6064.dispatchPopulateAccessibilityEvent(view, accessibilityEvent);
        }

        public AccessibilityNodeProvider getAccessibilityNodeProvider(View view) {
            C1778 accessibilityNodeProvider = this.f6064.getAccessibilityNodeProvider(view);
            if (accessibilityNodeProvider != null) {
                return (AccessibilityNodeProvider) accessibilityNodeProvider.f6119;
            }
            return null;
        }

        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            this.f6064.onInitializeAccessibilityEvent(view, accessibilityEvent);
        }

        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            boolean z;
            int i;
            C1782 r1 = new C1782(accessibilityNodeInfo);
            boolean r3 = C1729.m4492(view);
            boolean z2 = true;
            if (Build.VERSION.SDK_INT >= 28) {
                r1.f6124.setScreenReaderFocusable(r3);
            } else {
                r1.m4661(1, r3);
            }
            Boolean r32 = C1729.m4467().m4513(view);
            if (r32 == null) {
                z = false;
            } else {
                z = r32.booleanValue();
            }
            if (Build.VERSION.SDK_INT >= 28) {
                r1.f6124.setHeading(z);
            } else {
                r1.m4661(2, z);
            }
            CharSequence r33 = C1729.m4505(view);
            if (Build.VERSION.SDK_INT >= 28) {
                r1.f6124.setPaneTitle(r33);
            } else {
                r1.f6124.getExtras().putCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.PANE_TITLE_KEY", r33);
            }
            CharSequence charSequence = (CharSequence) new C1776(R$id.tag_state_description, CharSequence.class, 64, 30).m4513(view);
            if (Build.VERSION.SDK_INT < 30) {
                z2 = false;
            }
            if (z2) {
                r1.f6124.setStateDescription(charSequence);
            } else {
                int i2 = Build.VERSION.SDK_INT;
                r1.f6124.getExtras().putCharSequence("androidx.view.accessibility.AccessibilityNodeInfoCompat.STATE_DESCRIPTION_KEY", charSequence);
            }
            this.f6064.onInitializeAccessibilityNodeInfo(view, r1);
            CharSequence text = accessibilityNodeInfo.getText();
            if (Build.VERSION.SDK_INT < 26) {
                r1.f6124.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_START_KEY");
                r1.f6124.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_END_KEY");
                r1.f6124.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_FLAGS_KEY");
                r1.f6124.getExtras().remove("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ID_KEY");
                SparseArray<WeakReference<ClickableSpan>> r5 = r1.m4659(view);
                if (r5 != null) {
                    ArrayList arrayList = new ArrayList();
                    for (int i3 = 0; i3 < r5.size(); i3++) {
                        if (r5.valueAt(i3).get() == null) {
                            arrayList.add(Integer.valueOf(i3));
                        }
                    }
                    for (int i4 = 0; i4 < arrayList.size(); i4++) {
                        r5.remove(((Integer) arrayList.get(i4)).intValue());
                    }
                }
                ClickableSpan[] r52 = C1782.m4644(text);
                if (r52 != null && r52.length > 0) {
                    r1.m4670().putInt("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ACTION_ID_KEY", R$id.accessibility_action_clickable_span);
                    SparseArray<WeakReference<ClickableSpan>> r10 = r1.m4659(view);
                    if (r10 == null) {
                        r10 = new SparseArray<>();
                        view.setTag(R$id.tag_accessibility_clickable_spans, r10);
                    }
                    for (int i5 = 0; i5 < r52.length; i5++) {
                        ClickableSpan clickableSpan = r52[i5];
                        int i6 = 0;
                        while (true) {
                            if (i6 >= r10.size()) {
                                i = C1782.f6121;
                                C1782.f6121 = i + 1;
                                break;
                            } else if (clickableSpan.equals(r10.valueAt(i6).get())) {
                                i = r10.keyAt(i6);
                                break;
                            } else {
                                i6++;
                            }
                        }
                        r10.put(i, new WeakReference<>(r52[i5]));
                        ClickableSpan clickableSpan2 = r52[i5];
                        Spanned spanned = (Spanned) text;
                        r1.m4660("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_START_KEY").add(Integer.valueOf(spanned.getSpanStart(clickableSpan2)));
                        r1.m4660("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_END_KEY").add(Integer.valueOf(spanned.getSpanEnd(clickableSpan2)));
                        r1.m4660("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_FLAGS_KEY").add(Integer.valueOf(spanned.getSpanFlags(clickableSpan2)));
                        r1.m4660("androidx.view.accessibility.AccessibilityNodeInfoCompat.SPANS_ID_KEY").add(Integer.valueOf(i));
                    }
                }
            }
            List<C1782.C1785> actionList = C1747.getActionList(view);
            for (int i7 = 0; i7 < actionList.size(); i7++) {
                r1.m4664(actionList.get(i7));
            }
        }

        public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            this.f6064.onPopulateAccessibilityEvent(view, accessibilityEvent);
        }

        public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            return this.f6064.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
        }

        public boolean performAccessibilityAction(View view, int i, Bundle bundle) {
            return this.f6064.performAccessibilityAction(view, i, bundle);
        }

        public void sendAccessibilityEvent(View view, int i) {
            this.f6064.sendAccessibilityEvent(view, i);
        }

        public void sendAccessibilityEventUnchecked(View view, AccessibilityEvent accessibilityEvent) {
            this.f6064.sendAccessibilityEventUnchecked(view, accessibilityEvent);
        }
    }

    public C1747() {
        this(DEFAULT_DELEGATE);
    }

    public static List<C1782.C1785> getActionList(View view) {
        List<C1782.C1785> list = (List) view.getTag(R$id.tag_accessibility_actions);
        return list == null ? Collections.emptyList() : list;
    }

    private boolean isSpanStillValid(ClickableSpan clickableSpan, View view) {
        if (clickableSpan != null) {
            ClickableSpan[] r5 = C1782.m4644(view.createAccessibilityNodeInfo().getText());
            int i = 0;
            while (r5 != null && i < r5.length) {
                if (clickableSpan.equals(r5[i])) {
                    return true;
                }
                i++;
            }
        }
        return false;
    }

    private boolean performClickableSpanAction(int i, View view) {
        WeakReference weakReference;
        SparseArray sparseArray = (SparseArray) view.getTag(R$id.tag_accessibility_clickable_spans);
        if (sparseArray == null || (weakReference = (WeakReference) sparseArray.get(i)) == null) {
            return false;
        }
        ClickableSpan clickableSpan = (ClickableSpan) weakReference.get();
        if (!isSpanStillValid(clickableSpan, view)) {
            return false;
        }
        clickableSpan.onClick(view);
        return true;
    }

    public boolean dispatchPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        return this.mOriginalDelegate.dispatchPopulateAccessibilityEvent(view, accessibilityEvent);
    }

    public C1778 getAccessibilityNodeProvider(View view) {
        int i = Build.VERSION.SDK_INT;
        AccessibilityNodeProvider accessibilityNodeProvider = this.mOriginalDelegate.getAccessibilityNodeProvider(view);
        if (accessibilityNodeProvider != null) {
            return new C1778(accessibilityNodeProvider);
        }
        return null;
    }

    public View.AccessibilityDelegate getBridge() {
        return this.mBridge;
    }

    public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        this.mOriginalDelegate.onInitializeAccessibilityEvent(view, accessibilityEvent);
    }

    public void onInitializeAccessibilityNodeInfo(View view, C1782 r3) {
        this.mOriginalDelegate.onInitializeAccessibilityNodeInfo(view, r3.f6124);
    }

    public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        this.mOriginalDelegate.onPopulateAccessibilityEvent(view, accessibilityEvent);
    }

    public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
        return this.mOriginalDelegate.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
    }

    /* JADX WARNING: Removed duplicated region for block: B:25:0x0069  */
    public boolean performAccessibilityAction(View view, int i, Bundle bundle) {
        AbstractC1787.AbstractC1792 k;
        Exception e;
        String str;
        List<C1782.C1785> actionList = getActionList(view);
        boolean z = false;
        int i2 = 0;
        while (true) {
            if (i2 >= actionList.size()) {
                break;
            }
            C1782.C1785 k2 = actionList.get(i2);
            if (k2.m4674() != i) {
                i2++;
            } else if (k2.f6141 != null) {
                Class<? extends AbstractC1787.AbstractC1792> cls = k2.f6138;
                if (cls != null) {
                    try {
                        k = (AbstractC1787.AbstractC1792) cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        try {
                            k.m4675(bundle);
                        } catch (Exception e2) {
                            e = e2;
                        }
                    } catch (Exception e3) {
                        k = null;
                        e = e3;
                        Class<? extends AbstractC1787.AbstractC1792> cls2 = k2.f6138;
                        if (cls2 == null) {
                            str = "null";
                        } else {
                            str = cls2.getName();
                        }
                        Log.e("A11yActionCompat", "Failed to execute command with argument class ViewCommandArgument: " + str, e);
                        z = k2.f6141.perform(view, k);
                        if (!z) {
                        }
                        return z ? z : z;
                    }
                } else {
                    k = null;
                }
                z = k2.f6141.perform(view, k);
            }
        }
        if (!z) {
            int i3 = Build.VERSION.SDK_INT;
            z = this.mOriginalDelegate.performAccessibilityAction(view, i, bundle);
        }
        if (z && i == R$id.accessibility_action_clickable_span) {
            return performClickableSpanAction(bundle.getInt("ACCESSIBILITY_CLICKABLE_SPAN_ID", -1), view);
        }
    }

    public void sendAccessibilityEvent(View view, int i) {
        this.mOriginalDelegate.sendAccessibilityEvent(view, i);
    }

    public void sendAccessibilityEventUnchecked(View view, AccessibilityEvent accessibilityEvent) {
        this.mOriginalDelegate.sendAccessibilityEventUnchecked(view, accessibilityEvent);
    }

    public C1747(View.AccessibilityDelegate accessibilityDelegate) {
        this.mOriginalDelegate = accessibilityDelegate;
        this.mBridge = new C1748(this);
    }
}
