package retrofit2.converter.scalars;

import java.io.IOException;
import retrofit2.Converter;
import ඓ.K.K.K.C1293;
import 㿎.AbstractC2632;

public final class ScalarResponseBodyConverters {

    public static final class BooleanResponseBodyConverter implements Converter<AbstractC2632, Boolean> {
        public static final BooleanResponseBodyConverter INSTANCE = new BooleanResponseBodyConverter();

        public Boolean convert(AbstractC2632 r1) throws IOException {
            return Boolean.valueOf(r1.string());
        }
    }

    public static final class ByteResponseBodyConverter implements Converter<AbstractC2632, Byte> {
        public static final ByteResponseBodyConverter INSTANCE = new ByteResponseBodyConverter();

        public Byte convert(AbstractC2632 r1) throws IOException {
            return Byte.valueOf(r1.string());
        }
    }

    public static final class CharacterResponseBodyConverter implements Converter<AbstractC2632, Character> {
        public static final CharacterResponseBodyConverter INSTANCE = new CharacterResponseBodyConverter();

        public Character convert(AbstractC2632 r3) throws IOException {
            String string = r3.string();
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            StringBuilder r1 = C1293.m3416("Expected body of length 1 for Character conversion but was ");
            r1.append(string.length());
            throw new IOException(r1.toString());
        }
    }

    public static final class DoubleResponseBodyConverter implements Converter<AbstractC2632, Double> {
        public static final DoubleResponseBodyConverter INSTANCE = new DoubleResponseBodyConverter();

        public Double convert(AbstractC2632 r1) throws IOException {
            return Double.valueOf(r1.string());
        }
    }

    public static final class FloatResponseBodyConverter implements Converter<AbstractC2632, Float> {
        public static final FloatResponseBodyConverter INSTANCE = new FloatResponseBodyConverter();

        public Float convert(AbstractC2632 r1) throws IOException {
            return Float.valueOf(r1.string());
        }
    }

    public static final class IntegerResponseBodyConverter implements Converter<AbstractC2632, Integer> {
        public static final IntegerResponseBodyConverter INSTANCE = new IntegerResponseBodyConverter();

        public Integer convert(AbstractC2632 r1) throws IOException {
            return Integer.valueOf(r1.string());
        }
    }

    public static final class LongResponseBodyConverter implements Converter<AbstractC2632, Long> {
        public static final LongResponseBodyConverter INSTANCE = new LongResponseBodyConverter();

        public Long convert(AbstractC2632 r1) throws IOException {
            return Long.valueOf(r1.string());
        }
    }

    public static final class ShortResponseBodyConverter implements Converter<AbstractC2632, Short> {
        public static final ShortResponseBodyConverter INSTANCE = new ShortResponseBodyConverter();

        public Short convert(AbstractC2632 r1) throws IOException {
            return Short.valueOf(r1.string());
        }
    }

    public static final class StringResponseBodyConverter implements Converter<AbstractC2632, String> {
        public static final StringResponseBodyConverter INSTANCE = new StringResponseBodyConverter();

        public String convert(AbstractC2632 r1) throws IOException {
            return r1.string();
        }
    }
}
