package retrofit2.converter.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import java.io.IOException;
import retrofit2.Converter;
import 㿎.AbstractC2632;

public final class GsonResponseBodyConverter<T> implements Converter<AbstractC2632, T> {
    public final TypeAdapter<T> adapter;
    public final Gson gson;

    public GsonResponseBodyConverter(Gson gson2, TypeAdapter<T> typeAdapter) {
        this.gson = gson2;
        this.adapter = typeAdapter;
    }

    public T convert(AbstractC2632 r3) throws IOException {
        try {
            return this.adapter.read(this.gson.newJsonReader(r3.charStream()));
        } finally {
            r3.close();
        }
    }
}
