package retrofit2.converter.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import retrofit2.Converter;
import ᨨ.C1476;
import ᨨ.C1492;
import 㿎.AbstractC2651;
import 㿎.C2628;

public final class GsonRequestBodyConverter<T> implements Converter<T, AbstractC2651> {
    public static final C2628 MEDIA_TYPE = C2628.m6936("application/json; charset=UTF-8");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public final TypeAdapter<T> adapter;
    public final Gson gson;

    public GsonRequestBodyConverter(Gson gson2, TypeAdapter<T> typeAdapter) {
        this.gson = gson2;
        this.adapter = typeAdapter;
    }

    @Override // retrofit2.Converter
    public AbstractC2651 convert(T t) throws IOException {
        C1492 r0 = new C1492();
        JsonWriter newJsonWriter = this.gson.newJsonWriter(new OutputStreamWriter(new C1476(r0), UTF_8));
        this.adapter.write(newJsonWriter, t);
        newJsonWriter.close();
        return AbstractC2651.create(MEDIA_TYPE, r0.m3772());
    }
}
