package okio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import ᨨ.C1475;
import ᨨ.C1491;
import ᨨ.C1492;

public final class SegmentedByteString extends ByteString {
    public final transient int[] directory;
    public final transient byte[][] segments;

    public SegmentedByteString(C1492 r8, int i) {
        super(null);
        C1491.m3764(r8.f5529, 0, (long) i);
        int i2 = 0;
        C1475 r3 = r8.f5530;
        int i3 = 0;
        int i4 = 0;
        while (i3 < i) {
            int i5 = r3.f5494;
            int i6 = r3.f5496;
            if (i5 != i6) {
                i3 += i5 - i6;
                i4++;
                r3 = r3.f5499;
            } else {
                throw new AssertionError("s.limit == s.pos");
            }
        }
        this.segments = new byte[i4][];
        this.directory = new int[(i4 * 2)];
        C1475 r0 = r8.f5530;
        int i7 = 0;
        while (i2 < i) {
            this.segments[i7] = r0.f5498;
            i2 += r0.f5494 - r0.f5496;
            if (i2 > i) {
                i2 = i;
            }
            int[] iArr = this.directory;
            iArr[i7] = i2;
            iArr[this.segments.length + i7] = r0.f5496;
            r0.f5500 = true;
            i7++;
            r0 = r0.f5499;
        }
    }

    private Object writeReplace() {
        return m2011();
    }

    @Override // okio.ByteString
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(toByteArray()).asReadOnlyBuffer();
    }

    @Override // okio.ByteString
    public String base64() {
        return m2011().base64();
    }

    @Override // okio.ByteString
    public String base64Url() {
        return m2011().base64Url();
    }

    @Override // okio.ByteString
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteString) {
            ByteString byteString = (ByteString) obj;
            if (byteString.size() != size() || !rangeEquals(0, byteString, 0, size())) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override // okio.ByteString
    public byte getByte(int i) {
        int i2;
        C1491.m3764((long) this.directory[this.segments.length - 1], (long) i, 1);
        int r0 = m2010(i);
        if (r0 == 0) {
            i2 = 0;
        } else {
            i2 = this.directory[r0 - 1];
        }
        int[] iArr = this.directory;
        byte[][] bArr = this.segments;
        return bArr[r0][(i - i2) + iArr[bArr.length + r0]];
    }

    @Override // okio.ByteString
    public int hashCode() {
        int i = this.hashCode;
        if (i != 0) {
            return i;
        }
        int length = this.segments.length;
        int i2 = 0;
        int i3 = 1;
        int i4 = 0;
        while (i2 < length) {
            byte[] bArr = this.segments[i2];
            int[] iArr = this.directory;
            int i5 = iArr[length + i2];
            int i6 = iArr[i2];
            int i7 = (i6 - i4) + i5;
            while (i5 < i7) {
                i3 = (i3 * 31) + bArr[i5];
                i5++;
            }
            i2++;
            i4 = i6;
        }
        this.hashCode = i3;
        return i3;
    }

    @Override // okio.ByteString
    public String hex() {
        return m2011().hex();
    }

    @Override // okio.ByteString
    public ByteString hmacSha1(ByteString byteString) {
        return m2011().hmacSha1(byteString);
    }

    @Override // okio.ByteString
    public ByteString hmacSha256(ByteString byteString) {
        return m2011().hmacSha256(byteString);
    }

    @Override // okio.ByteString
    public int indexOf(byte[] bArr, int i) {
        return m2011().indexOf(bArr, i);
    }

    @Override // okio.ByteString
    public byte[] internalArray() {
        return toByteArray();
    }

    @Override // okio.ByteString
    public int lastIndexOf(byte[] bArr, int i) {
        return m2011().lastIndexOf(bArr, i);
    }

    @Override // okio.ByteString
    public ByteString md5() {
        return m2011().md5();
    }

    @Override // okio.ByteString
    public boolean rangeEquals(int i, ByteString byteString, int i2, int i3) {
        int i4;
        if (i < 0 || i > size() - i3) {
            return false;
        }
        int r1 = m2010(i);
        while (i3 > 0) {
            if (r1 == 0) {
                i4 = 0;
            } else {
                i4 = this.directory[r1 - 1];
            }
            int min = Math.min(i3, ((this.directory[r1] - i4) + i4) - i);
            int[] iArr = this.directory;
            byte[][] bArr = this.segments;
            if (!byteString.rangeEquals(i2, bArr[r1], (i - i4) + iArr[bArr.length + r1], min)) {
                return false;
            }
            i += min;
            i2 += min;
            i3 -= min;
            r1++;
        }
        return true;
    }

    @Override // okio.ByteString
    public ByteString sha1() {
        return m2011().sha1();
    }

    @Override // okio.ByteString
    public ByteString sha256() {
        return m2011().sha256();
    }

    @Override // okio.ByteString
    public int size() {
        return this.directory[this.segments.length - 1];
    }

    @Override // okio.ByteString
    public String string(Charset charset) {
        return m2011().string(charset);
    }

    @Override // okio.ByteString
    public ByteString substring(int i) {
        return m2011().substring(i);
    }

    @Override // okio.ByteString
    public ByteString toAsciiLowercase() {
        return m2011().toAsciiLowercase();
    }

    @Override // okio.ByteString
    public ByteString toAsciiUppercase() {
        return m2011().toAsciiUppercase();
    }

    @Override // okio.ByteString
    public byte[] toByteArray() {
        int[] iArr = this.directory;
        byte[][] bArr = this.segments;
        byte[] bArr2 = new byte[iArr[bArr.length - 1]];
        int length = bArr.length;
        int i = 0;
        int i2 = 0;
        while (i < length) {
            int[] iArr2 = this.directory;
            int i3 = iArr2[length + i];
            int i4 = iArr2[i];
            System.arraycopy(this.segments[i], i3, bArr2, i2, i4 - i2);
            i++;
            i2 = i4;
        }
        return bArr2;
    }

    @Override // okio.ByteString
    public String toString() {
        return m2011().toString();
    }

    @Override // okio.ByteString
    public String utf8() {
        return m2011().utf8();
    }

    @Override // okio.ByteString
    public void write(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            int length = this.segments.length;
            int i = 0;
            int i2 = 0;
            while (i < length) {
                int[] iArr = this.directory;
                int i3 = iArr[length + i];
                int i4 = iArr[i];
                outputStream.write(this.segments[i], i3, i4 - i2);
                i++;
                i2 = i4;
            }
            return;
        }
        throw new IllegalArgumentException("out == null");
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m2010(int i) {
        int binarySearch = Arrays.binarySearch(this.directory, 0, this.segments.length, i + 1);
        return binarySearch >= 0 ? binarySearch : ~binarySearch;
    }

    @Override // okio.ByteString
    public ByteString substring(int i, int i2) {
        return m2011().substring(i, i2);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final ByteString m2011() {
        return new ByteString(toByteArray());
    }

    @Override // okio.ByteString
    public void write(C1492 r12) {
        int length = this.segments.length;
        int i = 0;
        int i2 = 0;
        while (i < length) {
            int[] iArr = this.directory;
            int i3 = iArr[length + i];
            int i4 = iArr[i];
            C1475 r4 = new C1475(this.segments[i], i3, (i3 + i4) - i2, true, false);
            C1475 r2 = r12.f5530;
            if (r2 == null) {
                r4.f5497 = r4;
                r4.f5499 = r4;
                r12.f5530 = r4;
            } else {
                r2.f5497.m3698(r4);
            }
            i++;
            i2 = i4;
        }
        r12.f5529 += (long) i2;
    }

    @Override // okio.ByteString
    public boolean rangeEquals(int i, byte[] bArr, int i2, int i3) {
        int i4;
        if (i < 0 || i > size() - i3 || i2 < 0 || i2 > bArr.length - i3) {
            return false;
        }
        int r1 = m2010(i);
        while (i3 > 0) {
            if (r1 == 0) {
                i4 = 0;
            } else {
                i4 = this.directory[r1 - 1];
            }
            int min = Math.min(i3, ((this.directory[r1] - i4) + i4) - i);
            int[] iArr = this.directory;
            byte[][] bArr2 = this.segments;
            if (!C1491.m3766(bArr2[r1], (i - i4) + iArr[bArr2.length + r1], bArr, i2, min)) {
                return false;
            }
            i += min;
            i2 += min;
            i3 -= min;
            r1++;
        }
        return true;
    }
}
