package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ඓ.K.K.K.C1293;

public enum TlsVersion {
    TLS_1_3("TLSv1.3"),
    TLS_1_2("TLSv1.2"),
    TLS_1_1("TLSv1.1"),
    TLS_1_0("TLSv1"),
    SSL_3_0("SSLv3");
    
    public final String javaName;

    /* access modifiers changed from: public */
    TlsVersion(String str) {
        this.javaName = str;
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* JADX WARNING: Removed duplicated region for block: B:22:0x004b  */
    /* JADX WARNING: Removed duplicated region for block: B:36:0x006b  */
    public static TlsVersion forJavaName(String str) {
        char c;
        int hashCode = str.hashCode();
        if (hashCode != 79201641) {
            if (hashCode != 79923350) {
                switch (hashCode) {
                    case -503070503:
                        if (str.equals("TLSv1.1")) {
                            c = 2;
                            break;
                        }
                        break;
                    case -503070502:
                        if (str.equals("TLSv1.2")) {
                            c = 1;
                            break;
                        }
                        break;
                    case -503070501:
                        if (str.equals("TLSv1.3")) {
                            c = 0;
                            break;
                        }
                        break;
                }
                if (c != 0) {
                    return TLS_1_3;
                }
                if (c == 1) {
                    return TLS_1_2;
                }
                if (c == 2) {
                    return TLS_1_1;
                }
                if (c == 3) {
                    return TLS_1_0;
                }
                if (c == 4) {
                    return SSL_3_0;
                }
                throw new IllegalArgumentException(C1293.m3412("Unexpected TLS version: ", str));
            } else if (str.equals("TLSv1")) {
                c = 3;
                if (c != 0) {
                }
            }
        } else if (str.equals("SSLv3")) {
            c = 4;
            if (c != 0) {
            }
        }
        c = 65535;
        if (c != 0) {
        }
    }

    public static List<TlsVersion> forJavaNames(String... strArr) {
        ArrayList arrayList = new ArrayList(strArr.length);
        for (String str : strArr) {
            arrayList.add(forJavaName(str));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String javaName() {
        return this.javaName;
    }
}
