package io.reactivex.subjects;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.AbstractC2520;
import 㴹.K.ᓣ.AbstractC2501;
import 㴹.K.㑃.AbstractC2514;

public final class PublishSubject<T> extends AbstractC2501<T> {

    /* renamed from: ඓ  reason: contains not printable characters */
    public static final PublishDisposable[] f3446 = new PublishDisposable[0];

    /* renamed from: 㸾  reason: contains not printable characters */
    public static final PublishDisposable[] f3447 = new PublishDisposable[0];

    /* renamed from: ʬ  reason: contains not printable characters */
    public Throwable f3448;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final AtomicReference<PublishDisposable<T>[]> f3449 = new AtomicReference<>(f3446);

    public static final class PublishDisposable<T> extends AtomicBoolean implements AbstractC2514 {
        public static final long serialVersionUID = 3562861878281475070L;
        public final AbstractC2520<? super T> actual;
        public final PublishSubject<T> parent;

        public PublishDisposable(AbstractC2520<? super T> r1, PublishSubject<T> publishSubject) {
            this.actual = r1;
            this.parent = publishSubject;
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public void dispose() {
            if (compareAndSet(false, true)) {
                this.parent.m1959((PublishDisposable) this);
            }
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public boolean isDisposed() {
            return get();
        }

        public void onComplete() {
            if (!get()) {
                this.actual.onComplete();
            }
        }

        public void onError(Throwable th) {
            if (get()) {
                C1252.m3349(th);
            } else {
                this.actual.onError(th);
            }
        }

        public void onNext(T t) {
            if (!get()) {
                this.actual.onNext(t);
            }
        }
    }

    @Override // 㴹.K.AbstractC2520
    public void onComplete() {
        PublishDisposable<T>[] publishDisposableArr = this.f3449.get();
        PublishDisposable<T>[] publishDisposableArr2 = f3447;
        if (publishDisposableArr != publishDisposableArr2) {
            for (PublishDisposable<T> publishDisposable : this.f3449.getAndSet(publishDisposableArr2)) {
                publishDisposable.onComplete();
            }
        }
    }

    @Override // 㴹.K.AbstractC2520
    public void onError(Throwable th) {
        if (this.f3449.get() == f3447) {
            C1252.m3349(th);
            return;
        }
        if (th == null) {
            th = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        this.f3448 = th;
        for (PublishDisposable<T> publishDisposable : this.f3449.getAndSet(f3447)) {
            publishDisposable.onError(th);
        }
    }

    @Override // 㴹.K.AbstractC2520
    public void onNext(T t) {
        if (this.f3449.get() != f3447) {
            if (t == null) {
                onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                return;
            }
            for (PublishDisposable<T> publishDisposable : this.f3449.get()) {
                publishDisposable.onNext(t);
            }
        }
    }

    @Override // 㴹.K.AbstractC2520
    public void onSubscribe(AbstractC2514 r3) {
        if (this.f3449.get() == f3447) {
            r3.dispose();
        }
    }

    @Override // 㴹.K.AbstractC2500
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1958(AbstractC2520<? super T> r6) {
        boolean z;
        PublishDisposable<T> publishDisposable = new PublishDisposable<>(r6, this);
        r6.onSubscribe(publishDisposable);
        while (true) {
            PublishDisposable<T>[] publishDisposableArr = this.f3449.get();
            z = false;
            if (publishDisposableArr != f3447) {
                int length = publishDisposableArr.length;
                PublishDisposable<T>[] publishDisposableArr2 = new PublishDisposable[(length + 1)];
                System.arraycopy(publishDisposableArr, 0, publishDisposableArr2, 0, length);
                publishDisposableArr2[length] = publishDisposable;
                if (this.f3449.compareAndSet(publishDisposableArr, publishDisposableArr2)) {
                    z = true;
                    break;
                }
            } else {
                break;
            }
        }
        if (!z) {
            Throwable th = this.f3448;
            if (th != null) {
                r6.onError(th);
            } else {
                r6.onComplete();
            }
        } else if (publishDisposable.isDisposed()) {
            m1959((PublishDisposable) publishDisposable);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1959(PublishDisposable<T> publishDisposable) {
        PublishDisposable<T>[] publishDisposableArr;
        PublishDisposable<T>[] publishDisposableArr2;
        do {
            publishDisposableArr = this.f3449.get();
            if (publishDisposableArr != f3447 && publishDisposableArr != f3446) {
                int length = publishDisposableArr.length;
                int i = -1;
                int i2 = 0;
                while (true) {
                    if (i2 >= length) {
                        break;
                    } else if (publishDisposableArr[i2] == publishDisposable) {
                        i = i2;
                        break;
                    } else {
                        i2++;
                    }
                }
                if (i >= 0) {
                    if (length == 1) {
                        publishDisposableArr2 = f3446;
                    } else {
                        PublishDisposable<T>[] publishDisposableArr3 = new PublishDisposable[(length - 1)];
                        System.arraycopy(publishDisposableArr, 0, publishDisposableArr3, 0, i);
                        System.arraycopy(publishDisposableArr, i + 1, publishDisposableArr3, i, (length - i) - 1);
                        publishDisposableArr2 = publishDisposableArr3;
                    }
                } else {
                    return;
                }
            } else {
                return;
            }
        } while (!this.f3449.compareAndSet(publishDisposableArr, publishDisposableArr2));
    }
}
