package io.reactivex.internal.util;

import java.io.Serializable;
import ඓ.K.K.K.C1293;
import 㳳.ʬ.AbstractC2396;
import 㳳.ʬ.AbstractC2397;
import 㴹.K.AbstractC2520;
import 㴹.K.㑃.AbstractC2514;

public enum NotificationLite {
    COMPLETE;

    public static final class DisposableNotification implements Serializable {
        public static final long serialVersionUID = -7482590109178395495L;
        public final AbstractC2514 d;

        public DisposableNotification(AbstractC2514 r1) {
            this.d = r1;
        }

        public String toString() {
            StringBuilder r0 = C1293.m3416("NotificationLite.Disposable[");
            r0.append(this.d);
            r0.append("]");
            return r0.toString();
        }
    }

    public static final class ErrorNotification implements Serializable {
        public static final long serialVersionUID = -8759979445933046293L;
        public final Throwable e;

        public ErrorNotification(Throwable th) {
            this.e = th;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ErrorNotification)) {
                return false;
            }
            Throwable th = this.e;
            Throwable th2 = ((ErrorNotification) obj).e;
            if (th == th2 || (th != null && th.equals(th2))) {
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public String toString() {
            StringBuilder r0 = C1293.m3416("NotificationLite.Error[");
            r0.append(this.e);
            r0.append("]");
            return r0.toString();
        }
    }

    public static final class SubscriptionNotification implements Serializable {
        public static final long serialVersionUID = -1322257508628817540L;
        public final AbstractC2396 s;

        public SubscriptionNotification(AbstractC2396 r1) {
            this.s = r1;
        }

        public String toString() {
            StringBuilder r0 = C1293.m3416("NotificationLite.Subscription[");
            r0.append(this.s);
            r0.append("]");
            return r0.toString();
        }
    }

    public static <T> boolean accept(Object obj, AbstractC2397<? super T> r3) {
        if (obj == COMPLETE) {
            r3.onComplete();
            return true;
        } else if (obj instanceof ErrorNotification) {
            r3.onError(((ErrorNotification) obj).e);
            return true;
        } else {
            r3.onNext(obj);
            return false;
        }
    }

    public static <T> boolean acceptFull(Object obj, AbstractC2397<? super T> r3) {
        if (obj == COMPLETE) {
            r3.onComplete();
            return true;
        } else if (obj instanceof ErrorNotification) {
            r3.onError(((ErrorNotification) obj).e);
            return true;
        } else if (obj instanceof SubscriptionNotification) {
            r3.onSubscribe(((SubscriptionNotification) obj).s);
            return false;
        } else {
            r3.onNext(obj);
            return false;
        }
    }

    public static Object complete() {
        return COMPLETE;
    }

    public static Object disposable(AbstractC2514 r1) {
        return new DisposableNotification(r1);
    }

    public static Object error(Throwable th) {
        return new ErrorNotification(th);
    }

    public static AbstractC2514 getDisposable(Object obj) {
        return ((DisposableNotification) obj).d;
    }

    public static Throwable getError(Object obj) {
        return ((ErrorNotification) obj).e;
    }

    public static AbstractC2396 getSubscription(Object obj) {
        return ((SubscriptionNotification) obj).s;
    }

    /* JADX DEBUG: Multi-variable search result rejected for r0v0, resolved type: java.lang.Object */
    /* JADX WARN: Multi-variable type inference failed */
    public static <T> T getValue(Object obj) {
        return obj;
    }

    public static boolean isComplete(Object obj) {
        return obj == COMPLETE;
    }

    public static boolean isDisposable(Object obj) {
        return obj instanceof DisposableNotification;
    }

    public static boolean isError(Object obj) {
        return obj instanceof ErrorNotification;
    }

    public static boolean isSubscription(Object obj) {
        return obj instanceof SubscriptionNotification;
    }

    public static <T> Object next(T t) {
        return t;
    }

    public static Object subscription(AbstractC2396 r1) {
        return new SubscriptionNotification(r1);
    }

    public String toString() {
        return "NotificationLite.Complete";
    }

    public static <T> boolean accept(Object obj, AbstractC2520<? super T> r3) {
        if (obj == COMPLETE) {
            r3.onComplete();
            return true;
        } else if (obj instanceof ErrorNotification) {
            r3.onError(((ErrorNotification) obj).e);
            return true;
        } else {
            r3.onNext(obj);
            return false;
        }
    }

    public static <T> boolean acceptFull(Object obj, AbstractC2520<? super T> r3) {
        if (obj == COMPLETE) {
            r3.onComplete();
            return true;
        } else if (obj instanceof ErrorNotification) {
            r3.onError(((ErrorNotification) obj).e);
            return true;
        } else if (obj instanceof DisposableNotification) {
            r3.onSubscribe(((DisposableNotification) obj).d);
            return false;
        } else {
            r3.onNext(obj);
            return false;
        }
    }
}
