package io.reactivex.internal.subscriptions;

import io.reactivex.exceptions.ProtocolViolationException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import ඓ.ⁱ.K.ඓ.C1252;
import ඓ.K.K.K.C1293;
import 㳳.ʬ.AbstractC2396;
import 㴹.K.Ԕ.ῲ.C2456;

public enum SubscriptionHelper implements AbstractC2396 {
    CANCELLED;

    public static boolean cancel(AtomicReference<AbstractC2396> atomicReference) {
        AbstractC2396 andSet;
        AbstractC2396 r0 = atomicReference.get();
        SubscriptionHelper subscriptionHelper = CANCELLED;
        if (r0 == subscriptionHelper || (andSet = atomicReference.getAndSet(subscriptionHelper)) == CANCELLED) {
            return false;
        }
        if (andSet == null) {
            return true;
        }
        andSet.cancel();
        return true;
    }

    public static void deferredRequest(AtomicReference<AbstractC2396> atomicReference, AtomicLong atomicLong, long j) {
        AbstractC2396 r0 = atomicReference.get();
        if (r0 != null) {
            r0.request(j);
        } else if (validate(j)) {
            C1252.m3335(atomicLong, j);
            AbstractC2396 r2 = atomicReference.get();
            if (r2 != null) {
                long andSet = atomicLong.getAndSet(0);
                if (andSet != 0) {
                    r2.request(andSet);
                }
            }
        }
    }

    public static boolean deferredSetOnce(AtomicReference<AbstractC2396> atomicReference, AtomicLong atomicLong, AbstractC2396 r5) {
        if (!setOnce(atomicReference, r5)) {
            return false;
        }
        long andSet = atomicLong.getAndSet(0);
        if (andSet == 0) {
            return true;
        }
        r5.request(andSet);
        return true;
    }

    public static boolean isCancelled(AbstractC2396 r1) {
        return r1 == CANCELLED;
    }

    public static boolean replace(AtomicReference<AbstractC2396> atomicReference, AbstractC2396 r3) {
        AbstractC2396 r0;
        do {
            r0 = atomicReference.get();
            if (r0 == CANCELLED) {
                if (r3 == null) {
                    return false;
                }
                r3.cancel();
                return false;
            }
        } while (!atomicReference.compareAndSet(r0, r3));
        return true;
    }

    public static void reportMoreProduced(long j) {
        C1252.m3349(new ProtocolViolationException(C1293.m3409("More produced than requested: ", j)));
    }

    public static void reportSubscriptionSet() {
        C1252.m3349(new ProtocolViolationException("Subscription already set!"));
    }

    public static boolean set(AtomicReference<AbstractC2396> atomicReference, AbstractC2396 r3) {
        AbstractC2396 r0;
        do {
            r0 = atomicReference.get();
            if (r0 == CANCELLED) {
                if (r3 == null) {
                    return false;
                }
                r3.cancel();
                return false;
            }
        } while (!atomicReference.compareAndSet(r0, r3));
        if (r0 == null) {
            return true;
        }
        r0.cancel();
        return true;
    }

    public static boolean setOnce(AtomicReference<AbstractC2396> atomicReference, AbstractC2396 r2) {
        C2456.m6500(r2, "d is null");
        if (atomicReference.compareAndSet(null, r2)) {
            return true;
        }
        r2.cancel();
        if (atomicReference.get() == CANCELLED) {
            return false;
        }
        reportSubscriptionSet();
        return false;
    }

    public static boolean validate(AbstractC2396 r1, AbstractC2396 r2) {
        if (r2 == null) {
            C1252.m3349(new NullPointerException("next is null"));
            return false;
        } else if (r1 == null) {
            return true;
        } else {
            r2.cancel();
            reportSubscriptionSet();
            return false;
        }
    }

    @Override // 㳳.ʬ.AbstractC2396
    public void cancel() {
    }

    @Override // 㳳.ʬ.AbstractC2396
    public void request(long j) {
    }

    public static boolean validate(long j) {
        if (j > 0) {
            return true;
        }
        C1252.m3349(new IllegalArgumentException(C1293.m3409("n > 0 required but it was ", j)));
        return false;
    }
}
