package io.reactivex.internal.subscriptions;

import java.util.concurrent.atomic.AtomicInteger;
import 㳳.ʬ.AbstractC2397;
import 㴹.K.Ԕ.ʬ.AbstractC2433;

public final class ScalarSubscription<T> extends AtomicInteger implements AbstractC2433<T> {
    public static final int CANCELLED = 2;
    public static final int NO_REQUEST = 0;
    public static final int REQUESTED = 1;
    public static final long serialVersionUID = -3830916580126663321L;
    public final AbstractC2397<? super T> subscriber;
    public final T value;

    public ScalarSubscription(AbstractC2397<? super T> r1, T t) {
        this.subscriber = r1;
        this.value = t;
    }

    @Override // 㳳.ʬ.AbstractC2396
    public void cancel() {
        lazySet(2);
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
    public void clear() {
        lazySet(1);
    }

    public boolean isCancelled() {
        return get() == 2;
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
    public boolean isEmpty() {
        return get() != 0;
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
    public boolean offer(T t) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
    public T poll() {
        if (get() != 0) {
            return null;
        }
        lazySet(1);
        return this.value;
    }

    @Override // 㳳.ʬ.AbstractC2396
    public void request(long j) {
        if (SubscriptionHelper.validate(j) && compareAndSet(0, 1)) {
            AbstractC2397<? super T> r2 = this.subscriber;
            r2.onNext(this.value);
            if (get() != 2) {
                r2.onComplete();
            }
        }
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2438
    public int requestFusion(int i) {
        return i & 1;
    }

    public boolean offer(T t, T t2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}
