package io.reactivex.internal.queue;

import androidx.recyclerview.widget.RecyclerView;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.Ԕ.ʬ.AbstractC2435;

public final class SpscArrayQueue<E> extends AtomicReferenceArray<E> implements AbstractC2435<E> {
    public static final long serialVersionUID = -1296597691183856449L;

    /* renamed from: ῲ  reason: contains not printable characters */
    public static final Integer f3440 = Integer.getInteger("jctools.spsc.max.lookahead.step", (int) RecyclerView.AbstractC0269.FLAG_APPEARED_IN_PRE_LAYOUT);
    public final AtomicLong consumerIndex = new AtomicLong();
    public final int lookAheadStep;
    public final int mask = (length() - 1);
    public final AtomicLong producerIndex = new AtomicLong();
    public long producerLookAhead;

    public SpscArrayQueue(int i) {
        super(C1252.m3334(i));
        this.lookAheadStep = Math.min(i / 4, f3440.intValue());
    }

    public int calcElementOffset(long j) {
        return this.mask & ((int) j);
    }

    public int calcElementOffset(long j, int i) {
        return ((int) j) & i;
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
    public void clear() {
        while (true) {
            if (poll() == null && isEmpty()) {
                return;
            }
        }
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
    public boolean isEmpty() {
        return this.producerIndex.get() == this.consumerIndex.get();
    }

    public E lvElement(int i) {
        return get(i);
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
    public boolean offer(E e) {
        if (e != null) {
            int i = this.mask;
            long j = this.producerIndex.get();
            int calcElementOffset = calcElementOffset(j, i);
            if (j >= this.producerLookAhead) {
                long j2 = ((long) this.lookAheadStep) + j;
                if (lvElement(calcElementOffset(j2, i)) == null) {
                    this.producerLookAhead = j2;
                } else if (lvElement(calcElementOffset) != null) {
                    return false;
                }
            }
            soElement(calcElementOffset, e);
            soProducerIndex(j + 1);
            return true;
        }
        throw new NullPointerException("Null is not a valid element");
    }

    @Override // 㴹.K.Ԕ.ʬ.AbstractC2435, 㴹.K.Ԕ.ʬ.AbstractC2439
    public E poll() {
        long j = this.consumerIndex.get();
        int calcElementOffset = calcElementOffset(j);
        E lvElement = lvElement(calcElementOffset);
        if (lvElement == null) {
            return null;
        }
        soConsumerIndex(j + 1);
        soElement(calcElementOffset, null);
        return lvElement;
    }

    public void soConsumerIndex(long j) {
        this.consumerIndex.lazySet(j);
    }

    public void soElement(int i, E e) {
        lazySet(i, e);
    }

    public void soProducerIndex(long j) {
        this.producerIndex.lazySet(j);
    }

    public boolean offer(E e, E e2) {
        return offer(e) && offer(e2);
    }
}
