package io.reactivex.internal.operators.observable;

import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.AbstractC2500;
import 㴹.K.AbstractC2508;
import 㴹.K.AbstractC2518;
import 㴹.K.AbstractC2520;
import 㴹.K.Ԕ.ʬ.AbstractC2432;
import 㴹.K.Ԕ.ʬ.AbstractC2439;
import 㴹.K.Ԕ.ඓ.ῲ.AbstractC2445;
import 㴹.K.Ԕ.ⁱ.C2480;
import 㴹.K.Ԕ.㴹.C2487;
import 㴹.K.㑃.AbstractC2514;

public final class ObservableObserveOn<T> extends AbstractC2445<T, T> {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final AbstractC2508 f3432;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final int f3433;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final boolean f3434;

    public static final class ObserveOnObserver<T> extends BasicIntQueueDisposable<T> implements AbstractC2520<T>, Runnable {
        public static final long serialVersionUID = 6576896619930983584L;
        public final AbstractC2520<? super T> actual;
        public final int bufferSize;
        public volatile boolean cancelled;
        public final boolean delayError;
        public volatile boolean done;
        public Throwable error;
        public boolean outputFused;
        public AbstractC2439<T> queue;
        public AbstractC2514 s;
        public int sourceMode;
        public final AbstractC2508.AbstractC2509 worker;

        public ObserveOnObserver(AbstractC2520<? super T> r1, AbstractC2508.AbstractC2509 r2, boolean z, int i) {
            this.actual = r1;
            this.worker = r2;
            this.delayError = z;
            this.bufferSize = i;
        }

        public boolean checkTerminated(boolean z, boolean z2, AbstractC2520<? super T> r5) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            } else if (!z) {
                return false;
            } else {
                Throwable th = this.error;
                if (this.delayError) {
                    if (!z2) {
                        return false;
                    }
                    if (th != null) {
                        r5.onError(th);
                    } else {
                        r5.onComplete();
                    }
                    this.worker.dispose();
                    return true;
                } else if (th != null) {
                    this.queue.clear();
                    r5.onError(th);
                    this.worker.dispose();
                    return true;
                } else if (!z2) {
                    return false;
                } else {
                    r5.onComplete();
                    this.worker.dispose();
                    return true;
                }
            }
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
        public void clear() {
            this.queue.clear();
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.dispose();
                this.worker.dispose();
                if (getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        public void drainFused() {
            int i = 1;
            while (!this.cancelled) {
                boolean z = this.done;
                Throwable th = this.error;
                if (this.delayError || !z || th == null) {
                    this.actual.onNext(null);
                    if (z) {
                        Throwable th2 = this.error;
                        if (th2 != null) {
                            this.actual.onError(th2);
                        } else {
                            this.actual.onComplete();
                        }
                        this.worker.dispose();
                        return;
                    }
                    i = addAndGet(-i);
                    if (i == 0) {
                        return;
                    }
                } else {
                    this.actual.onError(th);
                    this.worker.dispose();
                    return;
                }
            }
        }

        public void drainNormal() {
            AbstractC2439<T> r0 = this.queue;
            AbstractC2520<? super T> r1 = this.actual;
            int i = 1;
            while (!checkTerminated(this.done, r0.isEmpty(), r1)) {
                while (true) {
                    boolean z = this.done;
                    try {
                        T poll = r0.poll();
                        boolean z2 = poll == null;
                        if (!checkTerminated(z, z2, r1)) {
                            if (z2) {
                                i = addAndGet(-i);
                                if (i == 0) {
                                    return;
                                }
                            } else {
                                r1.onNext(poll);
                            }
                        } else {
                            return;
                        }
                    } catch (Throwable th) {
                        C1252.m3329(th);
                        this.s.dispose();
                        r0.clear();
                        r1.onError(th);
                        this.worker.dispose();
                        return;
                    }
                }
            }
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override // 㴹.K.AbstractC2520
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                schedule();
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onError(Throwable th) {
            if (this.done) {
                C1252.m3349(th);
                return;
            }
            this.error = th;
            this.done = true;
            schedule();
        }

        @Override // 㴹.K.AbstractC2520
        public void onNext(T t) {
            if (!this.done) {
                if (this.sourceMode != 2) {
                    this.queue.offer(t);
                }
                schedule();
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onSubscribe(AbstractC2514 r3) {
            if (DisposableHelper.validate(this.s, r3)) {
                this.s = r3;
                if (r3 instanceof AbstractC2432) {
                    AbstractC2432 r32 = (AbstractC2432) r3;
                    int requestFusion = r32.requestFusion(7);
                    if (requestFusion == 1) {
                        this.sourceMode = requestFusion;
                        this.queue = r32;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        schedule();
                        return;
                    } else if (requestFusion == 2) {
                        this.sourceMode = requestFusion;
                        this.queue = r32;
                        this.actual.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new C2487(this.bufferSize);
                this.actual.onSubscribe(this);
            }
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
        public T poll() throws Exception {
            return this.queue.poll();
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2438
        public int requestFusion(int i) {
            if ((i & 2) == 0) {
                return 0;
            }
            this.outputFused = true;
            return 2;
        }

        public void run() {
            if (this.outputFused) {
                drainFused();
            } else {
                drainNormal();
            }
        }

        public void schedule() {
            if (getAndIncrement() == 0) {
                this.worker.m6554(this);
            }
        }
    }

    public ObservableObserveOn(AbstractC2518<T> r1, AbstractC2508 r2, boolean z, int i) {
        super(r1);
        this.f3432 = r2;
        this.f3434 = z;
        this.f3433 = i;
    }

    @Override // 㴹.K.AbstractC2500
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1952(AbstractC2520<? super T> r6) {
        AbstractC2508 r0 = this.f3432;
        if (r0 instanceof C2480) {
            ((AbstractC2500) this.f8388).m6545((AbstractC2520) r6);
            return;
        }
        AbstractC2508.AbstractC2509 r02 = r0.m6550();
        ((AbstractC2500) this.f8388).m6545((AbstractC2520) new ObserveOnObserver(r6, r02, this.f3434, this.f3433));
    }
}
