package io.reactivex.internal.operators.flowable;

import androidx.recyclerview.widget.RecyclerView;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import ඓ.ⁱ.K.ඓ.C1252;
import 㳳.ʬ.AbstractC2396;
import 㳳.ʬ.AbstractC2397;
import 㴹.K.AbstractC2431;
import 㴹.K.AbstractC2508;
import 㴹.K.AbstractC2511;
import 㴹.K.Ԕ.ʬ.AbstractC2433;
import 㴹.K.Ԕ.ʬ.AbstractC2436;
import 㴹.K.Ԕ.ʬ.AbstractC2439;
import 㴹.K.Ԕ.ඓ.K.AbstractC2453;
import 㴹.K.Ԕ.ඓ.K.C2449;

public final class FlowableObserveOn<T> extends AbstractC2453<T, T> {

    /* renamed from: ඓ  reason: contains not printable characters */
    public final boolean f3409;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final int f3410;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final AbstractC2508 f3411;

    public static abstract class BaseObserveOnSubscriber<T> extends BasicIntQueueSubscription<T> implements AbstractC2431<T>, Runnable {
        public static final long serialVersionUID = -8241002408341274697L;
        public volatile boolean cancelled;
        public final boolean delayError;
        public volatile boolean done;
        public Throwable error;
        public final int limit;
        public boolean outputFused;
        public final int prefetch;
        public long produced;
        public AbstractC2439<T> queue;
        public final AtomicLong requested = new AtomicLong();
        public AbstractC2396 s;
        public int sourceMode;
        public final AbstractC2508.AbstractC2509 worker;

        public BaseObserveOnSubscriber(AbstractC2508.AbstractC2509 r1, boolean z, int i) {
            this.worker = r1;
            this.delayError = z;
            this.prefetch = i;
            this.limit = i - (i >> 2);
        }

        @Override // 㳳.ʬ.AbstractC2396
        public final void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                this.worker.dispose();
                if (getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        public final boolean checkTerminated(boolean z, boolean z2, AbstractC2397<?> r5) {
            if (this.cancelled) {
                clear();
                return true;
            } else if (!z) {
                return false;
            } else {
                if (!this.delayError) {
                    Throwable th = this.error;
                    if (th != null) {
                        clear();
                        r5.onError(th);
                        this.worker.dispose();
                        return true;
                    } else if (!z2) {
                        return false;
                    } else {
                        r5.onComplete();
                        this.worker.dispose();
                        return true;
                    }
                } else if (!z2) {
                    return false;
                } else {
                    Throwable th2 = this.error;
                    if (th2 != null) {
                        r5.onError(th2);
                    } else {
                        r5.onComplete();
                    }
                    this.worker.dispose();
                    return true;
                }
            }
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
        public final void clear() {
            this.queue.clear();
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
        public final boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override // 㳳.ʬ.AbstractC2397
        public final void onComplete() {
            if (!this.done) {
                this.done = true;
                trySchedule();
            }
        }

        @Override // 㳳.ʬ.AbstractC2397
        public final void onError(Throwable th) {
            if (this.done) {
                C1252.m3349(th);
                return;
            }
            this.error = th;
            this.done = true;
            trySchedule();
        }

        @Override // 㳳.ʬ.AbstractC2397
        public final void onNext(T t) {
            if (!this.done) {
                if (this.sourceMode == 2) {
                    trySchedule();
                    return;
                }
                if (!this.queue.offer(t)) {
                    this.s.cancel();
                    this.error = new MissingBackpressureException("Queue is full?!");
                    this.done = true;
                }
                trySchedule();
            }
        }

        @Override // 㳳.ʬ.AbstractC2396
        public final void request(long j) {
            if (SubscriptionHelper.validate(j)) {
                C1252.m3335(this.requested, j);
                trySchedule();
            }
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2438
        public final int requestFusion(int i) {
            if ((i & 2) == 0) {
                return 0;
            }
            this.outputFused = true;
            return 2;
        }

        public final void run() {
            if (this.outputFused) {
                runBackfused();
            } else if (this.sourceMode == 1) {
                runSync();
            } else {
                runAsync();
            }
        }

        public abstract void runAsync();

        public abstract void runBackfused();

        public abstract void runSync();

        public final void trySchedule() {
            if (getAndIncrement() == 0) {
                this.worker.m6554(this);
            }
        }
    }

    public static final class ObserveOnConditionalSubscriber<T> extends BaseObserveOnSubscriber<T> {
        public static final long serialVersionUID = 644624475404284533L;
        public final AbstractC2436<? super T> actual;
        public long consumed;

        public ObserveOnConditionalSubscriber(AbstractC2436<? super T> k, AbstractC2508.AbstractC2509 r2, boolean z, int i) {
            super(r2, z, i);
            this.actual = k;
        }

        @Override // 㳳.ʬ.AbstractC2397, 㴹.K.AbstractC2431
        public void onSubscribe(AbstractC2396 r4) {
            if (SubscriptionHelper.validate(this.s, r4)) {
                this.s = r4;
                if (r4 instanceof AbstractC2433) {
                    AbstractC2433 r0 = (AbstractC2433) r4;
                    int requestFusion = r0.requestFusion(7);
                    if (requestFusion == 1) {
                        this.sourceMode = 1;
                        this.queue = r0;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        return;
                    } else if (requestFusion == 2) {
                        this.sourceMode = 2;
                        this.queue = r0;
                        this.actual.onSubscribe(this);
                        r4.request((long) this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.actual.onSubscribe(this);
                r4.request((long) this.prefetch);
            }
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
        public T poll() throws Exception {
            T poll = this.queue.poll();
            if (!(poll == null || this.sourceMode == 1)) {
                long j = this.consumed + 1;
                if (j == ((long) this.limit)) {
                    this.consumed = 0;
                    this.s.request(j);
                } else {
                    this.consumed = j;
                }
            }
            return poll;
        }

        @Override // io.reactivex.internal.operators.flowable.FlowableObserveOn.BaseObserveOnSubscriber
        public void runAsync() {
            int i;
            AbstractC2436<? super T> k = this.actual;
            AbstractC2439<T> r1 = this.queue;
            long j = this.produced;
            long j2 = this.consumed;
            int i2 = 1;
            while (true) {
                long j3 = this.requested.get();
                while (true) {
                    i = (j > j3 ? 1 : (j == j3 ? 0 : -1));
                    if (i == 0) {
                        break;
                    }
                    boolean z = this.done;
                    try {
                        T poll = r1.poll();
                        boolean z2 = poll == null;
                        if (!checkTerminated(z, z2, k)) {
                            if (z2) {
                                break;
                            }
                            if (((C2449.C2451) k).m6493(poll)) {
                                j++;
                            }
                            j2++;
                            if (j2 == ((long) this.limit)) {
                                this.s.request(j2);
                                j2 = 0;
                            }
                        } else {
                            return;
                        }
                    } catch (Throwable th) {
                        C1252.m3329(th);
                        this.s.cancel();
                        r1.clear();
                        k.onError(th);
                        this.worker.dispose();
                        return;
                    }
                }
                if (i != 0 || !checkTerminated(this.done, r1.isEmpty(), k)) {
                    int i3 = get();
                    if (i2 == i3) {
                        this.produced = j;
                        this.consumed = j2;
                        i2 = addAndGet(-i2);
                        if (i2 == 0) {
                            return;
                        }
                    } else {
                        i2 = i3;
                    }
                } else {
                    return;
                }
            }
        }

        @Override // io.reactivex.internal.operators.flowable.FlowableObserveOn.BaseObserveOnSubscriber
        public void runBackfused() {
            int i = 1;
            while (!this.cancelled) {
                boolean z = this.done;
                this.actual.onNext(null);
                if (z) {
                    Throwable th = this.error;
                    if (th != null) {
                        this.actual.onError(th);
                    } else {
                        this.actual.onComplete();
                    }
                    this.worker.dispose();
                    return;
                }
                i = addAndGet(-i);
                if (i == 0) {
                    return;
                }
            }
        }

        @Override // io.reactivex.internal.operators.flowable.FlowableObserveOn.BaseObserveOnSubscriber
        public void runSync() {
            AbstractC2436<? super T> k = this.actual;
            AbstractC2439<T> r1 = this.queue;
            long j = this.produced;
            int i = 1;
            while (true) {
                long j2 = this.requested.get();
                while (j != j2) {
                    try {
                        T poll = r1.poll();
                        if (!this.cancelled) {
                            if (poll == null) {
                                k.onComplete();
                                this.worker.dispose();
                                return;
                            } else if (((C2449.C2451) k).m6493(poll)) {
                                j++;
                            }
                        } else {
                            return;
                        }
                    } catch (Throwable th) {
                        C1252.m3329(th);
                        this.s.cancel();
                        k.onError(th);
                        this.worker.dispose();
                        return;
                    }
                }
                if (!this.cancelled) {
                    if (r1.isEmpty()) {
                        k.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    int i2 = get();
                    if (i == i2) {
                        this.produced = j;
                        i = addAndGet(-i);
                        if (i == 0) {
                            return;
                        }
                    } else {
                        i = i2;
                    }
                } else {
                    return;
                }
            }
        }
    }

    public static final class ObserveOnSubscriber<T> extends BaseObserveOnSubscriber<T> implements AbstractC2431<T> {
        public static final long serialVersionUID = -4547113800637756442L;
        public final AbstractC2397<? super T> actual;

        public ObserveOnSubscriber(AbstractC2397<? super T> r1, AbstractC2508.AbstractC2509 r2, boolean z, int i) {
            super(r2, z, i);
            this.actual = r1;
        }

        @Override // 㳳.ʬ.AbstractC2397, 㴹.K.AbstractC2431
        public void onSubscribe(AbstractC2396 r4) {
            if (SubscriptionHelper.validate(this.s, r4)) {
                this.s = r4;
                if (r4 instanceof AbstractC2433) {
                    AbstractC2433 r0 = (AbstractC2433) r4;
                    int requestFusion = r0.requestFusion(7);
                    if (requestFusion == 1) {
                        this.sourceMode = 1;
                        this.queue = r0;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        return;
                    } else if (requestFusion == 2) {
                        this.sourceMode = 2;
                        this.queue = r0;
                        this.actual.onSubscribe(this);
                        r4.request((long) this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.actual.onSubscribe(this);
                r4.request((long) this.prefetch);
            }
        }

        @Override // 㴹.K.Ԕ.ʬ.AbstractC2439
        public T poll() throws Exception {
            T poll = this.queue.poll();
            if (!(poll == null || this.sourceMode == 1)) {
                long j = this.produced + 1;
                if (j == ((long) this.limit)) {
                    this.produced = 0;
                    this.s.request(j);
                } else {
                    this.produced = j;
                }
            }
            return poll;
        }

        @Override // io.reactivex.internal.operators.flowable.FlowableObserveOn.BaseObserveOnSubscriber
        public void runAsync() {
            int i;
            AbstractC2397<? super T> r0 = this.actual;
            AbstractC2439<T> r1 = this.queue;
            long j = this.produced;
            int i2 = 1;
            while (true) {
                long j2 = this.requested.get();
                while (true) {
                    i = (j > j2 ? 1 : (j == j2 ? 0 : -1));
                    if (i == 0) {
                        break;
                    }
                    boolean z = this.done;
                    try {
                        T poll = r1.poll();
                        boolean z2 = poll == null;
                        if (!checkTerminated(z, z2, r0)) {
                            if (z2) {
                                break;
                            }
                            r0.onNext(poll);
                            j++;
                            if (j == ((long) this.limit)) {
                                if (j2 != RecyclerView.FOREVER_NS) {
                                    j2 = this.requested.addAndGet(-j);
                                }
                                this.s.request(j);
                                j = 0;
                            }
                        } else {
                            return;
                        }
                    } catch (Throwable th) {
                        C1252.m3329(th);
                        this.s.cancel();
                        r1.clear();
                        r0.onError(th);
                        this.worker.dispose();
                        return;
                    }
                }
                if (i != 0 || !checkTerminated(this.done, r1.isEmpty(), r0)) {
                    int i3 = get();
                    if (i2 == i3) {
                        this.produced = j;
                        i2 = addAndGet(-i2);
                        if (i2 == 0) {
                            return;
                        }
                    } else {
                        i2 = i3;
                    }
                } else {
                    return;
                }
            }
        }

        @Override // io.reactivex.internal.operators.flowable.FlowableObserveOn.BaseObserveOnSubscriber
        public void runBackfused() {
            int i = 1;
            while (!this.cancelled) {
                boolean z = this.done;
                this.actual.onNext(null);
                if (z) {
                    Throwable th = this.error;
                    if (th != null) {
                        this.actual.onError(th);
                    } else {
                        this.actual.onComplete();
                    }
                    this.worker.dispose();
                    return;
                }
                i = addAndGet(-i);
                if (i == 0) {
                    return;
                }
            }
        }

        @Override // io.reactivex.internal.operators.flowable.FlowableObserveOn.BaseObserveOnSubscriber
        public void runSync() {
            AbstractC2397<? super T> r0 = this.actual;
            AbstractC2439<T> r1 = this.queue;
            long j = this.produced;
            int i = 1;
            while (true) {
                long j2 = this.requested.get();
                while (j != j2) {
                    try {
                        T poll = r1.poll();
                        if (!this.cancelled) {
                            if (poll == null) {
                                r0.onComplete();
                                this.worker.dispose();
                                return;
                            }
                            r0.onNext(poll);
                            j++;
                        } else {
                            return;
                        }
                    } catch (Throwable th) {
                        C1252.m3329(th);
                        this.s.cancel();
                        r0.onError(th);
                        this.worker.dispose();
                        return;
                    }
                }
                if (!this.cancelled) {
                    if (r1.isEmpty()) {
                        r0.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    int i2 = get();
                    if (i == i2) {
                        this.produced = j;
                        i = addAndGet(-i);
                        if (i == 0) {
                            return;
                        }
                    } else {
                        i = i2;
                    }
                } else {
                    return;
                }
            }
        }
    }

    public FlowableObserveOn(AbstractC2511<T> r1, AbstractC2508 r2, boolean z, int i) {
        super(r1);
        this.f3411 = r2;
        this.f3409 = z;
        this.f3410 = i;
    }

    @Override // 㴹.K.AbstractC2511
    /* renamed from: K  reason: contains not printable characters */
    public void m1947(AbstractC2397<? super T> r6) {
        AbstractC2508.AbstractC2509 r0 = this.f3411.m6550();
        if (r6 instanceof AbstractC2436) {
            this.f8401.m6562((AbstractC2431) new ObserveOnConditionalSubscriber((AbstractC2436) r6, r0, this.f3409, this.f3410));
        } else {
            this.f8401.m6562((AbstractC2431) new ObserveOnSubscriber(r6, r0, this.f3409, this.f3410));
        }
    }
}
