package io.reactivex.internal.disposables;

import io.reactivex.exceptions.ProtocolViolationException;
import java.util.concurrent.atomic.AtomicReference;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.Ԕ.ῲ.C2456;
import 㴹.K.㑃.AbstractC2514;

public enum DisposableHelper implements AbstractC2514 {
    DISPOSED;

    public static boolean dispose(AtomicReference<AbstractC2514> atomicReference) {
        AbstractC2514 andSet;
        AbstractC2514 r0 = atomicReference.get();
        DisposableHelper disposableHelper = DISPOSED;
        if (r0 == disposableHelper || (andSet = atomicReference.getAndSet(disposableHelper)) == disposableHelper) {
            return false;
        }
        if (andSet == null) {
            return true;
        }
        andSet.dispose();
        return true;
    }

    public static boolean isDisposed(AbstractC2514 r1) {
        return r1 == DISPOSED;
    }

    public static boolean replace(AtomicReference<AbstractC2514> atomicReference, AbstractC2514 r3) {
        AbstractC2514 r0;
        do {
            r0 = atomicReference.get();
            if (r0 == DISPOSED) {
                if (r3 == null) {
                    return false;
                }
                r3.dispose();
                return false;
            }
        } while (!atomicReference.compareAndSet(r0, r3));
        return true;
    }

    public static void reportDisposableSet() {
        C1252.m3349(new ProtocolViolationException("Disposable already set!"));
    }

    public static boolean set(AtomicReference<AbstractC2514> atomicReference, AbstractC2514 r3) {
        AbstractC2514 r0;
        do {
            r0 = atomicReference.get();
            if (r0 == DISPOSED) {
                if (r3 == null) {
                    return false;
                }
                r3.dispose();
                return false;
            }
        } while (!atomicReference.compareAndSet(r0, r3));
        if (r0 == null) {
            return true;
        }
        r0.dispose();
        return true;
    }

    public static boolean setOnce(AtomicReference<AbstractC2514> atomicReference, AbstractC2514 r2) {
        C2456.m6500(r2, "d is null");
        if (atomicReference.compareAndSet(null, r2)) {
            return true;
        }
        r2.dispose();
        if (atomicReference.get() == DISPOSED) {
            return false;
        }
        reportDisposableSet();
        return false;
    }

    public static boolean trySet(AtomicReference<AbstractC2514> atomicReference, AbstractC2514 r2) {
        if (atomicReference.compareAndSet(null, r2)) {
            return true;
        }
        if (atomicReference.get() != DISPOSED) {
            return false;
        }
        r2.dispose();
        return false;
    }

    public static boolean validate(AbstractC2514 r1, AbstractC2514 r2) {
        if (r2 == null) {
            C1252.m3349(new NullPointerException("next is null"));
            return false;
        } else if (r1 == null) {
            return true;
        } else {
            r2.dispose();
            reportDisposableSet();
            return false;
        }
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public void dispose() {
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public boolean isDisposed() {
        return true;
    }
}
