package com.zhihu.matisse.ui;

import android.content.Intent;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.zhihu.matisse.R$attr;
import com.zhihu.matisse.R$id;
import com.zhihu.matisse.R$layout;
import com.zhihu.matisse.R$string;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.ui.AlbumPreviewActivity;
import com.zhihu.matisse.internal.ui.SelectedPreviewActivity;
import com.zhihu.matisse.internal.ui.widget.CheckRadioView;
import java.util.ArrayList;
import java.util.Iterator;
import ඓ.ᨨ.K.ඓ.ʬ.C0766;
import ඓ.ᨨ.K.ඓ.ʬ.C0769;
import ඓ.ᨨ.K.ඓ.ඓ.C0771;
import ඓ.ᨨ.K.ඓ.ඓ.C0772;
import ඓ.ᨨ.K.ඓ.ඓ.C0774;
import ඓ.ᨨ.K.ඓ.K.C0778;
import ඓ.ᨨ.K.ඓ.K.C0782;
import ඓ.ᨨ.K.ඓ.㸾.C0796;
import ඓ.ᨨ.K.ඓ.㸾.ʬ.C0784;
import ඓ.ᨨ.K.ඓ.㸾.ʬ.C0785;
import ඓ.ᨨ.K.ඓ.㸾.㸾.C0799;
import ඓ.ᨨ.K.ඓ.㸾.㸾.C0801;
import ඓ.ᨨ.K.㴹.AbstractC0806;
import ඓ.ᨨ.K.㴹.AbstractC0808;
import ඓ.ⁱ.K.ඓ.C1252;
import ῲ.ᓣ.K.AbstractC1695;
import ῲ.ῲ.K.AbstractC1963;

public class MatisseActivity extends AppCompatActivity implements C0769.AbstractC0770, AdapterView.OnItemSelectedListener, C0796.AbstractC0797, View.OnClickListener, C0785.AbstractC0786, C0785.AbstractC0787, C0785.AbstractC0790 {

    /* renamed from: Ԕ  reason: contains not printable characters */
    public LinearLayout f3387;

    /* renamed from: ؿ  reason: contains not printable characters */
    public boolean f3388;

    /* renamed from: ඓ  reason: contains not printable characters */
    public C0772 f3389;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public TextView f3390;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public C0784 f3391;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public C0778 f3392;

    /* renamed from: 㑃  reason: contains not printable characters */
    public View f3393;

    /* renamed from: 㗗  reason: contains not printable characters */
    public CheckRadioView f3394;

    /* renamed from: 㳳  reason: contains not printable characters */
    public TextView f3395;

    /* renamed from: 㴹  reason: contains not printable characters */
    public C0766 f3396 = new C0766(this);

    /* renamed from: 㸾  reason: contains not printable characters */
    public final C0769 f3397 = new C0769();

    /* renamed from: 㿎  reason: contains not printable characters */
    public C0801 f3398;

    /* renamed from: 䁗  reason: contains not printable characters */
    public View f3399;

    /* renamed from: com.zhihu.matisse.ui.MatisseActivity$ῲ  reason: contains not printable characters */
    public class RunnableC0570 implements Runnable {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ Cursor f3401;

        public RunnableC0570(Cursor cursor) {
            this.f3401 = cursor;
        }

        public void run() {
            this.f3401.moveToPosition(MatisseActivity.this.f3397.f3926);
            MatisseActivity matisseActivity = MatisseActivity.this;
            matisseActivity.f3398.m2387(matisseActivity, matisseActivity.f3397.f3926);
            Album r0 = Album.m1903(this.f3401);
            if (r0.m1905() && C0778.C0779.f3967.f3952) {
                r0.m1908();
            }
            MatisseActivity.this.m1941(r0);
        }
    }

    /* renamed from: com.zhihu.matisse.ui.MatisseActivity$K  reason: contains not printable characters */
    public class C0571 implements C0774.AbstractC0775 {
        public C0571(MatisseActivity matisseActivity) {
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m1944() {
            Log.i("SingleMediaScanner", "scan finish!");
        }
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onActivityResult(int i, int i2, Intent intent) {
        super.onActivityResult(i, i2, intent);
        if (i2 == -1) {
            if (i == 23) {
                Bundle bundleExtra = intent.getBundleExtra("extra_result_bundle");
                ArrayList<Item> parcelableArrayList = bundleExtra.getParcelableArrayList("state_selection");
                this.f3388 = intent.getBooleanExtra("extra_result_original_enable", false);
                int i3 = bundleExtra.getInt("state_collection_type", 0);
                if (intent.getBooleanExtra("extra_result_apply", false)) {
                    Intent intent2 = new Intent();
                    ArrayList<? extends Parcelable> arrayList = new ArrayList<>();
                    ArrayList<String> arrayList2 = new ArrayList<>();
                    if (parcelableArrayList != null) {
                        Iterator<Item> it2 = parcelableArrayList.iterator();
                        while (it2.hasNext()) {
                            Item next = it2.next();
                            arrayList.add(next.m1915());
                            arrayList2.add(C1252.m3340(this, next.m1915()));
                        }
                    }
                    intent2.putParcelableArrayListExtra("extra_result_selection", arrayList);
                    intent2.putStringArrayListExtra("extra_result_selection_path", arrayList2);
                    intent2.putExtra("extra_result_original_enable", this.f3388);
                    setResult(-1, intent2);
                    finish();
                    return;
                }
                this.f3396.m2321(parcelableArrayList, i3);
                Fragment r8 = getSupportFragmentManager().m3914(C0796.class.getSimpleName());
                if (r8 instanceof C0796) {
                    ((C0796) r8).m2384();
                }
                m1937();
            } else if (i == 24) {
                C0772 r82 = this.f3389;
                Uri uri = r82.f3931;
                String str = r82.f3928;
                ArrayList<? extends Parcelable> arrayList3 = new ArrayList<>();
                arrayList3.add(uri);
                ArrayList<String> arrayList4 = new ArrayList<>();
                arrayList4.add(str);
                Intent intent3 = new Intent();
                intent3.putParcelableArrayListExtra("extra_result_selection", arrayList3);
                intent3.putStringArrayListExtra("extra_result_selection_path", arrayList4);
                setResult(-1, intent3);
                int i4 = Build.VERSION.SDK_INT;
                new C0774(getApplicationContext(), str, new C0571(this));
                finish();
            }
        }
    }

    @Override // androidx.activity.ComponentActivity
    public void onBackPressed() {
        setResult(0);
        super.onBackPressed();
    }

    public void onClick(View view) {
        if (view.getId() == R$id.button_preview) {
            Intent intent = new Intent(this, SelectedPreviewActivity.class);
            intent.putExtra("extra_default_bundle", this.f3396.m2323());
            intent.putExtra("extra_result_original_enable", this.f3388);
            startActivityForResult(intent, 23);
        } else if (view.getId() == R$id.button_apply) {
            Intent intent2 = new Intent();
            intent2.putParcelableArrayListExtra("extra_result_selection", (ArrayList) this.f3396.m2311());
            intent2.putStringArrayListExtra("extra_result_selection_path", (ArrayList) this.f3396.m2316());
            intent2.putExtra("extra_result_original_enable", this.f3388);
            setResult(-1, intent2);
            finish();
        } else if (view.getId() == R$id.originalLayout) {
            int r5 = m1935();
            if (r5 > 0) {
                C0799.m2386("", getString(R$string.error_over_original_count, new Object[]{Integer.valueOf(r5), Integer.valueOf(this.f3392.f3946)})).show(getSupportFragmentManager(), C0799.class.getName());
                return;
            }
            this.f3388 = !this.f3388;
            this.f3394.setChecked(this.f3388);
            AbstractC0808 k = this.f3392.f3962;
            if (k != null) {
                k.m2397(this.f3388);
            }
        }
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onCreate(Bundle bundle) {
        this.f3392 = C0778.C0779.f3967;
        setTheme(this.f3392.f3963);
        super.onCreate(bundle);
        if (!this.f3392.f3951) {
            setResult(0);
            finish();
            return;
        }
        setContentView(R$layout.activity_matisse);
        if (this.f3392.f3949 != -1) {
            setRequestedOrientation(this.f3392.f3949);
        }
        if (this.f3392.f3952) {
            this.f3389 = new C0772(this);
            C0782 k = this.f3392.f3957;
            if (k != null) {
                this.f3389.f3927 = k;
            } else {
                throw new RuntimeException("Don't forget to set CaptureStrategy.");
            }
        }
        Toolbar toolbar = (Toolbar) findViewById(R$id.toolbar);
        m138(toolbar);
        AbstractC1963 r2 = m134();
        r2.m5074(false);
        r2.m5088(true);
        Drawable navigationIcon = toolbar.getNavigationIcon();
        TypedArray obtainStyledAttributes = getTheme().obtainStyledAttributes(new int[]{R$attr.album_element_color});
        int color = obtainStyledAttributes.getColor(0, 0);
        obtainStyledAttributes.recycle();
        navigationIcon.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        this.f3395 = (TextView) findViewById(R$id.button_preview);
        this.f3390 = (TextView) findViewById(R$id.button_apply);
        this.f3395.setOnClickListener(this);
        this.f3390.setOnClickListener(this);
        this.f3393 = findViewById(R$id.container);
        this.f3399 = findViewById(R$id.empty_view);
        this.f3387 = (LinearLayout) findViewById(R$id.originalLayout);
        this.f3394 = (CheckRadioView) findViewById(R$id.original);
        this.f3387.setOnClickListener(this);
        this.f3396.m2320(bundle);
        if (bundle != null) {
            this.f3388 = bundle.getBoolean("checkState");
        }
        m1937();
        this.f3391 = new C0784(this, null, false);
        this.f3398 = new C0801(this);
        this.f3398.setOnItemSelectedListener(this);
        this.f3398.m2391((TextView) findViewById(R$id.selected_album));
        this.f3398.m2389(findViewById(R$id.toolbar));
        this.f3398.m2390(this.f3391);
        this.f3397.m2336(this, this);
        this.f3397.m2335(bundle);
        C0769 k2 = this.f3397;
        k2.f3924.m4340(1, null, k2);
    }

    @Override // androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onDestroy() {
        super.onDestroy();
        C0769 k = this.f3397;
        AbstractC1695 k2 = k.f3924;
        if (k2 != null) {
            k2.m4341(1);
        }
        k.f3922 = null;
        C0778 r0 = this.f3392;
        r0.f3962 = null;
        r0.f3959 = null;
    }

    @Override // android.widget.AdapterView.OnItemSelectedListener
    public void onItemSelected(AdapterView<?> adapterView, View view, int i, long j) {
        this.f3397.f3926 = i;
        this.f3391.getCursor().moveToPosition(i);
        Album r1 = Album.m1903(this.f3391.getCursor());
        if (r1.m1905() && C0778.C0779.f3967.f3952) {
            r1.m1908();
        }
        m1941(r1);
    }

    @Override // android.widget.AdapterView.OnItemSelectedListener
    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() != 16908332) {
            return super.onOptionsItemSelected(menuItem);
        }
        onBackPressed();
        return true;
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.f3396.m2317(bundle);
        bundle.putInt("state_current_selection", this.f3397.f3926);
        bundle.putBoolean("checkState", this.f3388);
    }

    /* renamed from: ؿ  reason: contains not printable characters */
    public final int m1935() {
        int r0 = this.f3396.m2325();
        int i = 0;
        for (int i2 = 0; i2 < r0; i2++) {
            Item item = this.f3396.m2319().get(i2);
            if (item.m1916() && C0771.m2341(item.f3336) > ((float) this.f3392.f3946)) {
                i++;
            }
        }
        return i;
    }

    @Override // ඓ.ᨨ.K.ඓ.㸾.C0796.AbstractC0797
    /* renamed from: ඓ  reason: contains not printable characters */
    public C0766 m1936() {
        return this.f3396;
    }

    /* renamed from: ᓣ  reason: contains not printable characters */
    public final void m1937() {
        int r0 = this.f3396.m2325();
        if (r0 == 0) {
            this.f3395.setEnabled(false);
            this.f3390.setEnabled(false);
            this.f3390.setText(getString(R$string.button_apply_default));
        } else if (r0 != 1 || !this.f3392.m2361()) {
            this.f3395.setEnabled(true);
            this.f3390.setEnabled(true);
            this.f3390.setText(getString(R$string.button_apply, new Object[]{Integer.valueOf(r0)}));
        } else {
            this.f3395.setEnabled(true);
            this.f3390.setText(R$string.button_apply_default);
            this.f3390.setEnabled(true);
        }
        if (this.f3392.f3948) {
            this.f3387.setVisibility(0);
            this.f3394.setChecked(this.f3388);
            if (m1935() > 0 && this.f3388) {
                C0799.m2386("", getString(R$string.error_over_original_size, new Object[]{Integer.valueOf(this.f3392.f3946)})).show(getSupportFragmentManager(), C0799.class.getName());
                this.f3394.setChecked(false);
                this.f3388 = false;
                return;
            }
            return;
        }
        this.f3387.setVisibility(4);
    }

    @Override // ඓ.ᨨ.K.ඓ.ʬ.C0769.AbstractC0770
    /* renamed from: ᨨ  reason: contains not printable characters */
    public void m1938() {
        this.f3391.swapCursor(null);
    }

    @Override // ඓ.ᨨ.K.ඓ.ʬ.C0769.AbstractC0770
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1939(Cursor cursor) {
        this.f3391.swapCursor(cursor);
        new Handler(Looper.getMainLooper()).post(new RunnableC0570(cursor));
    }

    @Override // ඓ.ᨨ.K.ඓ.㸾.ʬ.C0785.AbstractC0786
    /* renamed from: ⁱ  reason: contains not printable characters */
    public void m1940() {
        m1937();
        AbstractC0806 r0 = this.f3392.f3959;
        if (r0 != null) {
            r0.m2395(this.f3396.m2311(), this.f3396.m2316());
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1941(Album album) {
        if (!album.m1905() || !album.m1909()) {
            this.f3393.setVisibility(0);
            this.f3399.setVisibility(8);
            C0796 k = new C0796();
            Bundle bundle = new Bundle();
            bundle.putParcelable("extra_album", album);
            k.setArguments(bundle);
            getSupportFragmentManager().m3915().m4093(R$id.container, k, C0796.class.getSimpleName()).m4091();
            return;
        }
        this.f3393.setVisibility(8);
        this.f3399.setVisibility(0);
    }

    @Override // ඓ.ᨨ.K.ඓ.㸾.ʬ.C0785.AbstractC0790
    /* renamed from: 㿎  reason: contains not printable characters */
    public void m1943() {
        C0772 r0 = this.f3389;
        if (r0 != null) {
            r0.m2346(this, 24);
        }
    }

    @Override // ඓ.ᨨ.K.ඓ.㸾.ʬ.C0785.AbstractC0787
    /* renamed from: K  reason: contains not printable characters */
    public void m1942(Album album, Item item, int i) {
        Intent intent = new Intent(this, AlbumPreviewActivity.class);
        intent.putExtra("extra_album", album);
        intent.putExtra("extra_item", item);
        intent.putExtra("extra_default_bundle", this.f3396.m2323());
        intent.putExtra("extra_result_original_enable", this.f3388);
        startActivityForResult(intent, 23);
    }
}
