package com.zhihu.matisse.internal.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.zhihu.matisse.R$attr;
import com.zhihu.matisse.R$color;
import com.zhihu.matisse.R$drawable;
import K.K.K.ʬ.C2369;

public class CheckView extends View {

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean f3362;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Paint f3363;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public Rect f3364;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public Drawable f3365;

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean f3366;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public TextPaint f3367;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f3368 = true;

    /* renamed from: 㳳  reason: contains not printable characters */
    public float f3369;

    /* renamed from: 㴹  reason: contains not printable characters */
    public Paint f3370;

    /* renamed from: 㸾  reason: contains not printable characters */
    public int f3371;

    /* renamed from: 㿎  reason: contains not printable characters */
    public Paint f3372;

    public CheckView(Context context) {
        super(context);
        m1927(context);
    }

    private Rect getCheckRect() {
        if (this.f3364 == null) {
            float f = this.f3369;
            int i = (int) (((f * 48.0f) / 2.0f) - ((16.0f * f) / 2.0f));
            float f2 = (float) i;
            this.f3364 = new Rect(i, i, (int) ((f * 48.0f) - f2), (int) ((f * 48.0f) - f2));
        }
        return this.f3364;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.f3372 == null) {
            this.f3372 = new Paint();
            this.f3372.setAntiAlias(true);
            Paint paint = this.f3372;
            float f = this.f3369;
            float f2 = (f * 48.0f) / 2.0f;
            paint.setShader(new RadialGradient(f2, f2, f * 19.0f, new int[]{Color.parseColor("#00000000"), Color.parseColor("#0D000000"), Color.parseColor("#0D000000"), Color.parseColor("#00000000")}, new float[]{0.21052632f, 0.5263158f, 0.68421054f, 1.0f}, Shader.TileMode.CLAMP));
        }
        float f3 = this.f3369;
        canvas.drawCircle((f3 * 48.0f) / 2.0f, (f3 * 48.0f) / 2.0f, f3 * 19.0f, this.f3372);
        float f4 = this.f3369;
        canvas.drawCircle((f4 * 48.0f) / 2.0f, (f4 * 48.0f) / 2.0f, f4 * 11.5f, this.f3363);
        if (this.f3366) {
            if (this.f3371 != Integer.MIN_VALUE) {
                m1926();
                float f5 = this.f3369;
                canvas.drawCircle((f5 * 48.0f) / 2.0f, (48.0f * f5) / 2.0f, f5 * 11.0f, this.f3370);
                if (this.f3367 == null) {
                    this.f3367 = new TextPaint();
                    this.f3367.setAntiAlias(true);
                    this.f3367.setColor(-1);
                    this.f3367.setTypeface(Typeface.create(Typeface.DEFAULT, 1));
                    this.f3367.setTextSize(this.f3369 * 12.0f);
                }
                String valueOf = String.valueOf(this.f3371);
                canvas.drawText(valueOf, (float) (((int) (((float) canvas.getWidth()) - this.f3367.measureText(valueOf))) / 2), (float) (((int) ((((float) canvas.getHeight()) - this.f3367.descent()) - this.f3367.ascent())) / 2), this.f3367);
            }
        } else if (this.f3362) {
            m1926();
            float f6 = this.f3369;
            canvas.drawCircle((f6 * 48.0f) / 2.0f, (48.0f * f6) / 2.0f, f6 * 11.0f, this.f3370);
            this.f3365.setBounds(getCheckRect());
            this.f3365.draw(canvas);
        }
        setAlpha(this.f3368 ? 1.0f : 0.5f);
    }

    public void onMeasure(int i, int i2) {
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec((int) (this.f3369 * 48.0f), 1073741824);
        super.onMeasure(makeMeasureSpec, makeMeasureSpec);
    }

    public void setChecked(boolean z) {
        if (!this.f3366) {
            this.f3362 = z;
            invalidate();
            return;
        }
        throw new IllegalStateException("CheckView is countable, call setCheckedNum() instead.");
    }

    public void setCheckedNum(int i) {
        if (!this.f3366) {
            throw new IllegalStateException("CheckView is not countable, call setChecked() instead.");
        } else if (i == Integer.MIN_VALUE || i > 0) {
            this.f3371 = i;
            invalidate();
        } else {
            throw new IllegalArgumentException("checked num can't be negative.");
        }
    }

    public void setCountable(boolean z) {
        this.f3366 = z;
    }

    public void setEnabled(boolean z) {
        if (this.f3368 != z) {
            this.f3368 = z;
            invalidate();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1927(Context context) {
        this.f3369 = context.getResources().getDisplayMetrics().density;
        this.f3363 = new Paint();
        this.f3363.setAntiAlias(true);
        this.f3363.setStyle(Paint.Style.STROKE);
        this.f3363.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        this.f3363.setStrokeWidth(this.f3369 * 3.0f);
        TypedArray obtainStyledAttributes = getContext().getTheme().obtainStyledAttributes(new int[]{R$attr.item_checkCircle_borderColor});
        int color = obtainStyledAttributes.getColor(0, C2369.m6297(getResources(), R$color.zhihu_item_checkCircle_borderColor, getContext().getTheme()));
        obtainStyledAttributes.recycle();
        this.f3363.setColor(color);
        this.f3365 = C2369.m6280(context.getResources(), R$drawable.ic_check_white_18dp, context.getTheme());
    }

    public CheckView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m1927(context);
    }

    public CheckView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m1927(context);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1926() {
        if (this.f3370 == null) {
            this.f3370 = new Paint();
            this.f3370.setAntiAlias(true);
            this.f3370.setStyle(Paint.Style.FILL);
            TypedArray obtainStyledAttributes = getContext().getTheme().obtainStyledAttributes(new int[]{R$attr.item_checkCircle_backgroundColor});
            int color = obtainStyledAttributes.getColor(0, C2369.m6297(getResources(), R$color.zhihu_item_checkCircle_backgroundColor, getContext().getTheme()));
            obtainStyledAttributes.recycle();
            this.f3370.setColor(color);
        }
    }
}
