package com.zhihu.matisse;

import android.content.ContentResolver;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.facebook.share.internal.MessengerShareContentUtility;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import ඓ.ᨨ.K.ඓ.ඓ.C0771;
import ῲ.㴹.C2274;

public enum MimeType {
    JPEG("image/jpeg", m1902("jpg", "jpeg")),
    PNG("image/png", m1902("png")),
    GIF("image/gif", m1902("gif")),
    BMP("image/x-ms-bmp", m1902("bmp")),
    WEBP("image/webp", m1902("webp")),
    MPEG("video/mpeg", m1902("mpeg", "mpg")),
    MP4("video/mp4", m1902("mp4", "m4v")),
    QUICKTIME("video/quicktime", m1902("mov")),
    THREEGPP("video/3gpp", m1902("3gp", "3gpp")),
    THREEGPP2("video/3gpp2", m1902("3g2", "3gpp2")),
    MKV("video/x-matroska", m1902("mkv")),
    WEBM("video/webm", m1902("webm")),
    TS("video/mp2ts", m1902("ts")),
    AVI("video/avi", m1902("avi"));
    
    public final Set<String> mExtensions;
    public final String mMimeTypeName;

    /* access modifiers changed from: public */
    MimeType(String str, Set set) {
        this.mMimeTypeName = str;
        this.mExtensions = set;
    }

    public static boolean isGif(String str) {
        if (str == null) {
            return false;
        }
        return str.equals(GIF.toString());
    }

    public static boolean isImage(String str) {
        if (str == null) {
            return false;
        }
        return str.startsWith(MessengerShareContentUtility.MEDIA_IMAGE);
    }

    public static boolean isVideo(String str) {
        if (str == null) {
            return false;
        }
        return str.startsWith("video");
    }

    public static Set<MimeType> of(MimeType mimeType, MimeType... mimeTypeArr) {
        return EnumSet.of(mimeType, mimeTypeArr);
    }

    public static Set<MimeType> ofAll() {
        return EnumSet.allOf(MimeType.class);
    }

    public static Set<MimeType> ofGif() {
        return ofImage(true);
    }

    public static Set<MimeType> ofImage() {
        return EnumSet.of(JPEG, PNG, GIF, BMP, WEBP);
    }

    public static Set<MimeType> ofVideo() {
        return EnumSet.of(MPEG, MP4, QUICKTIME, THREEGPP, THREEGPP2, MKV, WEBM, TS, AVI);
    }

    /* renamed from: K  reason: contains not printable characters */
    public static Set<String> m1902(String... strArr) {
        List asList = Arrays.asList(strArr);
        C2274 r0 = new C2274();
        if (asList != null) {
            r0.addAll(asList);
        }
        return r0;
    }

    public boolean checkType(ContentResolver contentResolver, Uri uri) {
        MimeTypeMap singleton = MimeTypeMap.getSingleton();
        if (uri == null) {
            return false;
        }
        String extensionFromMimeType = singleton.getExtensionFromMimeType(contentResolver.getType(uri));
        String str = null;
        boolean z = false;
        for (String str2 : this.mExtensions) {
            if (str2.equals(extensionFromMimeType)) {
                return true;
            }
            if (!z) {
                String r2 = C0771.m2343(contentResolver, uri);
                if (!TextUtils.isEmpty(r2)) {
                    r2 = r2.toLowerCase(Locale.US);
                }
                str = r2;
                z = true;
            }
            if (str != null && str.endsWith(str2)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.mMimeTypeName;
    }

    public static Set<MimeType> ofImage(boolean z) {
        return EnumSet.of(GIF);
    }
}
