package com.scwang.smartrefresh.layout.header.bezierradar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;

public class WaveView extends View {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f3324;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Paint f3325;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f3326;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Path f3327;

    public WaveView(Context context) {
        this(context, null, 0);
    }

    public int getHeadHeight() {
        return this.f3324;
    }

    public int getWaveHeight() {
        return this.f3326;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = getWidth();
        this.f3327.reset();
        this.f3327.lineTo(0.0f, (float) this.f3324);
        int i = this.f3324;
        float f = (float) width;
        this.f3327.quadTo((float) (width / 2), (float) (this.f3326 + i), f, (float) i);
        this.f3327.lineTo(f, 0.0f);
        canvas.drawPath(this.f3327, this.f3325);
    }

    public void onMeasure(int i, int i2) {
        setMeasuredDimension(View.resolveSize(getSuggestedMinimumWidth(), i), View.resolveSize(getSuggestedMinimumHeight(), i2));
    }

    public void setHeadHeight(int i) {
        this.f3324 = i;
    }

    public void setWaveColor(int i) {
        this.f3325.setColor(i);
    }

    public void setWaveHeight(int i) {
        this.f3326 = i;
    }

    public WaveView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WaveView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f3327 = new Path();
        this.f3325 = new Paint();
        this.f3325.setColor(-14736346);
        this.f3325.setAntiAlias(true);
    }
}
