package com.scwang.smartrefresh.layout.header;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R$styleable;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.pathview.PathsView;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.ؿ.RunnableC1407;
import ඓ.㿎.K.ῲ.㗽.C1430;

public class ClassicsHeader extends RelativeLayout implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public TextView f3300;

    /* renamed from: ඓ  reason: contains not printable characters */
    public ImageView f3301;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public Runnable f3302;

    /* renamed from: ῲ  reason: contains not printable characters */
    public TextView f3303;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public DateFormat f3304 = new SimpleDateFormat("上次更新 M-d HH:mm", Locale.CHINA);

    /* renamed from: 㴹  reason: contains not printable characters */
    public C1430 f3305;

    /* renamed from: 㸾  reason: contains not printable characters */
    public PathsView f3306;

    /* renamed from: 㿎  reason: contains not printable characters */
    public SpinnerStyle f3307 = SpinnerStyle.Translate;

    public ClassicsHeader(Context context) {
        super(context);
        m1883(context, (AttributeSet) null, 0);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return this.f3307;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 1) {
            setBackgroundColor(iArr[0]);
            this.f3306.m1900(iArr[1]);
            this.f3303.setTextColor(iArr[1]);
            C1430 r0 = this.f3305;
            r0.f5385.setColor(iArr[1]);
            this.f3300.setTextColor((iArr[1] & 16777215) | -1728053248);
        } else if (iArr.length > 0) {
            setBackgroundColor(iArr[0]);
            if (iArr[0] == -1) {
                this.f3306.m1900(-10066330);
                this.f3303.setTextColor(-10066330);
                this.f3305.f5385.setColor(-10066330);
                this.f3300.setTextColor(-1721342362);
                return;
            }
            this.f3306.m1900(-1);
            this.f3303.setTextColor(-1);
            this.f3305.f5385.setColor(-1);
            this.f3300.setTextColor(-1426063361);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1881(float f, int i, int i2, int i3) {
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1882(float f, int i, int i2, int i3) {
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1883(Context context, AttributeSet attributeSet, int i) {
        float f = Resources.getSystem().getDisplayMetrics().density;
        setMinimumHeight((int) ((80.0f * f) + 0.5f));
        this.f3305 = new C1430();
        this.f3305.f5385.setColor(-10066330);
        this.f3301 = new ImageView(context);
        this.f3301.setImageDrawable(this.f3305);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int) ((20.0f * f) + 0.5f), (int) ((20.0f * f) + 0.5f));
        layoutParams.leftMargin = (int) ((80.0f * f) + 0.5f);
        layoutParams.addRule(15);
        layoutParams.addRule(9);
        addView(this.f3301, layoutParams);
        this.f3306 = new PathsView(context);
        this.f3306.m1900(-10066330);
        this.f3306.m1901("M20,12l-1.41,-1.41L13,16.17V4h-2v12.17l-5.58,-5.59L4,12l8,8 8,-8z");
        addView(this.f3306, layoutParams);
        LinearLayout linearLayout = new LinearLayout(context, attributeSet, i);
        linearLayout.setGravity(1);
        linearLayout.setOrientation(1);
        this.f3303 = new TextView(context);
        this.f3303.setText("下拉可以刷新");
        this.f3303.setTextColor(-10066330);
        this.f3303.setTextSize(16.0f);
        this.f3300 = new TextView(context);
        this.f3300.setText(this.f3304.format(new Date()));
        this.f3300.setTextColor(-8618884);
        this.f3300.setTextSize(12.0f);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
        layoutParams2.leftMargin = (int) ((20.0f * f) + 0.5f);
        layoutParams2.rightMargin = (int) ((20.0f * f) + 0.5f);
        linearLayout.addView(this.f3303, layoutParams2);
        linearLayout.addView(this.f3300, new LinearLayout.LayoutParams(-2, -2));
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams3.addRule(13);
        addView(linearLayout, layoutParams3);
        if (isInEditMode()) {
            this.f3306.setVisibility(8);
            this.f3303.setText("正在刷新");
        } else {
            this.f3301.setVisibility(8);
        }
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.ClassicsHeader);
        this.f3307 = SpinnerStyle.values()[obtainStyledAttributes.getInt(R$styleable.ClassicsHeader_srlClassicsSpinnerStyle, this.f3307.ordinal())];
        int color = obtainStyledAttributes.getColor(R$styleable.ClassicsHeader_srlPrimaryColor, 0);
        int color2 = obtainStyledAttributes.getColor(R$styleable.ClassicsHeader_srlAccentColor, 0);
        if (color != 0) {
            if (color2 != 0) {
                setPrimaryColors(color, color2);
            } else {
                setPrimaryColors(color);
            }
        } else if (color2 != 0) {
            setPrimaryColors(0, color2);
        }
        obtainStyledAttributes.recycle();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1884(AbstractC1396 r1, int i, int i2) {
    }

    public ClassicsHeader(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m1883(context, attributeSet, 0);
    }

    public ClassicsHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m1883(context, attributeSet, i);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1886(AbstractC1401 r1, int i, int i2) {
        this.f3305.start();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1885(AbstractC1401 r1) {
        this.f3305.stop();
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1887(AbstractC1401 r3, RefreshState refreshState, RefreshState refreshState2) {
        int ordinal = refreshState2.ordinal();
        if (ordinal == 0) {
            Runnable runnable = this.f3302;
            if (runnable != null) {
                runnable.run();
                this.f3302 = null;
            }
        } else if (ordinal != 1) {
            if (ordinal == 5) {
                this.f3303.setText("释放立即刷新");
                this.f3306.animate().rotation(180.0f);
                if (this.f3302 == null && this.f3307 == SpinnerStyle.FixedBehind) {
                    this.f3302 = new RunnableC1407(this, r3);
                    r3.getLayout().setBackgroundDrawable(getBackground());
                    return;
                }
                return;
            } else if (ordinal == 7) {
                this.f3303.setText("正在刷新");
                this.f3301.setVisibility(0);
                this.f3306.setVisibility(8);
                return;
            } else {
                return;
            }
        }
        this.f3303.setText("下拉可以刷新");
        this.f3306.setVisibility(0);
        this.f3301.setVisibility(8);
        this.f3306.animate().rotation(0.0f);
    }
}
