package com.scwang.smartrefresh.header.waterdrop;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import ඓ.K.K.K.C1293;
import ඓ.㿎.K.ῲ.䀟.C1436;
import ඓ.㿎.K.K.㑃.C1447;
import ඓ.㿎.K.K.㑃.C1448;

public class WaterDropView extends View {

    /* renamed from: 㿎  reason: contains not printable characters */
    public static int f3190 = 2;

    /* renamed from: ʬ  reason: contains not printable characters */
    public C1448 f3191;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Paint f3192;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C1448 f3193;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public float f3194;

    /* renamed from: 㴹  reason: contains not printable characters */
    public float f3195;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Path f3196;

    public WaterDropView(Context context) {
        super(context);
        m1804();
    }

    private double getAngle() {
        C1448 k = this.f3191;
        float f = k.f5410;
        C1448 k2 = this.f3193;
        float f2 = k2.f5410;
        if (f <= f2) {
            return Math.asin((double) ((f2 - f) / (k.f5411 - k2.f5411)));
        }
        throw new IllegalStateException("bottomCircle's radius must be less than the topCircle's");
    }

    public C1448 getBottomCircle() {
        return this.f3191;
    }

    public int getIndicatorColor() {
        return this.f3192.getColor();
    }

    public C1448 getTopCircle() {
        return this.f3193;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int paddingTop = getPaddingTop();
        int paddingLeft = getPaddingLeft();
        int paddingBottom = getPaddingBottom();
        int height = getHeight();
        canvas.save();
        float f = (float) height;
        float f2 = this.f3193.f5410;
        float f3 = (float) paddingTop;
        float f4 = (float) paddingBottom;
        if (f <= (f2 * 2.0f) + f3 + f4) {
            canvas.translate((float) paddingLeft, (f - (f2 * 2.0f)) - f4);
            C1448 k = this.f3193;
            canvas.drawCircle(k.f5412, k.f5411, k.f5410, this.f3192);
        } else {
            canvas.translate((float) paddingLeft, f3);
            this.f3196.reset();
            Path path = this.f3196;
            C1448 k2 = this.f3191;
            path.addCircle(k2.f5412, k2.f5411, k2.f5410, Path.Direction.CCW);
            float f5 = this.f3191.f5410;
            C1448 k3 = this.f3193;
            float f6 = k3.f5410;
            if (f5 < f6) {
                this.f3196.addCircle(k3.f5412, k3.f5411, f6, Path.Direction.CCW);
                double angle = getAngle();
                C1448 k4 = this.f3193;
                float cos = (float) (((double) k4.f5412) - (Math.cos(angle) * ((double) k4.f5410)));
                C1448 k5 = this.f3193;
                float sin = (float) ((Math.sin(angle) * ((double) k5.f5410)) + ((double) k5.f5411));
                C1448 k6 = this.f3193;
                float cos2 = (float) ((Math.cos(angle) * ((double) k6.f5410)) + ((double) k6.f5412));
                C1448 k7 = this.f3191;
                float cos3 = (float) (((double) k7.f5412) - (Math.cos(angle) * ((double) k7.f5410)));
                C1448 k8 = this.f3191;
                float sin2 = (float) ((Math.sin(angle) * ((double) k8.f5410)) + ((double) k8.f5411));
                C1448 k9 = this.f3191;
                double cos4 = Math.cos(angle) * ((double) k9.f5410);
                Path path2 = this.f3196;
                C1448 k10 = this.f3193;
                path2.moveTo(k10.f5412, k10.f5411);
                this.f3196.lineTo(cos, sin);
                Path path3 = this.f3196;
                C1448 k11 = this.f3191;
                path3.quadTo(k11.f5412 - k11.f5410, (k11.f5411 + this.f3193.f5411) / 2.0f, cos3, sin2);
                this.f3196.lineTo((float) (cos4 + ((double) k9.f5412)), sin2);
                Path path4 = this.f3196;
                C1448 k12 = this.f3191;
                path4.quadTo(k12.f5412 + k12.f5410, (k12.f5411 + sin) / 2.0f, cos2, sin);
                this.f3196.close();
            }
            canvas.drawPath(this.f3196, this.f3192);
        }
        canvas.restore();
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        m1807(getHeight());
    }

    public void onMeasure(int i, int i2) {
        float f = this.f3195;
        int i3 = f3190;
        C1448 k = this.f3191;
        setMeasuredDimension(getPaddingRight() + getPaddingLeft() + ((int) ((f + ((float) i3)) * 2.0f)), View.resolveSize(getPaddingBottom() + getPaddingTop() + ((int) Math.ceil((double) (k.f5411 + k.f5410 + ((float) (i3 * 2))))), i2));
    }

    public void setIndicatorColor(int i) {
        this.f3192.setColor(i);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m1803() {
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m1804() {
        this.f3193 = new C1448();
        this.f3191 = new C1448();
        this.f3196 = new Path();
        this.f3192 = new Paint();
        this.f3192.setColor(-7829368);
        this.f3192.setAntiAlias(true);
        this.f3192.setStyle(Paint.Style.FILL_AND_STROKE);
        Paint paint = this.f3192;
        int r3 = C1436.m3649(1.0f);
        f3190 = r3;
        paint.setStrokeWidth((float) r3);
        this.f3192.setShadowLayer((float) f3190, 0.0f, 0.0f, -16777216);
        setLayerType(1, null);
        int i = f3190 * 4;
        setPadding(i, i, i, i);
        this.f3192.setColor(-7829368);
        this.f3195 = (float) C1436.m3649(20.0f);
        float f = this.f3195;
        this.f3194 = f / 4.0f;
        C1448 k = this.f3193;
        k.f5410 = f;
        C1448 k2 = this.f3191;
        k2.f5410 = f;
        float f2 = ((float) f3190) + f;
        k.f5412 = f2;
        k.f5411 = f2;
        k2.f5412 = f2;
        k2.f5411 = f2;
    }

    /* renamed from: K  reason: contains not printable characters */
    public Animator m1805() {
        ValueAnimator duration = ValueAnimator.ofFloat(1.0f, 0.001f).setDuration(180L);
        duration.setInterpolator(new DecelerateInterpolator());
        duration.addUpdateListener(new C1447(this));
        return duration;
    }

    public WaterDropView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m1804();
    }

    public WaterDropView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m1804();
    }

    /* renamed from: K  reason: contains not printable characters */
    public static /* synthetic */ void m1802(WaterDropView waterDropView, ValueAnimator valueAnimator) {
        waterDropView.m1806(((Float) valueAnimator.getAnimatedValue()).floatValue());
        waterDropView.postInvalidate();
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1806(float f) {
        float f2 = this.f3195;
        float r2 = C1293.m3403(this.f3194, f2, f, f2);
        float f3 = f * 4.0f * f2;
        C1448 k = this.f3193;
        k.f5410 = (float) (((double) f2) - ((((double) f) * 0.25d) * ((double) f2)));
        C1448 k2 = this.f3191;
        k2.f5410 = r2;
        k2.f5411 = k.f5411 + f3;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1807(int i) {
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        float f = this.f3195;
        float f2 = (2.0f * f) + ((float) paddingTop) + ((float) paddingBottom);
        float f3 = (float) i;
        if (f3 < f2) {
            C1448 k = this.f3193;
            k.f5410 = f;
            C1448 k2 = this.f3191;
            k2.f5410 = f;
            k2.f5411 = k.f5411;
            return;
        }
        float max = Math.max(0.0f, f3 - f2);
        float pow = (float) ((1.0d - Math.pow(100.0d, (double) ((-max) / ((float) C1436.m3649(200.0f))))) * ((double) (f - this.f3194)));
        C1448 k3 = this.f3193;
        float f4 = this.f3195;
        k3.f5410 = f4 - (pow / 4.0f);
        C1448 k4 = this.f3191;
        k4.f5410 = f4 - pow;
        k4.f5411 = ((float) ((i - paddingTop) - paddingBottom)) - k4.f5410;
    }
}
