package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.㗽.ʬ.C1428;
import ඓ.㿎.K.ῲ.䀟.C1436;
import ඓ.㿎.K.K.C1445;

public class TaurusHeader extends View implements AbstractC1391 {

    /* renamed from: 䀟  reason: contains not printable characters */
    public static final Interpolator f3092 = new AccelerateDecelerateInterpolator();

    /* renamed from: ʬ  reason: contains not printable characters */
    public C1428 f3093;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f3094;

    /* renamed from: ؿ  reason: contains not printable characters */
    public Paint f3095;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f3096;

    /* renamed from: ඓ  reason: contains not printable characters */
    public C1428 f3097;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public float f3098;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public float f3099;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public Animation f3100;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C1428 f3101;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public float f3102;

    /* renamed from: 㑃  reason: contains not printable characters */
    public float f3103;

    /* renamed from: 㗗  reason: contains not printable characters */
    public Map<Float, Float> f3104;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f3105;

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean f3106;

    /* renamed from: 㴹  reason: contains not printable characters */
    public Matrix f3107;

    /* renamed from: 㸾  reason: contains not printable characters */
    public C1428 f3108;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f3109;

    /* renamed from: 䁗  reason: contains not printable characters */
    public Random f3110;

    public enum AnimationPart {
        FIRST,
        SECOND,
        THIRD,
        FOURTH
    }

    public TaurusHeader(Context context) {
        this(context, null);
    }

    /* access modifiers changed from: private */
    public void setLoadingAnimationTime(float f) {
        this.f3099 = (f / 6.0f) * 80.0f;
        invalidate();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    public void onDraw(Canvas canvas) {
        float f;
        float f2;
        boolean z;
        boolean z2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        int width = getWidth();
        int height = getHeight();
        if (this.f3106) {
            while (this.f3104.size() < 10) {
                float random = (float) (((double) this.f3109) / (Math.random() * 5.0d));
                float nextInt = (float) (this.f3110.nextInt(1001) + 1000);
                if (this.f3104.size() <= 1) {
                    this.f3104.put(Float.valueOf(random), Float.valueOf(nextInt));
                    m1743(canvas, random, nextInt, width);
                }
                while (true) {
                    random = 0.0f;
                    while (true) {
                        if (random != 0.0f) {
                            break;
                        }
                        float random2 = (float) (((double) this.f3109) / (Math.random() * 5.0d));
                        Iterator<Map.Entry<Float, Float>> it2 = this.f3104.entrySet().iterator();
                        while (true) {
                            if (it2.hasNext()) {
                                if (Math.abs(it2.next().getKey().floatValue() - random2) > ((float) (this.f3109 / 5))) {
                                    random = random2;
                                }
                            }
                        }
                    }
                }
                this.f3104.put(Float.valueOf(random), Float.valueOf(nextInt));
                m1743(canvas, random, nextInt, width);
            }
            if (this.f3104.size() >= 10) {
                for (Map.Entry<Float, Float> entry : this.f3104.entrySet()) {
                    m1743(canvas, entry.getKey().floatValue(), entry.getValue().floatValue(), width);
                }
            }
            if (this.f3096 && this.f3105) {
                this.f3104.clear();
                this.f3105 = false;
                this.f3098 = (float) (this.f3110.nextInt(251) + 50);
            }
            this.f3103 = this.f3099;
        }
        Matrix matrix = this.f3107;
        matrix.reset();
        float f10 = this.f3102;
        if (isInEditMode()) {
            this.f3109 = height;
            f10 = 1.0f;
        }
        if (f10 > 1.0f) {
            f = (f10 % 1.0f) * 20.0f;
            f10 = 1.0f;
        } else {
            f = 0.0f;
        }
        float f11 = (float) width;
        float r12 = ((f11 * f10) / 2.0f) - ((float) (this.f3101.m3639() / 2));
        float r15 = ((1.0f - (f10 / 2.0f)) * ((float) this.f3109)) - ((float) (this.f3101.m3641() / 2));
        if (this.f3094) {
            r12 = ((((1.0f - f10) * f11) / 2.0f) + ((float) (width / 2))) - ((float) (this.f3101.m3639() / 2));
            r15 = (f10 * ((float) (((this.f3101.m3641() * 3) / 2) + (this.f3109 / 2)))) - ((float) (this.f3101.m3641() * 2));
        }
        if (this.f3106) {
            if (m1748(AnimationPart.FIRST)) {
                f8 = m1739(AnimationPart.FIRST);
            } else if (m1748(AnimationPart.SECOND)) {
                f8 = m1739(AnimationPart.SECOND);
            } else {
                if (m1748(AnimationPart.THIRD)) {
                    f9 = m1739(AnimationPart.THIRD);
                } else if (m1748(AnimationPart.FOURTH)) {
                    f9 = m1739(AnimationPart.FOURTH);
                }
                r15 += f9;
            }
            r15 -= f8;
        }
        if (f > 0.0f) {
            matrix.postRotate(f, (float) (this.f3101.m3639() / 2), (float) (this.f3101.m3641() / 2));
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(r12, r15);
        canvas.concat(matrix);
        this.f3101.draw(canvas);
        canvas.restoreToCount(saveCount);
        Matrix matrix2 = this.f3107;
        matrix2.reset();
        C1428 r8 = this.f3093;
        this.f3108 = r8;
        this.f3097 = r8;
        float min = Math.min(1.0f, Math.abs(this.f3102));
        if (isInEditMode()) {
            this.f3109 = height;
            min = 1.0f;
        }
        float f12 = min - 0.5f;
        float f13 = 0.6f;
        if (f12 > 0.0f) {
            f13 = 0.6f + ((f12 / 0.5f) * 0.39999998f);
        }
        float f14 = (1.0f - min) * ((float) this.f3109);
        float r11 = (float) (0 - (this.f3108.m3639() / 2));
        float r14 = (float) (width - (this.f3097.m3639() / 2));
        if (this.f3106) {
            if (m1748(AnimationPart.FIRST)) {
                r11 -= (m1739(AnimationPart.FIRST) * 2.0f) / 4.0f;
                f7 = m1739(AnimationPart.FIRST);
            } else if (m1748(AnimationPart.SECOND)) {
                r11 -= (m1739(AnimationPart.SECOND) * 2.0f) / 4.0f;
                f7 = m1739(AnimationPart.SECOND);
            } else if (m1748(AnimationPart.THIRD)) {
                r11 -= m1739(AnimationPart.THIRD) / 4.0f;
                f7 = m1739(AnimationPart.THIRD) * 2.0f;
            } else if (m1748(AnimationPart.FOURTH)) {
                r11 -= m1739(AnimationPart.FOURTH) / 2.0f;
                f6 = (m1739(AnimationPart.FOURTH) * 2.0f) / 4.0f;
                r14 += f6;
            }
            f6 = f7 / 2.0f;
            r14 += f6;
        }
        float f15 = (float) (height + 2);
        float r152 = (((float) this.f3108.m3641()) * f13) + f14 < f15 ? f15 - (((float) this.f3108.m3641()) * f13) : f14;
        if ((((float) this.f3097.m3641()) * f13) + f14 < f15) {
            f14 = f15 - (((float) this.f3097.m3641()) * f13);
        }
        int saveCount2 = canvas.getSaveCount();
        canvas.save();
        canvas.translate(r11, r152);
        matrix2.postScale(f13, f13, (float) ((this.f3108.m3639() * 3) / 4), (float) this.f3108.m3641());
        canvas.concat(matrix2);
        this.f3108.f5376.setAlpha(100);
        this.f3108.draw(canvas);
        this.f3108.f5376.setAlpha(BaseProgressIndicator.MAX_ALPHA);
        canvas.restoreToCount(saveCount2);
        canvas.save();
        canvas.translate(r14, f14);
        matrix2.postScale(f13, f13, 0.0f, (float) this.f3097.m3641());
        canvas.concat(matrix2);
        this.f3097.f5376.setAlpha(100);
        this.f3097.draw(canvas);
        this.f3097.f5376.setAlpha(BaseProgressIndicator.MAX_ALPHA);
        canvas.restoreToCount(saveCount2);
        Matrix matrix3 = this.f3107;
        matrix3.reset();
        float min2 = Math.min(1.0f, Math.abs(this.f3102));
        if (isInEditMode()) {
            this.f3109 = height;
            min2 = 1.0f;
        }
        float f16 = this.f3102;
        if (f16 > 1.0f) {
            f2 = Math.abs(1.0f - f16);
            z = true;
        } else {
            z = false;
            f2 = 0.0f;
        }
        float f17 = min2 - 0.5f;
        float f18 = 0.8f;
        if (f17 > 0.0f) {
            f18 = 0.8f + ((f17 / 0.5f) * 0.19999999f);
        }
        int i = this.f3109;
        float f19 = ((float) i) * min2;
        float r6 = (float) (i - (this.f3093.m3641() / 2));
        if (f19 > r6) {
            f3 = f19 - r6;
            z2 = true;
        } else {
            f3 = 0.0f;
            z2 = false;
        }
        float r2 = (float) ((width / 2) - (this.f3093.m3639() / 2));
        float r10 = f19 - (z2 ? ((float) (this.f3093.m3641() / 2)) + f3 : (float) (this.f3093.m3641() / 2));
        float f20 = z ? (f2 / 4.0f) + f18 : f18;
        float f21 = z ? (f2 / 2.0f) + f18 : f18;
        if (this.f3106 && !z) {
            if (m1748(AnimationPart.FIRST)) {
                f4 = m1739(AnimationPart.FIRST);
            } else if (m1748(AnimationPart.SECOND)) {
                f4 = m1739(AnimationPart.SECOND);
            } else {
                if (m1748(AnimationPart.THIRD)) {
                    f5 = m1739(AnimationPart.THIRD);
                } else {
                    if (m1748(AnimationPart.FOURTH)) {
                        f5 = m1739(AnimationPart.FOURTH);
                    }
                    f21 = f20;
                }
                f20 = ((f5 / 80.0f) / 6.0f) + f18;
                f21 = f20;
            }
            f20 = f18 - ((f4 / 80.0f) / 8.0f);
            f21 = f20;
        }
        matrix3.postScale(f20, f21, (float) (this.f3093.m3639() / 2), 0.0f);
        if ((((float) this.f3093.m3641()) * f21) + r10 < f15) {
            r10 = f15 - (f21 * ((float) this.f3093.m3641()));
        }
        int saveCount3 = canvas.getSaveCount();
        canvas.save();
        canvas.translate(r2, r10);
        canvas.concat(matrix3);
        this.f3093.draw(canvas);
        canvas.restoreToCount(saveCount3);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        setBackgroundColor(iArr[0]);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final int m1738(AnimationPart animationPart) {
        int ordinal = animationPart.ordinal();
        if (ordinal == 1) {
            return 40;
        }
        if (ordinal != 2) {
            return ordinal != 3 ? 0 : 20;
        }
        return m1738(AnimationPart.FOURTH) * 3;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1740(float f, int i, int i2, int i3) {
        this.f3102 = (((float) i) * 1.0f) / ((float) i2);
        this.f3109 = i2;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1744(AbstractC1396 r1, int i, int i2) {
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1747(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
    }

    public TaurusHeader(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1742(Context context, AttributeSet attributeSet) {
        this.f3107 = new Matrix();
        this.f3104 = new HashMap();
        this.f3110 = new Random();
        this.f3095 = new Paint();
        this.f3095.setColor(-1);
        this.f3095.setStrokeWidth((float) C1436.m3649(3.0f));
        this.f3095.setAlpha(50);
        this.f3100 = new C1445(this);
        this.f3100.setRepeatCount(-1);
        this.f3100.setRepeatMode(2);
        this.f3100.setInterpolator(f3092);
        this.f3100.setDuration(1000);
        float f = Resources.getSystem().getDisplayMetrics().density;
        this.f3101 = new C1428();
        this.f3101.m3644("m23.01,81.48c-0.21,-0.3 -0.38,-0.83 -0.38,-1.19 0,-0.55 0.24,-0.78 1.5,-1.48 1.78,-0.97 2.62,-1.94 2.24,-2.57 -0.57,-0.93 -1.97,-1.24 -11.64,-2.59 -5.35,-0.74 -10.21,-1.44 -10.82,-1.54l-1.09,-0.18 1.19,-0.91c0.99,-0.76 1.38,-0.91 2.35,-0.91 0.64,0 6.39,0.33 12.79,0.74 6.39,0.41 12.09,0.71 12.65,0.67l1.03,-0.07 -1.24,-2.19C30.18,66.77 15.91,42 15.13,40.68l-0.51,-0.87 4.19,-1.26c2.3,-0.69 4.27,-1.26 4.37,-1.26 0.1,0 5.95,3.85 13,8.55 14.69,9.81 17.1,11.31 19.7,12.31 4.63,1.78 6.45,1.69 12.94,-0.64 13.18,-4.73 25.22,-9.13 25.75,-9.4 0.69,-0.36 3.6,1.33 -24.38,-14.22L50.73,23.07 46.74,16.42 42.75,9.77 43.63,8.89c0.83,-0.83 0.91,-0.86 1.46,-0.52 0.32,0.2 3.72,3.09 7.55,6.44 3.83,3.34 7.21,6.16 7.5,6.27 0.29,0.11 13.6,2.82 29.58,6.03 15.98,3.21 31.86,6.4 35.3,7.1l6.26,1.26 3.22,-1.13c41.63,-14.63 67.88,-23.23 85.38,-28 14.83,-4.04 23.75,-4.75 32.07,-2.57 7.04,1.84 9.87,4.88 7.71,8.27 -1.6,2.5 -4.6,4.63 -10.61,7.54 -5.94,2.88 -10.22,4.46 -25.4,9.41 -8.15,2.66 -16.66,5.72 -39.01,14.02 -66.79,24.82 -88.49,31.25 -121.66,36.07 -14.56,2.11 -24.17,2.95 -34.08,2.95 -5.43,0 -5.52,-0.01 -5.89,-0.54z");
        this.f3101.setBounds(0, 0, (int) ((65.0f * f) + 0.5f), (int) ((20.0f * f) + 0.5f));
        this.f3101.m3643(-1);
        this.f3093 = new C1428();
        this.f3093.m3644("M551.81,1.01A65.42,65.42 0,0 0,504.38 21.5A50.65,50.65 0,0 0,492.4 20A50.65,50.65 0,0 0,441.75 70.65A50.65,50.65 0,0 0,492.4 121.3A50.65,50.65 0,0 0,511.22 117.64A65.42,65.42 0,0 0,517.45 122L586.25,122A65.42,65.42 0,0 0,599.79 110.78A59.79,59.79 0,0 0,607.81 122L696.34,122A59.79,59.79 0,0 0,711.87 81.9A59.79,59.79 0,0 0,652.07 22.11A59.79,59.79 0,0 0,610.93 38.57A65.42,65.42 0,0 0,551.81 1.01zM246.2,1.71A54.87,54.87 0,0 0,195.14 36.64A46.78,46.78 0,0 0,167.77 27.74A46.78,46.78 0,0 0,120.99 74.52A46.78,46.78 0,0 0,167.77 121.3A46.78,46.78 0,0 0,208.92 96.74A54.87,54.87 0,0 0,246.2 111.45A54.87,54.87 0,0 0,268.71 106.54A39.04,39.04 0,0 0,281.09 122L327.6,122A39.04,39.04 0,0 0,343.38 90.7A39.04,39.04 0,0 0,304.34 51.66A39.04,39.04 0,0 0,300.82 51.85A54.87,54.87 0,0 0,246.2 1.71z", "m506.71,31.37a53.11,53.11 0,0 0,-53.11 53.11,53.11 53.11,0 0,0 15.55,37.5h75.12a53.11,53.11 0,0 0,1.88 -2.01,28.49 28.49,0 0,0 0.81,2.01h212.96a96.72,96.72 0,0 0,-87.09 -54.85,96.72 96.72,0 0,0 -73.14,33.52 28.49,28.49 0,0 0,-26.74 -18.74,28.49 28.49,0 0,0 -13.16,3.23 53.11,53.11 0,0 0,0.03 -0.66,53.11 53.11,0 0,0 -53.11,-53.11zM206.23,31.81a53.81,53.81 0,0 0,-49.99 34.03,74.91 74.91,0 0,0 -47.45,-17 74.91,74.91 0,0 0,-73.54 60.82,31.3 31.3,0 0,0 -10.17,-1.73 31.3,31.3 0,0 0,-26.09 14.05L300.86,121.98a37.63,37.63 0,0 0,0.2 -3.85,37.63 37.63,0 0,0 -37.63,-37.63 37.63,37.63 0,0 0,-3.65 0.21,53.81 53.81,0 0,0 -53.54,-48.9z", "m424.05,36.88a53.46,53.46 0,0 0,-40.89 19.02,53.46 53.46,0 0,0 -1.34,1.76 62.6,62.6 0,0 0,-5.39 -0.27,62.6 62.6,0 0,0 -61.36,50.17 62.6,62.6 0,0 0,-0.53 3.51,15.83 15.83,0 0,0 -10.33,-3.84 15.83,15.83 0,0 0,-8.06 2.23,21.1 21.1,0 0,0 -18.31,-10.67 21.1,21.1 0,0 0,-19.47 12.97,21.81 21.81,0 0,0 -6.56,-1.01 21.81,21.81 0,0 0,-19.09 11.32L522.84,122.07a43.61,43.61 0,0 0,-43.11 -37.35,43.61 43.61,0 0,0 -2.57,0.09 53.46,53.46 0,0 0,-53.11 -47.93zM129.08,38.4a50.29,50.29 0,0 0,-50.29 50.29,50.29 50.29,0 0,0 2.37,15.06 15.48,15.83 0,0 0,-5.87 1.68,15.48 15.83,0 0,0 -0.98,0.58 16.53,16.18 0,0 0,-0.19 -0.21,16.53 16.18,0 0,0 -11.86,-4.91 16.53,16.18 0,0 0,-16.38 14.13,20.05 16.18,0 0,0 -14.97,7.04L223.95,122.07a42.56,42.56 0,0 0,1.14 -9.56,42.56 42.56,0 0,0 -42.56,-42.56 42.56,42.56 0,0 0,-6.58 0.54,50.29 50.29,0 0,0 -0,-0.01 50.29,50.29 0,0 0,-46.88 -32.07zM631.67,82.61a64.01,64.01 0,0 0,-44.9 18.42,26.73 26.73,0 0,0 -10.67,-2.24 26.73,26.73 0,0 0,-22.72 12.71,16.88 16.88,0 0,0 -0.25,-0.12 16.88,16.88 0,0 0,-6.57 -1.33,16.88 16.88,0 0,0 -16.15,12.03h160.36a64.01,64.01 0,0 0,-59.1 -39.46z");
        this.f3093.m3643(-3678991, -1510403, -131587);
        this.f3093.setBounds(0, 0, (int) ((260.0f * f) + 0.5f), (int) ((f * 45.0f) + 0.5f));
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.TaurusHeader);
        int color = obtainStyledAttributes.getColor(R$styleable.TaurusHeader_thPrimaryColor, 0);
        if (color != 0) {
            setBackgroundColor(color);
        } else {
            setBackgroundColor(-15614977);
        }
        obtainStyledAttributes.recycle();
    }

    public TaurusHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f3106 = false;
        m1742(context, attributeSet);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final float m1739(AnimationPart animationPart) {
        float r3;
        float f;
        int r1;
        float f2;
        int ordinal = animationPart.ordinal();
        if (ordinal == 0) {
            return this.f3099;
        }
        if (ordinal == 1) {
            r3 = (float) m1738(AnimationPart.FOURTH);
            f = this.f3099;
            r1 = m1738(AnimationPart.FOURTH);
        } else if (ordinal == 2) {
            r3 = this.f3099;
            f2 = (float) m1738(AnimationPart.SECOND);
            return r3 - f2;
        } else if (ordinal != 3) {
            return 0.0f;
        } else {
            r3 = (float) m1738(AnimationPart.THIRD);
            f = this.f3099;
            r1 = m1738(AnimationPart.FOURTH);
        }
        f2 = f - ((float) r1);
        return r3 - f2;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1741(float f, int i, int i2, int i3) {
        this.f3094 = false;
        this.f3102 = (((float) i) * 1.0f) / ((float) i2);
        this.f3109 = i2;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1746(AbstractC1401 r1, int i, int i2) {
        this.f3106 = true;
        startAnimation(this.f3100);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1745(AbstractC1401 r1) {
        this.f3106 = false;
        this.f3094 = true;
        clearAnimation();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1743(Canvas canvas, float f, float f2, int i) {
        float f3 = (float) i;
        float f4 = (f3 + f2) / 13.0f;
        float f5 = this.f3099;
        if (this.f3103 - f5 > 0.0f) {
            this.f3096 = true;
            f5 = 13.0f - f5;
        } else {
            this.f3105 = true;
            this.f3096 = false;
        }
        float f6 = (f3 - (f5 * f4)) + f2;
        float f7 = this.f3098;
        float f8 = f6 - f7;
        canvas.drawLine(f8, f, f8 + f7, f, this.f3095);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m1748(AnimationPart animationPart) {
        int ordinal = animationPart.ordinal();
        if (ordinal != 0) {
            if (ordinal == 1 || ordinal == 2) {
                if (this.f3099 < ((float) m1738(animationPart))) {
                    return true;
                }
                return false;
            } else if (ordinal == 3 && this.f3099 > ((float) m1738(AnimationPart.THIRD))) {
                return true;
            } else {
                return false;
            }
        } else if (this.f3099 < ((float) m1738(AnimationPart.FOURTH))) {
            return true;
        } else {
            return false;
        }
    }
}
