package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.scwang.smartrefresh.header.material.CircleImageView;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.䀟.C1436;
import ඓ.㿎.K.K.㳳.C1449;

public class MaterialHeader extends ViewGroup implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f3040;

    /* renamed from: ඓ  reason: contains not printable characters */
    public C1449 f3041;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public Paint f3042;

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean f3043;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f3044;

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean f3045;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f3046;

    /* renamed from: 㸾  reason: contains not printable characters */
    public CircleImageView f3047;

    /* renamed from: 㿎  reason: contains not printable characters */
    public Path f3048;

    public MaterialHeader(Context context) {
        this(context, null);
    }

    public void dispatchDraw(Canvas canvas) {
        if (this.f3045) {
            this.f3048.reset();
            this.f3048.lineTo(0.0f, (float) this.f3044);
            this.f3048.quadTo((float) (getMeasuredWidth() / 2), (((float) this.f3046) * 1.9f) + ((float) this.f3044), (float) getMeasuredWidth(), (float) this.f3044);
            this.f3048.lineTo((float) getMeasuredWidth(), 0.0f);
            canvas.drawPath(this.f3048, this.f3042);
        }
        super.dispatchDraw(canvas);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.FixedFront;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        if (getChildCount() != 0) {
            int measuredWidth = getMeasuredWidth();
            int measuredWidth2 = this.f3047.getMeasuredWidth();
            int measuredHeight = this.f3047.getMeasuredHeight();
            if (!isInEditMode() || (i5 = this.f3044) <= 0) {
                int i6 = measuredWidth / 2;
                int i7 = measuredWidth2 / 2;
                int i8 = this.f3040;
                this.f3047.layout(i6 - i7, -i8, i6 + i7, measuredHeight - i8);
                return;
            }
            int i9 = i5 - (measuredHeight / 2);
            int i10 = measuredWidth / 2;
            int i11 = measuredWidth2 / 2;
            this.f3047.layout(i10 - i11, i9, i10 + i11, measuredHeight + i9);
            this.f3041.m3661(true);
            this.f3041.m3658(0.0f, 0.8f);
            this.f3041.m3657(1.0f);
            this.f3047.setAlpha(1.0f);
            this.f3047.setVisibility(0);
        }
    }

    public void onMeasure(int i, int i2) {
        setMeasuredDimension(View.MeasureSpec.getSize(i), View.MeasureSpec.getSize(i2));
        this.f3047.measure(View.MeasureSpec.makeMeasureSpec(this.f3040, 1073741824), View.MeasureSpec.makeMeasureSpec(this.f3040, 1073741824));
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        super.setLayoutParams(layoutParams);
        layoutParams.height = -3;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 0) {
            this.f3042.setColor(iArr[0]);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1710(float f, int i, int i2, int i3) {
        if (!this.f3041.isRunning() && !this.f3043) {
            m1711(f, i, i2, i3);
        } else if (this.f3045) {
            this.f3044 = Math.min(i, i2);
            this.f3046 = Math.max(0, i - i2);
            postInvalidate();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1712(Context context, AttributeSet attributeSet) {
        setMinimumHeight(C1436.m3649(100.0f));
        this.f3041 = new C1449(context, this);
        C1449 r0 = this.f3041;
        C1449.C1450 r1 = r0.f5416;
        r1.f5433 = -328966;
        r1.f5429 = BaseProgressIndicator.MAX_ALPHA;
        r1.m3667(new int[]{-16737844, -48060, -10053376, -5609780, -30720});
        r0.f5416.m3665(0);
        this.f3047 = new CircleImageView(context, -328966);
        this.f3047.setImageDrawable(this.f3041);
        this.f3047.setVisibility(8);
        addView(this.f3047);
        this.f3040 = (int) (getResources().getDisplayMetrics().density * 40.0f);
        this.f3048 = new Path();
        this.f3042 = new Paint();
        this.f3042.setAntiAlias(true);
        this.f3042.setStyle(Paint.Style.FILL);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.MaterialHeader);
        this.f3045 = obtainStyledAttributes.getBoolean(R$styleable.MaterialHeader_mhShowBezierWave, this.f3045);
        this.f3042.setColor(obtainStyledAttributes.getColor(R$styleable.MaterialHeader_mhPrimaryColor, -15614977));
        if (obtainStyledAttributes.hasValue(R$styleable.MaterialHeader_mhShadowRadius)) {
            int dimensionPixelOffset = obtainStyledAttributes.getDimensionPixelOffset(R$styleable.MaterialHeader_mhShadowRadius, 0);
            this.f3042.setShadowLayer((float) dimensionPixelOffset, 0.0f, 0.0f, obtainStyledAttributes.getColor(R$styleable.MaterialHeader_mhShadowColor, -16777216));
            setLayerType(1, null);
        }
        obtainStyledAttributes.recycle();
    }

    public MaterialHeader(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MaterialHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f3045 = false;
        m1712(context, attributeSet);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1713(AbstractC1396 r1, int i, int i2) {
        if (isInEditMode()) {
            int i3 = i / 2;
            this.f3044 = i3;
            this.f3046 = i3;
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1711(float f, int i, int i2, int i3) {
        if (this.f3045) {
            this.f3044 = Math.min(i, i2);
            this.f3046 = Math.max(0, i - i2);
            postInvalidate();
        }
        float f2 = (float) i;
        float f3 = (float) i2;
        float f4 = (f2 * 1.0f) / f3;
        float max = (((float) Math.max(((double) Math.min(1.0f, Math.abs(f4))) - 0.4d, 0.0d)) * 5.0f) / 3.0f;
        double max2 = (double) (Math.max(0.0f, Math.min((float) (Math.abs(i) - i2), f3 * 2.0f) / f3) / 4.0f);
        this.f3041.m3661(true);
        this.f3041.m3658(0.0f, Math.min(0.8f, max * 0.8f));
        this.f3041.m3657(Math.min(1.0f, max));
        float pow = ((float) (max2 - Math.pow(max2, 2.0d))) * 2.0f * 2.0f;
        this.f3041.m3655((pow + ((max * 0.4f) - 16.0f)) * 0.5f);
        this.f3047.setAlpha(Math.min(1.0f, f4 * 2.0f));
        this.f3047.setTranslationY(Math.min(f2, (float) ((this.f3040 / 2) + (i / 2))));
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1715(AbstractC1401 r1, int i, int i2) {
        this.f3041.start();
        int i3 = i / 2;
        if (((int) this.f3047.getTranslationY()) != (this.f3040 / 2) + i3) {
            this.f3047.animate().translationY((float) ((this.f3040 / 2) + i3));
        }
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1716(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
        int ordinal = refreshState2.ordinal();
        if (ordinal == 0) {
            return;
        }
        if (ordinal == 1) {
            this.f3043 = false;
            this.f3047.setVisibility(0);
            this.f3047.setScaleX(1.0f);
            this.f3047.setScaleY(1.0f);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1714(AbstractC1401 r2) {
        this.f3041.stop();
        this.f3047.animate().scaleX(0.0f).scaleY(0.0f);
        this.f3043 = true;
    }
}
