package com.scwang.smartrefresh.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.google.android.material.bottomappbar.BottomAppBarTopEdgeTreatment;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import ඓ.K.K.K.C1293;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1393;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.ᓣ.AbstractC1418;
import ඓ.㿎.K.ῲ.䀟.C1436;
import ඓ.㿎.K.K.C1446;

public class CircleHeader extends View implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public Paint f2909;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f2910;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f2911;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Paint f2912;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f2913;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public float f2914;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public float f2915;

    /* renamed from: ῲ  reason: contains not printable characters */
    public Path f2916;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public float f2917;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f2918;

    /* renamed from: 㗗  reason: contains not printable characters */
    public float f2919;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f2920;

    /* renamed from: 㳳  reason: contains not printable characters */
    public RefreshState f2921;

    /* renamed from: 㴹  reason: contains not printable characters */
    public float f2922;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Paint f2923;

    /* renamed from: 㿎  reason: contains not printable characters */
    public float f2924;

    /* renamed from: 䁗  reason: contains not printable characters */
    public boolean f2925;

    /* renamed from: com.scwang.smartrefresh.header.CircleHeader$ῲ  reason: contains not printable characters */
    public class C0536 implements ValueAnimator.AnimatorUpdateListener {

        /* renamed from: ʬ  reason: contains not printable characters */
        public float f2926 = 0.0f;

        /* renamed from: ඓ  reason: contains not printable characters */
        public final /* synthetic */ float f2927;

        /* renamed from: ῲ  reason: contains not printable characters */
        public float f2928;

        /* renamed from: K  reason: contains not printable characters */
        public float f2929 = 0.0f;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f2931 = 0;

        public C0536(float f) {
            this.f2927 = f;
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            float floatValue = ((Float) valueAnimator.getAnimatedValue()).floatValue();
            if (this.f2931 == 0 && floatValue <= 0.0f) {
                this.f2931 = 1;
                this.f2929 = Math.abs(floatValue - CircleHeader.this.f2922);
            }
            if (this.f2931 == 1) {
                this.f2926 = (-floatValue) / this.f2927;
                float f = this.f2926;
                CircleHeader circleHeader = CircleHeader.this;
                if (f >= circleHeader.f2924) {
                    circleHeader.f2924 = f;
                    circleHeader.f2914 = circleHeader.f2917 + floatValue;
                    this.f2929 = Math.abs(floatValue - circleHeader.f2922);
                } else {
                    this.f2931 = 2;
                    circleHeader.f2924 = 0.0f;
                    circleHeader.f2918 = true;
                    circleHeader.f2925 = true;
                    this.f2928 = circleHeader.f2914;
                }
            }
            if (this.f2931 == 2) {
                CircleHeader circleHeader2 = CircleHeader.this;
                float f2 = circleHeader2.f2914;
                float f3 = circleHeader2.f2917 / 2.0f;
                if (f2 > f3) {
                    circleHeader2.f2914 = Math.max(f3, f2 - this.f2929);
                    float animatedFraction = valueAnimator.getAnimatedFraction();
                    CircleHeader circleHeader3 = CircleHeader.this;
                    float f4 = this.f2928;
                    float r8 = C1293.m3403(circleHeader3.f2917 / 2.0f, f4, animatedFraction, f4);
                    if (circleHeader3.f2914 > r8) {
                        circleHeader3.f2914 = r8;
                    }
                }
            }
            CircleHeader circleHeader4 = CircleHeader.this;
            if (circleHeader4.f2925 && floatValue < circleHeader4.f2922) {
                circleHeader4.f2910 = true;
                circleHeader4.f2925 = false;
                circleHeader4.f2920 = true;
                circleHeader4.f2913 = 90;
                circleHeader4.f2911 = 90;
            }
            CircleHeader circleHeader5 = CircleHeader.this;
            circleHeader5.f2922 = floatValue;
            circleHeader5.invalidate();
        }
    }

    /* renamed from: com.scwang.smartrefresh.header.CircleHeader$K  reason: contains not printable characters */
    public class C0537 extends AbstractC1418 {

        /* renamed from: com.scwang.smartrefresh.header.CircleHeader$K$K  reason: contains not printable characters */
        public class C0538 extends AnimatorListenerAdapter {

            /* renamed from: K  reason: contains not printable characters */
            public final /* synthetic */ AbstractC1393.AbstractC1394 f2933;

            public C0538(C0537 k, AbstractC1393.AbstractC1394 k2) {
                this.f2933 = k2;
            }

            public void onAnimationEnd(Animator animator) {
                this.f2933.m3603(0);
            }
        }

        public C0537() {
        }

        @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1392
        /* renamed from: K  reason: contains not printable characters */
        public void m1666(AbstractC1393.AbstractC1394 k, AbstractC1401 r4) {
            CircleHeader circleHeader = CircleHeader.this;
            circleHeader.f2910 = false;
            circleHeader.f2918 = false;
            ValueAnimator ofFloat = ValueAnimator.ofFloat(0.0f, 1.0f);
            ofFloat.addUpdateListener(new C1446(this));
            ofFloat.setInterpolator(new AccelerateInterpolator());
            ofFloat.setDuration(800L);
            ofFloat.addListener(new C0538(this, k));
            ofFloat.start();
        }
    }

    public CircleHeader(Context context) {
        this(context, null, 0);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (isInEditMode()) {
            this.f2918 = true;
            this.f2910 = true;
            this.f2917 = (float) getHeight();
            this.f2911 = BottomAppBarTopEdgeTreatment.ANGLE_UP;
            float f = this.f2917;
            this.f2914 = f / 2.0f;
            this.f2919 = f / 6.0f;
        }
        int width = getWidth();
        float min = Math.min(this.f2917, (float) getHeight());
        if (this.f2922 != 0.0f) {
            this.f2916.reset();
            float f2 = (float) width;
            this.f2916.lineTo(f2, 0.0f);
            this.f2916.lineTo(f2, min);
            this.f2916.quadTo((float) (width / 2), (this.f2922 * 2.0f) + min, 0.0f, min);
            this.f2916.close();
            canvas.drawPath(this.f2916, this.f2909);
        } else {
            canvas.drawRect(0.0f, 0.0f, (float) width, min, this.f2909);
        }
        float f3 = this.f2924;
        if (f3 > 0.0f) {
            float f4 = (float) (width / 2);
            float f5 = this.f2919;
            float f6 = (3.0f * f3 * f5) + (f4 - (4.0f * f5));
            if (((double) f3) < 0.9d) {
                this.f2916.reset();
                this.f2916.moveTo(f6, this.f2914);
                Path path = this.f2916;
                float f7 = this.f2914;
                path.quadTo(f4, f7 - ((this.f2919 * this.f2924) * 2.0f), ((float) width) - f6, f7);
                canvas.drawPath(this.f2916, this.f2923);
            } else {
                canvas.drawCircle(f4, this.f2914, f5, this.f2923);
            }
        }
        if (this.f2918) {
            canvas.drawCircle((float) (width / 2), this.f2914, this.f2919, this.f2923);
            float f8 = this.f2917;
            m1661(canvas, width, (this.f2922 + f8) / f8);
        }
        if (this.f2910) {
            float strokeWidth = (this.f2912.getStrokeWidth() * 2.0f) + this.f2919;
            int i = 3;
            this.f2913 += this.f2920 ? 3 : 10;
            int i2 = this.f2911;
            if (this.f2920) {
                i = 10;
            }
            this.f2911 = i2 + i;
            this.f2913 %= 360;
            this.f2911 %= 360;
            int i3 = this.f2911 - this.f2913;
            if (i3 < 0) {
                i3 += 360;
            }
            float f9 = (float) (width / 2);
            float f10 = this.f2914;
            canvas.drawArc(new RectF(f9 - strokeWidth, f10 - strokeWidth, f9 + strokeWidth, f10 + strokeWidth), (float) this.f2913, (float) i3, false, this.f2912);
            if (i3 >= 270) {
                this.f2920 = false;
            } else if (i3 <= 10) {
                this.f2920 = true;
            }
            invalidate();
        }
        if (this.f2915 > 0.0f) {
            int color = this.f2912.getColor();
            if (((double) this.f2915) < 0.3d) {
                int i4 = width / 2;
                canvas.drawCircle((float) i4, this.f2914, this.f2919, this.f2923);
                float f11 = this.f2919;
                float f12 = this.f2915 / 0.3f;
                int strokeWidth2 = (int) (((f12 + 1.0f) * this.f2912.getStrokeWidth() * 2.0f) + f11);
                this.f2912.setColor(Color.argb((int) ((1.0f - f12) * 255.0f), Color.red(color), Color.green(color), Color.blue(color)));
                float f13 = this.f2914;
                float f14 = (float) strokeWidth2;
                canvas.drawArc(new RectF((float) (i4 - strokeWidth2), f13 - f14, (float) (i4 + strokeWidth2), f13 + f14), 0.0f, 360.0f, false, this.f2912);
            }
            this.f2912.setColor(color);
            float f15 = this.f2915;
            double d = (double) f15;
            if (d >= 0.3d && d < 0.7d) {
                float f16 = (f15 - 0.3f) / 0.4f;
                float f17 = this.f2917;
                float f18 = f17 / 2.0f;
                this.f2914 = (float) ((int) C1293.m3403(f17, f18, f16, f18));
                canvas.drawCircle((float) (width / 2), this.f2914, this.f2919, this.f2923);
                if (this.f2914 >= this.f2917 - (this.f2919 * 2.0f)) {
                    this.f2925 = true;
                    m1661(canvas, width, f16);
                }
                this.f2925 = false;
            }
            float f19 = this.f2915;
            if (((double) f19) >= 0.7d && f19 <= 1.0f) {
                float f20 = (f19 - 0.7f) / 0.3f;
                float f21 = (float) (width / 2);
                float f22 = this.f2919;
                int i5 = (int) ((f21 - f22) - ((f22 * 2.0f) * f20));
                this.f2916.reset();
                this.f2916.moveTo((float) i5, this.f2917);
                Path path2 = this.f2916;
                float f23 = this.f2917;
                path2.quadTo(f21, f23 - ((1.0f - f20) * this.f2919), (float) (width - i5), f23);
                canvas.drawPath(this.f2916, this.f2923);
            }
        }
    }

    public void onMeasure(int i, int i2) {
        setMeasuredDimension(View.resolveSize(getSuggestedMinimumWidth(), i), View.resolveSize(getSuggestedMinimumHeight(), i2));
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 0) {
            this.f2909.setColor(iArr[0]);
            if (iArr.length > 1) {
                this.f2923.setColor(iArr[1]);
                this.f2912.setColor(iArr[1]);
            }
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1658(float f, int i, int i2, int i3) {
        if (this.f2921 != RefreshState.Refreshing) {
            m1660(f, i, i2, i3);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1659() {
        setMinimumHeight(C1436.m3649(100.0f));
        this.f2909 = new Paint();
        this.f2909.setColor(-15614977);
        this.f2909.setAntiAlias(true);
        this.f2923 = new Paint();
        this.f2923.setColor(-1);
        this.f2923.setAntiAlias(true);
        this.f2912 = new Paint();
        this.f2912.setAntiAlias(true);
        this.f2912.setColor(-1);
        this.f2912.setStyle(Paint.Style.STROKE);
        this.f2912.setStrokeWidth((float) C1436.m3649(2.0f));
        this.f2916 = new Path();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1663(AbstractC1401 r1) {
    }

    public CircleHeader(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CircleHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f2911 = 90;
        this.f2913 = 90;
        this.f2920 = true;
        m1659();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1661(Canvas canvas, int i, float f) {
        if (this.f2925) {
            float f2 = this.f2917 + this.f2922;
            float f3 = this.f2914;
            float f4 = this.f2919;
            float f5 = ((f4 * f) / 2.0f) + f3;
            float f6 = (float) (i / 2);
            float sqrt = ((float) Math.sqrt((double) ((1.0f - ((f * f) / 4.0f)) * f4 * f4))) + f6;
            float f7 = this.f2919;
            float r12 = C1293.m3403(1.0f, f, (3.0f * f7) / 4.0f, f6);
            float f8 = f7 + r12;
            this.f2916.reset();
            this.f2916.moveTo(sqrt, f5);
            this.f2916.quadTo(r12, f2, f8, f2);
            float f9 = (float) i;
            this.f2916.lineTo(f9 - f8, f2);
            this.f2916.quadTo(f9 - r12, f2, f9 - sqrt, f5);
            canvas.drawPath(this.f2916, this.f2923);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1662(AbstractC1396 r1, int i, int i2) {
        ((SmartRefreshLayout.C0559) r1).m1854(new C0537());
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1660(float f, int i, int i2, int i3) {
        this.f2917 = (float) i2;
        this.f2922 = ((float) Math.max(i - i2, 0)) * 0.8f;
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1665(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
        this.f2921 = refreshState2;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1664(AbstractC1401 r4, int i, int i2) {
        this.f2917 = (float) i;
        this.f2919 = (float) (i / 6);
        DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
        float min = Math.min(this.f2922 * 0.8f, this.f2917 / 2.0f);
        ValueAnimator ofFloat = ValueAnimator.ofFloat(this.f2922, 0.0f, -(1.0f * min), 0.0f, -(0.4f * min), 0.0f);
        ofFloat.addUpdateListener(new C0536(min));
        ofFloat.setInterpolator(decelerateInterpolator);
        ofFloat.setDuration(1000L);
        ofFloat.start();
    }
}
