package com.mexico.inloancash.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import butterknife.ButterKnife;
import com.facebook.AccessToken;
import com.google.gson.Gson;
import com.indiaholacash.holacash.R;
import com.mexico.inloancash.MyApplication;
import com.mexico.inloancash.bean.BaseBean;
import com.mexico.inloancash.bean.India_CardNumberInfo_ListBean;
import com.mexico.inloancash.bean.India_NewBank_ListBean;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import ඓ.ඓ.K.㳳.AbstractC0672;
import ඓ.ඓ.K.㴹.DialogC0684;
import ඓ.ඓ.K.㿎.C0701;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.㳳.C1841;

public class IndiaBankInfoActivity extends BaseActivity implements AbstractC0672 {
    public ImageView logonBack;
    public EditText mIndiaBankCard;
    public TextView mIndiaBankName;
    public EditText mIndiaEditTextIFSCCode;
    public EditText mIndiaPhoneNumber;
    public EditText mIndiaUserName;
    public TextView title;

    /* renamed from: ඓ  reason: contains not printable characters */
    public List<String> f2337;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public DialogC0684 f2338;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public String f2339 = "";

    /* renamed from: 㴹  reason: contains not printable characters */
    public List<String> f2340;

    /* renamed from: 㿎  reason: contains not printable characters */
    public String f2341 = "";

    /* renamed from: com.mexico.inloancash.activity.IndiaBankInfoActivity$ʬ  reason: contains not printable characters */
    public class C0363 implements Callback<String> {
        public C0363() {
        }

        @Override // retrofit2.Callback
        public void onFailure(Call<String> call, Throwable th) {
            IndiaBankInfoActivity.this.f2296.m2185();
        }

        @Override // retrofit2.Callback
        public void onResponse(Call<String> call, Response<String> response) {
            if (response.isSuccessful()) {
                BaseBean baseBean = (BaseBean) new Gson().fromJson(response.body(), BaseBean.class);
                if (baseBean.getCode() == 200) {
                    C1841.m4792((Context) IndiaBankInfoActivity.this, "Modified successfully");
                    IndiaBankInfoActivity.this.finish();
                } else if (baseBean.getCode() == 401) {
                    C1841.m4744("myPhone", "");
                    C1841.m4744(AccessToken.TOKEN_KEY, "");
                    C1841.m4766(false);
                    IndiaBankInfoActivity.this.startActivity(new Intent(IndiaBankInfoActivity.this, IndiaLoginActivity.class));
                } else if (baseBean.getCode() != 60) {
                    C1841.m4792((Context) IndiaBankInfoActivity.this, baseBean.getMsg());
                }
            }
            IndiaBankInfoActivity.this.f2296.m2185();
        }
    }

    /* renamed from: com.mexico.inloancash.activity.IndiaBankInfoActivity$ῲ  reason: contains not printable characters */
    public class C0364 implements Callback<String> {
        public C0364() {
        }

        @Override // retrofit2.Callback
        public void onFailure(Call<String> call, Throwable th) {
        }

        @Override // retrofit2.Callback
        public void onResponse(Call<String> call, Response<String> response) {
            try {
                Log.e("data", "getBankList onResponse:" + response.body());
                if (response.isSuccessful()) {
                    India_CardNumberInfo_ListBean india_CardNumberInfo_ListBean = (India_CardNumberInfo_ListBean) new Gson().fromJson(response.body(), India_CardNumberInfo_ListBean.class);
                    IndiaBankInfoActivity.this.mIndiaBankCard.setText(india_CardNumberInfo_ListBean.getData().getCard_no());
                    if (IndiaBankInfoActivity.this.f2337.size() > 0) {
                        TextView textView = IndiaBankInfoActivity.this.mIndiaBankName;
                        textView.setText(IndiaBankInfoActivity.this.f2337.get(IndiaBankInfoActivity.this.f2340.indexOf(india_CardNumberInfo_ListBean.getData().getBank_code().trim())) + "");
                    }
                    IndiaBankInfoActivity.this.f2341 = india_CardNumberInfo_ListBean.getData().getBank_code().trim();
                    IndiaBankInfoActivity.this.mIndiaEditTextIFSCCode.setText(india_CardNumberInfo_ListBean.getData().getBank_ifsc().trim());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /* renamed from: com.mexico.inloancash.activity.IndiaBankInfoActivity$K  reason: contains not printable characters */
    public class C0365 implements Callback<String> {
        public C0365() {
        }

        @Override // retrofit2.Callback
        public void onFailure(Call<String> call, Throwable th) {
            IndiaBankInfoActivity.this.f2296.m2185();
        }

        @Override // retrofit2.Callback
        public void onResponse(Call<String> call, Response<String> response) {
            if (response.isSuccessful()) {
                India_NewBank_ListBean india_NewBank_ListBean = (India_NewBank_ListBean) new Gson().fromJson(response.body(), India_NewBank_ListBean.class);
                if (Integer.parseInt(india_NewBank_ListBean.getCode()) == 200) {
                    List<India_NewBank_ListBean.DataBean> data = india_NewBank_ListBean.getData();
                    if (data.size() > 0) {
                        IndiaBankInfoActivity.this.f2337.clear();
                        IndiaBankInfoActivity.this.f2340.clear();
                        for (int i = 0; i < data.size(); i++) {
                            India_NewBank_ListBean.DataBean dataBean = data.get(i);
                            IndiaBankInfoActivity.this.f2337.add(dataBean.getSerpay());
                            IndiaBankInfoActivity.this.f2340.add(dataBean.getCode());
                        }
                        if (!TextUtils.isEmpty(IndiaBankInfoActivity.this.f2341)) {
                            IndiaBankInfoActivity indiaBankInfoActivity = IndiaBankInfoActivity.this;
                            indiaBankInfoActivity.mIndiaBankName.setText(indiaBankInfoActivity.f2337.get(indiaBankInfoActivity.f2340.indexOf(indiaBankInfoActivity.f2341)));
                        }
                    }
                }
            }
            IndiaBankInfoActivity.this.f2296.m2185();
        }
    }

    @Override // androidx.fragment.app.FragmentActivity
    public void onActivityResult(int i, int i2, Intent intent) {
        super.onActivityResult(i, i2, intent);
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, com.mexico.inloancash.activity.BaseActivity, androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        setContentView(R.layout.india_activity_view_banking);
        ButterKnife.m1066(this);
        this.title.setText("My Bank Card");
        this.f2337 = new ArrayList();
        this.f2340 = new ArrayList();
        Intent intent = getIntent();
        if (intent != null) {
            this.f2339 = intent.getStringExtra("orderno");
            if (!TextUtils.isEmpty(this.f2339)) {
                m1376();
            }
        }
        m1375();
    }

    @Override // androidx.appcompat.app.AppCompatActivity
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        if (i == 4) {
            finish();
        }
        return super.onKeyDown(i, keyEvent);
    }

    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.bank_linear) {
            this.f2338 = new DialogC0684(this, this, "Bank Card", this.f2337, "bank");
            this.f2338.show();
        } else if (id != R.id.commit_button) {
            if (id == R.id.logon_back) {
                finish();
            }
        } else if (TextUtils.isEmpty(this.mIndiaBankName.getText().toString().trim())) {
            Toast.makeText(this, "Select the name of the receiving bank!", 0).show();
        } else if (C1293.m3418(this.mIndiaBankCard)) {
            C1841.m4792((Context) this, "Please enter your bank card number!");
        } else if (C1293.m3418(this.mIndiaEditTextIFSCCode)) {
            C1841.m4792((Context) this, "Please enter your IFSC!");
        } else {
            m1378();
        }
    }

    /* renamed from: ؿ  reason: contains not printable characters */
    public void m1375() {
        this.f2296.m2183();
        C0701.f3707.m2131().m2126().enqueue(new C0365());
    }

    /* renamed from: ᓣ  reason: contains not printable characters */
    public void m1376() {
        Log.d("loan", "getBankList");
        C0701.f3707.m2131().m2123(C1841.m4788(AccessToken.TOKEN_KEY, ""), MyApplication.f2291, this.f2339).enqueue(new C0364());
    }

    @Override // ඓ.ඓ.K.㳳.AbstractC0672
    /* renamed from: K  reason: contains not printable characters */
    public void m1377(String str, String str2) {
        if (str.equals("bank")) {
            this.mIndiaBankName.setText(str2);
        }
    }

    /* renamed from: 㗽  reason: contains not printable characters */
    public void m1378() {
        this.f2296.m2183();
        C0701.f3707.m2131().m2105(C1841.m4788(AccessToken.TOKEN_KEY, ""), MyApplication.f2291, this.mIndiaUserName.getText().toString().trim(), this.mIndiaBankCard.getText().toString().trim(), this.mIndiaPhoneNumber.getText().toString().trim(), this.f2340.get(this.f2337.indexOf(this.mIndiaBankName.getText().toString().trim())), this.f2339, this.mIndiaEditTextIFSCCode.getText().toString().trim()).enqueue(new C0363());
    }
}
