package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class DecodedBitStreamParser {
    public static final int AL = 28;
    public static final int AS = 27;
    public static final int BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    public static final int BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    public static final int BYTE_COMPACTION_MODE_LATCH = 901;
    public static final int BYTE_COMPACTION_MODE_LATCH_6 = 924;
    public static final int ECI_CHARSET = 927;
    public static final int ECI_GENERAL_PURPOSE = 926;
    public static final int ECI_USER_DEFINED = 925;
    public static final BigInteger[] EXP900;
    public static final int LL = 27;
    public static final int MACRO_PDF417_OPTIONAL_FIELD_ADDRESSEE = 4;
    public static final int MACRO_PDF417_OPTIONAL_FIELD_CHECKSUM = 6;
    public static final int MACRO_PDF417_OPTIONAL_FIELD_FILE_NAME = 0;
    public static final int MACRO_PDF417_OPTIONAL_FIELD_FILE_SIZE = 5;
    public static final int MACRO_PDF417_OPTIONAL_FIELD_SEGMENT_COUNT = 1;
    public static final int MACRO_PDF417_OPTIONAL_FIELD_SENDER = 3;
    public static final int MACRO_PDF417_OPTIONAL_FIELD_TIME_STAMP = 2;
    public static final int MACRO_PDF417_TERMINATOR = 922;
    public static final int MAX_NUMERIC_CODEWORDS = 15;
    public static final char[] MIXED_CHARS = "0123456789&\r\t,:#-.$/+%*=^".toCharArray();
    public static final int ML = 28;
    public static final int MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    public static final int NUMBER_OF_SEQUENCE_CODEWORDS = 2;
    public static final int NUMERIC_COMPACTION_MODE_LATCH = 902;
    public static final int PAL = 29;
    public static final int PL = 25;
    public static final int PS = 29;
    public static final char[] PUNCT_CHARS = ";<>@[\\]_`~!\r\t,:\n-.$/\"|*()?{}'".toCharArray();
    public static final int TEXT_COMPACTION_MODE_LATCH = 900;

    /* renamed from: com.google.zxing.pdf417.decoder.DecodedBitStreamParser$1  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass1 {
        public static final /* synthetic */ int[] $SwitchMap$com$google$zxing$pdf417$decoder$DecodedBitStreamParser$Mode = new int[Mode.values().length];

        /* JADX WARNING: Can't wrap try/catch for region: R(12:0|1|2|3|4|5|6|7|8|9|10|(3:11|12|14)) */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x0040 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x0014 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:5:0x001f */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x002a */
        /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x0035 */
        static {
            $SwitchMap$com$google$zxing$pdf417$decoder$DecodedBitStreamParser$Mode[Mode.ALPHA.ordinal()] = 1;
            $SwitchMap$com$google$zxing$pdf417$decoder$DecodedBitStreamParser$Mode[Mode.LOWER.ordinal()] = 2;
            $SwitchMap$com$google$zxing$pdf417$decoder$DecodedBitStreamParser$Mode[Mode.MIXED.ordinal()] = 3;
            $SwitchMap$com$google$zxing$pdf417$decoder$DecodedBitStreamParser$Mode[Mode.PUNCT.ordinal()] = 4;
            $SwitchMap$com$google$zxing$pdf417$decoder$DecodedBitStreamParser$Mode[Mode.ALPHA_SHIFT.ordinal()] = 5;
            try {
                $SwitchMap$com$google$zxing$pdf417$decoder$DecodedBitStreamParser$Mode[Mode.PUNCT_SHIFT.ordinal()] = 6;
            } catch (NoSuchFieldError unused) {
            }
        }
    }

    public enum Mode {
        ALPHA,
        LOWER,
        MIXED,
        PUNCT,
        ALPHA_SHIFT,
        PUNCT_SHIFT
    }

    static {
        BigInteger[] bigIntegerArr = new BigInteger[16];
        EXP900 = bigIntegerArr;
        bigIntegerArr[0] = BigInteger.ONE;
        BigInteger valueOf = BigInteger.valueOf(900);
        EXP900[1] = valueOf;
        int i = 2;
        while (true) {
            BigInteger[] bigIntegerArr2 = EXP900;
            if (i < bigIntegerArr2.length) {
                bigIntegerArr2[i] = bigIntegerArr2[i - 1].multiply(valueOf);
                i++;
            } else {
                return;
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:20:0x0046 A[ADDED_TO_REGION] */
    /* JADX WARNING: Removed duplicated region for block: B:57:0x0021 A[ADDED_TO_REGION, SYNTHETIC] */
    public static int byteCompaction(int i, int[] iArr, Charset charset, int i2, StringBuilder sb) {
        int i3;
        int i4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long j = 900;
        int i5 = 6;
        if (i == 901) {
            int[] iArr2 = new int[6];
            int i6 = i2 + 1;
            int i7 = iArr[i2];
            boolean z = false;
            while (true) {
                i4 = 0;
                long j2 = 0;
                while (i6 < iArr[0] && !z) {
                    int i8 = i4 + 1;
                    iArr2[i4] = i7;
                    j2 = (j2 * j) + ((long) i7);
                    int i9 = i6 + 1;
                    i7 = iArr[i6];
                    if (i7 != 928) {
                        switch (i7) {
                            case 900:
                            case 901:
                            case 902:
                                break;
                            default:
                                switch (i7) {
                                    case MACRO_PDF417_TERMINATOR /*{ENCODED_INT: 922}*/:
                                    case BEGIN_MACRO_PDF417_OPTIONAL_FIELD /*{ENCODED_INT: 923}*/:
                                    case 924:
                                        break;
                                    default:
                                        if (i8 % 5 != 0 || i8 <= 0) {
                                            z = z;
                                            i6 = i9;
                                            i4 = i8;
                                            j = 900;
                                            i5 = 6;
                                        } else {
                                            int i10 = 0;
                                            while (i10 < i5) {
                                                byteArrayOutputStream.write((byte) ((int) (j2 >> ((5 - i10) * 8))));
                                                i10++;
                                                i5 = 6;
                                                z = z;
                                            }
                                            i6 = i9;
                                            j = 900;
                                        }
                                }
                                break;
                        }
                    }
                    i6 = i9 - 1;
                    i4 = i8;
                    j = 900;
                    i5 = 6;
                    z = true;
                }
            }
            if (i6 == iArr[0] && i7 < 900) {
                iArr2[i4] = i7;
                i4++;
            }
            for (int i11 = 0; i11 < i4; i11++) {
                byteArrayOutputStream.write((byte) iArr2[i11]);
            }
            i3 = i6;
        } else if (i != 924) {
            i3 = i2;
        } else {
            i3 = i2;
            boolean z2 = false;
            while (true) {
                int i12 = 0;
                long j3 = 0;
                while (i3 < iArr[0] && !z2) {
                    int i13 = i3 + 1;
                    int i14 = iArr[i3];
                    if (i14 < 900) {
                        i12++;
                        j3 = (j3 * 900) + ((long) i14);
                    } else {
                        if (i14 != 928) {
                            switch (i14) {
                                default:
                                    switch (i14) {
                                    }
                                case 900:
                                case 901:
                                case 902:
                                    i3 = i13 - 1;
                                    z2 = true;
                                    break;
                            }
                            if (i12 % 5 == 0 && i12 > 0) {
                                for (int i15 = 0; i15 < 6; i15++) {
                                    byteArrayOutputStream.write((byte) ((int) (j3 >> ((5 - i15) * 8))));
                                }
                            }
                        }
                        i3 = i13 - 1;
                        z2 = true;
                        if (i12 % 5 == 0) {
                        }
                    }
                    i3 = i13;
                    if (i12 % 5 == 0) {
                    }
                }
            }
        }
        sb.append(new String(byteArrayOutputStream.toByteArray(), charset));
        return i3;
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* JADX WARNING: Removed duplicated region for block: B:15:0x004e  */
    public static DecoderResult decode(int[] iArr, String str) throws FormatException {
        int i;
        StringBuilder sb = new StringBuilder(iArr.length << 1);
        Charset charset = StandardCharsets.ISO_8859_1;
        int i2 = iArr[1];
        PDF417ResultMetadata pDF417ResultMetadata = new PDF417ResultMetadata();
        int i3 = 2;
        while (i3 < iArr[0]) {
            if (i2 != 913) {
                switch (i2) {
                    case 900:
                        i = textCompaction(iArr, i3, sb);
                        break;
                    case 901:
                        i = byteCompaction(i2, iArr, charset, i3, sb);
                        break;
                    case 902:
                        i = numericCompaction(iArr, i3, sb);
                        break;
                    default:
                        switch (i2) {
                            case MACRO_PDF417_TERMINATOR /*{ENCODED_INT: 922}*/:
                            case BEGIN_MACRO_PDF417_OPTIONAL_FIELD /*{ENCODED_INT: 923}*/:
                                throw FormatException.getFormatInstance();
                            case 924:
                                break;
                            case 925:
                                i = i3 + 1;
                                break;
                            case 926:
                                i = i3 + 2;
                                break;
                            case 927:
                                i = i3 + 1;
                                charset = Charset.forName(CharacterSetECI.getCharacterSetECIByValue(iArr[i3]).name());
                                break;
                            case 928:
                                i = decodeMacroBlock(iArr, i3, pDF417ResultMetadata);
                                break;
                            default:
                                i = textCompaction(iArr, i3 - 1, sb);
                                break;
                        }
                }
            } else {
                i = i3 + 1;
                sb.append((char) iArr[i3]);
            }
            if (i < iArr.length) {
                i3 = i + 1;
                i2 = iArr[i];
            } else {
                throw FormatException.getFormatInstance();
            }
        }
        if (sb.length() != 0) {
            DecoderResult decoderResult = new DecoderResult(null, sb.toString(), null, str);
            decoderResult.setOther(pDF417ResultMetadata);
            return decoderResult;
        }
        throw FormatException.getFormatInstance();
    }

    public static String decodeBase900toBase10(int[] iArr, int i) throws FormatException {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i2 = 0; i2 < i; i2++) {
            bigInteger = bigInteger.add(EXP900[(i - i2) - 1].multiply(BigInteger.valueOf((long) iArr[i2])));
        }
        String bigInteger2 = bigInteger.toString();
        if (bigInteger2.charAt(0) == '1') {
            return bigInteger2.substring(1);
        }
        throw FormatException.getFormatInstance();
    }

    public static int decodeMacroBlock(int[] iArr, int i, PDF417ResultMetadata pDF417ResultMetadata) throws FormatException {
        if (i + 2 <= iArr[0]) {
            int[] iArr2 = new int[2];
            int i2 = i;
            int i3 = 0;
            while (i3 < 2) {
                iArr2[i3] = iArr[i2];
                i3++;
                i2++;
            }
            pDF417ResultMetadata.setSegmentIndex(Integer.parseInt(decodeBase900toBase10(iArr2, 2)));
            StringBuilder sb = new StringBuilder();
            int textCompaction = textCompaction(iArr, i2, sb);
            pDF417ResultMetadata.setFileId(sb.toString());
            int i4 = iArr[textCompaction] == 923 ? textCompaction + 1 : -1;
            while (textCompaction < iArr[0]) {
                int i5 = iArr[textCompaction];
                if (i5 == 922) {
                    textCompaction++;
                    pDF417ResultMetadata.setLastSegment(true);
                } else if (i5 == 923) {
                    int i6 = textCompaction + 1;
                    switch (iArr[i6]) {
                        case 0:
                            StringBuilder sb2 = new StringBuilder();
                            textCompaction = textCompaction(iArr, i6 + 1, sb2);
                            pDF417ResultMetadata.setFileName(sb2.toString());
                            continue;
                        case 1:
                            StringBuilder sb3 = new StringBuilder();
                            textCompaction = numericCompaction(iArr, i6 + 1, sb3);
                            pDF417ResultMetadata.setSegmentCount(Integer.parseInt(sb3.toString()));
                            continue;
                        case 2:
                            StringBuilder sb4 = new StringBuilder();
                            textCompaction = numericCompaction(iArr, i6 + 1, sb4);
                            pDF417ResultMetadata.setTimestamp(Long.parseLong(sb4.toString()));
                            continue;
                        case 3:
                            StringBuilder sb5 = new StringBuilder();
                            textCompaction = textCompaction(iArr, i6 + 1, sb5);
                            pDF417ResultMetadata.setSender(sb5.toString());
                            continue;
                        case 4:
                            StringBuilder sb6 = new StringBuilder();
                            textCompaction = textCompaction(iArr, i6 + 1, sb6);
                            pDF417ResultMetadata.setAddressee(sb6.toString());
                            continue;
                        case 5:
                            StringBuilder sb7 = new StringBuilder();
                            textCompaction = numericCompaction(iArr, i6 + 1, sb7);
                            pDF417ResultMetadata.setFileSize(Long.parseLong(sb7.toString()));
                            continue;
                        case 6:
                            StringBuilder sb8 = new StringBuilder();
                            textCompaction = numericCompaction(iArr, i6 + 1, sb8);
                            pDF417ResultMetadata.setChecksum(Integer.parseInt(sb8.toString()));
                            continue;
                        default:
                            throw FormatException.getFormatInstance();
                    }
                } else {
                    throw FormatException.getFormatInstance();
                }
            }
            if (i4 != -1) {
                int i7 = textCompaction - i4;
                if (pDF417ResultMetadata.isLastSegment()) {
                    i7--;
                }
                pDF417ResultMetadata.setOptionalData(Arrays.copyOfRange(iArr, i4, i7 + i4));
            }
            return textCompaction;
        }
        throw FormatException.getFormatInstance();
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    /* JADX WARNING: Removed duplicated region for block: B:70:0x00e9 A[PHI: r4 
      PHI: (r4v4 com.google.zxing.pdf417.decoder.DecodedBitStreamParser$Mode) = (r4v1 com.google.zxing.pdf417.decoder.DecodedBitStreamParser$Mode), (r4v1 com.google.zxing.pdf417.decoder.DecodedBitStreamParser$Mode), (r4v1 com.google.zxing.pdf417.decoder.DecodedBitStreamParser$Mode), (r4v19 com.google.zxing.pdf417.decoder.DecodedBitStreamParser$Mode) binds: [B:65:0x00d8, B:54:0x00b7, B:43:0x0091, B:29:0x0060] A[DONT_GENERATE, DONT_INLINE]] */
    /* JADX WARNING: Removed duplicated region for block: B:75:0x00f9  */
    /* JADX WARNING: Removed duplicated region for block: B:80:0x00fc A[SYNTHETIC] */
    public static void decodeTextCompaction(int[] iArr, int[] iArr2, int i, StringBuilder sb) {
        char c;
        Mode mode;
        int i2;
        char c2;
        Mode mode2 = Mode.ALPHA;
        Mode mode3 = mode2;
        for (int i3 = 0; i3 < i; i3++) {
            int i4 = iArr[i3];
            int ordinal = mode2.ordinal();
            if (ordinal != 0) {
                if (ordinal != 1) {
                    if (ordinal != 2) {
                        if (ordinal != 3) {
                            if (ordinal != 4) {
                                if (ordinal == 5) {
                                    if (i4 < 29) {
                                        c2 = PUNCT_CHARS[i4];
                                        c = c2;
                                        mode2 = mode3;
                                        if (c == 0) {
                                            sb.append(c);
                                        }
                                    } else if (i4 == 29) {
                                        mode2 = Mode.ALPHA;
                                    } else if (i4 == 900) {
                                        mode2 = Mode.ALPHA;
                                    } else if (i4 == 913) {
                                        sb.append((char) iArr2[i3]);
                                    }
                                }
                                c = 0;
                                if (c == 0) {
                                }
                            } else if (i4 < 26) {
                                c2 = (char) (i4 + 65);
                                c = c2;
                                mode2 = mode3;
                                if (c == 0) {
                                }
                            } else if (i4 == 26) {
                                mode2 = mode3;
                                c = ' ';
                                if (c == 0) {
                                }
                            } else if (i4 == 900) {
                                mode2 = Mode.ALPHA;
                                c = 0;
                                if (c == 0) {
                                }
                            }
                            mode2 = mode3;
                            c = 0;
                            if (c == 0) {
                            }
                        } else if (i4 < 29) {
                            c = PUNCT_CHARS[i4];
                            if (c == 0) {
                            }
                        } else {
                            if (i4 == 29) {
                                mode2 = Mode.ALPHA;
                            } else if (i4 == 900) {
                                mode2 = Mode.ALPHA;
                            } else if (i4 == 913) {
                                sb.append((char) iArr2[i3]);
                            }
                            c = 0;
                            if (c == 0) {
                            }
                        }
                    } else if (i4 < 25) {
                        c = MIXED_CHARS[i4];
                        if (c == 0) {
                        }
                    } else {
                        if (i4 == 900) {
                            mode2 = Mode.ALPHA;
                        } else if (i4 != 913) {
                            switch (i4) {
                                case 25:
                                    mode2 = Mode.PUNCT;
                                    break;
                                case 26:
                                    c = ' ';
                                    break;
                                case 27:
                                    mode2 = Mode.LOWER;
                                    break;
                                case 28:
                                    mode2 = Mode.ALPHA;
                                    break;
                                case 29:
                                    mode = Mode.PUNCT_SHIFT;
                                    c = 0;
                                    mode3 = mode2;
                                    mode2 = mode;
                                    break;
                            }
                            if (c == 0) {
                            }
                        } else {
                            sb.append((char) iArr2[i3]);
                        }
                        c = 0;
                        if (c == 0) {
                        }
                    }
                } else if (i4 < 26) {
                    i2 = i4 + 97;
                } else {
                    if (i4 == 900) {
                        mode2 = Mode.ALPHA;
                    } else if (i4 != 913) {
                        switch (i4) {
                            case 27:
                                mode = Mode.ALPHA_SHIFT;
                                c = 0;
                                mode3 = mode2;
                                mode2 = mode;
                                break;
                            case 28:
                                mode2 = Mode.MIXED;
                                break;
                            case 29:
                                mode = Mode.PUNCT_SHIFT;
                                c = 0;
                                mode3 = mode2;
                                mode2 = mode;
                                break;
                        }
                        if (c == 0) {
                        }
                    } else {
                        sb.append((char) iArr2[i3]);
                    }
                    c = 0;
                    if (c == 0) {
                    }
                }
            } else if (i4 < 26) {
                i2 = i4 + 65;
            } else {
                if (i4 == 900) {
                    mode2 = Mode.ALPHA;
                } else if (i4 != 913) {
                    switch (i4) {
                        case 27:
                            mode2 = Mode.LOWER;
                            break;
                        case 28:
                            mode2 = Mode.MIXED;
                            break;
                        case 29:
                            mode = Mode.PUNCT_SHIFT;
                            c = 0;
                            mode3 = mode2;
                            mode2 = mode;
                            break;
                    }
                    if (c == 0) {
                    }
                } else {
                    sb.append((char) iArr2[i3]);
                }
                c = 0;
                if (c == 0) {
                }
            }
            c = (char) i2;
            if (c == 0) {
            }
        }
    }

    public static int numericCompaction(int[] iArr, int i, StringBuilder sb) throws FormatException {
        int[] iArr2 = new int[15];
        boolean z = false;
        int i2 = 0;
        while (i < iArr[0] && !z) {
            int i3 = i + 1;
            int i4 = iArr[i];
            if (i3 == iArr[0]) {
                z = true;
            }
            if (i4 < 900) {
                iArr2[i2] = i4;
                i2++;
            } else {
                if (!(i4 == 900 || i4 == 901 || i4 == 928)) {
                    switch (i4) {
                    }
                }
                i3--;
                z = true;
            }
            if ((i2 % 15 == 0 || i4 == 902 || z) && i2 > 0) {
                sb.append(decodeBase900toBase10(iArr2, i2));
                i2 = 0;
            }
            i = i3;
        }
        return i;
    }

    public static int textCompaction(int[] iArr, int i, StringBuilder sb) {
        int[] iArr2 = new int[((iArr[0] - i) << 1)];
        int[] iArr3 = new int[((iArr[0] - i) << 1)];
        boolean z = false;
        int i2 = 0;
        while (i < iArr[0] && !z) {
            int i3 = i + 1;
            int i4 = iArr[i];
            if (i4 < 900) {
                iArr2[i2] = i4 / 30;
                iArr2[i2 + 1] = i4 % 30;
                i2 += 2;
            } else if (i4 != 913) {
                if (i4 != 928) {
                    switch (i4) {
                        case 900:
                            iArr2[i2] = 900;
                            i2++;
                            break;
                        default:
                            switch (i4) {
                            }
                        case 901:
                        case 902:
                            i = i3 - 1;
                            z = true;
                            break;
                    }
                }
                i = i3 - 1;
                z = true;
            } else {
                iArr2[i2] = 913;
                i = i3 + 1;
                iArr3[i2] = iArr[i3];
                i2++;
            }
            i = i3;
        }
        decodeTextCompaction(iArr2, iArr3, i2, sb);
        return i;
    }
}
