package com.google.android.material.resources;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.TypedValue;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.C2019;

public class MaterialResources {
    public static final float FONT_SCALE_1_3 = 1.3f;
    public static final float FONT_SCALE_2_0 = 2.0f;

    public static ColorStateList getColorStateList(Context context, TypedArray typedArray, int i) {
        int resourceId;
        ColorStateList r1;
        if (typedArray.hasValue(i) && (resourceId = typedArray.getResourceId(i, 0)) != 0 && (r1 = C1940.m5018(context, resourceId)) != null) {
            return r1;
        }
        int i2 = Build.VERSION.SDK_INT;
        return typedArray.getColorStateList(i);
    }

    public static int getDimensionPixelSize(Context context, TypedArray typedArray, int i, int i2) {
        TypedValue typedValue = new TypedValue();
        if (!typedArray.getValue(i, typedValue) || typedValue.type != 2) {
            return typedArray.getDimensionPixelSize(i, i2);
        }
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(new int[]{typedValue.data});
        int dimensionPixelSize = obtainStyledAttributes.getDimensionPixelSize(0, i2);
        obtainStyledAttributes.recycle();
        return dimensionPixelSize;
    }

    public static Drawable getDrawable(Context context, TypedArray typedArray, int i) {
        int resourceId;
        Drawable r1;
        if (!typedArray.hasValue(i) || (resourceId = typedArray.getResourceId(i, 0)) == 0 || (r1 = C1940.m5017(context, resourceId)) == null) {
            return typedArray.getDrawable(i);
        }
        return r1;
    }

    public static int getIndexWithValue(TypedArray typedArray, int i, int i2) {
        return typedArray.hasValue(i) ? i : i2;
    }

    public static TextAppearance getTextAppearance(Context context, TypedArray typedArray, int i) {
        int resourceId;
        if (!typedArray.hasValue(i) || (resourceId = typedArray.getResourceId(i, 0)) == 0) {
            return null;
        }
        return new TextAppearance(context, resourceId);
    }

    public static boolean isFontScaleAtLeast1_3(Context context) {
        return context.getResources().getConfiguration().fontScale >= 1.3f;
    }

    public static boolean isFontScaleAtLeast2_0(Context context) {
        return context.getResources().getConfiguration().fontScale >= 2.0f;
    }

    public static ColorStateList getColorStateList(Context context, C2019 r3, int i) {
        int resourceId;
        ColorStateList r2;
        if (r3.f6846.hasValue(i) && (resourceId = r3.f6846.getResourceId(i, 0)) != 0 && (r2 = C1940.m5018(context, resourceId)) != null) {
            return r2;
        }
        int i2 = Build.VERSION.SDK_INT;
        return r3.m5233(i);
    }
}
