package com.google.android.material.navigation;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.ViewGroup;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.internal.ParcelableSparseArray;
import ῲ.ῲ.ඓ.㳳.AbstractC1897;
import ῲ.ῲ.ඓ.㳳.AbstractC1917;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ඓ.㳳.C1922;
import ῲ.ῲ.ඓ.㳳.SubMenuC1900;

public class NavigationBarPresenter implements AbstractC1897 {
    public int id;
    public C1912 menu;
    public NavigationBarMenuView menuView;
    public boolean updateSuspended = false;

    public static class SavedState implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>() {
            /* class com.google.android.material.navigation.NavigationBarPresenter.SavedState.AnonymousClass1 */

            @Override // android.os.Parcelable.Creator
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            @Override // android.os.Parcelable.Creator
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        };
        public ParcelableSparseArray badgeSavedStates;
        public int selectedItemId;

        public SavedState() {
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.selectedItemId);
            parcel.writeParcelable(this.badgeSavedStates, 0);
        }

        public SavedState(Parcel parcel) {
            this.selectedItemId = parcel.readInt();
            this.badgeSavedStates = (ParcelableSparseArray) parcel.readParcelable(SavedState.class.getClassLoader());
        }
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public boolean collapseItemActionView(C1912 r1, C1922 r2) {
        return false;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public boolean expandItemActionView(C1912 r1, C1922 r2) {
        return false;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public boolean flagActionItems() {
        return false;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public int getId() {
        return this.id;
    }

    public AbstractC1917 getMenuView(ViewGroup viewGroup) {
        return this.menuView;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public void initForMenu(Context context, C1912 r2) {
        this.menu = r2;
        this.menuView.initialize(this.menu);
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public void onCloseMenu(C1912 r1, boolean z) {
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof SavedState) {
            SavedState savedState = (SavedState) parcelable;
            this.menuView.tryRestoreSelectedItemId(savedState.selectedItemId);
            this.menuView.setBadgeDrawables(BadgeUtils.createBadgeDrawablesFromSavedStates(this.menuView.getContext(), savedState.badgeSavedStates));
        }
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState();
        savedState.selectedItemId = this.menuView.getSelectedItemId();
        savedState.badgeSavedStates = BadgeUtils.createParcelableBadgeStates(this.menuView.getBadgeDrawables());
        return savedState;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public boolean onSubMenuSelected(SubMenuC1900 r1) {
        return false;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public void setCallback(AbstractC1897.AbstractC1898 k) {
    }

    public void setId(int i) {
        this.id = i;
    }

    public void setMenuView(NavigationBarMenuView navigationBarMenuView) {
        this.menuView = navigationBarMenuView;
    }

    public void setUpdateSuspended(boolean z) {
        this.updateSuspended = z;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
    public void updateMenuView(boolean z) {
        if (!this.updateSuspended) {
            if (z) {
                this.menuView.buildMenuView();
            } else {
                this.menuView.updateMenuView();
            }
        }
    }
}
