package com.google.android.material.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import com.google.android.material.R;
import ῲ.ᨨ.ᨨ.AbstractC1777;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1754;

public class ViewUtils {

    public interface OnApplyWindowInsetsListener {
        C1754 onApplyWindowInsets(View view, C1754 v, RelativePadding relativePadding);
    }

    public static void addOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        if (view != null) {
            view.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public static void doOnApplyWindowInsets(View view, AttributeSet attributeSet, int i, int i2) {
        doOnApplyWindowInsets(view, attributeSet, i, i2, null);
    }

    public static float dpToPx(Context context, int i) {
        return TypedValue.applyDimension(1, (float) i, context.getResources().getDisplayMetrics());
    }

    public static ViewGroup getContentView(View view) {
        if (view == null) {
            return null;
        }
        View rootView = view.getRootView();
        ViewGroup viewGroup = (ViewGroup) rootView.findViewById(16908290);
        if (viewGroup != null) {
            return viewGroup;
        }
        if (rootView == view || !(rootView instanceof ViewGroup)) {
            return null;
        }
        return (ViewGroup) rootView;
    }

    public static ViewOverlayImpl getContentViewOverlay(View view) {
        return getOverlay(getContentView(view));
    }

    public static ViewOverlayImpl getOverlay(View view) {
        if (view == null) {
            return null;
        }
        int i = Build.VERSION.SDK_INT;
        return new ViewOverlayApi18(view);
    }

    public static float getParentAbsoluteElevation(View view) {
        float f = 0.0f;
        for (ViewParent parent = view.getParent(); parent instanceof View; parent = parent.getParent()) {
            f += C1729.m4456((View) parent);
        }
        return f;
    }

    public static boolean isLayoutRtl(View view) {
        return C1729.m4511(view) == 1;
    }

    public static PorterDuff.Mode parseTintMode(int i, PorterDuff.Mode mode) {
        if (i == 3) {
            return PorterDuff.Mode.SRC_OVER;
        }
        if (i == 5) {
            return PorterDuff.Mode.SRC_IN;
        }
        if (i == 9) {
            return PorterDuff.Mode.SRC_ATOP;
        }
        switch (i) {
            case 14:
                return PorterDuff.Mode.MULTIPLY;
            case 15:
                return PorterDuff.Mode.SCREEN;
            case 16:
                return PorterDuff.Mode.ADD;
            default:
                return mode;
        }
    }

    public static void removeOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        if (view != null) {
            removeOnGlobalLayoutListener(view.getViewTreeObserver(), onGlobalLayoutListener);
        }
    }

    public static void requestApplyInsetsWhenAttached(View view) {
        if (C1729.m4498(view)) {
            int i = Build.VERSION.SDK_INT;
            view.requestApplyInsets();
            return;
        }
        view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener() {
            /* class com.google.android.material.internal.ViewUtils.AnonymousClass4 */

            public void onViewAttachedToWindow(View view) {
                view.removeOnAttachStateChangeListener(this);
                C1729.m4451(view);
            }

            public void onViewDetachedFromWindow(View view) {
            }
        });
    }

    public static void requestFocusAndShowKeyboard(final View view) {
        view.requestFocus();
        view.post(new Runnable() {
            /* class com.google.android.material.internal.ViewUtils.AnonymousClass1 */

            public void run() {
                ((InputMethodManager) view.getContext().getSystemService("input_method")).showSoftInput(view, 1);
            }
        });
    }

    public static void doOnApplyWindowInsets(View view, AttributeSet attributeSet, int i, int i2, final OnApplyWindowInsetsListener onApplyWindowInsetsListener) {
        TypedArray obtainStyledAttributes = view.getContext().obtainStyledAttributes(attributeSet, R.styleable.Insets, i, i2);
        final boolean z = obtainStyledAttributes.getBoolean(R.styleable.Insets_paddingBottomSystemWindowInsets, false);
        final boolean z2 = obtainStyledAttributes.getBoolean(R.styleable.Insets_paddingLeftSystemWindowInsets, false);
        final boolean z3 = obtainStyledAttributes.getBoolean(R.styleable.Insets_paddingRightSystemWindowInsets, false);
        obtainStyledAttributes.recycle();
        doOnApplyWindowInsets(view, new OnApplyWindowInsetsListener() {
            /* class com.google.android.material.internal.ViewUtils.AnonymousClass2 */

            @Override // com.google.android.material.internal.ViewUtils.OnApplyWindowInsetsListener
            public C1754 onApplyWindowInsets(View view, C1754 r5, RelativePadding relativePadding) {
                if (z) {
                    relativePadding.bottom = r5.m4558() + relativePadding.bottom;
                }
                boolean isLayoutRtl = ViewUtils.isLayoutRtl(view);
                if (z2) {
                    if (isLayoutRtl) {
                        relativePadding.end = r5.m4556() + relativePadding.end;
                    } else {
                        relativePadding.start = r5.m4556() + relativePadding.start;
                    }
                }
                if (z3) {
                    if (isLayoutRtl) {
                        relativePadding.start = r5.m4563() + relativePadding.start;
                    } else {
                        relativePadding.end = r5.m4563() + relativePadding.end;
                    }
                }
                relativePadding.applyToView(view);
                OnApplyWindowInsetsListener onApplyWindowInsetsListener = onApplyWindowInsetsListener;
                return onApplyWindowInsetsListener != null ? onApplyWindowInsetsListener.onApplyWindowInsets(view, r5, relativePadding) : r5;
            }
        });
    }

    public static void removeOnGlobalLayoutListener(ViewTreeObserver viewTreeObserver, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        int i = Build.VERSION.SDK_INT;
        viewTreeObserver.removeOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    public static class RelativePadding {
        public int bottom;
        public int end;
        public int start;

        /* renamed from: top  reason: collision with root package name */
        public int f9137top;

        public RelativePadding(int i, int i2, int i3, int i4) {
            this.start = i;
            this.f9137top = i2;
            this.end = i3;
            this.bottom = i4;
        }

        public void applyToView(View view) {
            C1729.m4474(view, this.start, this.f9137top, this.end, this.bottom);
        }

        public RelativePadding(RelativePadding relativePadding) {
            this.start = relativePadding.start;
            this.f9137top = relativePadding.f9137top;
            this.end = relativePadding.end;
            this.bottom = relativePadding.bottom;
        }
    }

    public static void doOnApplyWindowInsets(View view, final OnApplyWindowInsetsListener onApplyWindowInsetsListener) {
        final RelativePadding relativePadding = new RelativePadding(C1729.m4497(view), view.getPaddingTop(), C1729.m4453(view), view.getPaddingBottom());
        C1729.m4484(view, new AbstractC1777() {
            /* class com.google.android.material.internal.ViewUtils.AnonymousClass3 */

            @Override // ῲ.ᨨ.ᨨ.AbstractC1777
            public C1754 onApplyWindowInsets(View view, C1754 r5) {
                return onApplyWindowInsetsListener.onApplyWindowInsets(view, r5, new RelativePadding(relativePadding));
            }
        });
        requestApplyInsetsWhenAttached(view);
    }
}
