package com.google.android.material.animation;

import android.animation.TimeInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import ඓ.K.K.K.C1293;
import ῲ.㗗.K.K.C2239;
import ῲ.㗗.K.K.C2240;
import ῲ.㗗.K.K.C2241;

public class AnimationUtils {
    public static final TimeInterpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    public static final TimeInterpolator FAST_OUT_LINEAR_IN_INTERPOLATOR = new C2241();
    public static final TimeInterpolator FAST_OUT_SLOW_IN_INTERPOLATOR = new C2240();
    public static final TimeInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    public static final TimeInterpolator LINEAR_OUT_SLOW_IN_INTERPOLATOR = new C2239();

    public static float lerp(float f, float f2, float f3) {
        return C1293.m3403(f2, f, f3, f);
    }

    public static int lerp(int i, int i2, float f) {
        return Math.round(f * ((float) (i2 - i))) + i;
    }

    public static float lerp(float f, float f2, float f3, float f4, float f5) {
        if (f5 < f3) {
            return f;
        }
        return f5 > f4 ? f2 : lerp(f, f2, (f5 - f3) / (f4 - f3));
    }
}
