package com.facebook.share.internal;

import com.facebook.share.model.CameraEffectArguments;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ඓ.K.K.K.C1293;

public class CameraEffectJSONUtility {
    public static final Map<Class<?>, Setter> SETTERS = new HashMap();

    public interface Setter {
        void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String str, Object obj) throws JSONException;

        void setOnJSON(JSONObject jSONObject, String str, Object obj) throws JSONException;
    }

    static {
        SETTERS.put(String.class, new Setter() {
            /* class com.facebook.share.internal.CameraEffectJSONUtility.AnonymousClass1 */

            @Override // com.facebook.share.internal.CameraEffectJSONUtility.Setter
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String str, Object obj) throws JSONException {
                builder.putArgument(str, (String) obj);
            }

            @Override // com.facebook.share.internal.CameraEffectJSONUtility.Setter
            public void setOnJSON(JSONObject jSONObject, String str, Object obj) throws JSONException {
                jSONObject.put(str, obj);
            }
        });
        SETTERS.put(String[].class, new Setter() {
            /* class com.facebook.share.internal.CameraEffectJSONUtility.AnonymousClass2 */

            @Override // com.facebook.share.internal.CameraEffectJSONUtility.Setter
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String str, Object obj) throws JSONException {
                throw new IllegalArgumentException("Unexpected type from JSON");
            }

            @Override // com.facebook.share.internal.CameraEffectJSONUtility.Setter
            public void setOnJSON(JSONObject jSONObject, String str, Object obj) throws JSONException {
                JSONArray jSONArray = new JSONArray();
                for (String str2 : (String[]) obj) {
                    jSONArray.put(str2);
                }
                jSONObject.put(str, jSONArray);
            }
        });
        SETTERS.put(JSONArray.class, new Setter() {
            /* class com.facebook.share.internal.CameraEffectJSONUtility.AnonymousClass3 */

            @Override // com.facebook.share.internal.CameraEffectJSONUtility.Setter
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String str, Object obj) throws JSONException {
                JSONArray jSONArray = (JSONArray) obj;
                String[] strArr = new String[jSONArray.length()];
                for (int i = 0; i < jSONArray.length(); i++) {
                    Object obj2 = jSONArray.get(i);
                    if (obj2 instanceof String) {
                        strArr[i] = (String) obj2;
                    } else {
                        StringBuilder r6 = C1293.m3416("Unexpected type in an array: ");
                        r6.append(obj2.getClass());
                        throw new IllegalArgumentException(r6.toString());
                    }
                }
                builder.putArgument(str, strArr);
            }

            @Override // com.facebook.share.internal.CameraEffectJSONUtility.Setter
            public void setOnJSON(JSONObject jSONObject, String str, Object obj) throws JSONException {
                throw new IllegalArgumentException("JSONArray's are not supported in bundles.");
            }
        });
    }

    public static CameraEffectArguments convertToCameraEffectArguments(JSONObject jSONObject) throws JSONException {
        if (jSONObject == null) {
            return null;
        }
        CameraEffectArguments.Builder builder = new CameraEffectArguments.Builder();
        Iterator<String> keys = jSONObject.keys();
        while (keys.hasNext()) {
            String next = keys.next();
            Object obj = jSONObject.get(next);
            if (!(obj == null || obj == JSONObject.NULL)) {
                Setter setter = SETTERS.get(obj.getClass());
                if (setter != null) {
                    setter.setOnArgumentsBuilder(builder, next, obj);
                } else {
                    StringBuilder r0 = C1293.m3416("Unsupported type: ");
                    r0.append(obj.getClass());
                    throw new IllegalArgumentException(r0.toString());
                }
            }
        }
        return builder.build();
    }

    public static JSONObject convertToJSON(CameraEffectArguments cameraEffectArguments) throws JSONException {
        if (cameraEffectArguments == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (String str : cameraEffectArguments.keySet()) {
            Object obj = cameraEffectArguments.get(str);
            if (obj != null) {
                Setter setter = SETTERS.get(obj.getClass());
                if (setter != null) {
                    setter.setOnJSON(jSONObject, str, obj);
                } else {
                    StringBuilder r0 = C1293.m3416("Unsupported type: ");
                    r0.append(obj.getClass());
                    throw new IllegalArgumentException(r0.toString());
                }
            }
        }
        return jSONObject;
    }
}
